//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: editevent.h,v 1.1.1.1 2003/10/29 10:05:22 wschweer Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __EDIT_EVENT_H__
#define __EDIT_EVENT_H__

#include <qdialog.h>

#include "editnotedialogbase.h"
#include "editsysexdialogbase.h"

class MidiEvent;
class PosEdit;
class IntLabel;
class PitchLabel;
class QGridLayout;
class QMultiLineEdit;
class QRadioButton;
class PosEdit;

//---------------------------------------------------------
//   EditEventDialog
//---------------------------------------------------------

class EditEventDialog : public QDialog {
      Q_OBJECT

   protected:
      QGridLayout* layout;

   public:
      EditEventDialog(QWidget* parent=0, const char* name=0);
      virtual MidiEvent* event() = 0;
      };

//---------------------------------------------------------
//   EditNoteDialog
//---------------------------------------------------------

class EditNoteDialog : public EditNoteDialogBase {
      Q_OBJECT

   public:
      EditNoteDialog(int tick, const MidiEvent*,
         QWidget* parent=0, const char* name=0);
      static MidiEvent* getEvent(int tick, const MidiEvent*,
         QWidget* parent = 0);
      virtual MidiEvent* event();
      };

//---------------------------------------------------------
//   EditSysExDialog
//---------------------------------------------------------

class EditSysexDialog : public EditSysexDialogBase {
      Q_OBJECT

      unsigned char* sysex;
      int len;

   private slots:
      virtual void accept();

   public:
      EditSysexDialog(int tick, const MidiEvent*,
         QWidget* parent=0, const char* name=0);
      ~EditSysexDialog();
      static MidiEvent* getEvent(int tick, const MidiEvent*,
         QWidget* parent = 0);
      virtual MidiEvent* event();
      };

//---------------------------------------------------------
//   EditCtrl7Dialog
//---------------------------------------------------------

class EditCtrl7Dialog : public EditEventDialog {
      Q_OBJECT

      PosEdit* pos;
      IntLabel* il2;
      IntLabel* il3;

   public:
      EditCtrl7Dialog(int tick, const MidiEvent*,
         QWidget* parent=0, const char* name=0);
      static MidiEvent* getEvent(int tick, const MidiEvent*,
         QWidget* parent = 0);
      virtual MidiEvent* event();
      };

//---------------------------------------------------------
//   EditCtrl14Dialog
//---------------------------------------------------------

class EditCtrl14Dialog : public EditEventDialog {
      Q_OBJECT

      PosEdit* pos;
      IntLabel* il2h;
      IntLabel* il2l;
      IntLabel* il3;

   public:
      EditCtrl14Dialog(int tick, const MidiEvent*,
         QWidget* parent=0, const char* name=0);
      static MidiEvent* getEvent(int tick, const MidiEvent*,
         QWidget* parent = 0);
      virtual MidiEvent* event();
      };

//---------------------------------------------------------
//   EditMetaDialog
//---------------------------------------------------------

class EditMetaDialog : public EditEventDialog {
      Q_OBJECT

      unsigned char* meta;
      int len;
      PosEdit* pos;
      QMultiLineEdit* edit;
      IntLabel* il2;
      QRadioButton* hexButton;

   private slots:
      virtual void accept();
      void toggled(bool);

   public:
      EditMetaDialog(int tick, const MidiEvent*,
         QWidget* parent=0, const char* name=0);
      ~EditMetaDialog();
      static MidiEvent* getEvent(int tick, const MidiEvent*,
         QWidget* parent = 0);
      virtual MidiEvent* event();
      };

//---------------------------------------------------------
//   EditPitchDialog
//---------------------------------------------------------

class EditPitchDialog : public EditEventDialog {
      Q_OBJECT

      PosEdit* pos;
      IntLabel* il2;

   public:
      EditPitchDialog(int tick, const MidiEvent*,
         QWidget* parent=0, const char* name=0);
      static MidiEvent* getEvent(int tick, const MidiEvent*,
         QWidget* parent = 0);
      virtual MidiEvent* event();
      };

//---------------------------------------------------------
//   EditCAfterDialog
//---------------------------------------------------------

class EditCAfterDialog : public EditEventDialog {
      Q_OBJECT

      PosEdit* pos;
      IntLabel* il2;

   public:
      EditCAfterDialog(int tick, const MidiEvent*,
         QWidget* parent=0, const char* name=0);
      static MidiEvent* getEvent(int tick, const MidiEvent*,
         QWidget* parent = 0);
      virtual MidiEvent* event();
      };

//---------------------------------------------------------
//   EditPAfterDialog
//---------------------------------------------------------

class EditPAfterDialog : public EditEventDialog {
      Q_OBJECT

      PosEdit* pos;
      PitchLabel* pl;
      IntLabel* il2;

   public:
      EditPAfterDialog(int tick, const MidiEvent*,
         QWidget* parent=0, const char* name=0);
      static MidiEvent* getEvent(int tick, const MidiEvent*,
         QWidget* parent = 0);
      virtual MidiEvent* event();
      };

#endif

