//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: jackaudio.h,v 1.1.1.1 2003/10/29 10:06:11 wschweer Exp $
//  (C) Copyright 2002 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __JACKAUDIO_H__
#define __JACKAUDIO_H__

#include "config.h"

#if HAVE_JACK
#include <jack/jack.h>
#include "audiodev.h"

//---------------------------------------------------------
//   JackAudioDevice
//---------------------------------------------------------

class JackAudioDevice : public AudioDevice {
      jack_client_t* client;
      jack_port_t* out1;
      jack_port_t* out2;
      jack_port_t* in1;
      jack_port_t* in2;

      double sampleTime;
      int samplePos;

   public:
      JackAudioDevice(jack_client_t* cl) {
            client = cl;
            }
      virtual ~JackAudioDevice();
      virtual QString open(int);
      virtual void close();
      virtual void read(int, unsigned long, float**);
//      virtual void write(int, unsigned long, float**);
      virtual bool getWriteBuffer(int n, unsigned long nframes, float** buffer);
      virtual void start();
      virtual void stop ();
      virtual void activate(bool);
      virtual int curPlayPos() const;

      virtual std::list<QString> outputPorts();
      virtual std::list<QString> inputPorts();
      virtual void setInputPort(const QString&);
      virtual void setOutputPort(const QString&);

      void registerClient();
      };

extern JackAudioDevice* jackAudioDevice;

#else
#include <stdint.h>
typedef uint32_t jack_nframes_t;
#endif

#endif

