#ifndef SYNCML_PLUGIN_H
#define SYNCML_PLUGIN_H

#include <glib.h>
#include <multisync.h>
#include "syncml_engine.h"

#define SYNCML_FREE_STRING(x) {if(x) g_free(x); x=NULL; }

typedef enum {
  SYNCML_PLUGIN_MODE_IDLE = 0,
  SYNCML_PLUGIN_SERVER_MODE_GOTCHANGES = 1,
  SYNCML_PLUGIN_SERVER_MODE_SENTMODIFY = 2,
  SYNCML_PLUGIN_SERVER_MODE_SYNCNOTIFIED = 3,
  SYNCML_PLUGIN_SERVER_MODE_WAITING_FOR_MODIFY = 4,
  SYNCML_PLUGIN_CLIENT_MODE_SYNC = 5,
  SYNCML_PLUGIN_MODE_GET_DEVINFO = 6
} syncml_plugin_mode;
  

typedef struct {
  client_connection commondata;
  sync_pair *sync_pair;
  connection_type conntype;

  // Saved information
  gboolean isserver;
  char* serverURI;
  char* login; // Login name
  char* passwd; // Password
  char* othercalendardb;
  char* otherphonebookdb;
  gboolean removeutc; // Bug workaround

  syncml_state *state;
  syncml_devinfo *devinfo; // Devinfo from the other device
  GList *changelist; // Storing of the change list until the sync engine
                     // fetches it.
  sync_object_type newdbs; // Which of the databases above are new?
  syncml_plugin_mode mode;
} syncml_connection;

void syncml_sync_serverinit_received(syncml_state *state, 
				     syncml_connection *conn);
void syncml_changes_results_received(syncml_state *state,
				     syncml_connection *conn, 
				     GList *results);
void syncml_changes_received(syncml_state *state, syncml_connection* conn, 
			     GList *changes, gboolean final, 
			     sync_object_type newdbs);
void syncml_sync_done_received(syncml_state *state, syncml_connection* conn);
char* syncml_error_to_str(syncml_error_type err);
void syncml_error(syncml_state *state, syncml_connection *conn,
		  syncml_error_type err);
void syncml_info(syncml_state *state, syncml_connection *conn, char *txt);
void syncml_get_devinfo(syncml_connection *conn);
void syncml_devinfo_received(syncml_state *state,
			     syncml_connection *conn, 
			     syncml_devinfo *devinfo);

GList *syncml_convert_copy_change_list(syncml_connection *conn,
				       GList *orig);
syncml_data_type syncml_get_db_datatype(syncml_connection *conn,
					sync_object_type objtype,
					gboolean tx, 
					syncml_data_type pref);
char *syncml_get_datapath(syncml_connection *conn);
void syncml_load_state(syncml_connection *conn);
void syncml_save_state(syncml_connection *conn);
gboolean syncml_start_syncml_engine(syncml_connection *conn);
void syncml_stop_syncml_engine(syncml_connection *conn);
void resp_objchanged(syncml_connection *conn);
void resp_get_changes(syncml_connection *conn, int respcode,
		      change_info *changes);
void syncml_reget_changes(syncml_state *state, syncml_connection *conn,
		      sync_object_type object_types);
syncml_connection* sync_connect(sync_pair* handle, connection_type type,
				sync_object_type object_types);
void syncml_free_connection(syncml_connection *conn);
void sync_disconnect(syncml_connection *conn);
gboolean always_connected(void);
char* short_name(void);
char* long_name(void);
sync_object_type object_types(void);
void plugin_init(void);
char* plugin_info(void);





#endif
