/*

    mp_msg_en.h

    Deutsche Nachrichten

    mp - Programmer Text Editor

    Copyright (C) 1991-2000 Angel Ortega <angel@triptico.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    http://www.triptico.com

    German messages by Peter Ludikovsky

*/
/* -*- Mode: C */

static char * _de_ids[] = { "german", "de", "de_DE", "de_AT", "DE", NULL };

static struct lang_str _de_strs[] = 
{
	{ MSG_YES_STRING,	"Ja" },
	{ MSG_NO_STRING,	"Nicht" },

	{ MSG_UNNAMED,	    "<unbenannt>" },
	{ MSG_TEXTTOSEEK,   "Zu suchender Text: " },
	{ MSG_TAGTOSEEK,    "ZU suchender Tag: " },
	{ MSG_NOTFOUND,     "Text nicht gefunden." },
	{ MSG_TAGNOTFOUND,  "Tag(s) nicht gefunden." },
	{ MSG_FILENAME,     "Dateinamen eingeben: " },
	{ MSG_SAVECHANGES,  "Datei wurde verndert. Sollen die nderungen gespeichert werden?" },
	{ MSG_FILENOTFOUND, "Datei '%s' nicht gefunden." },
	{ MSG_CANTWRITE,    "Kann Datei '%s' nicht erzeugen." },
	{ MSG_YESNO,	    " [J/N]" },
	{ MSG_ENTER,	    " [EINGABE]" },
	{ MSG_HELP,	    "<Hilfe ber '%s'>" },
	{ MSG_LOADING,	    "LADE" },
	{ MSG_LINETOGO,     "Springe zu Zeile: " },
	{ MSG_NOHELPFOR,    "Keine Hilfe ber '%s'" },
	{ MSG_REPLACETHIS,  "Ersetze Text: " },
	{ MSG_REPLACEWITH,  "Ersetze durch: " },
	{ MSG_TOENDOFFILE,  "Zum Ende der Datei?" },
	{ MSG_YES,	    "J" },
	{ MSG_NO,	    "N" },
	{ MSG_KEYHELP,	    "<Tastaturkrzel>" },
	{ MSG_ABOUT,	    "<ber Minimum Profit>" },
	{ MSG_EXEC,	    "System Kommando: " },
	{ MSG_CANTEXEC,     "Fehler beim Ausfhren des Kommandos." },
	{ MSG_WORDWRAP,     "Zeilenumbruch bei Spalte (0, kein Umbruch): " },
	{ MSG_TABSIZE,	    "Tabulatorgre: " },
	{ MSG_BADMODE,	    "Unbekannter Modus. Verfgbare Modi:" },
	{ MSG_TMPLNOTFOUND, "Vorlage nicht gefunden (%s)" },
	{ MSG_SELECTTMPL,   "Vorlage auswhlen" },
	{ MSG_TAGLIST,	    "Tagliste" },
	{ MSG_OPENLIST,     "ffne Dokumente" },
	{ MSG_DEFAULTHINT,  "^A Men" },
	{ MSG_CANCELHINT,   "^N Abbrechen" },

	{ MSG_MENU10,	    "&Datei" },
	{ MSG_MENU11,	    "&Neu\tF5" },
	{ MSG_MENU12,	    "&ffnen...\tF3" },
	{ MSG_MENU13,	    "E&rneut ffnen..." },
	{ MSG_MENU14,	    "&Speichern...\tF2" },
	{ MSG_MENU15,	    "Speichern &Als..." },
	{ MSG_MENU16,	    "S&chlieen\tF4" },
	{ MSG_MENU17,	    "&Beenden\tStrg-X" },

	{ MSG_MENU20,	    "&Bearbeiten" },
	{ MSG_MENU21,	    "&Kopieren\tStrg-D" },
	{ MSG_MENU22,	    "&Ausschneiden\tStrg-T" },
	{ MSG_MENU23,	    "&Einfgen\tStrg-V" },
	{ MSG_MENU24,	    "&Lsche Zeile\tStrg-Y" },
	{ MSG_MENU25,	    "Editiere &Vorlage" },
	{ MSG_MENU26,	    "&System Kommando..." },

	{ MSG_MENU30,	    "&Suche" },
	{ MSG_MENU31,	    "&Suche...\tStrg-B" },
	{ MSG_MENU32,	    "&Weiter Suchen\tStrg-L" },
	{ MSG_MENU33,	    "&Ersetzen...\tStrg-R" },
	{ MSG_MENU34,	    "In &allen Ersetzen..." },
	{ MSG_MENU35,	    "&Gro/Kleinschreibung beachten" },
	{ MSG_MENU36,	    "Suche &Tag...\tStrg-F" },

	{ MSG_MENU40,	    "&Gehe zu" },
	{ MSG_MENU41,	    "&Nchstes\tF6" },
	{ MSG_MENU42,	    "&Anfang\tStrg-W" },
	{ MSG_MENU43,	    "&Ende\tStrg-E" },
	{ MSG_MENU44,	    "Anfang der &Zeile\tHome" },
	{ MSG_MENU45,	    "Ende &der Zeile\tEnd" },
	{ MSG_MENU46,	    "&Gehe zu Zeile\tStrg-G" },
	{ MSG_MENU47,	    "&Nchstes Wort\tStrg-K" },
	{ MSG_MENU48,	    "&Letztes Wort\tStrg-L" },
	{ MSG_MENU49,	    "D&okumente Liste\tStrg-O" },

	{ MSG_MENU50,	    "&Optionen" },
	{ MSG_MENU51,	    "&Speichere Tabulatoren" },
	{ MSG_MENU52,	    "S&peicher LF als CR/LF" },
	{ MSG_MENU53,	    "Auto &Einrcken" },
	{ MSG_MENU54,	    "&Markiere Spalte 80" },
	{ MSG_MENU55,	    "&Tabulatorgre..." },
	{ MSG_MENU56,	    "&Zeilenumbruch..." },
	{ MSG_MENU57,	    "T&astaturbelegung" },
	{ MSG_MENU58,	    "&ber..." },

	{ MSG_HELP_TEXT,	"\
+------------------------------------------------------------------+\n\
| Minimum Profit - Tasten					   |\n\
+----------+-------------------------------------------------------+\n\
|  F1	   |   Hilfe zu Wort unter dem Cursor			   |\n\
|  F2	   |   Speichern					   |\n\
|  F3	   |   ffnen						   |\n\
|  F4	   |   Schlieen					   |\n\
|  F5	   |   Neue Datei					   |\n\
|  F6	   |   Nchste Datei					   |\n\
|  F7	   |   Makro abspielen					   |\n\
|  F8	   |   Blockmarkierung lschen				   |\n\
|  F9	   |   Markiere Anfang / Ende eines Blocks		   |\n\
|  F10	   |   Makro aufzeichen 				   |\n\
|  HOCH    |   Zeile hoch					   |\n\
|  RUNTER  |   Zeile runter					   |\n\
|  LINKS   |   Zeichen links					   |\n\
|  RECHTS  |   Zeichen rechts					   |\n\
|  POS1    |   Anfang der Zeile 				   |\n\
|  ENDE    |   Ende der Zeile					   |\n\
| BILD-HOCH|   Seite hoch					   |\n\
| BILD-AB  |   Seite runter					   |\n\
|  EINFG   |   Umschalten Einfgen / berschreiben		   |\n\
|  ENTF    |   Lsche Zeichen ber dem Cursor			   |\n\
|  BACKSPC |   Lsche Zeichen links vom Cursor			   |\n\
|  ESC	   |   Aktiviere Kontrollmodus				   |\n\
|  TAB	   |   Tabulator					   |\n\
|  F11	   |   Verringere Schriftgre (nur win32)		   |\n\
|  F12	   |   Erhhe Schriftgre (nur win32)			   |\n\
|  ^F12    |   Fenster Maximieren (nur win32)			   |\n\
+----------+-------------------------------------------------------+\n\
| Kontroll Modus						   |\n\
| Der Kontroll Modus wird durch das gleichzeitige drcken von	   |\n\
| Strg+Taste oder Alt+Taste in untersttzenden Umgebungen	   |\n\
| aktiviert. Ein weiterer Weg zur Aktivierung ist die Eingabe von  |\n\
| ESC und danach die Taste.					   |\n\
+----------+-------------------------------------------------------+\n\
|  0-9	   |   Equivalent zu den Funktionstasten F10-F1-F2...F9    |\n\
|  A	   |   Dropdown Men					   |\n\
|  B	   |   Suche Text					   |\n\
|  C	   |   Block kopieren					   |\n\
|  D	   |   Block kopieren					   |\n\
|  E	   |   Anfang des Dokuments				   |\n\
|  F	   |   Suche Tag					   |\n\
|  G	   |   Gehe zu Zeile					   |\n\
|  H	   |   Lsche Zeichen links vom Cursor			   |\n\
|  I	   |   Tabulator					   |\n\
|  J	   |   Ein Wort nach links				   |\n\
|  K	   |   Ein Wort nach rechts				   |\n\
|  L	   |   Weitersuchen					   |\n\
|  M	   |   EINGABE						   |\n\
|  N	   |   Aktiviere Kontrollmodus				   |\n\
|  O	   |   Zeige Liste aller offenen Dokumente		   |\n\
|  P	   |   Block einfgen					   |\n\
|  Q	   |   Block ausschneiden				   |\n\
|  R	   |   Suchen und Ersetzen				   |\n\
|  S	   |   Tag vervollstndigen				   |\n\
|  T	   |   Block ausschneiden				   |\n\
|  U	   |   Vorlage einfgen 				   |\n\
|  V	   |   Block einfgen					   |\n\
|  W	   |   Ende des Dokuments				   |\n\
|  X	   |   Beenden						   |\n\
|  Y	   |   Zeile lschen					   |\n\
|  HOCH    |   Seite hoch					   |\n\
|  RUNTER  |   Seite runter					   |\n\
|  LINKS   |   Wort nach links					   |\n\
|  RECHTS  |   Wort nach rechts 				   |\n\
|  POS1    |   Anfang des Dokuments				   |\n\
|  ENDE    |   Ende des Dokuments				   |\n\
+----------+-------------------------------------------------------+\n\
| Eingabemodus							   |\n\
| (Dateinamen, zu suchender Text, etc.) 			   |\n\
+----------+-------------------------------------------------------+\n\
|  ENTER   |   Eingabe						   |\n\
|  ESC	   |   Abbrechen					   |\n\
|  Strg-N  |   Abbrechen					   |\n\
|  Strg-U  |   Eintrag lschen					   |\n\
|  HOCH    |   Zurck in der History				   |\n\
|  RUNTER  |   Weiter in der History				   |\n\
|  BACKSPC |   Lsche Zeichen links vom Cursor			   |\n\
+----------+-------------------------------------------------------+" },

	{ MSG_USAGE_TEXT, "\
Aufruf: mp [Optionen] [Datei [Datei ...]]\n\
\n\
Optionen:\n\
\n\
 -t|--tag [Tag] 	ffnet die Datei in der Tag definiert ist\n\
 -w|--word-wrap [col]	Setzt den Zeilenumbruch auf Spalte col\n\
 -ts|--tab-size [size]	Setzt Tabulatorgre auf size\n\
 --alt-color		Alternatives Farbschema (mehr Kontrast)\n\
 --mouse		Aktiviere Mausuntersttzung zur Cursorplatzierung\n\
 --col80		Markiert Spalte # 80\n\
 -hw|--hardware-cursor	Aktiviert den Hardwarecursor\n\
 --version		Version anzeigen\n\
 -h|--help		Diese Hilfeseite\n\
 -bw|--monochrome	Monochrom\n\
 -ai|--autoindent	Aktiviert das Automatische Einrcken\n\
 -nt|--no-transparent	Deaktiviert transparenten Modus (eterm, aterm, etc.)\n\
 -l|--lang lang 	Language selection\n\
 -m|--mode [mode]	Syntax-Hervorhebung. Verfgbare Modi:\n\
			" },

	{ MSG_EMPTY_TEMPLATE, "\
%%Leere Vorlage\n\
\n\
Diese Vorlage ist leer. Um Vorlagen zu erstellen, schreiben Sie fr\n\
jedes Name (markiert durch zwei % zusammen am Anfang der Zeile) und den\n\
Textkrper, abgegrenzt durch den nchsten Vorlagennamen oder das Ende\n\
der Datei. Durch das Auswhlen einer Vorlage aus der Liste (angezeigt\n\
durch Strg+U) wird sie in den momentanen Text eingefgt.\n" },
	{ 0, NULL }
};

