/***************************************************************************
                          mp3kultview.h  -  description
                             -------------------
    begin                : Tue Feb 13 15:23:55 /etc/localtime 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef MP3KULTVIEW_H
#define MP3KULTVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>
//#include <qlistview.h>
#include <qfont.h>


#include <qlayout.h>

#include <kfiledialog.h>
#include <kmainwindow.h>
#include "mydb.h"
#include "item.h"
#include "mp3list.h"

/*class Mp3KultDoc;*/

/** The Mp3KultView class provides the view widget for the Mp3KultApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As Mp3KultView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the Mp3KultApp class to manipulate and display
 * the document structure provided by the Mp3KultDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
//#define MYSQL_ROW char**
class MyDb;
class Mp3KultView : public QWidget
{
  Q_OBJECT
  //class MyDb;
  public:
    /** Constructor for the main view */
    Mp3KultView(MyDb *db, QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~Mp3KultView();

    void decTotalMp3(int n);
    /** returns a pointer to the document connected to the view instance. Mind that this method requires a Mp3KultApp instance as a parent
     * widget to get to the window document pointer by calling the Mp3KultApp::getDocument() method.
     *
     * @see Mp3KultApp#getDocument
     */
    /*Mp3KultDoc *getDocument() const;*/

    /** contains the implementation for printing functionality */
    void print(QPrinter *pPrinter);
     void viewallmp3(KMainWindow * = 0);
     void viewmp3(MYSQL_ROW row);
     void viewVolume (const char* volname);
     void updateViewVolume (int del, const char* volname);
		void updateRenamed (int num, const char* oldName, const char* newName);
     void remViewVolume (const char* volname, int num);
     void setFont(QFont font);
     Mp3List* getListView() const;
     void saveOptions();

private:
		MyDb* db;
     /*QListViewItem*/
     Mp3ListItem *item, *last, *parentItemFind;
		 bool status, findAll;
     QFont acFont;
     QWidget* parent;
     QGridLayout* mainGrid;
     Mp3List* listview;
     MYSQL_ROW row;
     int totalmp3;
		 bool tree;

	void setValues(Mp3ListItem *item, MYSQL_ROW row);
     void setupListView();
     const char* elabLength(int len);
     void readOptions();
     void exportView(bool selected);
     bool colVis(int column);

signals:

void viewallmp3Total(int);


protected slots:

void slotsearch (QString text, bool reset);
void slotadvsearch (QString text, bool reset, const bool* options);
void slotParentOpenIcon(QListViewItem *item);
void slotParentCloseIcon(QListViewItem *item);

public slots:
    void slotExport();
    void slotExportSelected();
		void slotToggleFindInAllTree();
		void slotToggleTreeView();
		void slotTreeOpenAll();
		void slotTreeCloseAll();
};

#endif // MP3KULT_H
