/***************************************************************************
                          mp3kult.h  -  description
                             -------------------
    begin                : Tue Feb 13 15:23:55 /etc/localtime 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef MP3KULT_H
#define MP3KULT_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for KDE
#include <kapp.h>
#include <kdockwidget.h>
#include <kaccel.h>
#include <kaction.h>
#include <kprogress.h>

// include files for Qt
#include <qdir.h>
#include <qsplitter.h>

#include "plview.h"
#include "find.h"
#include "mydb.h"

// forward declaration of the Mp3Kult classes
/*class Mp3KultDoc;*/
class Mp3KultView;

/**
  * The base class for Mp3Kult application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of Mp3KultView creates your center view, which is connected
  * to the window's Doc object.
  * Mp3KultApp reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
class Mp3KultApp : public KDockMainWindow
{
	Q_OBJECT

	friend class Mp3KultView;

	public:
    /** construtor of Mp3KultApp, calls all init functions to create the application.
     */
		Mp3KultApp(QWidget* parent=0, const char* name=0);
		~Mp3KultApp();

		void decTotalMp3(int n);
		void initProgBar(int max);
		void advProgBar(int val);
		void resetProgBar();
		void setCursorBusy(bool b);
		void connectToDB();

	protected:
    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */
		void saveOptions();
    /** read general Options again and initialize all variables like the recent file list
     */
		void readOptions();
    /** initializes the KActions of the application */
		void initActions();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
		void initStatusBar();
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view
     */
		void initView();

		void initFind();
		void insertInfoDB();
		bool initDataBase();
		void checkVersion();
    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
     * be saved if Modified; on cancel the closeEvent is rejected.
     * @see KTMainWindow#queryClose
     * @see KTMainWindow#closeEvent
     */
 /*   virtual bool queryClose();*/
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */
		virtual bool queryExit();
		void dePLActions();
		void playSongs (bool enqueue);
		void playPLSongs(bool enqueue);

	public slots:
    /** print the actual file */
		void slotFilePrint();
    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
		void slotFileQuit();
    /** toggles the toolbar
     */
		void slotViewToolBar();
    /** toggles the statusbar
     */
		void slotViewStatusBar();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */

		void slotViewTreeOptions(bool tree);

		void slotPopupMenu( QListViewItem *l, const QPoint &pos, int );
		void slotPLPopupMenu( QListViewItem *, const QPoint &pos, int );
		void slotStatusMsg(const QString &text);

		void slotTotalMp3Msg(int);

		void slotFileRefresh();
    //void slotFileExport();

		void slotVolumeAdd();
		void slotVolumeAddCd();
		void slotVolumeDel();
		void slotVolumeUpdate();
		void slotVolumeAddMp3();
		void slotVolumeRename();

		void slotEraseDb();

		void slotFind();
		void slotFindNext();

		void slotPreferences();

		void slotPopupEditTag();
		void slotPopupDelMp3();
		//void slotPopupPlaySong();
		void slotPopupPlaySongs();
		void slotPopupEnqueueSongs();
		void slotPopupAddSongsPL();
		//void slotPopupAddSelected();

		void slotPopupPLPlaySongs();
		void slotPopupPLEnqueueSongs();
		void slotPopupPLPlayAllSong();
		void slotTogglePL();

		void slotPlaySong(QListViewItem* item);
		void slotPLPlaySong( QListViewItem* item);
		void slotHeaderCloseButton();

	private:
		MyDb *db;
    /** the configuration object of the application */
		KConfig *config;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
		Mp3KultView *view;
    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
   /* Mp3KultDoc *doc;*/

		PLView* plview;
		KDockWidget* pldock;
		KDockWidget* maindock;
		//QSplitter *splitter;
    // KAction pointers to enable/disable actions
		Mp3Find* find;

		KAction *fileNewWindow, *fileNew, *fileOpen, *fileSave, *fileSaveAs;
		KAction *fileClose, *filePrint, *fileQuit, *fileExport;
		KAction *fileExportSelected, *fileRefreshList, *fileEraseDb;

		KRecentFilesAction* fileOpenRecent;

		KAction *editCut, *editCopy, *editPaste;

		KAction *searchFind, *searchFindNext;

		KAction* settingsPreferences;

		KAction *volumeAdd, *volumeAddCd, *volumeDel, *volumeUpdate, *volumeAddMp3;
		KAction *volumeRename;

		KToggleAction *viewToggleTreeView, *viewToggleFindInAllTree;
		KAction *viewTreeOpenAll, *viewTreeCloseAll;

		KAction *plAddSong, *plDel, *plSave, *plNew, *plLocal, *plExport;
		KAction* plImport, *plRefreshStatus, *plRename;

		KAction* popupEditTag, *popupDelMp3, *popupAddSongsPL, *popupPlaySongs;
		KAction* popupEnqueueSongs;;

		KAction *popupPLPlaySongs, *popupPLRemoveSongs, *popupPLEnqueueSongs;
		KAction *popupPLPlayAllSong;

		KAction* togglePL;

		KToggleAction* viewToolBar;
		KToggleAction* viewStatusBar;
    /*KFileDialog* dir;*/

		KProgress* progressBar;
		bool hidePL;
		QDir path;
		QString playerExe;
		QString playerOpt;
		int filetype;
		//bool dbConnect;
		bool initAll;

};

extern Mp3KultApp* mp3kult;

#endif // MP3KULT_H
