/***************************************************************************
                          addcd.cpp  -  description
                             -------------------
    begin                : Thu Feb 22 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "addcd.h"

#include "resources.h"
#include <stdlib.h>


#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>

#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kprocess.h>

AddCd::AddCd(MyDb* db, QWidget* parent, const char* name)
     : QDialog (parent, name, true), db(db)
{
     initDialog();
     setOptions();
     connect (volname, SIGNAL(returnPressed()), this, SLOT(slotbutok()));
     connect (butok, SIGNAL(clicked()), SLOT (slotbutok()));
     connect (butcancel, SIGNAL(clicked()), SLOT (slotbutcancel()));
}

void AddCd::initDialog()
{
     setCaption(i18n("Add CdRom"));

     QGridLayout* grid = new QGridLayout (this,3,3,8,20);

     eject= new QCheckBox(this, "check_eject");
     grid->addWidget (eject, 0,0);
     eject->setText ( i18n("Eject"));

     recursive = new QCheckBox(this, "check_recursive");
     grid->addWidget(recursive, 0, 2);
     recursive->setText(i18n("Recursive"));

    /* QLabel *lvolname= new QLabel(i18n("Volume Name"), this);
     lvolname->resize( lvolname->sizeHint() );
     grid->addWidget(lvolname, 1, 0);   */

     QGroupBox* group = new QGroupBox (this);
     group->setTitle(i18n("Volume Name"));
     group->setLineWidth(1);
     group->setMidLineWidth( 0 );
     grid->addMultiCellWidget(group, 1, 1, 0, 2);

     QGridLayout* grid1 = new QGridLayout (group, 1, 1, 25, 4);

     volname = new QLineEdit(group);
     volname->setMaxLength(MAX_VOLUME_L);
    /* grid->addMultiCellWidget(volname, 1, 1, 1, 2);*/
      grid1->addWidget(volname,0,0);

   /*grid->addRowSpacing (0, 40);      */


    /* QGroupBox* group = new QGroupBox (this);
     group->setTitle(i18n("Cd-Rom Mount Path"));
     group->setLineWidth(1);
     group->setMidLineWidth( 0 );
     grid->addMultiCellWidget(group, 1, 2, 0, 2);

     QGridLayout* grid1 = new QGridLayout (group, 1, 2, 15, 4);

     dir = new QLineEdit(group);
     grid1->addWidget(dir,0,0);


     butdirdial = new QPushButton (group, "Dir..." );
     butdirdial->setText ("...");
     butdirdial->resize (butdirdial->sizeHint() );

     grid1->addWidget (butdirdial, 0,1);  */



     butok = new QPushButton (this, "Push_Ok");
     butok->resize (butok->sizeHint() );
     butok->setText( i18n("Ok") );
     grid->addWidget (butok, 2,0);



     butcancel = new QPushButton( this, "Push_Cancel" );
     grid->addWidget(butcancel,2,2);
     butcancel->resize (butcancel->sizeHint() );
     butcancel->setText( i18n("Cancel") );


     volname->setFocus();
     resize (270, 170);
}

void AddCd::setOptions()
{

     KConfig *config;

     config = kapp->config();

     config->setGroup("OPTIONS");
   /*  dir->setText(config->readEntry ("Cdpath", ""));    */
     path = config->readEntry ("Cdpath", "");
     eject->setChecked(config->readBoolEntry("Eject", false));
     recursive->setChecked(config->readBoolEntry("RecursiveCd", true));
}

void AddCd::slotbutok()
{
   if (volname->text()=="")
     {
       KMessageBox::error( this, i18n("Volume Name  \n"
                                      "Must be NOT NULL !!"  ));
       return;
     }
     done(0);
}

void AddCd::adding(int filetype)
{
    KProcess p;
   QString command;
   QString command2;


     if (!checkMounted())
     {
        p << "mount" << path;
         /* command= QString("mount ");
          command= command+path+" > /dev/null";
          system(command);  */
        p.start( KProcess::Block);
        p.clearArguments();
          if (!checkMounted())
          {
               KMessageBox::error(this, i18n("Mount Failed !"), i18n("Error"));
               return;
          }


     }

     //MyDb* db;
     //db=new MyDb();
     db->addVolume(path, true, volname->text(), filetype);
     if (eject->isChecked())
     {
          /*command2=QString("eject -r ");
          command2=command2 + path;
          system(command2); */
        p << "eject" << "-r" << path;
        p.start( KProcess::Block);
        p.clearArguments();
     }
     else
     {
         /* command2=QString("umount ");
          command2=command2 + path + " > /dev/null";
          system(command2);    */
        p << "umount" << path;
        p.start( KProcess::Block);
        p.clearArguments();
     }


}

void AddCd::slotbutcancel()
{
    done(1);
}


bool AddCd::checkMounted ()
{
  FILE *fp;
  char line[1024];
  char s1[1024];
  char s2[1024];
  char s3[1024];
  int rc;

  fp = fopen ("/proc/mounts", "r");
  if (fp == NULL)
    return false;

  while (fgets (line, sizeof (line), fp) != 0)
    {
      rc = sscanf (line, "%1023s %1023s %1023s", s1, s2, s3);
      if ((rc >= 3) && (strcmp (s2, path) == 0))
	{
	  fclose (fp);
	  return true;
	}
    }
  fclose (fp);
  return false;

}

QString AddCd::getVolName()
{
     return (volname->text());
}


#include "addcd.moc"
