# copyright (C) 1997-2005 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: help.tcl,v 2.35 2005/01/02 00:45:07 jfontain Exp $

namespace eval help {

    variable description \
"<center><h4>moodss
<br>Modular Object Oriented Dynamic SpreadSheet
<br>version $global::applicationVersion</h4></center>

<p><i>Copyright &copy; 1997-2005 Jean-Luc FONTAINE (jfontain@free.fr). All rights reserved.</i>
<br><i>Japanese translation thanks to SENRI Hiroshi and KITAHARA Kosei.</i>

<p>This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License (GPL) version 2 as published by the Free Software Foundation (at http://www.gnu.org).
<br>This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

<p>This software uses the following extensions:<ul>
  <li>the BLT library by George Howlett
  <li>the tkTable widget by Jeffrey Hobbs
  <li>the MIME/SMTP library (part of tcllib) by Marshall Rose
  <li>the BWidget widget set
  <li>the tclXML and tclDOM libraries from Zveno
  <li>the Tcl HTML library from Sun Microsystems
  <li>the stooop OO (part of tcllib) extension by me
  <li>the scwoop widget library by me
  <li>the tkpiechart widget by me
  <li>the SQLite library (included in the moodss standalone binary package and Windows package)
</ul>

<p><p>The KDE Crystal theme icons are licensed under the GNU Lesser General Public License (LGPL) version 2.1 as published by the Free Software Foundation (at http://www.gnu.org), with the following addition:

<p><i>Copyright (C) 2002 and following years KDE Artists.</i>
<br>The GNU Lesser General Public License or LGPL is written for software libraries in the first place. We expressly want the LGPL to be valid for this artwork library too. KDE Crystal theme icons is a special kind of software library, it is an artwork library, its elements can be used in a Graphical User Interface, or GUI.
<br>Source code, for this library means:<ul>
  <li>for vectors svg
  <li>for pixels, if applicable, the multi-layered formats xcf or psd, or otherwise png
</ul>
<br>The LGPL in some sections obliges you to make the files carry notices. With images this is in some cases impossible or hardly useful. With this library a notice is placed at a prominent place in the directory containing the elements. You may follow this practice. The exception in section 6 of the GNU Lesser General Public License covers the use of elements of this art library in a GUI.

<p><p>The tclXML and tclDOM libraries by Zveno are made available under the following license terms:

<p><i>Copyright &copy; 1998-2002 Zveno Pty Ltd (http://www.zveno.com/).</i>
<br>Zveno makes this software available free of charge for any purpose. Copies may be made of this software but all of this notice must be included on any copy.
<br>The software was developed for research purposes only and Zveno does not warrant that it is error free or fit for any purpose.  Zveno disclaims any liability for all claims, expenses, losses, damages and costs any user may incur as a result of using, copying or modifying this software.

<p><p>The Tcl HTML library developed by Sun Microsystems is made available under the following license terms:

<p>Sun Microsystems, Inc.  The following terms apply to all files associated with the software unless explicitly disclaimed in individual files.
<br>The authors hereby grant permission to use, copy, modify, distribute, and license this software and its documentation for any purpose, provided that existing copyright notices are retained in all copies and that this notice is included verbatim in any distributions. No written agreement, license, or royalty fee is required for any of the authorized uses. Modifications to this software may be copyrighted by their authors and need not follow the licensing terms described here, provided that the new terms are clearly indicated on the first page of each file where they apply.
<br>IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
<br>THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT. THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
<br>RESTRICTED RIGHTS: Use, duplication or disclosure by the government is subject to the restrictions as set forth in subparagraph (c) (1) (ii) of the Rights in Technical Data and Computer Software Clause as DFARS 252.227-7013 and FAR 52.227-19."

}

proc aboutDialogBox {} {
    set dialog [new dialogBox . -buttons x -default x -title [mc {moodss: About}] -x [winfo pointerx .] -y [winfo pointery .]]
    set viewer [new htmlViewer $widget::($dialog,path) -data $help::description]
    composite::configure $viewer base -height 300 -width 500
    dialogBox::display $dialog $widget::($viewer,path)
    composite::configure $dialog -deletecommand "delete $viewer"                     ;# delete objects not managed by the dialog box
}

proc linkedHelpWidgetTip {path} {
    return [new widgetTip\
        -path $path\
        -text [mc {display the relevant section in the global help window (may take some time if the window is not yet opened)}]\
    ]
}
