# -*- makefile -*-

if ARCH_DARWIN
if MPC107
# dummy
else
BUNDLE		= MolExt.kext
A_KERNEL_MODULE	= $(BUNDLE)/Contents/MacOS/MolExt

KFRAMEWORK	= -I/System/Library/Frameworks/Kernel.framework/Headers \
		  -I/System/Library/Frameworks/Kernel.framework/Headers/bsd

A_INCLUDES	= -Wall -O -I$(top_srcdir)/src/kmod/include -I$(top_srcdir)/src/shared \
		  -I$(top_srcdir)/src/kmod/Darwin -nostdinc $(KFRAMEWORK)

A_CFLAGS	= -arch ppc -fno-common -msoft-float -mlong-branch \
		  -finline -fno-keep-inline-functions -force_cpusubtype_ALL -static \
		  -DKERNEL -D__KERNEL__ -DKERNEL_PRIVATE -DDRIVER_PRIVATE -DAPPLE -DNeXT -g

A_CXXFLAGS	= $(A_CFLAGS) -x c++ -fno-rtti -fno-exceptions -fcheck-new \
		  -fvtable-thunks -findirect-virtual-calls


#############################################################################
# kext linking
#############################################################################

$(A_KERNEL_MODULE): $(BUNDLE)/Contents/Info.plist
	@$(CC) -o $@ $(KMOD_OBJS) `cat Darwin/objs` -arch ppc -static -nostdlib \
		-r -lkmodc++ -lkmod -lcc_kext 
	echo $(CC) -o $@ $(KMOD_OBJS) `cat Darwin/objs` -arch ppc -static -nostdlib \
		-r -lkmodc++ -lkmod -lcc_kext 

#############################################################################
# Bundle building
#############################################################################

$(BUNDLE)/Contents/Info.plist: Darwin/Info.plist
	@test -d $(BUNDLE) || mkdir $(BUNDLE)
	@test -d $(BUNDLE)/Contents || mkdir $(BUNDLE)/Contents
	@test -d $(BUNDLE)/Contents/MacOS || mkdir $(BUNDLE)/Contents/MacOS
	@test -d $(BUNDLE)/Contents/Resources || mkdir $(BUNDLE)/Contents/Resources
	cp -f Darwin/Info.plist $(BUNDLE)/Contents/Info.plist


#############################################################################
# Module loading
#############################################################################

insert:
	sudo kextload MolExt.kext
remove:
	sudo kextunload MolExt.kext

reload: remove insert

endif
endif
