#ifndef _M_DEBUG_H_
#define _M_DEBUG_H_

#if 0
#define IS_M_DEBUG(dbg, sec, lvl) \
		((dbg >> (sec * M_DEBUG_LEVEL_SHIFT) & M_DEBUG_LEVEL_MASK) >= lvl)
#else
#define IS_M_DEBUG(dbg, sec, lvl) \
		(dbg >= lvl)
#endif


#ifdef HAVE_FUNCTION
#define M_DEBUG0(dbg, sec, lvl, fmt) \
		if (IS_M_DEBUG(dbg, sec, lvl)) {\
			fprintf(stderr, "%s.%d (%s): " fmt, __FILE__, __LINE__, __FUNCTION__); \
                }


#define M_DEBUG1(dbg, sec, lvl, fmt, parm1) \
	if (IS_M_DEBUG(dbg, sec, lvl)) {\
		fprintf(stderr, "%s.%d (%s): " fmt, __FILE__, __LINE__, __FUNCTION__, parm1); \
	}

#define M_DEBUG2(dbg, sec, lvl, fmt, parm1, parm2) \
	if (IS_M_DEBUG(dbg, sec, lvl)) {\
		fprintf(stderr, "%s.%d (%s): " fmt, __FILE__, __LINE__, __FUNCTION__, parm1, parm2); \
	}

#define M_DEBUG3(dbg, sec, lvl, fmt, parm1, parm2, parm3) \
	if (IS_M_DEBUG(dbg, sec, lvl)) {\
		fprintf(stderr, "%s.%d (%s): " fmt, __FILE__, __LINE__, __FUNCTION__, parm1, parm2, parm3); \
	}

#define M_DEBUG4(dbg, sec, lvl, fmt, parm1, parm2, parm3, parm4) \
	if (IS_M_DEBUG(dbg, sec, lvl)) {\
		fprintf(stderr, "%s.%d (%s): " fmt, __FILE__, __LINE__, __FUNCTION__, parm1, parm2, parm3, parm4); \
	}

#define M_WP() \
	fprintf(stderr, "%s.%d (%s)\n", __FILE__, __LINE__, __FUNCTION__);
#else
# define M_DEBUG0(dbg, sec, lvl, fmt) \
		if (IS_M_DEBUG(dbg, sec, lvl)) {\
			fprintf(stderr, "%s.%d: " fmt, __FILE__, __LINE__); \
                }


# define M_DEBUG1(dbg, sec, lvl, fmt, parm1) \
	if (IS_M_DEBUG(dbg, sec, lvl)) {\
		fprintf(stderr, "%s.%d: " fmt, __FILE__, __LINE__, parm1); \
	}

# define M_DEBUG2(dbg, sec, lvl, fmt, parm1, parm2) \
	if (IS_M_DEBUG(dbg, sec, lvl)) {\
		fprintf(stderr, "%s.%d: " fmt, __FILE__, __LINE__, parm1, parm2); \
	}

#define M_DEBUG3(dbg, sec, lvl, fmt, parm1, parm2, parm3) \
	if (IS_M_DEBUG(dbg, sec, lvl)) {\
		fprintf(stderr, "%s.%d: " fmt, __FILE__, __LINE__, parm1, parm2, parm3); \
	}
#define M_DEBUG4(dbg, sec, lvl, fmt, parm1, parm2, parm3, parm4) \
	if (IS_M_DEBUG(dbg, sec, lvl)) {\
		fprintf(stderr, "%s.%d: " fmt, __FILE__, __LINE__, parm1, parm2, parm3, parm4); \
	}

#define M_WP() \
	fprintf(stderr, "%s.%d\n", __FILE__, __LINE__);
#endif


#define M_DEBUG_LEVEL_MASK              0x3
#define M_DEBUG_LEVEL_SHIFT             2
#define M_DEBUG_LEVEL_NONE              0
#define M_DEBUG_LEVEL_ERRORS            1
#define M_DEBUG_LEVEL_WARNINGS          2
#define M_DEBUG_LEVEL_VERBOSE           3

#define M_DEBUG_SECTION_INIT            0
#define M_DEBUG_SECTION_PARSING         1
#define M_DEBUG_SECTION_PROCESSING      2
#define M_DEBUG_SECTION_GENERATING      3
#define M_DEBUG_SECTION_CLEANUP         4
#define M_DEBUG_SECTION_INTERNALS       5
#define M_DEBUG_SECTION_MAINLOOP        6

#endif
