/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.c,v 1.2 2003/07/18 11:38:10 ostborn Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>

#include "mlocale.h"
#include "mplugins.h"
#include "mrecord.h"
#include "mdatatypes.h"
#include "misc.h"

#include "plugin_config.h"

/* this code is taken from the squid plugin */

/* init the plugin */

int mplugins_input_mod_log_sql_dlinit(mconfig *ext_conf) {
	config_input *conf = NULL;

	if (0 != strcmp(ext_conf->version, VERSION)) {
		M_DEBUG2(ext_conf->debug_level, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "version string doesn't match: (mla) %s != (plugin) %s\n", ext_conf->version, VERSION);
		return -1;
	}

/* get the neccesary space */
	conf = malloc(sizeof(config_input));
	memset(conf, 0, sizeof(config_input));

/* connect the plugin config to the master config */
	ext_conf->plugin_conf = conf;

	return 0;
}

/* destructor */

int mplugins_input_mod_log_sql_dlclose(mconfig *ext_conf) {
	config_input *conf = ext_conf->plugin_conf;
	
#ifdef HAVE_MYSQL
	mysql_free_result(conf->result);
	mysql_close(conf->mysql);
#endif
	
#define CLEAN(x) \
	if (conf->x) free(conf->x)
	
	CLEAN(user);
	CLEAN(host);
	CLEAN(database);
	CLEAN(passwd);
	CLEAN(query);
#undef CLEAN
	free(ext_conf->plugin_conf);
	ext_conf->plugin_conf = NULL;
	

	return 0;
}

int mplugins_input_mod_log_sql_parse_config(mconfig *ext_conf, const char *filename, const char *section) {
	config_input *conf = ext_conf->plugin_conf;

/* add your config options here. the format of the struct:
 * {"<name of the option>", <type>, <how to handle the further
 * occurences of the same value>, <address of the pointer where
 * the value should go to> }
 *
 * you only have the change config_values[] the rest is done in the
 * background (-> ./src/mconfig.c)
 */
	const mconfig_values config_values[] = {
		{"db_user",	M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->user)},
		{"db_host",	M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->host)},
		{"db_database",	M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->database)},
		{"db_passwd",	M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->passwd)},
		{"db_query",	M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->query)},

/* terminate the array of options */
		{NULL, M_CONFIG_TYPE_INT, 0, NULL}
	};

	return mconfig_parse_section(ext_conf, filename, section, config_values);
}


int mplugins_input_mod_log_sql_set_defaults(mconfig *ext_conf) {
	config_input *conf = ext_conf->plugin_conf;

#define CLEAN(x) \
	if (!conf->x) { \
		printf("db_"#x" has to be set\n"); \
		return -1;\
	}
	
	CLEAN(user);
	CLEAN(host);
	CLEAN(database);
	CLEAN(passwd);
	CLEAN(query);
#ifdef HAVE_MYSQL	
	if (NULL == (conf->mysql = mysql_init(NULL))) {
		printf("mysql_init() failed\n");
		return -1;
	}
	
	if (NULL == (mysql_real_connect(conf->mysql, conf->host, conf->user, conf->passwd,
					NULL, 0, NULL, 0))) {
		printf("mysql_connect() failed\n");
		return -1;
	}
	
	if (0 != mysql_select_db(conf->mysql, conf->database)) {
		printf("mysql_select_db() failed\n");
		return -1;
	}
	
	
	if (0 != mysql_query(conf->mysql, conf->query)) {
		printf("%s.%d: %s<br />\n", __FILE__, __LINE__, mysql_error(conf->mysql));
		return -1;
	}
	
	if (NULL == (conf->result = mysql_store_result(conf->mysql))) {
		printf("%s.%d: %s<br />\n", __FILE__, __LINE__, mysql_error(conf->mysql));
		return -1;
	}
#endif
	return 0;
}


int mplugins_init(mplugin *func) {
	func->dlinit = mplugins_input_mod_log_sql_dlinit;
	func->dlclose = mplugins_input_mod_log_sql_dlclose;
	func->parse_config = mplugins_input_mod_log_sql_parse_config;
	func->set_defaults = mplugins_input_mod_log_sql_set_defaults;
	func->get_next_record = mplugins_input_mod_log_sql_get_next_record;
	func->insert_record = NULL;
	func->gen_report = NULL;
        func->gen_history = NULL;

	return 0;
}
