/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.h,v 1.7 2003/04/18 18:32:26 ostborn Exp $
*/
#ifndef _INPUT_PLUGIN_CONFIG_H_
#define _INPUT_PLUGIN_CONFIG_H_

#include <pcre.h>

#include "mio.h"
#include "mconfig.h"
#include "mrecord.h"

typedef struct {
	pid_t pid;
	char *hostname;
	char *ip;
	char *username;
	int state;
	time_t starttstmp;
	time_t lasttstmp;
} bsdftpd_user;

typedef struct {
	char	*inputfilename;
	mfile   inputfile;
	buffer  *buf;

	bsdftpd_user **connections;
	int connection_size;

	pcre	*match_bsdftpd_syslog_pre,
		*match_bsdftpd_syslog_timestamp,
		*match_bsdftpd_user_login_success,
		*match_bsdftpd_user_login_refused,
		*match_bsdftpd_user_login_failed,
		*match_bsdftpd_anonymous_login_success,
		*match_bsdftpd_anonymous_login_refused,
		*match_bsdftpd_connection,
		*match_bsdftpd_put,
		*match_bsdftpd_mkdir,
		*match_bsdftpd_delete,
		*match_bsdftpd_get,
		*match_bsdftpd_user,
		*match_bsdftpd_rename,
		*match_bsdftpd_rmdir,
		*match_bsdftpd_append;

} config_input;

int mplugins_input_bsdftpd_get_next_record(mconfig *ext_conf, mlogrec *record);

#endif
