#ifndef PLAYER_STATUS_H
#define PLAYER_STATUS_H

#include <string>

#include "Tools.h"
#include "SDLTools.h"

//----------------------------------------------------------------------------
class PlayerStatus
{
    //------------------------------------------------------------------------
    PlayerStatus();
    ~PlayerStatus();

  public:

    //------------------------------------------------------------------------
    inline static PlayerStatus* getInstance()
    {
        if (sm_instance == NULL)
            sm_instance = new PlayerStatus();
        return sm_instance;
    }

    //------------------------------------------------------------------------
    inline static void destroy()
    {
        if (sm_instance)
            ZAP_POINTER(sm_instance);
    }


    //------------------------------------------------------------------------
    inline void addToScore(unsigned points)
    {
        m_score += points;
    }

    //------------------------------------------------------------------------
    inline size_t getScore() const
    {
        return m_score;
    }

    //------------------------------------------------------------------------
    inline void incLifes()
    {
        ++m_lifes;
    }

    //------------------------------------------------------------------------
    inline void decLifes()
    {
        --m_lifes;
    }

    //------------------------------------------------------------------------
    inline unsigned getLifes() const
    {
        return m_lifes;
    } 

    //------------------------------------------------------------------------
    inline void setInitialBonus(unsigned bonus)
    {
        m_bonus = bonus;
    }

    //------------------------------------------------------------------------
    inline void decBonus(unsigned decrement)
    {
        if (m_bonus > decrement)
        {
            m_bonus -= decrement;
        }
        else
        {
            m_bonus = 0;
        }
    }

    //------------------------------------------------------------------------
    inline unsigned getBonus() const
    {
        return m_bonus;
    }

    //------------------------------------------------------------------------
    inline void clearMessage()
    {
        m_message.clear();
    }

    //------------------------------------------------------------------------
    inline void setMessage(const std::string &message)
    {
        m_message = message;
    }

    //------------------------------------------------------------------------
    inline const std::string &getMessage() const
    {
        return m_message;
    }

  private:

    //------------------------------------------------------------------------
    unsigned m_score;
    unsigned m_lifes;
    unsigned m_bonus;
    std::string m_message;

    //------------------------------------------------------------------------
    static PlayerStatus* sm_instance;
};

#endif // PLAYER_STATUS_H
