/*======================================================================*\
|*		Editor mined						*|
|*		part 1							*|
\*======================================================================*/

#include "mined.h"
#include "io.h"

#include <errno.h>


/*======================================================================*\
|*			Definitions specific for mined1.c		*|
\*======================================================================*/

# ifdef unix
#  ifdef sysV
#  define print_command "lp %s"
#  else
#  define print_command "lpr %s"
#  endif
# endif

# ifdef vms
# define print_command "print %s"
# endif

# ifdef msdos
# define print_command "copy %s prn: > nul:"
# endif

#define mark_file	"@mined.mar"


#ifdef msdos
#ifdef __TURBOC__
#define msdos_screenfunctions
#endif
#endif


/**
   How to deal with non-matching tty and terminal sizes.
 */
#define adjust_terminal_height
#define dont_adjust_to_actual_termsize	/* not fully implemented */


/*======================================================================*\
|*			Forward declarations and local FLAGS		*|
\*======================================================================*/

static void set_file_type_flags _((void));
static void end_view_help _((void));

static FLAG save_viewonly;
static FLAG save_restricted;
static char save_file_name [maxLINE_LEN];
static FLAG viewing_help = False;
static int save_cur_column;
static int save_cur_line;


/*======================================================================*\
|*			Screen stuff					*|
\*======================================================================*/

#define clearscreen()	clear_screen (); top_line_scrolled = True;


/*======================================================================*\
|*			Data section					*|
\*======================================================================*/

LINE * header;			/* Head of line list */
LINE * tail;			/* Last line in line list */
LINE * cur_line;		/* Current line in use */
LINE * top_line;		/* First line of screen */
LINE * bot_line;		/* Last line of screen */
char * cur_text;		/* Current char on current line in use */
int last_y;			/* Last y of screen. Usually SCREENMAX */
int x = 0;			/* screen column of current text position */
int y = 0;			/* screen row of current text position */
int line_number;		/* current line # determined by file_status */
int lines_per_page = 0;		/* assumption for file_status */
int open_linum;			/* line # to re-position to */
int open_col;			/* column to re-position to */

int YMAX, XMAX;
short MENU = 1;
mousebutton mouse_button, mouse_lastbutton, mouse_prevbutton;
FLAG report_release = False;
int mouse_shift = 0;
int mouse_xpos, mouse_ypos, mouse_lastxpos, mouse_lastypos;

char linesplitmarker = '\0';	/* Leave 1 char. space BEFORE screen [] ! */
char screen [screen_BUFL + 1];	/* I/O buffer for "writes" and "reads" */

FLAG flags_changed = False;	/* Should flag menu area be redrawn? */
FLAG quickmenu = True;		/* Right mouse button pops up menu */
static int wheel_scroll = 3;	/* Number of lines scrolled by mouse wheel */
int total_lines = 0;		/* Number of lines in file */
long total_chars = -1L;		/* Number of characters in file */
FLAG modified = False;		/* Set when file is modified */
FLAG viewonly = False;		/* Set when view only mode is selected */
static FLAG init_viewonly = False;	/* Set with option v */
FLAG append_flag = False;	/* Set when buffer should be appended to */
FLAG restricted = False;	/* Set when edited file shall not be switched */
FLAG mined_keypad = True;	/* Apply mined keypad assignments */
FLAG mined_del_is_cut = True;	/* Del key cuts buffer */
FLAG overwriteOK = False;	/* Set if current file is OK for overwrite */
FLAG tab_left = True;		/* Set if moving up/down on TAB should go left */
FLAG writable;			/* Set if file cannot be written */
int JUSlevel = 0;		/* Keep justified while typing? */
int JUSmode = 0;		/* 1: paragraphs end at empty line */
FLAG autoindent = True;		/* Auto indent on input of Enter? */
FLAG dim_HTML = True;		/* Display HTML dimmed ? */
FLAG loading = True;		/* Loading a file? Init True for error handling */
FLAG quit = False;		/* Set when quit character is typed */
FLAG intr_char = False;		/* Set when intr character is typed */
FLAG winchg = False;		/* Set when window size has changed */
FLAG interrupted = False;	/* Set when a signal interrupts */
FLAG isscreenmode = False;	/* Set when screen mode is on */
FLAG stat_visible;		/* Set if status line is visible */
FLAG top_line_scrolled = False;	/* Was menu line scrolled away? */
FLAG always_disp_fstat = False;	/* Permanent file status display on status line? */
FLAG always_disp_code = False;	/* Permanent char code display on status line? */
FLAG always_disp_Han = False;	/* Permanent Han character description display on status line? */
FLAG disp_Han_Mandarin = False;	/* display this Han pronunciation ? */
FLAG disp_Han_Cantonese = False;	/* display this Han pronunciation ? */
FLAG disp_Han_Japanese = False;	/* display this Han pronunciation ? */
FLAG disp_Han_Sino_Japanese = False;	/* display this Han pronunciation ? */
FLAG disp_Han_Korean = False;	/* display this Han pronunciation ? */
FLAG disp_Han_Vietnamese = False;	/* display this Han pronunciation ? */
FLAG disp_Han_description = True;	/* display Han description ? */
FLAG disp_Han_full = True;	/* display full Han description ? */
FLAG waitingforinput = False;	/* Set while waiting for the next command key */
static FLAG rpipe = False;		/* Set if file should be read from stdin */
static FLAG wpipe = False;		/* Set if file should be written to stdout */
static FLAG multiexit = True;		/* Should exit command go to next file? */
FLAG wordnonblank = False;	/* Handle all non-blank sequences as words */
FLAG proportional = False;	/* Enable support for proportional fonts? */
FLAG auto_detect_utf = True;	/* Auto detect character encoding from file ? */
FLAG auto_detect_cjk = True;	/* Auto detect CJK encoding from file ? */
static char selected_encoding = ' ';
static FLAG cjk_encoding_selected = False;
static char * detect_encodings;	/* List of encodings to detect */
static char language_tag = 0;
FLAG translate_output = False;	/* Transform output diacritics to strings */
int translen;			/* length of " */
char * transout;		/* Output transformation table */
int tabsize = 8;		/* Width of tab positions, 4 or 8 */
char * dimansi;			/* Special character dimming ANSI sequence */
char * ctrlansi;		/* Control character display ANSI sequence */
char * uniansi;			/* Unicode character display ANSI sequence */
char * unimarkansi;		/* Unicode (lineend) marker display ANSI sequence */
char * combiningansi;		/* combining character display ANSI sequence */
char * menuansi;		/* menu line ANSI sequence */
char * HTMLansi;		/* HTML display ANSI sequence */
char * diagansi;		/* dialog (bottom status) line ANSI sequence */
char * scrollfgansi;		/* scrollbar foreground ANSI sequence */
char * scrollbgansi;		/* scrollbar background ANSI sequence */
FLAG controlQS = False;		/* must respect ^Q/^S handshake ? */
FLAG insert_mode = True;	/* insert or overwrite */
character erase_char = '\010';	/* effective (configured) char for erase left */
char emulation = ' ';		/* 'w' for WordStar, 'e' for emacs */
FLAG emacs_buffer = False;	/* enable emacs buffer fct for ^K/^T */
FLAG paste_stay_left = True;	/* cursor stays before pasted region */
character control_prefix = '\026'; /* ^V/^P/^Q character to prefix control chars */
character quit_char = '\034';	/* ^\/^G character to cancel command */
FLAG Turkish = False;		/* use Turkish case toggle specials ? */
FLAG Lithuanian = False;	/* use Lithuanian case toggle specials ? */
FLAG smart_quotes = True;	/* replace " with typographic quote ? */
static char * preselect_quote_style = NIL_PTR;

FLAG utf8_screen = False;	/* screen driven in UTF-8 mode ? */
FLAG utf8_input = False;	/* keyboard input in UTF-8 mode ? */
#ifndef pc_charset
FLAG pc_term = False;		/* PC (CP437) character set ? */
#endif
FLAG cjk_term = False;		/* terminal in CJK mode ? */
static FLAG cjk_term_selected = False;	/* explicitly selected CJK terminal ? */
FLAG cjk_uni_term = False;	/* terminal in CJK mode with Unicode widths ? */
FLAG gb18030_term = True;	/* does CJK terminal support GB18030 ? */
FLAG euc3_term = True;		/* does CJK terminal support EUC 3 byte ? */
FLAG euc4_term = True;		/* does CJK terminal support EUC 4 byte ? */
FLAG cjklow_term = True;	/* does CJK terminal support 81-9F range ? */
int cjk_tab_width;		/* width of CJK TAB indicator */
int cjk_lineend_width;		/* width of CJK line end indicator */
FLAG combining_screen = False;	/* combining character terminal ? */
static FLAG combining_screen_selected = False;	/* explicitly selected combining character terminal ? */
FLAG bidi_screen = False;	/* UTF-8 bidi terminal ? */
int width_data_version = 2;
int nonbmp_width_data = 0x4;
int combining_data_version = 3;
FLAG suppress_unknown_cjk = True;	/* on CJK terminal if no Unicode mapping */
FLAG suppress_extended_cjk = True;	/* on CJK terminal if in extended code range */
FLAG suppress_invalid_cjk = True;	/* on CJK terminal if invalid CJK code */
FLAG utf_cjk_wide_padding = False; /* always display CJK on UTF double-width ? */

FLAG cjk_text = False;		/* text in CJK encoding ? */
FLAG utf8_text = False;		/* text in UTF-8 representation ? */
FLAG mapped_text = False;	/* text in 8 bit, non-Latin-1 representation ? */
FLAG utf8_lineends = True;	/* detect UTF-8 LS and PS line ends ? */
FLAG poormansbidi = True;	/* poor man's bidirectional support ? */
FLAG disp_scrollbar = True;	/* shall scrollbar be displayed ? */
FLAG fine_scrollbar = True;	/* fine-grained UTF-8 scrollbar ? */
int scrollbar_width = 1;
FLAG update_scrollbar_lazy = True;	/* partial scrollbar refresh as needed ? */
FLAG combining_mode = False;	/* UTF-8 combining character display support ? */
static FLAG combining_mode_disabled = False;	/* combining mode explicitly disabled ? */
static FLAG U_mode_set = False;
FLAG display_block_graphics = False;	/* display control chars as graphics */
FLAG no_window_title = False;	/* suppress filename display in window title? */

char selection_space = SPACE_NEXT;	/* space behaviour in keyboard mapping menu */
FLAG enforce_keymap = False;	/* enable keyboard mapping even on non-suitable terminal */

FLAG page_scroll = False;	/* use scroll for page up/down */
FLAG page_stay = False;		/* stay at edge of screen after page up/down */
int display_delay = 3;		/* delay between display lines */

#ifdef msdos_with_auto_crlf
char RET_opt = 'r';		/* handle RET chars: ignore / newline */
#else
char RET_opt = ' ';		/* handle RET chars: ignore / newline */
#endif
lineend_type default_lineend = lineend_LF;	/* used for some inserts */

long chars_saved;		/* # of chars in paste buffer */
long bytes_saved;		/* # of bytes in paste buffer */
int lines_saved;		/* # of lines in paste buffer */
int input_fd = STD_IN;		/* File descriptors for terminal dialog */
#ifdef __EMX__
int output_fd = STD_OUT;
#else
int output_fd = STD_ERR;
#endif
unsigned int out_count = 0;	/* Index in output buffer */
char file_name [maxLINE_LEN];	/* Name of file in use */
char text_buffer [MAX_CHARS];	/* for get_line, modifications, build_string */
int hop_flag = 0;		/* Counter flag for the HOP function */
char TABchar = ' ';		/* Char to be shown in place of tab chars */
char TABchar0 = '\0';		/* Char to be shown at start of tab chars */
char TABchar2 = '\0';		/* Char to be shown at end of tab chars */
char TABcharmid = '\0';		/* Char to be shown in middle of tab chars */
unsigned long CJK_TAB_MARK = 0x2026;	/* to be shown in place of tab */
char SHIFT_BEG = '\0';		/* Char indicating that line continues left */
char RET_MARK = '\0';		/* Char indicating end of line */
char DOSRET_MARK = '\0';	/* Char indicating DOS end of line */
char PARA_MARK = '\0';		/* Char indicating end of paragraph */
char RET_BLANK = '\0';		/* Char to fill the end of line with */
char RET_BLANK2 = '\0';		/* Char to fill last position of line with */
char * UTF_TAB = NIL_PTR;	/* Char to be shown in place of tab chars */
char * UTF_TAB0 = NIL_PTR;	/* Char to be shown at start of tab chars */
char * UTF_TAB2 = NIL_PTR;	/* Char to be shown at end of tab chars */
char * UTF_TABmid = NIL_PTR;	/* Char to be shown in middle of tab chars */
char * UTF_RET = NIL_PTR;	/* Char indicating end of line */
char * UTF_DOSRET = NIL_PTR;	/* Char indicating DOS end of line */
char * UTF_PARA = NIL_PTR;	/* Char indicating end of paragraph */
char * UTF_RETblank = NIL_PTR;	/* Char to fill the end of line with */
char * UTF_RETblank2 = NIL_PTR;	/* Char to fill last position of line with */
FLAG paradisp = False;		/* Shall paragraph end be distinguished? */

#ifdef vms
unsigned int fprot = 0;		/* To be used for file creatings */
unsigned int bufprot = 0;	/* To be used for paste buffer file */
static unsigned int exeprot = 0;	/* To be used for creation of executables */
#else
PROT fprot = 0644;	/* To be used for file creatings */
PROT bufprot = 0600;	/* To be used for paste buffer file */
static PROT exeprot = 0111;	/* To be used for creation of executables */
#endif
static PROT xprot = 0;

int fnami;			/* Parameter index of current file name */
int fnami_min, fnami_max, fnami_cnt;
char * * fnamv;			/* Copy of argv, points to program params */

char * inisearch = NIL_PTR;	/* Optional startup search string */

extern int first_left_margin;
extern int next_left_margin;
extern int right_margin;

#ifdef unix
/* window headline and icon text setting */
char * window_string_code = "";
char * mined_modf = " (*)";
#endif

#define empty_buffer_name "[no file]"

/**
   Yank variables
 */
char * temp_dir;
char yank_file [maxLINE_LEN];
char yankie_file [maxLINE_LEN];
char html_file [maxLINE_LEN];	/* temp. file for HTML embedding buffer */
char panic_file [maxLINE_LEN];

/**
   Line indicators
 */
char TABdefault = '';		/* default TAB indicator */
char RETdefault = '';		/* indicates line end */
char DOSRETdefault = '';	/* indicates DOS line end */
char PARAdefault = '';		/* indicates end of paragraph */
char SHIFT_MARK = '';		/* indicates that line continues */
char UNI_MARK = '';		/* to be shown in place of Unicode char */


/*======================================================================*\
|*			Text string routines				*|
\*======================================================================*/

int
UTF_len (c)
  char c;
{
	if ((c & 0x80) == 0x00) {
		return 1;
	} else if ((c & 0xE0) == 0xC0) {
		return 2;
	} else if ((c & 0xF0) == 0xE0) {
		return 3;
	} else if ((c & 0xF8) == 0xF0) {
		return 4;
	} else if ((c & 0xFC) == 0xF8) {
		return 5;
	} else if ((c & 0xFE) == 0xFC) {
		return 6;
	} else { /* illegal UTF-8 code */
		return 1;
	}
}

/*
int
UTFseq_len (text)
  char * text;
{
	int follow = UTF_len (* text) - 1;
	int len = 1;
	text ++;
	while (follow > 0 && (* text & 0xC0) == 0x80) {
		len ++;
		text ++;
		follow --;
	}
	return len;
}
*/

int
CJK_len (text)
  character * text;
{
  if (multichar (* text)) {
	if (cjk_encoding == 'C' && * text == 0x8E) {
		return 4;
	} else if (cjk_encoding == 'J' && * text == 0x8F) {
		return 3;
	} else if (cjk_encoding == 'G'
		&& * (text + 1) <= '9'
		&& * (text + 1) >= '0') {
			return 4;
	} else {
		return 2;
	}
  } else {
	return 1;
  }
}


/*
 * char_count () returns the number of characters in the string
 * excluding the '\0'.
 */
int
char_count (string)
  char * string;
{
  int count = 0;

  if (string != NIL_PTR) {
	while (* string != '\0') {
		advance_char (& string);
		count ++;
	}
  }
  return count;
}


/**
   Quotation marks detection
 */

/**
   determine if current position (if quote mark) is opening
 */
static
FLAG
isopeningquote (s, beg)
  char * s;
  char * beg;
{
	unsigned int prevchar = precedingchar (s, beg);
	/* for now, follow simplified approach; don't consider 
	   quotes after quotes, or CJK embedded quotes */
	switch (prevchar) {
	case '(':
	case '\n':
	case '\t':
	case ' ':
	case '[':
	case '{':
		return True;
	}
	return False;
}

/**
   language-specific quotation mark counters
 */
static unsigned long count_plain = 0;
static unsigned long count_English = 0;
static unsigned long count_German = 0;
static unsigned long count_French = 0;
static unsigned long count_inwards = 0;
static unsigned long count_Dutch = 0;
static unsigned long count_Swedish_q = 0;
static unsigned long count_Swedish_g = 0;
static unsigned long count_Greek = 0;
static unsigned long count_Chinese = 0;
static unsigned long count_Japanese = 0;

static
void
reset_quote_statistics ()
{
	count_plain = 0;
	count_English = 0;
	count_German = 0;
	count_French = 0;
	count_inwards = 0;
	count_Dutch = 0;
	count_Swedish_q = 0;
	count_Swedish_g = 0;
	count_Greek = 0;
	count_Chinese = 0;
	count_Japanese = 0;
}

static unsigned long count_quotes;

static
void
check_quote_style (c, s)
  unsigned long c;
  char * s;
{
/*printf ("%4d %s\n", c, s);*/
  if (c > count_quotes) {
	count_quotes = c;
	set_quote_style (s);
  }
}

static
void
determine_quote_style ()
{
	count_quotes = 0;
	check_quote_style (count_plain, "\"\"");
	check_quote_style (count_English, "“”");
	check_quote_style (count_inwards, "»«");
	check_quote_style (count_German, "„“");
	check_quote_style (count_French, "«» ‹›");
	check_quote_style (count_Dutch, "„”");
	check_quote_style (count_Swedish_q, "””");
	check_quote_style (count_Swedish_g, "»»");
	check_quote_style (count_Greek, "«» ‟”");
	check_quote_style (count_Chinese, "《》");
	check_quote_style (count_Japanese, "『』");
}

/*
 * utf_count () returns the number of UTF-8 characters in the string
   (like char_count) and also detects quotation marks and updates 
   their statistics.
 */
int
utf8_count (string)
  char * string;
{
  char * start = string;
  int count = 0;
  unsigned long unichar;
  int utflen;

  if (string != NIL_PTR) {
    while (* string != '\0') {
	/* Detect quotation marks.
	   The UTF-8 codes of all quotation marks are either 
	   C2AB or C2BB or start with either E280 or E380. 
	   This may help for efficient detection during file loading.
	 */
	if ((((character) * string) <= 0x27
	     && (* string == '\'' || * string == '"')
	    )
	    ||
	    ((* string & 0xDE) == 0xC2
	     && (((character) * string) == 0xC2 || ((character) * (string + 1)) == 0x80)
	    )
	   )
	{
	    utf8_info (string, & utflen, & unichar);
	    switch ((unsigned int) unichar) {
	    case (character) '"':
	    case (character) '\'':
			count_plain ++;
			break;
	    case 0x201C: /* “ LEFT DOUBLE QUOTATION MARK; DOUBLE TURNED COMMA QUOTATION MARK */
	    case 0x2018: /* ‘ LEFT SINGLE QUOTATION MARK; SINGLE TURNED COMMA QUOTATION MARK */
			/* left English, Spanish, Turkish */
			/* right German, Danish, Polish, Russian, Romanian, Slovak, Slovenian, Czech, Hungarian */
		if (isopeningquote (string, start)) {
			count_English ++;
		} else {
			count_German ++;
		}
		break;
	    case 0x201D: /* ” RIGHT DOUBLE QUOTATION MARK; DOUBLE COMMA QUOTATION MARK */
		count_Greek ++;
	    case 0x2019: /* ’ RIGHT SINGLE QUOTATION MARK; SINGLE COMMA QUOTATION MARK */
			/* right English, Spanish, Turkish */
			/* right Dutch, Hungarian */
			/* left/right Swedish, Finnish */
			/* ” right nested traditional Greek */
		count_Swedish_q ++;
		if (! isopeningquote (string, start)) {
			count_English ++;
			count_Dutch ++;
		}
		break;
	    case 0x201E: /* „ DOUBLE LOW-9 QUOTATION MARK; LOW DOUBLE COMMA QUOTATION MARK */
	    case 0x201A: /* ‚ SINGLE LOW-9 QUOTATION MARK; LOW SINGLE COMMA QUOTATION MARK */
			/* left German, Danish, Polish, Russian, Romanian, Slovak, Sloven, Czech, Hungarian */
			/* left Dutch, Hungarian */
		if (isopeningquote (string, start)) {
			count_German ++;
			count_Dutch ++;
		}
		break;
	    case 0x201F: /* ‟ DOUBLE HIGH-REVERSED-9 QUOTATION MARK; DOUBLE REVERSED COMMA QUOTATION MARK */
		count_Greek ++;
	    case 0x201B: /* ‛ SINGLE HIGH-REVERSED-9 QUOTATION MARK; SINGLE REVERSED COMMA QUOTATION MARK */
			/* ‟ left nested traditional Greek */
		break;
	    case 0x00AB: /* « LEFT-POINTING DOUBLE ANGLE QUOTATION MARK; LEFT POINTING GUILLEMET */
	    case 0x2039: /* ‹ SINGLE LEFT-POINTING ANGLE QUOTATION MARK; LEFT POINTING SINGLE GUILLEMET */
			/* left French, Italian, Norwegian, Portuguese, Russian, Slovenian, Turkish */
			/* right German, Polish, Slovak, Czech, Serbian, Croatian */
			/* left Greek */
		if (isopeningquote (string, start)) {
			count_French ++;
			count_Greek ++;
		} else {
			count_German ++;
			count_inwards ++;
		}
		break;
	    case 0x00BB: /* » RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK; RIGHT POINTING GUILLEMET */
	    case 0x203A: /* › SINGLE RIGHT-POINTING ANGLE QUOTATION MARK; RIGHT POINTING SINGLE GUILLEMET */
			/* right French, Italian, Norwegian, Portuguese, Russian, Slovenian, Turkish */
			/* left German, Polish, Slovak, Czech, Serbian, Croatian */
			/* left/right Swedish, Finnish */
			/* right Greek */
		count_Swedish_g ++;
		if (isopeningquote (string, start)) {
			count_German ++;
			count_inwards ++;
		} else {
			count_French ++;
			count_Greek ++;
		}
		break;
	    case 0x300A: /* 《 LEFT DOUBLE ANGLE BRACKET; OPENING DOUBLE ANGLE BRACKET */
	    case 0x3008: /* 〈 LEFT ANGLE BRACKET; OPENING ANGLE BRACKET */
			/* left Chinese? */
			/* 〈 left Chinese?? */
		if (isopeningquote (string, start)) {
			count_Chinese ++;
		}
		break;
	    case 0x300B: /* 》 RIGHT DOUBLE ANGLE BRACKET; CLOSING DOUBLE ANGLE BRACKET */
	    case 0x3009: /* 〉 RIGHT ANGLE BRACKET; CLOSING ANGLE BRACKET */
			/* right Chinese? */
			/* 〉 right Chinese?? */
		if (! isopeningquote (string, start)) {
			count_Chinese ++;
		}
		break;
	    case 0x300C: /* 「 LEFT CORNER BRACKET; OPENING CORNER BRACKET */
	    case 0x300E: /* 『 LEFT WHITE CORNER BRACKET; OPENING WHITE CORNER BRACKET */
			/* left Japanese */
			/* 『 left Japanese? */
		if (isopeningquote (string, start)) {
			count_Japanese ++;
		}
		break;
	    case 0x300D: /* 」 RIGHT CORNER BRACKET; CLOSING CORNER BRACKET */
	    case 0x300F: /* 』 RIGHT WHITE CORNER BRACKET; CLOSING WHITE CORNER BRACKET */
			/* right Japanese */
			/* 』 right Japanese? */
		if (! isopeningquote (string, start)) {
			count_Japanese ++;
		}
		break;
	    }
	}

	/* Advance and count */
	advance_utf8 (& string);
	count ++;
    }
  }
  return count;
}

/*
 * col_count () returns the number of screen columns in the string
 */
int
col_count (string)
  char * string;
{
  int count = 0;
  char * start = string;

  if (string != NIL_PTR) {
	while (* string != '\0') {
		advance_char_scr (& string, & count, start);
	}
  }
  return count;
}

/*
 * utf8_col_count () returns the number of screen columns in the 
 * UTF-8 string
 */
int
utf8_col_count (string)
  char * string;
{
  int count = 0;
  char * start = string;

  if (string != NIL_PTR) {
	while (* string != '\0') {
		advance_utf8_scr (& string, & count, start);
	}
  }
  return count;
}


/**
   determine Unicode information from UTF-8 character
   return parameters:
     length: the number of UTF-8 bytes in the character
     ucs: its Unicode value
 */
void
utf8_info (u, length, ucs)
  char * u;
  int * length;
  unsigned long * ucs;
{
#define REPLACEMENT_CHARACTER 0xFFFD
#define illegal 0x80000000

  char * textpoi = u;
  character c = * textpoi;
  int utfcount;
  unsigned long unichar;

	if ((c & 0x80) == 0x00) {
		utfcount = 1;
		unichar = c;
	} else if ((c & 0xE0) == 0xC0) {
		utfcount = 2;
		unichar = c & 0x1F;
	} else if ((c & 0xF0) == 0xE0) {
		utfcount = 3;
		unichar = c & 0x0F;
	} else if ((c & 0xF8) == 0xF0) {
		utfcount = 4;
		unichar = c & 0x07;
	} else if ((c & 0xFC) == 0xF8) {
		utfcount = 5;
		unichar = c & 0x03;
	} else if ((c & 0xFE) == 0xFC) {
		utfcount = 6;
		unichar = c & 0x01;
	} else if (c == 0xFE) {
		/* illegal UTF-8 code */
		utfcount = 1;
		unichar = '4';
	} else if (c == 0xFF) {
		/* illegal UTF-8 code */
		utfcount = 1;
		unichar = '5';
	} else {
		/* illegal UTF-8 sequence character */
		utfcount = 1;
		unichar = '8';
	}

	* length = utfcount;

	utfcount --;
	textpoi ++;
	while (utfcount > 0 && (* textpoi & 0xC0) == 0x80) {
		unichar = (unichar << 6) | (* textpoi & 0x3F);
		utfcount --;
		textpoi ++;
	}
	if (utfcount > 0) {
		/* too short UTF-8 sequence */
		unichar = (character) '';
		* length -= utfcount;
	}

	* ucs = unichar;
}

/**
   Determine if a Unicode character is joined to a ligature 
   with the previous character in the string or line 
   (which may be in any encoding).
 */
int
isjoined (unichar, charpos, linebegin)
  unsigned long unichar;
  char * charpos;
  char * linebegin;
{
  unsigned long prev_unichar;

  if (bidi_screen && encoding_has_combining ()) {
	if (unichar == 0x0622 || unichar == 0x0623 || unichar == 0x0625 || unichar == 0x0627) {
		/* ALEF may be joined to a ligature with preceding LAM */
		precede_char (& charpos, linebegin);
		prev_unichar = unicodevalue (charpos);
		if (prev_unichar == 0x0644) {
			/* LAM joins to a ligature with any of the above */
			return 1;
		}
	}
  }
  return 0;
}

/**
   Determine if a Unicode character is effectively of zero width, i.e. 
   if it combines with the previous character in the string or line 
   (which may be in any encoding).
 */
int
iscombined (unichar, charpos, linebegin)
  unsigned long unichar;
  char * charpos;
  char * linebegin;
{
  return isjoined (unichar, charpos, linebegin) || iscombining (unichar);
}

/**
   Determine the effective screen width of a Unicode character.
 */
int
uniscrwidth (unichar, charpos, linebegin)
  unsigned long unichar;
  char * charpos;
  char * linebegin;
{
  if (combining_mode && iscombined (unichar, charpos, linebegin)) {
	return 0;
  } else if (iswide (unichar)) {
	return 2;
  } else {
	return 1;
  }
}

/**
   Determine the effective screen width of a CJK character.
 */
int
cjkscrwidth (cjkchar, charpos, linebegin)
  unsigned long cjkchar;
  char * charpos;
  char * linebegin;
{
	if (utf8_screen || cjk_uni_term) {
		unsigned long unichar = lookup_cjk (cjkchar);
		if (unichar == 0 && ! valid_cjk (cjkchar, NIL_PTR)) {
			return 1;
		} else if (combining_mode && iscombined (unichar, charpos, linebegin)) {
			return 0;
		} else if (utf_cjk_wide_padding || iswide (unichar)) {
			return 2;
		} else if (unichar == 0 && cjk_term) {
			return 2;
		} else {
			return 1;
		}
	} else if (cjk_encoding == 'J' && (cjkchar >> 8) == 0x8E) {
		return 1;
	} else {
		return 2;
	}
}

/*
   charbegin () determines the first byte of the character pointed to 
   in the given line
 */
char *
charbegin (line, s)
  char * line;
  char * s;
{
  char * char_search;
  char * char_prev;

  if (utf8_text || cjk_text) {
	char_search = line;
	char_prev = char_search;
	while (char_search < s) {
		char_prev = char_search;
		advance_char (& char_search);
	}
	if (char_search > s) {
		return char_prev;
	} else {
		return s;
	}
  }
  return s;
}

/*
 * precede_char () moves the character pointer within line "begin_line" 
 * left by 1 character
 */
void
precede_char (poipoi, begin_line)
  char * * poipoi;
  char * begin_line;
{
  char * char_search;
  char * char_prev;

  if (utf8_text || cjk_text) {
	char_search = begin_line;
	char_prev = char_search;
	while (char_search < * poipoi) {
		char_prev = char_search;
		advance_char (& char_search);
	}
	(* poipoi) = char_prev;
  } else if ((* poipoi) != begin_line) {
	(* poipoi) --;
  }
}

/*
 * charvalue () determines the value of the character
 */
unsigned long
charvalue (poi)
  character * poi;
{
  int len;

  if (utf8_text) {
	unsigned long unichar;
	utf8_info (poi, & len, & unichar);
	return unichar;
  } else if (cjk_text && multichar (* poi)) {
	unsigned long cjkchar;
	len = CJK_len (poi);
	cjkchar = * poi ++;
	len --;
	while (len > 0 && * poi != '\0' && * poi != '\n') {
		cjkchar = (cjkchar << 8) | * poi ++;
		len --;
	}
	if (len > 0) {
		return CHAR_INVALID;
	} else {
		return cjkchar;
	}
  } else {
	return * poi;
  }
}

/**
   unicode () returns the Unicode value of the character code
 */
unsigned long
unicode (code)
  unsigned long code;
{
  if (cjk_text || mapped_text) {
	return lookup_cjk (code);
  } else {
	return code;
  }
}

/**
   unicodevalue () determines the Unicode value of the character
 */
unsigned long
unicodevalue (poi)
  character * poi;
{
  return unicode (charvalue (poi));
}

/*
 * precedingchar () determines the preceding character value
 */
unsigned long
precedingchar (curpoi, begin_line)
  char * curpoi;
  char * begin_line;
{
  char * poi;

  if (curpoi == begin_line) {
	return '\n';
  } else {
	poi = curpoi;
	precede_char (& poi, begin_line);
	return charvalue (poi);
  }
}

/*
 * Advance character pointer and screen column counter to next character.
 * UTF-8 mode.
 */
void
advance_utf8_scr (poipoi, colpoi, linebegin)
  char * * poipoi;
  int * colpoi;
  char * linebegin;
{
  unsigned long unichar;
  int follow;

	utf8_info (* poipoi, & follow, & unichar);
	(* colpoi) += uniscrwidth (unichar, * poipoi, linebegin);
	follow --;
	(* poipoi) ++;
	while (follow > 0 && (* * poipoi & 0xC0) == 0x80) {
		(* poipoi) ++;
		follow --;
	}
}

/*
 * Advance only character pointer to next character.
 * UTF-8 mode.
 */
void
advance_utf8 (poipoi)
  char * * poipoi;
{
  register int follow = UTF_len (* * poipoi) - 1;

	(* poipoi) ++;
	while (follow > 0 && (* * poipoi & 0xC0) == 0x80) {
		(* poipoi) ++;
		follow --;
	}
}

/*
 * Advance character pointer and screen column counter to next character.
 * Handle tab characters and different character encodings correctly.
 */
void
advance_char_scr (poipoi, colpoi, linebegin)
  char * * poipoi;
  int * colpoi;
  char * linebegin;
{
  int len;
  unsigned long unichar;

  if (is_tab (* * poipoi)) {
	* colpoi = tab (* colpoi);
	(* poipoi) ++;
  } else if (utf8_text) {
	advance_utf8_scr (poipoi, colpoi, linebegin);
  } else if (cjk_text && multichar (* * poipoi)) {
	len = CJK_len (* poipoi);

	if (cjk_term == False || cjk_uni_term) {
		unichar = lookup_cjk (charvalue (* poipoi));
		if (unichar == 0 && ! valid_cjk (charvalue (* poipoi), NIL_PTR)) {
			(* colpoi) ++;
		} else if (combining_mode && iscombined (unichar, * poipoi, linebegin)) {
			/* * colpoi stays where it is */
		} else if (utf_cjk_wide_padding || iswide (unichar)) {
			(* colpoi) += 2;
		} else if (unichar == 0 && cjk_term) {
			(* colpoi) += 2;
		} else {
			(* colpoi) ++;
		}
		(* poipoi) ++;
	} else if (cjk_encoding == 'J' && len == 2 && (character) * * poipoi == 0x8E) {
		(* colpoi) ++;
		(* poipoi) ++;
	} else {
		(* colpoi) ++;
		(* poipoi) ++;
		if (((character) * * poipoi) >= ' ') {
			(* colpoi) ++;
		}
	}

	len --;
	while (len > 0 && * * poipoi != '\0' && * * poipoi != '\n') {
		(* poipoi) ++;
		len --;
	}
  } else if (mapped_text) {
	unichar = lookup_cjk ((character) * * poipoi);
	if (combining_mode && iscombining (unichar)) {
		/* * colpoi stays where it is */
	} else {
		(* colpoi) ++;
	}
	(* poipoi) ++;
  } else {
	(* colpoi) ++;
	(* poipoi) ++;
  }
}

/*
 * Advance only character pointer to next character.
 * Handle tab characters and different character encodings correctly.
 */
void
advance_char (poipoi)
  char * * poipoi;
{
  register int len;

  if (utf8_text) {
	advance_utf8 (poipoi);
  } else if (cjk_text) {
	len = CJK_len (* poipoi);
	(* poipoi) ++;
	len --;
	while (len > 0 && * * poipoi != '\0' && * * poipoi != '\n') {
		(* poipoi) ++;
		len --;
	}
  } else {
	(* poipoi) ++;
  }
}


/*======================================================================*\
|*			Text buffer routines				*|
|*			File operations					*|
\*======================================================================*/

#include "textbuf.c"


/*======================================================================*\
|*			Web marker insertion				*|
\*======================================================================*/

/*
   Strip string from first blank.
 */
static
void
strip (s)
  char * s;
{
  while (* s != '\0' && * s != ' ') {
	s ++;
  }
  * s = '\0';
}

static
void
embed_HTML ()
{
  char marker [maxLINE_LEN];
  char tag [maxLINE_LEN];

  if (viewonly) {
	viewonlyerr ();
	return;
  }
  if (get_string_nokeymap ("Embed text in HTML marker:", marker, True, "") != FINE) {
	return;
  }

  yank_HTML (DELETE);
  S ('<');
  S ('/');
  S ('>');
  MLF ();
  strcpy (tag, marker);
  strip (tag);
  if (insert (cur_line, cur_text, tag) == ERRORS) {
	return;
  }
  MLF ();
  MLF ();
  paste_HTML ();
  S ('<');
  S ('>');
  MLF ();
  if ((marker [0] == 'A' || marker [0] == 'a') && marker [1] == '\0') {
	S (marker [0]);
	S (' ');
	S ('h');
	S ('r');
	S ('e');
	S ('f');
	S ('=');
  } else {
	(void) insert (cur_line, cur_text, marker);
  }
  RD ();
}

static char HTMLmarker [maxLINE_LEN];
static FLAG HTMLmarking = False;

void
HTML ()
{
  char * htmlpoi;

  if (viewonly) {
	viewonlyerr ();
	return;
  }

  if (hop_flag > 0) {
	hop_flag = 0;
	embed_HTML ();
  } else {
	if (HTMLmarking == False) {
		if (get_string_nokeymap ("Begin HTML marker:", HTMLmarker, True, "") != FINE)
			return;
		clear_status ();
		S ('<');
		S ('>');
		MLF ();
		if (insert (cur_line, cur_text, HTMLmarker) == ERRORS) {
			return;
		}
		HTMLmarking = True;
	} else {
		S ('<');
		S ('/');
		S ('>');
		MLF ();
		strip (HTMLmarker);
		if (insert (cur_line, cur_text, HTMLmarker) == ERRORS) {
			return;
		}
		HTMLmarking = False;
	}
/*
	set_cursor (0, y);
	line_print (y, cur_line);
*/
	RD ();
	if (* cur_text != '>') {
		htmlpoi = cur_text;
		do {
			advance_char (& htmlpoi);
		} while (* htmlpoi != '>' && * htmlpoi != '\0');
		if (* htmlpoi == '>') {
			htmlpoi ++;
		}
		move_address (htmlpoi, y);
	}
  }
}


/*======================================================================*\
|*			Miscellaneous					*|
\*======================================================================*/

static
int
get_tagline (idf, filename, search)
  char * idf;
  char * filename;
  char * search;
{
  int tags_fd = open ("tags", O_RDONLY | O_BINARY, 0);
  FLAG modif = modified;
  unsigned int len = strlen (idf);
  int dumlen;
  char * poi;
  char * outpoi;
  char lastpat = '\0';
  FLAG found;

  flush ();	/* clear the shared screen/get_line buffer! */

  if (tags_fd >= 0) {
	found = False;
	while (found == False && (get_line (tags_fd, text_buffer, & dumlen)) != ERRORS) {
	    if (strncmp (idf, text_buffer, len) == 0 && text_buffer [len] == '\t') {
		found = True;
		poi = text_buffer + len + 1;

		outpoi = filename;
		while (* poi != '\0' && * poi != '\t') {
			* outpoi ++ = * poi ++;
		}
		* outpoi = '\0';

		outpoi = search;
		poi ++;
		if (* poi == '/') {
			poi ++;
		}
		while (* poi != '\0' && (* poi != '/' || lastpat == '\\')) {
			if (* poi == '[' || * poi == ']' || * poi == '*') {
				* outpoi ++ = '\\';
			}
			lastpat = * poi ++;
			* outpoi ++ = lastpat;
		}
		* outpoi = '\0';
	    }
	}
	(void) close (tags_fd);
	clear_buffer ();
	clear_get_line ();
	modified = modif; /* don't let the tags file affect the modified flag */
	if (found == False) {
		error ("Identifier not found in tags file");
		return ERRORS;
	} else {
		return FINE;
	}
  } else {
	error ("No tags file present; apply the ctags command to your source files");
	return ERRORS;
  }
}

/*
 * Stag () opens file and moves to idf, using tags file
 */
void
Stag ()
{
  char idf_buf [MAX_CHARS];	/* identifier to search for */
  char new_file [maxLINE_LEN];	/* Buffer to hold new file name */
  char search [MAX_CHARS];	/* search expression */
  int lineno;

  if (hop_flag > 0) {
	if (get_string ("Enter identifier (to locate definition):", idf_buf, True, "") != FINE) {
		return;
	}
  } else {
	if (get_idf (idf_buf, cur_text, cur_line->text) == ERRORS) {
		return;
	}
  }

  if (get_tagline (idf_buf, new_file, search) == ERRORS) {
	return;
  }

  Pushmark ();

  if (! streq (new_file, file_name)) {
	if (save_text_load_file (new_file) == ERRORS) {
		return;
	}
  }

  if (* search >= '0' && * search <= '9') {
	(void) scan_int (search, & lineno);
	goline (lineno);
  } else {
	search_for (search, FORWARD);
  }
}


/*
   Set flags depending on file type.
 */
static
void
set_file_type_flags ()
{
  char * suffix = strrchr (file_name, '.');
  if (suffix != NIL_PTR) {
	suffix ++;
  } else {
	suffix = "";
  }
  if (streq (suffix, "html")
	|| streq (suffix, "htm")
	|| streq (suffix, "sgml")
	|| streq (suffix, "xml")
	|| streq (suffix, "jsp")
#ifdef msdos
	|| streq (suffix, "HTML")
	|| streq (suffix, "HTM")
	|| streq (suffix, "SGML")
	|| streq (suffix, "XML")
	|| streq (suffix, "JSP")
#endif
     )
  {
	dim_HTML = True;
  } else {
	dim_HTML = False;
  }
}


/*
 * return the mined command associated with the key value
 */
voidfunc
command (c)
  unsigned long c;
{
  if (c == (character) FUNcmd) {
	return keyproc;
  } else if (c < arrlen (key_map)) {
	return key_map [c];
  } else {
	return Scharacter;
  }
}


#ifdef unix

/*
 * Set window headline and icon text
 */
static
void
build_header (ws, fn, modf)
  char * ws;
  char * fn;
  char * modf;
{
  build_string (ws, window_string_code, fn, modf, fn, modf);
}

void
RD_window_title ()
{
  char window_string [MAX_CHARS];
  char filename_ok [maxLINE_LEN];
  char * filename_dispoi;
  char * filename_poi;
  FLAG suppress_u = utf8_screen && strisprefix ("xterm", envvar ("TERM"));

  filename_poi = file_name;
  filename_dispoi = filename_ok;
  while (* filename_poi != '\0') {
	if (suppress_u && (* filename_poi & 0xC0) == 0x80) {
		/* skip UTF-8 continuation byte */
	} else if ((! utf8_screen && (* filename_poi & 0x60) == 0)
	   || (suppress_u && (* filename_poi & 0x80) == 0x80)
	   ) {
		* filename_dispoi ++ = '?';
	} else {
		* filename_dispoi ++ = * filename_poi;
	}
	filename_poi ++;
  }
  * filename_dispoi = '\0';

  if (loading == False) {
	build_header (window_string, 
			file_name [0] == '\0' ? empty_buffer_name : filename_ok,
			modified ? mined_modf : "");
/*	putstring (window_string);	*/
/*	Mind! As long as screen buffer shared with file buffer:	*/
	write (output_fd, window_string, (unsigned int) length_of (window_string));
  }
}

void
clear_window_title ()
{
  char window_string [MAX_CHARS];

	build_header (window_string, " ", " ");
/*	putstring (window_string);	*/
/*	Mind! As long as screen buffer shared with file buffer:	*/
	write (output_fd, window_string, (unsigned int) length_of (window_string));
}

#endif


/*
 * Set the modified flag
 */
void
set_modified ()
{
  if (modified == False) {
	modified = True;
#ifdef unix
	RD_window_title ();
#endif
  }
}

/*
 * Redraw the screen
 */
static
void
RD_nobot ()
{
  reverse_off ();
  clearscreen ();

/* display page */
  display (0, top_line, last_y, y);

/* redraw scroll bar */
  if (disp_scrollbar) {
	(void) display_scrollbar (False);
  }

/* clear/redraw last line */
  set_cursor (0, YMAX);
  clear_lastline ();
  move_y (y);

#ifdef unix
  RD_window_title ();
#endif
}

void
RD ()
{
  RD_nobot ();
  if (stat_visible) {
	rd_bottom_line ();
  }
}

void
RD_y (y_pos)
  int y_pos;
{
  reverse_off ();
  clearscreen ();

/* display page */
  display (0, top_line, last_y, y_pos);

/* clear/redraw last line */
  set_cursor (0, YMAX);
  clear_lastline ();
  if (stat_visible) {
	rd_bottom_line ();
  }
}

/*
 * Adjust current window size after WINCH signal
 */
void
RDwin ()
{
  register LINE * current_line;

  winchg = False;
  getwinsize ();

#ifdef adjust_to_actual_termsize
  putoutstring ("\033[18t");
  flush ();
  if (char_ready_within (...)) {
	c = readcharacter ();...
	if (command (c) == ANSIseq) {
		ANSIseq ();
		... but without RD which is actually done here ...
		in both cases, reset the variables below, however ...
	}
  }
#endif

  if (loading == False) {
	current_line = cur_line;
	reset (top_line, y);
/*	move_y (find_y_w_o_RD (current_line)); */
	move_address (cur_text, find_y_w_o_RD (current_line));
	RD_nobot ();
	if (MENU) {
		displaymenuline ();
		set_cursor_xy ();
		redrawmenu ();
	}
  }
  if (stat_visible) {
	rd_bottom_line ();
  }
  flush ();
}

static
void
change_screen_size (sb, keep_columns)
  FLAG sb;
  FLAG keep_columns;
{
  int index;
  int mode1;
#ifdef msdos_screenfunctions
  int mode2;
#endif

/* Experimental area: */
/*	set_screen_mode (mode1);	any available mode number */
/*	set_video_lines (mode1);	0/1/2: 200/350/400 lines */
	/* does not seem to have any effect */
/*	set_textmode_height (mode1);	0/1/2: font height 8/14/16 */
/*	set_grafmode_height (mode1, mode2);
		0/1/2: font height 8/14/16 1/2/3/n: 14/25/43/n lines */
/*	set_fontbank (f);		0..7 */
/**/
  if (hop_flag > 0) {
#ifdef msdos_screenfunctions
    if (keep_columns) {
      if (sb == BIGGER) {
	index = get_number ("Switch to font bank (0..7) ", '\0', & mode1);
	if (index == ERRORS) {
		return;
	}
	set_fontbank (mode1);
      } else {
	index = get_number ("Set character height (<= 32 pixels) ", '\0', & mode1);
	if (index == ERRORS) {
		return;
	}
	set_font_height (mode1);
      }
    } else {
      if (sb == BIGGER) {
#endif
	index = get_number ("Select video mode ", '\0', & mode1);
	if (index == ERRORS) {
		return;
	}
	set_screen_mode (mode1);
#ifdef msdos_screenfunctions
      } else {
	index = get_number ("Select graf font (0/1/2: font height 8/14/16) ", '\0', & mode1);
	if (index == ERRORS) {
		return;
	}
	index = get_number ("Select line number (1/2/3/n: 14/25/43/n) ", '\0', & mode2);
	if (index == ERRORS) {
		return;
	}
	set_grafmode_height (mode1, mode2);	/* 0/1/2: font height 8/14/16 */
					/* 1/2/3/n: 14/25/43/n lines */
      }
    }
#endif
  }
  else {
	resize_the_screen (sb, keep_columns);
  }
  RDwin ();
}
void
screenmorelines ()
{
  change_screen_size (BIGGER, True);
}
void
screenlesslines ()
{
  change_screen_size (SMALLER, True);
}
void
screenbigger ()
{
  change_screen_size (BIGGER, False);
}
void
screensmaller ()
{
  change_screen_size (SMALLER, False);
}

void
LNCI ()
{
  switch_textmode_height (True);
  RDwin ();
}

void
LNSW ()
{
  switch_textmode_height (False);
  RDwin ();
}


/*======================================================================*\
|*			Generic command processing functions		*|
\*======================================================================*/

/*
 * BAD complains about unknown command characters.
 */
static
void
BAD (c, tag)
  unsigned long c;
  char * tag;
{
  char cmdbuf [17];
  char * cbuf = cmdbuf;

  if (tag) {
	strcpy (cmdbuf, tag);
  } else {
	* cmdbuf = '\0';
  }
  while (* cbuf) {
	cbuf ++;
  }

  if (no_char (c)) {
	strcpy (cbuf, "<unknown character>");
  } else if (c < ' ') {
	cbuf [0] = '^';
	cbuf [1] = c + '@';
	cbuf [2] = '\0';
  } else if (utf8_text) {
	(void) uniUTF (c, cbuf);
  } else if (cjk_text) {
	(void) cjkencode (cjk (c), cbuf);
  } else if (mapped_text) {
	cbuf [0] = cjk (c);
	cbuf [1] = '\0';
  } else {
	cbuf [0] = c;
	cbuf [1] = '\0';
  }

  ring_bell ();
  error2 ("Unknown command: ", cmdbuf);
}

void
BADch (c)
  unsigned long c;
{
  BAD (c, "");
}

static
unsigned long
readcmdcharacter ()
{
  unsigned long c = readcharacter ();
  if (cjk_text || mapped_text) {
	c = lookup_cjk (c);
	if (c == 0) {
		return CHAR_INVALID;
	}
  }
  return c;
}

/*
 * Ignore this keystroke.
 */
void
I ()
{
}

/*
 * Fortifying 'HOP' key.
 */
void
HOP ()
{
  hop_flag = 2;
  if (MENU) {
	displayflags ();
	set_cursor_xy ();
	flush ();
  }
  if (! char_ready_within (500)) {
	status_msg ("Continue HOP command (next command fortified) ...");
  }
}

/*
 * Cancel prefix function.
 */
void
CANCEL ()
{
  hop_flag = 0;
  clear_status ();
}

/*
 * Call proc associated with function key.
 */
void
FUNKEY ()
{
  (* keyproc) ('\0');
  keyproc = I;
}

/*
 * Toggle insert/overwrite mode.
 */
void
TOGINS ()
{
  if (insert_mode) {
	insert_mode = False;
  } else {
	insert_mode = True;
  }
}


#define cmd_char(c)	(c < '\040' ? c + '\100' : (c >= '\140' ? c - '\040' : c))

/*
 * Interpret control-Q commands. Most can be implemented with the Hop function.
 */
void
ctrlQ ()
{
  unsigned long c;
  void (* func) ();

  if (! char_ready_within (500)) {
	status_msg ("^Q: blockBegin Find replAce goto<n>mark HOP...");
  }
  if (quit) {
	return;
  }

  c = readcmdcharacter ();
  if (quit) {
	return;
  }

  clear_status ();
  if ('0' <= c && c <= '9') {
	GOMAn ((int) c - (int) '0');
	return;
  }
  if (c == '\033' || c == quit_char) {
	CANCEL ();
	return;
  }
  switch (cmd_char (c)) {
	case 'B' : {GOMA () ; return;}
	case 'K' : { ; return;}		/* not exactly WS function */
	case 'P' : { ; return;}		/* not exactly WS function */
	case 'V' : { ; return;}		/* not exactly WS function */
	case 'W' :			/* not exactly WS function */
	case 'Z' :			/* not exactly WS function */
	case 'Y' :
	case '\177' : {
			func = command (c);
			hop_flag = 1;
			(* func) (c);
			return;
		      }
	case 'F' : {if (hop_flag > 0) {
			SRV ();
		    } else {
			SFW ();
		    }
		    return;
		   }
	case 'A' : {if (hop_flag > 0) {
			REPL ();
		    } else {
			GR ();
		    }
		    return;
		   }
	case 'Q' : {REPT (' '); return;}	/* not exactly WS function */
	case 'L' :			/* not exactly WS function */
/*
^Q: B/K top/bottom block
    P last position
    W/Z continuous scroll
    V last find or block
    Y/DEL delete line right/left
    0-9 marker
    F find
    A replace
    Q repeat next key/command
    L find misspelling
*/
	default : {
		func = command (c);
		if ((c < ' ') || ((voidfunc) func == (voidfunc) FUNKEY)) {
			/* (voidfunc) is an identity cast here.
			   It seems to be required for the sake of the 
			   apparently totally rotten microvax C compiler */
			hop_flag = 1;
			(* func) (c);
		} else {
			BAD (c, "^Q ");
		}
		return;
	}
  }
}

/*
 * Interpret control-K commands.
 */
void
ctrlK ()
{
  unsigned long c;

  if (! char_ready_within (500)) {
	status_msg ("^K: Save Done eXit Quit Read Log <n>mark / block: B/K mark Cop Ydel moV Wr...");
  }
  if (quit) {
	return;
  }

  c = readcmdcharacter ();
  if (quit) {
	return;
  }

  clear_status ();
  if ('0' <= c && c <= '9') {
	MARKn ((int) c - (int) '0');
	return;
  }
  if (c == '\033' || c == quit_char) {
	CANCEL ();
	return;
  }
  switch (cmd_char (c)) {
	case 'S' : {WTU (); return;}
	case 'D' : {EXFILE (); return;}
	case 'X' : {EXMINED (); return;}
	case 'Q' : {QUED (); return;}
	case 'B' : {MARK () ; return;}
	case 'K' : {COPY () ; return;}	/* not exactly WS function */
	case 'H' : { ; return;}		/* not exactly WS function */
	case 'C' : {PASTE () ; return;}	/* not exactly WS function */
	case 'Y' : {CUT () ; return;}	/* not exactly WS function */
	case 'V' : {PASTE (); return;}	/* not exactly WS function */
	case 'W' : {WB (); return;}	/* not exactly WS function */
	case 'N' : { ; return;}		/* not exactly WS function */
	case 'R' : {INSFILE (); return;}
	case 'L' : {CHDI (); return;}
/*
^K  0-9 set/hide marker
    B/K block begin/end
    H block hide
    C/Y/V/W block copy/delete/move/write
    N column block
*/
	default : {
		BAD (c, "^K ");
		return;
	}
  }
}

/*
 * Interpret control-O commands.
 */
void
ctrlO ()
{
  unsigned long c;

  if (! char_ready_within (500)) {
	status_msg ("^O: L/R left/right margins...");
  }
  if (quit) {
	return;
  }

  c = readcmdcharacter ();
  if (quit) {
	return;
  }

  clear_status ();
  if ('0' <= c && c <= '9') {
	return;
  }
  if (c == '\033' || c == quit_char) {
	CANCEL ();
	return;
  }
  switch (cmd_char (c)) {
	case 'L' : {ADJLM (); return;}
	case 'R' : {ADJRM (); return;}
	case 'G' : {ADJFLM () /* actually paragraph tab */; return;}
/*
^O  L/R/M set left/right margin /release
    I/N set/clear tab
    F ruler from line
    C center line
    S set line spacing
    W toggle word wrap
    T toggle ruler line
    J toggle justify
    V     vari-tabs
    H     hyph-help
    E     soft hyph
    D     print display
    P     page break
*/
	default : {
		BAD (c, "^O ");
		return;
	}
  }
}

/*
 * Set marker / go to marker.
 */
void
MARKER ()
{
  unsigned long c;

  status_msg ("0..9: set marker / , or blank: default marker");
  c = readcmdcharacter ();
  if (quit) {
	return;
  }

  clear_status ();
  if (c == '\033' || c == quit_char) {
	CANCEL ();
  } else if ('0' <= c && c <= '9') {
	MARKn ((int) c - (int) '0');
  } else if (c == ',' || c == '\'' || c == ' ' || c == ']' || c == '\035') {
	MARK ();
  } else {
	BAD (c, "mark ");
  }
}

void
GOMARKER ()
{
  unsigned long c;

  status_msg ("0..9: go marker / blank: default marker");
  c = readcmdcharacter ();
  if (quit) {
	return;
  }

  clear_status ();
  if (c == '\033' || c == quit_char) {
	CANCEL ();
  } else if ('0' <= c && c <= '9') {
	GOMAn ((int) c - (int) '0');
  } else if (c == ',' || c == '.' || c == 'g' || c == 'G' || c == '\'' || 
      c == ' ' || c == ']' || c == '\035') {
	GOMA ();
  } else {
	BAD (c, "go mark ");
  }
}

/*
 * ...MENU () opens the respective menu
 */
void
FILEMENU ()
{
  if (keyshift & alt_mask) {
	keyshift = '0';
	handleFlagmenus ();
  } else if (keyshift & shift_mask) {
	keyshift = '0';
	QUICKMENU ();
  } else {
	openmenu (0);
  }
}

void
EDITMENU ()
{
  openmenu (1);
}

void
SEARCHMENU ()
{
  openmenu (2);
}

void
EXTRAMENU ()
{
  openmenu (3);
}

void
PARAMENU ()
{
  openmenu (4);
}

void
QUICKMENU ()
{
  QUICKMEN (x, y);
}

/*
   Toggle TAB width.
 */
void
toggletab ()
{
  if (tabsize == 4) {
	tabsize = 8;
  } else {
	tabsize = 4;
  }
  RDwin ();
}

void
UNDO ()
{
  error ("Undo not implemented");
}

/*
 * Interpret Escape commands.
 */
void
ESCAPE ()
{
  unsigned long c;
  voidfunc func;

  if (! char_ready_within (500)) {
	status_msg ("ESC(exit) TAB,blank(menu) q(uit /,\\(search) (match r(eplace g(oto h(elp ...");
  }
  if (quit) {
	return;
  }

  c = readcmdcharacter ();
  if (quit) {
	return;
  }

  clear_status ();

  if ('0' <= c && c <= '9') {
	REPT (c);
	return;
  }

  switch (c) {
	case '\033' : {EXED (); return;}
	case '\r' :
	case '\n' : {Popmark (); return;}
	case 'q' : {QUED (); return;}
	case '/' : {SFW (); return;}
	case '\\' : {SRV (); return;}
	case 'R' : {LR (); return;}
	case 'r' : {REPL (); return;}
	case 'w' : {WT (); return;}
	case 'W' : {WTU (); return;}
	case 'v' : {VIEW (); return;}
	case 'V' : {toggleVIEWmode (); return;}
	case 'g' : {GOTO (); return;}
	case 'h' : {HELP (); return;}
	case '?' : {FS (); return;}
	case '.' : {RDwin (); return;}
	case 'm' : {MARKER (); return;}
	case '\'' : {GOMARKER (); return;}
	case 'i' : {INSFILE (); return;}
	case 'b' : {WB (); return;}
	case '=' : {REPT (' '); return;}
	case 'z' : {SUSP (); return;}
	case 'd' : {CHDI (); return;}
	case '!' : {SH (); return;}
	case '@' :
	case '^' : {MARK (); return;}
	case ']' : {GOMA (); return;}
	case 'n' : {NN (); return;}
	case 'c' : {CMD (); return;}
	case 'u' : {display_code (); return;}
	case 'U' : {changeuni (); return;}
	case 'X' : {changehex (); return;}
	case 'A' : {changeoct (); return;}
	case 'D' : {changedec (); return;}
	case '+' : {NXTFILE (); return;}
	case '-' : {PRVFILE (); return;}
	case '#' : {NTHFILE (); return;}
	case '%' : {screensmaller (); return;}
	case '&' : {screenbigger (); return;}
	case 'l' : {screenlesslines (); return;}
	case 'L' : {screenmorelines (); return;}
	case 'J' : {JUS (); return;}
	case 'j' : {JUSclever (); return;}
	case '<' : {ADJLM (); return;}
	case ';' : {ADJFLM (); return;}
	case ':' : {ADJNLM (); return;}
	case '>' : {ADJRM (); return;}
	case 'P' : {ADJPAGELEN (); return;}
	case 'T' : {toggletab (); return;}
	case 'H' : {HTML (); return;}
	case '_' : {UML (language_tag); return;}
	case (character) '' :
	case (character) '' :
	case (character) '' :
	case (character) '' : {UML ('g'); return;}
	case (character) '' :
	case (character) '' :
	case (character) '' :
	case (character) '' :
	case (character) '' : {UML ('f'); return;}
	case (character) '' :
	case (character) '' :
	case (character) '' : {UML ('d'); return;}
	case 'C' : {LOWCAP (); return;}
	case '(' : {SCORR (REVERSE); return;}
	case ')' : {SCORR (FORWARD); return;}
	case '{' : {SCORR (REVERSE); return;}
	case '}' : {SCORR (FORWARD); return;}
	case 't' : {Stag (); return;}
	case 'a' : {toggleappend (); return;}
	case 'k' : {toggleKEYMAP (); return;}
	case 'K' : {setupKEYMAP (); return;}
	case 'Q' : if (utf8_text) {
			if (hop_flag > 0) {
				quote_type_up ();
			} else {
				handleQuotemenu ();
			}
			displayflags ();
		   } else {
			error ("Smart quotes not active");
		   }
		   return;
	case 'E' : if (hop_flag > 0) {
			toggle_encoding ();
		   } else {
			handleEncodingmenu ();
		   }
		   return;
/*	case 'o' : {TOGINS (); return;}	*/
/*	case '\t' : {FILEMENU (); return;}	*/
	case ' ' : {QUICKMENU (); return;}
	case 'f' : {FILEMENU (); return;}
	case 'e' : {EDITMENU (); return;}
	case 's' : {SEARCHMENU (); return;}
	case 'x' : {EXTRAMENU (); return;}
	case 'p' : {PARAMENU (); return;}
	case ',' : {GR (); return;}
/*
	case 'e' : {EDIT (); return;}
	case 's' : {GR (); return;}
	case 'p' : {PRINT (); return;}
*/
	default : {
		if (c == quit_char) {
			CANCEL ();
			return;
		}
		func = command (c);
		if ((c < ' ') || ((voidfunc) func == (voidfunc) FUNKEY)) {
			/* (voidfunc) is an identity cast here.
			   It seems to be required for the sake of the 
			   apparently totally rotten microvax C compiler */
			hop_flag = 1;
			(* func) (c);
		} else {
			BAD (c, "ESC/Alt-");
		}
		return;
	}
  }
}

/*
 * Interpret emacs meta commands.
 */
void
META ()
{
  unsigned long c;
  voidfunc func;

  if (! char_ready_within (500)) {
	status_msg ("Meta ESC(exit) TAB,blank(menu) /,\\(search) (match ...");
  }
  if (quit) {
	return;
  }

  c = readcmdcharacter ();
  if (quit) {
	return;
  }

  clear_status ();

  if ('0' <= c && c <= '9') {
	REPT (c);
	return;
  }

  switch (c) {
	/* emacs meta commands */
	case 'v' : {PU (); return;}
	case 'f' : {MNW (); return;}
	case 'b' : {MPW (); return;}
	case 'a' : {BSEN (); return;}
	case 'e' : {ESEN (); return;}
	case '<' : {BFILE (); return;}
	case '>' : {EFILE (); return;}
	case 'd' : {DNW (); return;}
	case 'k' : {MARK (); ESEN (); CUT (); return;}
	case 'w' : {COPY (); return;}
	case 'y' : {YANKRING (); return;}
	case 'z' : {SUSP (); return;}
	case '%' : {REPL (); return;}
	case 'x' : {ESCAPE (); return;}
	case 'u' : {hop_flag = 1; UPPER (); return;}
	case 'l' : {hop_flag = 1; LOWER (); return;}
	case 'c' : {CAPWORD (); return;}
	case '.' : {Stag (); return;}

#ifdef no_emacs
	/* hidden mined commands */
	case '.' : {RDwin (); return;}
	case 'd' : {CHDI (); return;}
	case 'u' : {display_code (); return;}
	case 'c' : {CMD (); return;}
	case 'f' : {FILEMENU (); return;}
	case 'e' : {EDITMENU (); return;}
	case 'x' : {EXTRAMENU (); return;}
	case '?' : {FS (); return;}

	case '<' : {ADJLM (); return;}
	case '>' : {ADJRM (); return;}
	case 'w' : {WT (); return;}
	case 'v' : {VIEW (); return;}
	case 'b' : {WB (); return;}
	case 'a' : {toggleappend (); return;}
	case 'k' : {toggleKEYMAP (); return;}
	case '%' : {screensmaller (); return;}
	case 'l' : {screenlesslines (); return;}

	/* remaining mined commands */
	case '\033' : {EXED (); return;}
	case '\r' :
	case '\n' : {Popmark (); return;}
	case '/' : {SFW (); return;}
	case '\\' : {SRV (); return;}
	case '\'' : {GOMARKER (); return;}
	case '=' : {REPT (' '); return;}
	case '!' : {SH (); return;}
	case '^' : {MARK (); return;}
	case ']' : {GOMA (); return;}
	case '+' : {NXTFILE (); return;}
	case '-' : {PRVFILE (); return;}
	case '#' : {NTHFILE (); return;}
	case '&' : {screenbigger (); return;}
	case ';' : {ADJFLM (); return;}
	case ':' : {ADJNLM (); return;}
	case '_' : {UML (language_tag); return;}
	case '(' : {SCORR (REVERSE); return;}
	case ')' : {SCORR (FORWARD); return;}
	case '{' : {SCORR (REVERSE); return;}
	case '}' : {SCORR (FORWARD); return;}
	case ' ' : {QUICKMENU (); return;}
	case ',' : {GR (); return;}

	case 'q' : {QUED (); return;}
	case 'R' : {LR (); return;}
	case 'r' : {REPL (); return;}
	case 'W' : {WTU (); return;}
	case 'V' : {toggleVIEWmode (); return;}
	case 'g' : {GOTO (); return;}
	case 'h' : {HELP (); return;}
	case 'm' : {MARKER (); return;}
	case 'i' : {INSFILE (); return;}
	case 'n' : {NN (); return;}
	case 'U' : {changeuni (); return;}
	case 'X' : {changehex (); return;}
	case 'A' : {changeoct (); return;}
	case 'D' : {changedec (); return;}
	case 'L' : {screenmorelines (); return;}
	case 'J' : {JUS (); return;}
	case 'j' : {JUSclever (); return;}
	case 'P' : {ADJPAGELEN (); return;}
	case 'T' : {toggletab (); return;}
	case 'H' : {HTML (); return;}
	case 'C' : {LOWCAP (); return;}
	case 't' : {Stag (); return;}
	case 'K' : {setupKEYMAP (); return;}
	case 'Q' : if (utf8_text) {
			if (hop_flag > 0) {
				quote_type_up ();
			} else {
				handleQuotemenu ();
			}
			displayflags ();
		   } else {
			error ("Smart quotes not active");
		   }
		   return;
	case 'E' : if (hop_flag > 0) {
			toggle_encoding ();
		   } else {
			handleEncodingmenu ();
		   }
		   return;
	case 's' : {SEARCHMENU (); return;}
	case 'p' : {PARAMENU (); return;}
/*	case 'o' : {TOGINS (); return;}	*/
/*	case '\t' : {FILEMENU (); return;}	*/
#endif

	default : {
		if (c == quit_char) {
			CANCEL ();
			return;
		}
		func = command (c);
		if ((c < ' ') || ((voidfunc) func == (voidfunc) FUNKEY)) {
			/* (voidfunc) is an identity cast here.
			   It seems to be required for the sake of the 
			   apparently totally rotten microvax C compiler */
			hop_flag = 1;
			(* func) (c);
		} else {
			BAD (c, "Meta-");
		}
		return;
	}
  }
}

/*
 * Interpret emacs ^X commands.
 */
void
EMAX ()
{
  unsigned long c;

  if (! char_ready_within (500)) {
	status_msg ("^X ...");
  }
  if (quit) {
	return;
  }

  c = readcmdcharacter ();
  if (quit) {
	return;
  }

  clear_status ();

  if (command (c) == MARK) {
	Popmark ();
	return;
  }
  switch (c) {
	case 'u' : {UNDO (); return;}
	case '' : {EXED (); return;}
	case '' : {WT (); return;}
	case '' : {SAVEAS (); return;}
	case '' : {PRVFILE (); return;}
	case '' : {EDIT (); return;}
	case '\032' : {SUSP (); return;}
	case '' : {REPT (' '); return;}
	case 'i' : {INSFILE (); return;}
	case 's' : {WT (); return;}
	case 'k' : {QUED (); return;}
	case '=' : {FS (); return;}
	case '[' : {PU (); return;}
	case ']' : {PD (); return;}
	default : {
		if (c == quit_char) {
			CANCEL ();
			return;
		}
		BAD (c, "^X ");
	}
  }
}

/*
 * MOUSEescape () is invoked after a mouse escape sequence with 
 * coordinates and button info already stored in 
 * mouse_xpos, mouse_ypos, and mouse_button.
 * Then it performs a menu or other mouse controlled function.
 */
void
MOUSEescape ()
{
  int proz;

  if (mouse_button == wheelup) {
	if (mouse_shift & shift_button) {
		PU ();
	} else if (mouse_shift & control_button) {
		SU ();
	} else {
		for (proz = 0; quit == False && proz < wheel_scroll && proz < YMAX; proz ++) {
			if (proz > 0 && disp_scrollbar) {
				(void) display_scrollbar (True);
			}
			SU ();
		}
	}
  } else if (mouse_button == wheeldown) {
	if (mouse_shift & shift_button) {
		PD ();
	} else if (mouse_shift & control_button) {
		SD ();
	} else {
		for (proz = 0; quit == False && proz < wheel_scroll && proz < YMAX; proz ++) {
			if (proz > 0 && disp_scrollbar) {
				(void) display_scrollbar (True);
			}
			SD ();
		}
	}
  } else if (disp_scrollbar && mouse_xpos == XMAX) {
	if (mouse_button == leftbutton) {
		PD ();
	} else if (mouse_button == rightbutton) {
		PU ();
	} else if (mouse_button == middlebutton
		   || (mouse_button == releasebutton
		       && mouse_lastbutton == middlebutton)
		   || mouse_button == movebutton
		  ) {
		proz = (mouse_ypos + 1) * 100 / YMAX;
		if (proz > 100) {
			goproz (100);
		} else {
			goproz ((mouse_ypos + 1) * 100 / YMAX);
		}
	}
  } else if (mouse_button == movebutton) {
	/* ignore */
  } else if (mouse_ypos == -1) {	/* menu stuff */
	openmenuat (mouse_xpos);
  } else if (mouse_ypos == YMAX) {
	if (mouse_button == leftbutton) {
		PD ();
	} else if (mouse_button == middlebutton) {
		FS ();
	} else if (mouse_button == rightbutton) {
		PU ();
	}
  } else if (quickmenu) {
	if (mouse_ypos > last_y) {
		mouse_ypos = last_y;
	}
	if (mouse_button == leftbutton) {
		move_to (mouse_xpos, mouse_ypos);
		report_release = True;
	} else if (mouse_button == middlebutton) {
		FS ();
	} else if (mouse_button == rightbutton) {
		move_to (mouse_xpos, mouse_ypos);
		QUICKMEN (x, y);
	} else if (mouse_button == releasebutton 
		&& mouse_lastbutton == leftbutton 
		&& (mouse_xpos != mouse_lastxpos 
		    || mouse_ypos != mouse_lastypos)) {
		MARK ();
		move_to (mouse_xpos, mouse_ypos);
		COPY ();
	}
  } else {
	if (mouse_ypos > last_y) {
		mouse_ypos = last_y;
	}
	move_to (mouse_xpos, mouse_ypos);
	if (mouse_button == leftbutton) {
		MARK ();
	} else if (mouse_button == middlebutton) {
		PASTE ();
	} else if (mouse_button == rightbutton) {
		COPY ();
	}
  }
}

/*
 * REPT () prompts for a count and wants a command after that. It repeats the
 * command count times. If a ^\ is given during repeating, stop looping and
 * return to main loop.
 */
void
REPT (firstdigit)
  char firstdigit;
{
  register int count;
  register void (* func) ();
  long cmd;
  int number;

  hop_flag = 0;
  if (firstdigit >= '0' && firstdigit <= '9') {
     cmd = get_number ("Please continue repeat count...", firstdigit, & number);
     if (firstdigit != '0' && number < 10) {
	error ("Invalid repeat count after ESC <digit>");
	return;
     }
  } else {
     cmd = get_number ("Please enter repeat count...", '\0', & number);
  }
  if (cmd == ERRORS) {
	return;
  }

  func = command (cmd);
  if ((voidfunc) func == (voidfunc) I) {	/* Function assigned? */
	/* (voidfunc) is an identity cast here. It seems to be required for
	   the sake of the apparently totally rotten microvax C compiler */
	clear_status ();
	return;
  }
  if ((voidfunc) func == (voidfunc) FUNKEY) {
	/* (voidfunc) is an identity cast here. It seems to be required for
	   the sake of the apparently totally rotten microvax C compiler */
/*	func = * keyproc;	*/
	func = keyproc;
	keyproc = I;
	cmd = '\0';
  }

  if ((voidfunc) func == (voidfunc) S) {
	func = Scharacter;
  }
  count = number;
  while (count -- > 0 && quit == False) {
	if (stat_visible) {
		clear_status ();
	}
	(* func) (cmd);
	flush ();
  }

  if (quit) {		/* Abort has been given */
	error ("Repeat aborted");
  } else {
	clear_status ();
  }
}


/*======================================================================*\
|*			System-related command functions		*|
\*======================================================================*/

/*
 * Change current directory.
 */
void
CHDI ()
{
  char new_dir [maxLINE_LEN];	/* Buffer to hold new dir. name */

  if (restricted) {
	restrictederr ();
	return;
  }

#ifdef pc
  build_string (text_buffer, "Drive/Directory: %s, change to:", unnull (getcwd (new_dir, maxLINE_LEN)));
#else
  build_string (text_buffer, "Directory: %s, change to:", unnull (getcwd (new_dir, maxLINE_LEN)));
#endif

  if (get_filename (text_buffer, new_dir) != FINE) {
	return;
  }
#ifdef msdos
  if (new_dir [0] != '\0' && new_dir [1] == ':')
	if (new_dir [2] == '\0') {
		new_dir [2] = '.';	/* change to current dir. of drive */
		new_dir [3] = '\0';
	}
#endif
  if (chdir (new_dir) == 0) {
#ifdef msdos
	if (new_dir [0] != '\0' && new_dir [1] == ':')
		setdisk (((int) new_dir [0] & (int) '\137') - (int) 'A');
	RD ();	/* disk error dialog may be on screen after chdir */
#endif
	clear_status ();
	overwriteOK = False;	/* Same file base name ... */
	writable = True;
/*	if (viewmode == False)	*/
	    set_modified ();	/* would mean different file now */
  } else {
#ifdef msdos
	RD ();	/* disk error dialog may be on screen */
#endif
	error2 ("Cannot change current directory: ", serror ());
  }
}

/*
 * Print file status.
 */
void
FSTAT ()
{
  fstatus (file_name [0] ? "" : empty_buffer_name, -1L, -1L);
}
void
FS ()
{
  if (hop_flag > 0) {
	if (always_disp_fstat == False) {
		always_disp_fstat = True;
	} else {
		always_disp_fstat = False;
	}
  } else {
	FSTAT ();
  }
}


/*
 * Checkout (from version managing system).
 */
void
checkout ()
{
  int save_cur_column;
  int save_cur_line;
  char syscommand [maxLINE_LEN];	/* Buffer for full system command */
  int sysres;

	if (modified) {
		if (write_text (False) != FINE) {
			return;
		}
	}

	/* save current position */
	save_cur_line = line_number;
	save_cur_column = get_cur_col ();

	/* try to check out */
	raw_mode (OFF);
	build_string (syscommand, "co %s", file_name);
	sysres = system (syscommand);
	sleep (1);
	raw_mode (ON);
	RDwin ();
	if (sysres != 0) {
		error ("Checkout failed");
	}

	/* reload file */
	initialize ();
	clearscreen ();
	load_file_position (file_name, True, save_cur_line, save_cur_column);
}

/*
 * Checkin (to version managing system).
 */
void
checkin ()
{
  char syscommand [maxLINE_LEN];	/* Buffer for full system command */
  int sysres;

	if (modified) {
		if (write_text (False) != FINE) {
			return;
		}
	}

	/* try to check in */
	raw_mode (OFF);
	build_string (syscommand, "ci %s", file_name);
	sysres = system (syscommand);
	sleep (1);
	raw_mode (ON);
	RDwin ();
	if (sysres != 0) {
		error ("Checkin failed");
	}
}


static
void
view_help (helpfile, item)
  char * helpfile;
  char * item;
{
  char searchstring [maxLINE_LEN];

  /* unless already viewing help, save edited text */
  if (viewing_help == False) {
	if (modified) {
		if (write_text (False) != FINE) {
			return;
		}
	}

	/* save current position */
	save_cur_line = line_number;
	save_cur_column = get_cur_col ();

	/* save editing mode and file name */
	save_viewonly = viewonly;
	save_restricted = restricted;
	copy_string (save_file_name, file_name);

	/* set mode appropriate for viewing online help */
	viewonly = True;
	restricted = True;
	viewing_help = True;

	/* load online help file */
	initialize ();
	clearscreen ();
	load_file_position (helpfile, True, -1, 0);
  }

  /* position to selected help topic */
  BFILE ();
  build_string (searchstring, "mined help topic '%s'", item);
  search_for (searchstring, FORWARD);
}

static
void
end_view_help ()
{
  viewonly = save_viewonly;
  restricted = save_restricted;
  viewing_help = False;

  initialize ();
  clearscreen ();
  load_file_position (save_file_name, True, save_cur_line, save_cur_column);
}

static
void
show_help (item)
  char * item;
{
#ifndef pc
  char syscommand [maxLINE_LEN];	/* Buffer for full system command */
  int sysres;
#endif
  char * helpfile;
  char exehelp [maxLINE_LEN];
  int hf = -1;

  helpfile = envvar ("MINEDHELPFILE");
  if (* helpfile != '\0') {
	hf = open (helpfile, O_RDONLY);
  }
  if (hf == -1) {
	strcpy (exehelp, fnamv [0]);
	helpfile = & exehelp [strlen (exehelp)];
	while (helpfile >= exehelp && * helpfile != '/') {
		helpfile --;
	}
	helpfile ++;
	strcpy (helpfile, "mined.hlp");
	helpfile = exehelp;
	hf = open (helpfile, O_RDONLY);
  }
#ifndef msdos
  if (hf == -1) {
	helpfile = HELPFILE;
	hf = open (helpfile, O_RDONLY);
  }
  if (hf == -1) {
	helpfile = LHELPFILE;
	hf = open (helpfile, O_RDONLY);
  }
#endif
  if (hf == -1) {
	helpfile = "/usr/share/mined/mined.hlp";
	hf = open (helpfile, O_RDONLY);
  }
  if (hf == -1) {
	helpfile = "/usr/local/share/mined/mined.hlp";
	hf = open (helpfile, O_RDONLY);
  }
  if (hf == -1) {
	helpfile = "/usr/share/lib/mined/mined.hlp";
	hf = open (helpfile, O_RDONLY);
  }
  if (hf == -1) {
	helpfile = "/opt/mined/share/mined.hlp";
	hf = open (helpfile, O_RDONLY);
  }
  if (hf == -1) {
	helpfile = "/usr/share/doc/packages/mined/mined.hlp";
	hf = open (helpfile, O_RDONLY);
  }

  if (hf == -1) {
	status_msg ("Help file not found; configure MINEDHELPFILE in environment!");
	return;
#ifndef pc
  } else if (! (hop_flag > 0 || viewing_help)) {
	(void) close (hf);
	build_string (syscommand, 
		"less '-QMPMMined help?e (end):?pb (%%pb\\%%).. - type \"'\\''h\" for help topic \"%s\", q to return to mined '"
		" +\"/mined help topic '%s'\nkmhG'h\" %s",
			item, item, helpfile);
	clear_status ();
	set_cursor (0, YMAX);
#ifdef unix
	clear_window_title ();
#endif
	raw_mode (OFF);

	sysres = system (syscommand);

	raw_mode (ON);
	RDwin ();
	if (sysres != 0) {
		error ("Help item not found in help file");
	}
#endif
  } else {
	(void) close (hf);
	view_help (helpfile, item);
  }
}

/*
 * Interactive Help
 */
void
HELP ()
{
  unsigned long c;

  status_msg ("Help on: i(ntroduction k(eyboard f(unction-keys c(ommands m(enu");
  if (quit) return;

  c = readcmdcharacter ();
  if (quit) return;

  clear_status ();
  switch (c) {
	case '\033': return;
	case 'i': show_help ("introduction"); return;
	case 'k': show_help ("keyboard"); return;
	case 'f': show_help ("function-keys"); return;
	case 'c': show_help ("commands"); return;
	case 'm': show_help ("menu"); return;
	default: {
		if (c == quit_char) {
			return;
		}
		status_msg ("No such help available");
		return;
	}
  }
}


static char print_file [maxLINE_LEN];	/* temp. file for printing */
static FLAG print_status = NOT_VALID;	/* status of print_file */

/**
   Copy text into temporary file for printing; convert to Unicode.
 */
static
int
write_unitext ()
{
  long chars_written = 0L;	/* chars written to buffer this time */
  int lines_written = 0;	/* lines written to buffer this time */
  LINE * line = header->next;
  char * textp = line->text;
  char fn [maxLINE_LEN];
  int fd;

  if (file_name [0] == '\0') {
	build_string (fn, "print");
  } else {
	char * basename = strrchr (file_name, '/');
	if (basename == NIL_PTR) {
		basename = file_name;
	} else {
		basename ++;
	}
	build_string (fn, "print.%s", basename);
  }
  fd = scratchfile (WRITE, False, print_file, fn, & print_status);
  if (fd == ERRORS) {
	return ERRORS;
  }

  chars_written = char_count (textp) - 1;
  while (textp != tail->text) {
	if (* textp == '\n') {
		/* handle different line ends */
		if (line->return_type != lineend_NONE) {
			int ret = writechar (fd, '\r');
			if (ret != ERRORS) {
				ret = writechar (fd, '\n');
			}
			if (ret == ERRORS) {
				(void) close (fd);
				return ERRORS;
			}
			lines_written ++;
			chars_written ++;
		}

		/* move to the next line */
		line = line->next;
		textp = line->text;

		chars_written += char_count (textp) - 1;
	} else {
		unsigned long unichar = charvalue (textp);
		character unibuf [7];
		char * up = (char *) unibuf;
		if (cjk_text || mapped_text) {
			unichar = lookup_cjk (unichar);
			if (unichar == 0) {
				unichar = 0x00A4;	/* ¤ */
			}
		}

		(void) uniUTF (unichar, unibuf);

		/* don't use writestring which might write UTF-16 ! */
		while (* up != '\0') {
			if (writechar (fd, * up) == ERRORS) {
				(void) close (fd);
				return ERRORS;
			}
			up ++;
		}

		advance_char (& textp);
	}
  }

/* Flush the I/O buffer and close file */
  if (flush_buffer (fd) == ERRORS) {
	(void) close (fd);
	return ERRORS;
  }
  if (close (fd) < 0) {
	return ERRORS;
  }

  return FINE;
}

/*
 * Print buffer
 */
void
PRINT ()
{
  char cmd [maxLINE_LEN];	/* Buffer for print command */
  int sysres;
  char * msg;

  if (write_unitext () == ERRORS) {
	error ("Cannot write spool file");
	return;
  }

  clear_status ();
  set_cursor (0, YMAX);
  flush ();
  raw_mode (OFF);

  /* try printing with $MINEDPRINT */
  if (getenv ("MINEDPRINT")) {
	build_string (cmd, getenv ("MINEDPRINT"), print_file);

	sysres = system (cmd);

	if (sysres == 0) {
		msg = getenv ("MINEDPRINT");
	}
  } else {
	sysres = -99;
  }

  /* try printing with uprint */
  if (sysres != 0) {
#ifdef unix
	build_string (cmd, "PATH=`dirname %s`:`dirname %s`:%s:%s:%s:%s:%s:$PATH uprint %s",
		HELPFILE,
		LHELPFILE,
		"/usr/share/mined",
		"/usr/local/share/mined",
		"/usr/share/lib/mined",
		"/opt/mined/share",
		"/usr/share/doc/packages/mined",
		print_file);
#else
	build_string (cmd, "uprint %s", print_file);
#endif

	sysres = system (cmd);

	if (sysres == 0) {
		msg = "uprint";
	}
  }

  /* try printing with $LPR */
  if (sysres != 0 && getenv ("LPR")) {
	build_string (cmd, "%s %s", getenv ("LPR"), print_file);

	sysres = system (cmd);

	if (sysres == 0) {
		msg = getenv ("LPR");
	}
  }

  /* try print with system-specific print_command */
  if (sysres != 0) {
	build_string (cmd, print_command, print_file);

	sysres = system (cmd);

	if (sysres == 0) {
		msg = "system print command";
	}
  }

  sleep (1);
  raw_mode (ON);
  RDwin ();
  if (sysres == 0) {
	status_line ("Printed with ", msg);
  } else {
	error ("Printing failed");
  }
}


/*
 * Pipe buffer
 */
void
CMD ()
{
  int fd;
  char cmd [maxLINE_LEN];	/* Buffer for command */
  char command [maxLINE_LEN];	/* Buffer for full command */

  if (restricted) {
	restrictederr ();
	return;
  }

  if ((fd = yankfile (READ, False)) == ERRORS) {
	error ("Buffer is empty");
	return;
  }
  (void) close (fd);
  if (get_string ("Command with buffer as input:", cmd, True, "") != FINE) {
	return;
  }
  build_string (command, "%s < %s", cmd, yank_file);
  clear_status ();
  set_cursor (0, YMAX);
#ifdef unix
  clear_window_title ();
#endif
  raw_mode (OFF);

  system (command);

  sleep (1);
  raw_mode (ON);
  RDwin ();
}

/*
 * Called if an operation is not implemented on this system
 */
static
void
notavailable ()
{
  error ("Command not available");
}

/*
 * Suspend editor after writing back the file.
 */
void
SUSP ()
{
  if (restricted) {
	restrictederr ();
	return;
  }

  if (cansuspendmyself) {
	if (hop_flag == 0 && modified) {
		if (write_text (False) == ERRORS) {
			return;
		}
	}
	set_cursor (0, YMAX);
#ifdef unix
	clear_window_title ();
#endif
	raw_mode (OFF);

	suspendmyself ();
	raw_mode (ON);
	clear_status ();
	RDwin ();
  } else {
	notavailable ();
  }
}

/*
 * Call an interactive shell.
 */
void
SH ()
{

#ifdef unix
#define SHimplemented
  register int w;
  int pid;
  int status;
  int waiterr;

  if (restricted) {
	restrictederr ();
	return;
  }

#ifdef FORK
  switch (pid = fork ()) {
#else
  switch (pid = vfork ()) {
#endif
	case -1:			/* Error */
		error2 ("Cannot fork command shell: ", serror ());
		return;
	case 0:				/* This is the child */
		set_cursor (0, YMAX);
		putchar ('\n');
		clear_window_title ();
		raw_mode (OFF);

		if (rpipe) {	/* Fix stdin */
			if (close (STD_IN) < 0) {
				_exit (126);
			}
			if (open ("/dev/tty", O_RDONLY, 0) < 0) {
				_exit (126);
			}
		}
		execl (getenv ("SHELL"), getenv ("SHELL"), 0);
		_exit (127);	/* Exit with 127 */
		/* NOTREACHED */
	default:			/* This is the parent */
		do {
			w = wait (& status);
		} while (w != -1 && w != pid);
		waiterr = geterrno ();
  }

  raw_mode (ON);
  RDwin ();

  if (w == -1) {
	error2 ("Shell termination error: ", serrorof (waiterr));
	if (((status >> 8) == 127) || ((status >> 8) == 126)) sleep (2);
  }
  if ((status >> 8) == 127) {		/* Child died with 127 */
	error2 (envvar ("SHELL"), ": error invoking ${SHELL} (not found / not enough memory ?)");
  } else if ((status >> 8) == 126) {
	error ("Cannot open /dev/tty as fd #0");
  }
#endif /* unix */


#ifdef msdos
#define SHimplemented
  char old_dir [maxLINE_LEN];	/* Buffer to hold dir. name */

  if (restricted) {
	restrictederr ();
	return;
  }

  (void) getcwd (old_dir, maxLINE_LEN);

  set_cursor (0, YMAX);
  raw_mode (OFF);

  system (getenv ("COMSPEC"));

  raw_mode (ON);
  clear_status ();
  RDwin ();

  if (chdir (old_dir) == 0) {
	if (old_dir [0] != '\0' && old_dir [1] == ':')
		setdisk (((int) old_dir [0] & (int) '\137') - (int) 'A');
	RD ();	/* disk error dialog may be on screen after chdir */
  } else {
	overwriteOK = False;	/* Same file base name ... */
	writable = True;
/*	if (viewmode == False)	*/
	    set_modified ();	/* would mean different file now */
	RD ();	/* disk error dialog may be on screen */
	error2 ("Cannot reset to previous directory: ", serror ());
  }
#endif /* msdos */


#ifdef vms
#define SHimplemented
  if (restricted) {
	restrictederr ();
	return;
  }

/* Who can tell me why this hangs the process after return from the CLI ?
  set_cursor (0, YMAX);
  raw_mode (OFF);

  system ("SPAWN");

  raw_mode (ON);
  clear_status ();
  RDwin ();
*/
  notavailable ();
#endif


#ifndef SHimplemented
  notavailable ();
#endif
}


/**
   Invoke function associated with the key.
 */
void
invoke_key_function (key)
  unsigned long key;
{
  if (key >= arrlen (key_map) || command (key) == (voidfunc) S) {
	/* out of table or S function: character insertion */
	Scharacter (key);
  } else {
	/* simple key: look up function in key_map */
	/* function key: invoke FUNKEY, then * keyproc */
	(* key_map [key]) (key);
  }
}


/*======================================================================*\
|*			Main						*|
\*======================================================================*/

#define dont_debug_encoding
#ifdef debug_encoding
#define trace_encoding()	printf ("utf8 %d (%d), cjk %d (%d), encoding %c\n", utf8_text, auto_detect_utf, cjk_text, auto_detect_cjk, cjk_encoding)
#else
#define trace_encoding()	
#endif

#define dont_debug_screenmode

#define dont_debug_graphics


void
ANSIseq ()
{
  if (ansi_fini == 'R') {
/*printf ("%d: %d %d\n", ansi_params, ansi_param [0], ansi_param [1]);*/
	status_line ("Late screen mode response ",
		"- set ESCDELAY=2000 or higher for proper detection");
  } else if (ansi_fini == 't') {
	if (ansi_params == 3 && ansi_param [0] == 8) {
#ifdef adjust_to_actual_termsize
		/* adjust to actual screen size reported by terminal */
		if (YMAX != ansi_param [1] - 1 - MENU || XMAX != ansi_param [2] - 1) {
			YMAX = ansi_param [1] - 1 - MENU;
			XMAX = ansi_param [2] - 1;
			RD ();
			... see RDwin
			flush ();
		}
#endif
	} else {
		error ("Unknown terminal status report");
	}
  } else {
	error ("Unknown keyboard control sequence");
  }
}

static
void
WordStar_keys ()
{
  int i;

  for (i = 0; i < 32; i ++) {
	key_map [i] = ws_key_map [i];
  }
  control_prefix = '\020';	/* ^P */
  emulation = 'w';
}

static
void
set_emacs_mode ()
{
  int i;

  for (i = 0; i < 32; i ++) {
	key_map [i] = emacs_key_map [i];
  }
  key_map ['\177'] = DPC;
  control_prefix = '\021';	/* ^Q */
  quit_char = '\007';		/* ^G */
  emulation = 'e';
  emacs_buffer = True;
  paste_stay_left = False;
  JUSmode = 1;
}

static
void
config_markers ()
{
  char * Mark;

  Mark = getenv ("MINEDSHIFT");
/* Turbo-C wants the cast here since getenv must be declared as far * */
  if (Mark != NIL_PTR) {
	SHIFT_MARK = Mark [0];
	if (Mark [0] != '\0') SHIFT_BEG = Mark [1];
  }

  Mark = getenv ("MINEDTAB");
  if (Mark != NIL_PTR) {
/*	TABchar = (Mark [0] == '\0' ? TABdefault : Mark [0]);	*/
	if (Mark [0] == '\0') {
		TABchar = TABdefault;
	} else {
		TABchar = Mark [0];
		TABchar0 = Mark [1];
		if (TABchar0 != '\0') {
			TABchar2 = Mark [2];
		}
		if (TABchar2 != '\0') {
			TABcharmid = Mark [3];
			TABchar0 = '\0';
		}
	}
  } else {
	TABchar = TABdefault;
  }
  UTF_TAB = getenv ("MINEDUTFTAB");
  if (UTF_TAB != NIL_PTR) {
	UTF_TAB0 = UTF_TAB;
	if (* UTF_TAB0 != '\0') {
		advance_utf8 (& UTF_TAB0);
	}
	UTF_TAB2 = UTF_TAB0;
	if (* UTF_TAB2 != '\0') {
		advance_utf8 (& UTF_TAB2);
	}
	UTF_TABmid = UTF_TAB2;
	if (* UTF_TABmid != '\0') {
		advance_utf8 (& UTF_TABmid);
		if (* UTF_TABmid != '\0') UTF_TAB0 = "";
	}
  }

  Mark = getenv ("MINEDRET");
  if (Mark != NIL_PTR) {
	RET_MARK = Mark [0];
	if (RET_MARK != '\0') {
		RET_BLANK = Mark [1];
	}
	if (RET_BLANK != '\0') {
		RET_BLANK2 = Mark [2];
	}
  } else {
	RET_MARK = RETdefault;
  }
  Mark = getenv ("MINEDDOSRET");
  if (Mark != NIL_PTR) {
	DOSRET_MARK = Mark [0];
  } else {
	DOSRET_MARK = DOSRETdefault;
  }
  Mark = getenv ("MINEDPARA");
  if (Mark != NIL_PTR) {
	PARA_MARK = Mark [0];
  } else {
	PARA_MARK = PARAdefault;
  }
  UTF_RET = getenv ("MINEDUTFRET");
  if (UTF_RET != NIL_PTR) {
	UTF_RETblank = UTF_RET;
	if (* UTF_RETblank != '\0') {
		advance_utf8 (& UTF_RETblank);
	}
	UTF_RETblank2 = UTF_RETblank;
	if (* UTF_RETblank2 != '\0') {
		advance_utf8 (& UTF_RETblank2);
	}
  }
  UTF_DOSRET = getenv ("MINEDUTFDOSRET");
  UTF_PARA = getenv ("MINEDUTFPARA");
}

static
void
set_cjk_mode (set_term)
  FLAG set_term;
{
	cjk_text = True;
	auto_detect_utf = False;
	utf8_text = False;
	utf8_lineends = False;
	if (cjk_term) {
		cjk_term_selected = True;
	} else if (set_term && utf8_screen == False) {
		cjk_term = True;
		/* make sure lineend marker will always fit: */
		scrollbar_width = 1;
	}
}

static
void
eval_options (minedopt)
  char * minedopt;
{
  FLAG plus_opt = False;	/* set if options start with '+' */

  while (* minedopt != '\0') {
    switch (* minedopt) {
	case '+':
		plus_opt = True;
		break;
	case '-':
		plus_opt = False;
		minedopt ++;
		if (* minedopt == '-') {
			restricted = True;
		} else {
			minedopt --;
		}
		break;
	case ' ':
		break;
	case 'M':
		MENU = 1 - MENU;
		break;
	case '*':
		use_mouse = False;
		break;
	case 'L':
		minedopt ++;
		minedopt = scan_int (minedopt, & wheel_scroll);
		minedopt --;
		break;
	case 'v':
		init_viewonly = True;
		viewonly = True;
		break;
	case 'm':
		if (plus_opt) {
			multiexit = False;
		} else {
			multiexit = True;
		}
		break;
	case 'P':
		proportional = True;
		break;
	case 'p':
		paradisp = True;
		break;
	case 'r':
		if (RET_opt == 'r') {
			RET_opt = ' ';
		} else {
			RET_opt = 'r';
		}
		break;
	case 'R':
		if (plus_opt) {
			RET_opt = 'M';
		} else {
			RET_opt = 'R';
		}
		break;
	case 'G':
		if (plus_opt) {
			use_vt100_block_graphics = True;
		} else {
			if (display_block_graphics) {
				display_block_graphics = False;
			} else {
				display_block_graphics = True;
			}
		}
		break;
	case 'Q':
		minedopt ++;
		explicit_border_style = True;
		if (* minedopt == 'Q') {
			use_stylish_menu_selection = True;
		} else if (* minedopt == 'a') {
			use_ascii_graphics = True;
		} else if (* minedopt == 'v') {
			use_vt100_block_graphics = True;
		} else {
			menu_border_style = * minedopt;
		}
		break;
	case 'o':
		minedopt ++;
		switch (* minedopt) {
		case '0':
			disp_scrollbar = False;
			scrollbar_width = 0;
			break;
		case '1':
			disp_scrollbar = True;
			fine_scrollbar = False;
			scrollbar_width = 1;
			break;
		case '2':
			disp_scrollbar = True;
			fine_scrollbar = True;
			scrollbar_width = 1;
			break;
		case '8':
			update_scrollbar_lazy = False;
			break;
		case '9':
			update_scrollbar_lazy = True;
			break;
		default:
			minedopt --;
			/* compatibility */
			if (disp_scrollbar) {
				disp_scrollbar = False;
				scrollbar_width = 0;
				/* compatibility with 2000.6 beta */
				if (utf8_screen) {
					bidi_screen = True;
					poormansbidi = False;
				}
			} else if (bidi_screen == False) {
				disp_scrollbar = True;
				scrollbar_width = 1;
			}
		}
		break;
	case 'c':
		if (plus_opt == False) {
			if (combining_mode_disabled) {
				combining_screen = False;
			} else {
				combining_mode = False;
				combining_mode_disabled = True;
			}
		} else {
			combining_screen = True;
			combining_mode = True;
			combining_screen_selected = True;
		}
		break;
	case 'C':
		set_cjk_mode (True);
		if (plus_opt) {
			/* output CJK encoded characters transparently */
			if (suppress_unknown_cjk) {
				suppress_unknown_cjk = False;
			} else if (suppress_invalid_cjk) {
				suppress_invalid_cjk = False;
			} else {
				suppress_extended_cjk = False;
			}
		}
		break;
	case 'U':
		if (plus_opt) {
			if (U_mode_set) {
				bidi_screen = True;
				poormansbidi = False;
				/* disable scrollbar to prevent interference */
				disp_scrollbar = False;
				scrollbar_width = 0;
			} else {
				utf8_screen = True;
				utf8_input = True;
				combining_screen = True;
				combining_mode = True;
				U_mode_set = True;
				cjk_term = False;
				cjk_term_selected = False;
			}
		} else if (utf8_input) {
			utf8_screen = False;
			utf8_input = False;
			combining_screen = False;
			combining_mode = False;
		} else {
			utf8_screen = True;
			utf8_input = True;
			combining_screen = True;
			combining_mode = True;
			cjk_term = False;
			cjk_term_selected = False;
		}
		break;
	case 'u':
		selected_encoding = * minedopt;
		auto_detect_utf = False;
		auto_detect_cjk = False;
		if (plus_opt) {
			utf8_text = False;
			utf8_lineends = False;
		} else {
			utf8_text = True;
			cjk_text = False;
		}
		break;
	case 'l':
		selected_encoding = * minedopt;
		auto_detect_utf = False;
		auto_detect_cjk = False;
		utf8_text = False;
		cjk_text = False;
		break;
	case 'E':
		minedopt ++;
		if (* minedopt == 'U' || * minedopt == 'L') {
			auto_detect_utf = False;
			auto_detect_cjk = False;
			cjk_text = False;
			if (* minedopt == 'U') {
				utf8_text = True;
			} else {
				utf8_text = False;
			}
		} else {
			auto_detect_cjk = False;
			switch (* minedopt) {
			case 'g':	gb18030_term = False;
					(void) set_char_encoding ('G');
					set_cjk_mode (False);
					cjk_encoding_selected = True;
					break;
			case 'j':	euc3_term = False;
					(void) set_char_encoding ('J');
					set_cjk_mode (False);
					cjk_encoding_selected = True;
					break;
			case 'c':	euc4_term = False;
					(void) set_char_encoding ('C');
					set_cjk_mode (False);
					cjk_encoding_selected = True;
					break;
			default:
				if (set_char_encoding (* minedopt)) {
					if (cjk_text) {
						set_cjk_mode (False);
						cjk_encoding_selected = True;
					} else {
						/* mapped_text */
						auto_detect_utf = False;
						auto_detect_cjk = False;
					}
				} else {
					fprintf (stderr, "Unknown encoding tag %c\n", * minedopt);
					sleep (1);
				}
				break;
			}
		}
		if (! cjk_encoding_selected) {
			selected_encoding = * minedopt;
		}
		break;
	case 'b':
		if (poormansbidi) {
			poormansbidi = False;
		} else {
			poormansbidi = True;
			bidi_screen = False;
		}
		break;
	case 'K':
		if (plus_opt) {
			enforce_keymap = True;
		} else {
			minedopt ++;
			selection_space = * minedopt;
		}
		break;
	case 'w':
		if (wordnonblank) {
			wordnonblank = False;
		} else {
			wordnonblank = True;
		}
		break;
	case 'a':
		append_flag = True;
		break;
	case 'j':
		if (plus_opt) {
			if (JUSlevel < 2) {
				JUSlevel ++;
			}
		} else if (JUSlevel == 1) {
			JUSlevel = 2;
		} else {
			JUSlevel = 1;
		}
		break;
	case 'J':
		JUSlevel = 2;
		break;
	case 'k':
		mined_keypad = False;
		mined_del_is_cut = False;
		break;
	case 'B':
		/*
		key_map ['\010'] = DPC;
		key_map ['\177'] = DCC;
		*/
		key_map ['\010'] = MLF;
		key_map ['\177'] = DPC;
		break;
	case 'T':
		tab_left = False;
		break;
	case 'W':
		WordStar_keys ();
		break;
	case 'e':
		set_emacs_mode ();
		break;
	case 'V':
		emacs_buffer = plus_opt;
		paste_stay_left = ! plus_opt;
		break;
	case 's':
		page_stay = True;
		break;
	case 'S':
		page_scroll = True;
		break;
	case 'x':
		xprot = exeprot;
		break;
	case 'X':
		no_window_title = True;
		break;
	case 't':
		minedopt ++;
		if (* minedopt == '\0') {
			TABchar = TABdefault;
		} else {
			TABchar = * minedopt;
		}
		break;
	case 'd':
		minedopt ++;
		if (* minedopt == '-') {
			display_delay = -1;
		} else if (* minedopt >= '0' && * minedopt <= '9') {
			display_delay = (int) * minedopt - (int) '0';
		} else {
			minedopt --;
		}
		break;
	case '/':
		minedopt ++;
		inisearch = minedopt;
		break;
	case '4':
		tabsize = 4;
		break;
	case '8':
		tabsize = 8;
		break;
	default:
		fprintf (stderr, "Unknown option %c\n", * minedopt);
		sleep (1);
		break;
    }
    if (* minedopt != '\0') {
	minedopt ++;
    }
  }
}


#define dont_debug_test_screen_width

/* for the initial position request, balance the delay time 
   (to accept a response) so that reponses via slow remote 
   terminal lines can be acquired but the user delay on a 
   terminal that doesn't respond at all remains acceptable
 */
static int response_delay = 700;	/* initial value */
static int response_delay_plus = 0;	/* additional value */
static int response_delay_more = 800;	/* for subsequent responses */
static int escape_delay = 0;		/* wait to detect escape sequence */
static int default_escape_delay = 450;	/* overridden by $ESCDELAY */

static
void
adjust_delays ()
{
  if (escape_delay == 0) {
	char * env = getenv ("ESCDELAY");
	if (env) {
		(void) scan_int (env, & escape_delay);
	}
	if (escape_delay == 0) {
		escape_delay = default_escape_delay;
	} else {
		response_delay += escape_delay - default_escape_delay;
	}
  }
}

static
int
test_screen_width (s)
  char * s;
{
#ifndef msdos
  character c;
  int row, col;

  putoutstring ("\r");
  putoutstring (s);
  putoutstring ("\033[6n");	/* maybe termcap u7 but not really defined */
  putoutstring ("\r\033[K");	/* reduce visible effect */
  flushout ();

  adjust_delays ();

  if (char_ready_within (response_delay + response_delay_plus)) {
	/* for subsequent position requests, increase delay time 
	   for the sake of mlterm which needs a longer time to react, 
	   probably for font loading
	 */
	response_delay_plus = response_delay_more;

	c = read1byte ();
	if (c == '\033' && char_ready_within (escape_delay)) {
		c = read1byte ();
		if (c == '[' && char_ready_within (escape_delay)) {
			c = get_digits (& row);
			if (c == ';') {
				c = get_digits (& col);
#ifdef debug_test_screen_width
	printf ("test %s -> %d\n", s, col - 1);
#endif
				return col - 1;
			}
		}
	}
  }
#endif

  return -1;
}

typedef struct {
	char * test;
	int width;
	} screen_width;

static screen_width utf8_widths [] =
{
	{"a̡"},
	{"《》〚〛｠"},
	{"a܏"},
	{".឴.឵.᠎"},
	{"‘’“”…―­"},
	{"…―…"},
	{"╭"},
	{"𠀀𠀀𠀀𠀀a𝆪a𝆪a󠀠"},
};

static screen_width cjk_widths [] =
{
	{"02"},
	{"ꥦޡ"},
	{""},
	{"x"},
	{""},
};

static
int
get_screen_width (s, sw, len)
  char * s;
  screen_width * sw;
  int len;
{
  int i;
  for (i = 0; i < len; i ++) {
	if (streq (s, sw [i].test)) {
#ifdef debug_test_screen_width
	printf ("get %s -> %d\n", s, sw [i].width);
#endif
		return sw [i].width;
	}
  }
  return test_screen_width (s);
}

static
void
acquire_screen_widths (sw, len)
  screen_width * sw;
  int len;
{
#ifndef msdos
  int i;
  character c;
  int row, col;

  for (i = 0; i < len; i ++) {
	putoutstring ("\r");
	putoutstring (sw [i].test);
	putoutstring ("\033[6n");	/* maybe termcap u7 but not really defined */
  }
  putoutstring ("\r\033[K");	/* reduce visible effect */
  flushout ();

  adjust_delays ();

  for (i = 0; i < len; i ++) {
    if (char_ready_within (response_delay + response_delay_plus)) {
	/* for subsequent position requests, increase delay time 
	   for the sake of mlterm which needs a longer time to react, 
	   probably for font loading
	 */
	response_delay_plus = response_delay_more;

	c = read1byte ();
	if (c == '\033' && char_ready_within (escape_delay)) {
		c = read1byte ();
		if (c == '[' && char_ready_within (escape_delay)) {
			c = get_digits (& row);
			if (c == ';') {
				c = get_digits (& col);
				sw [i].width = col - 1;
#ifdef debug_test_screen_width
	printf ("acquire %s -> %d\n", sw [i].test, col - 1);
#endif
			}
		}
	}
    }
  }
#endif
}


/**
   Setup configured display attributes for certain items
 */
static
void
get_ansi_modes ()
{
  dimansi = getenv ("MINEDDIM");
  if (dimansi == NIL_PTR) {
#ifdef pc
	dimansi = "1;31";
#else
	dimansi = "2;31";
#endif
  }

  uniansi = getenv ("MINEDUNI");
  if (uniansi == NIL_PTR) {
	if (cjk_term) {
		uniansi = "36;7;40";
	} else {
		uniansi = "40;36;7";
	}
  } else if ((character) * uniansi > '9') {
	UNI_MARK = * uniansi;
	do {
		uniansi ++;
	} while (* uniansi == ' ');
  }
  unimarkansi = getenv ("MINEDUNIMARK");
  if (unimarkansi == NIL_PTR) {
	unimarkansi = "36;1";
  }
  combiningansi = getenv ("MINEDCOMBINING");
  if (combiningansi == NIL_PTR) {
	combiningansi = "46";	/* 45? */
  }

  ctrlansi = getenv ("MINEDCTRL");
  if (ctrlansi == NIL_PTR) {
	ctrlansi = "";
  }
  menuansi = getenv ("MINEDMENU");
  if (menuansi == NIL_PTR) {
	menuansi = "";
  }
  HTMLansi = getenv ("MINEDHTML");
  if (HTMLansi == NIL_PTR) {
	if (streq ("cygwin", envvar ("TERM"))) {
		HTMLansi = "1;34";
	} else {
		HTMLansi = "34";
	}
  }
  diagansi = envvar ("MINEDDIAG");

  scrollbgansi = getenv ("MINEDSCROLLBG");
  if (scrollbgansi == NIL_PTR) {
	if (colours_256 || colours_88) {
		/*scrollbgansi = "34;48;5;45";*/
		scrollbgansi = "46;34;48;5;45";
	} else {
		scrollbgansi = "46;34";
	}
  }
  scrollfgansi = getenv ("MINEDSCROLLFG");
  if (scrollfgansi == NIL_PTR) {
	scrollfgansi = "";
	if (colours_256 || colours_88) {
		/*scrollfgansi = "44;38;5;45";*/
		/*scrollfgansi = "44;36;38;5;45";*/
	} else if (cjk_term && (cjk_encoding == 'K' || cjk_encoding == 'H')
		  && strisprefix ("xterm", envvar ("TERM"))
	    ) {
		/* probably hanterm; attributes will all be reverse 
		   and could not be distinguished to build the scrollbar
		 */
		scrollfgansi = "0";
	} else {
		/*scrollfgansi = "44;36";*/
	}
  }
}


/**
   configuration and initialisation:
 */
/* initially determine character encoding modes, simple approach */
/* determine various modes and display options from environment settings */
/* evaluate command line options (not file names) */
/* handling of input/output redirection */
/* terminal mode initialisation */
/* detect screen encoding and calibrate screen properties */
/* set screen mode and default text encoding according to locale encoding */
/* determine combining character support on CJK terminal */
/* configure line markers */
/* get preconfigured smart quotes style */
/* get selection of Han character information to be displayed */
/* detect language component of locale */
/* special cases of terminal capabilities handling (esp. block graphics) */
/* get ANSI screen mode configuration */
/* set configured keyboard mapping */
/* determine terminal-specific escape sequences and restrictions */
/* generate names of paste files and of panic-file */
/* read filter that defines which CJK encodings may be auto-detected */
/* terminal height adjustment / detection */
/* prepare editing buffer */
/* load the file (if any) */
/* main loop of the editor */

int
main (argc, argv)
  int argc;
  char * argv [];
{
  unsigned long inputchar;
  int initlinenum;
  int initlini = 0;
  LINE * initline;
  FLAG goon;
  FLAG cursor_somewhere = False;
  int swidth;
  int cwidth;
  char * encoding;
  char * language;
  char * env;
  char * minedopt;


/* initially determine character encoding modes, simple approach */
  if (getenv ("utf8_screen")) {
	utf8_screen = True;
  }
  if (getenv ("utf8_input")) {
	utf8_input = True;
  }
  if (getenv ("utf8_term")) {
	utf8_screen = True;
	utf8_input = True;
  }
  if (is_locale_utf8 ()) {
	utf8_screen = True;
	utf8_input = True;
  }
  if (! getenv ("utf8_no_combining_screen")) {
	if (utf8_screen) {
		combining_screen = True;
		combining_mode = True;
	}
  }

  if (getenv ("MINEDCJKTERM") || getenv ("MINEDCHIN")) {
	/* deprecated */
	set_cjk_mode (True);
  }


/* determine various modes and display options from environment settings */
  if (getenv ("NoCtrlSQ") || getenv ("NoControlSQ")) {
	/* ^S and ^Q may come arbitrarily from terminal, so don't use them */
	controlQS = True;
	key_map ['\021'] = I;
	key_map ['\023'] = I;
  }
  if (getenv ("MINEDPROP")) {
	proportional = True;
  }
  if (getenv ("MINEDTURKISH")) {
	/* deprecated */
	Turkish = True;
  }

  if (getenv ("MINEDMAC")) {
	RET_opt = 'R';
  }
  if (getenv ("MINEDWS")) {
	WordStar_keys ();
  }
  transout = envvar ("MINEDOUT");
  if (* transout != '\0') {
	translen = strlen (transout);
	translate_output = True;
	use_ascii_graphics = True;
  }
#ifdef unix
  if (getenv ("MINEDMODF")) {
	mined_modf = getenv ("MINEDMODF");
  }
#endif
#ifdef pc_winlowdelay
  if (getenv ("windir")) {
	display_delay = 0;
  }
#endif

#ifdef debug_graphics
  printf ("ascii %d, vga %d, vt100 %d\n", use_ascii_graphics, use_vga_block_graphics, use_vt100_block_graphics);
#endif

  if ((minedopt = getenv ("MINED")) != NIL_PTR) {
	eval_options (minedopt);
  }

#ifdef debug_graphics
  printf ("ascii %d, vga %d, vt100 %d\n", use_ascii_graphics, use_vga_block_graphics, use_vt100_block_graphics);
#endif


/* evaluate command line options (not file names) */
  fnami = 1;
  goon = True;
  do {
	if (fnami < argc) {
		if (streq (argv [fnami], "++")) {
			fnami += 1;
			goon = False;
		} else if (* argv [fnami] == '+' && argv [fnami] [1] >= '0' && argv [fnami] [1] <= '9') {
			initlini = fnami;
			fnami += 1;
		} else if (* argv [fnami] == '-'
			      || * argv [fnami] == '+'
#ifdef msdos
			      || * argv [fnami] == '/'
#endif
			      )
		{
			minedopt = argv [fnami];
			eval_options (minedopt);
			fnami += 1;
		} else {
			goon = False;
		}
	} else {
		goon = False;
	}
  } while (goon);

  fnami_min = fnami;
  fnami_max = argc - 1;
  fnami_cnt = argc - fnami_min;
  fnamv = argv;	/* Why did this produce a warning? C is such a stupid language! */
  if (! (fnami < argc)) {
     fnami = 0;
  }


/* handling of input/output redirection */
  /* Note:
     - input redirection does not work with DOS version
     - handling of input/output redirection has to be suppressed in 
       DOSBox or mined cannot start there (probably a DOSBox bug)
  */
#ifdef msdos
  if (strisprefix ("Z:\\", envvar ("COMSPEC")))
  {
	/* DOSBox detected */
  }
  else
#endif
  {
    if (! isatty (STD_IN)) {	/* Reading from pipe */
	if (fnami != 0) {
		panic ("Cannot read both pipe and file", NIL_PTR);
	}
	rpipe = True;
	set_modified ();	/* Set modified flag not to loose buffer */
#ifdef msdos
	panic ("Cannot edit after input from pipe", "MSDOS C incompatibility");
#else
	if ((input_fd = open ("/dev/tty", O_RDONLY, 0)) < 0) {
		panic ("Cannot open /dev/tty for read", serror ());
	}
#endif
    }

    if (! isatty (STD_OUT)) {
	wpipe = True;
	set_modified (); /* Set modified flag not to ignore buffer on exit */
	if ((output_fd = open ("/dev/tty", O_WRONLY, 0)) < 0) {
		panic ("Cannot open /dev/tty for write", serror ());
	}
    }
  }


/* terminal mode initialisation */
  get_term ();
  raw_mode (ON);	/* Set tty to appropriate mode */
  getwinsize ();
  if (erase_char != '\0') {
	key_map [erase_char] = DPC;
  }


/* detect screen encoding and calibrate screen properties */
  trace_encoding ();
  swidth = test_screen_width ("åلاษษ刈墢");
#ifdef debug_screenmode
  printf ("%d %s\n", swidth, getenv ("LC_CTYPE"));
#endif
  if (swidth > 0) {
	/**
	 check cursor column after test string, determine screen mode
	  6	-> UTF-8, no double-width, with LAM/ALEF ligature joining
	  7	-> UTF-8, no double-width, no LAM/ALEF ligature joining
	  8	-> UTF-8, double-width, with LAM/ALEF ligature joining
	  9	-> UTF-8, double-width, no LAM/ALEF ligature joining
	 10,11,16	-> CJK terminal (with luit)
	 15	-> 8 bit terminal or CJK terminal
	 14,17	-> CJK terminal
	 18	-> CJK terminal (or 8 bit terminal, e.g. Linux console)
	*/
	if (swidth > 0 && swidth <= 9 && ! cjk_term_selected) {
		utf8_screen = True;
		utf8_input = True;
		cjk_term = False;

		acquire_screen_widths (utf8_widths, arrlen (utf8_widths));
		if (get_screen_width ("a̡", utf8_widths, arrlen (utf8_widths)) == 1) {
			combining_screen = True;
			if (! combining_mode_disabled) {
				combining_mode = True;
			}
		} else {
			combining_screen = False;
			combining_mode = False;
		}
		if ((swidth & 1) == 0) {
			/* ligature joining detected, must also be bidi */
			bidi_screen = True;
			poormansbidi = False;
			/* disable scrollbar to prevent interference */
			disp_scrollbar = False;
			scrollbar_width = 0;
		}
		if (swidth < 8) {
			/* no wide character support */
			width_data_version = 0;
		} else if (get_screen_width ("《》〚〛｠", utf8_widths, arrlen (utf8_widths)) < 8) {
			/* older width data (before xterm 167) */
			width_data_version = 1;
			if (get_screen_width ("a܏", utf8_widths, arrlen (utf8_widths)) == 1) {
				combining_data_version = 2;
			} else {
				combining_data_version = 1;
			}
		} else if (get_screen_width (".឴.឵.᠎", utf8_widths, arrlen (utf8_widths)) == 4) {
			combining_data_version = 4;
		}
		if (width_data_version == 2) {
			swidth = get_screen_width ("‘’“”…―­", utf8_widths, arrlen (utf8_widths));
			if (swidth > 8) {
				/* xterm -cjk_width (since xterm 168) */
				fine_scrollbar = False;
				if (swidth & 1) {
					/* soft hyphen is narrow */
					width_data_version = 4;
				} else {
					width_data_version = 3;
				}
			}
#ifdef single_width_check
			swidth = get_screen_width ("…―…", utf8_widths, arrlen (utf8_widths));
			if ((swidth & 1) == 0) {
				/* ― is wide */
			}
			if (swidth >= 5) {
				/* … is wide */
			}
#endif
		}

		/* workaround for mlterm deficiencies */
		if (bidi_screen) { /* probably mlterm */
			/* bold does not work */
			use_bold = False;
			/* mouse hilite tracking does not work */
			mouse_hilite_tracking = False;
			raw_mode (OFF);
			raw_mode (ON);
		}
		/* workaround for buggy mlterm width data chaos */
		if (explicit_border_style == False && width_data_version != 3) {
			bold_on ();
			if (get_screen_width ("╭", utf8_widths, arrlen (utf8_widths)) > 1) {
				use_vt100_block_graphics = True;
			}
			bold_off ();
		}

		/* check non-BMP width properties */
		nonbmp_width_data = get_screen_width ("𠀀𠀀𠀀𠀀a𝆪a𝆪a󠀠", utf8_widths, arrlen (utf8_widths)) - 7;
	} else {
		utf8_screen = False;
		utf8_input = False;
		if (! combining_screen_selected) {
			combining_screen = False;
			combining_mode = False;
		}
		acquire_screen_widths (cjk_widths, arrlen (cjk_widths));
		if (swidth > 13) {
			cwidth = get_screen_width ("02", cjk_widths, arrlen (cjk_widths));
			if (cwidth > 2) {
				/* quite safe detection */
				gb18030_term = False;
			} else if (cwidth >= 0) {
				cjk_term = True;
				if (cwidth == 1) {
					cjk_uni_term = True;
				}
			}
			/* if any of the following characters is smaller 
			   than 2 character cells, 
			   it's not a native CJK terminal
			 */
			cwidth = get_screen_width ("ꥦޡ", cjk_widths, arrlen (cjk_widths));
			if (cwidth < 10) {
				cjk_uni_term = True;
			}
			cwidth = get_screen_width ("", cjk_widths, arrlen (cjk_widths));
			if (cwidth > 2) {
				/* quite safe detection */
				euc4_term = False;
			} else if (cwidth >= 0) {
				cjk_term = True;
			}
			if (euc3_term && get_screen_width ("x", cjk_widths, arrlen (cjk_widths)) > 3) {
				/* unsafe detection */
				euc3_term = False;
			}
			if (get_screen_width ("", cjk_widths, arrlen (cjk_widths)) < 2) {
				cjklow_term = False;
			}
		}
		if ((swidth > 10 && swidth != 15 && swidth < 18) || cjk_term) {
			/* if the test string width did not comply 
			   with 8 bit behaviour, or a 
			   GB18030 or EUC 4 byte (EUC-TW) terminal 
			   was asserted, assume CJK terminal;
			   a EUC 3 byte (EUC-JP) terminal cannot 
			   be asserted but can just be assumed as 
			   an 8 bit terminal might respond with 
			   the same width behaviour
			 */
			utf8_screen = False;
			utf8_input = False;
			if (! combining_screen_selected) {
				combining_screen = False;
				combining_mode = False;
			}
			set_cjk_mode (True);
		}
	}
  }
  trace_encoding ();


/* set screen mode and default text encoding according to locale encoding */
  if (cjk_encoding_selected == False) {
	if (utf8_screen) {
		encoding = locale_text_encoding ();
	} else {
		encoding = locale_terminal_encoding ();
	}

	/* detect CJK encodings by locale suffixes;
	   if there is no encoding suffix (starting after "."), 
	   as a fallback, try to interpret the country suffix 
	   (starting with "_" as returned by the functions above)
	 */
	if (strisprefix ("GB", encoding)
	 || strisprefix ("gb", encoding)
	 || strisprefix ("EUC-CN", encoding)
	 || strisprefix ("euccn", encoding)
	 || strisprefix ("_CN", encoding)
	   )
	{
		cjk_encoding_selected = True;
		(void) set_char_encoding ('G');
	}
	else if (strisprefix ("BIG5", encoding)
		 || strisprefix ("Big5", encoding)
		 || strisprefix ("_HK", encoding)
		 || strisprefix ("_TW", encoding)
		)
	{
		cjk_encoding_selected = True;
		(void) set_char_encoding ('B');
	}
	else if (strisprefix ("EUC-TW", encoding)
		 || strisprefix ("euctw", encoding)
		)
	{
		cjk_encoding_selected = True;
		(void) set_char_encoding ('C');
	}
	else if (strisprefix ("UHC", encoding)
		 || strisprefix ("EUC-KR", encoding)
		 || strisprefix ("euckr", encoding)
		)
	{
		cjk_encoding_selected = True;
		(void) set_char_encoding ('K');
	}
	else if (strisprefix ("EUC-JP", encoding)
		 || strisprefix ("eucjp", encoding)
		 || strisprefix ("euc", encoding)
		)
	{
		cjk_encoding_selected = True;
		(void) set_char_encoding ('J');
	}
	else if (strisprefix ("Shift_JIS", encoding)
		 || strisprefix ("sjis", encoding)
		)
	{
		cjk_encoding_selected = True;
		(void) set_char_encoding ('S');
	}
	else if (strisprefix ("JOHAB", encoding)
		)
	{
		cjk_encoding_selected = True;
		(void) set_char_encoding ('H');
	}

	if (cjk_encoding_selected) {
		auto_detect_cjk = False;
		set_cjk_mode (True);
	}
  }
  trace_encoding ();


/* determine combining character support on CJK terminal */
  if (cjk_term) {
	unsigned long cjk_combining = cjk (0x0300);
	char cjk_check [9];
	char * check = cjk_check;
	* check ++ = 'a';
	check += cjkencode (cjk_combining, check);
	* check = '\0';
	if (get_screen_width (cjk_check, cjk_widths, arrlen (cjk_widths)) == 1) {
		combining_screen = True;
		if (! combining_mode_disabled) {
			combining_mode = True;
		}
#ifdef debug_screenmode
	printf ("cjk combining screen %d (disabled %d) mode %d\n", combining_screen, combining_mode_disabled, combining_mode);
#endif
	}
  }


/* configure line markers */
  if (cjk_term == False) {
	config_markers ();
  } else {
	/* determine size of line markers in CJK terminal encoding */
	int cjk_tab3_width;
	int cjk_tab1_width;
	unsigned long cjk_lineend = cjk (0x300A);	/* 《 */
	unsigned long cjk_tab = cjk (0x00B7);		/* · */
	unsigned long cjk_tab3 = cjk (0x2026);		/* … */
	char cjk_check [29];
	char * check = cjk_check;
	int cjk_lmwidth;
	check += cjkencode (cjk_lineend, check);
	check += cjkencode (cjk_lineend, check);
	check += cjkencode (cjk_lineend, check);
	check += cjkencode (cjk_lineend, check);
	check += cjkencode (cjk_tab, check);
	check += cjkencode (cjk_tab, check);
	check += cjkencode (cjk_tab3, check);
	* check = '\0';
	cjk_lmwidth = get_screen_width (cjk_check, cjk_widths, arrlen (cjk_widths));
	cjk_lmwidth --;
	cjk_tab3_width = 1 + (cjk_lmwidth & 1);
	cjk_lmwidth = (cjk_lmwidth >> 1) - 1;
	cjk_tab1_width = 1 + (cjk_lmwidth & 1);
	cjk_lmwidth = (cjk_lmwidth >> 1) - 1;
	cjk_lineend_width = 1 + (cjk_lmwidth & 1);

	if (cjk_uni_term) {
		if (cjk_lineend_width == 1) {
			width_data_version = 1;
		} else if (cjk_tab1_width == 1) {
			/* fix this as a work-around for buggy rxvt */
			width_data_version = 2;
		} else if (cjk_tab3_width == 2) {
			/* if soft hyphen is wide 
				width_data_version = 3;
			   else
			 */
			width_data_version = 4;
		}
#ifdef debug_screenmode
	printf ("cjk_uni_term (%d) ", width_data_version);
#endif
	}
#ifdef debug_screenmode
	printf ("CJK %c\n", cjk_encoding);
	printf ("euc3 %d, euc4 %d, low cjk %d\n", euc3_term, euc4_term, cjklow_term);
#endif

#ifdef CJKTAB_MIDDLE_DOT
	/* does not work with JIS and Johab fonts */
	CJK_TAB_MARK = 0x00B7;
	cjk_tab_width = cjk_tab1_width;
#else
	cjk_tab_width = cjk_tab3_width;
#endif
	if (cjk_encoding == 'H') {
		/* work-around for buggy hanterm */
		CJK_TAB_MARK = '.';
		cjk_tab_width = 1;
	}

	/* ensure further markers work for CJK */
	SHIFT_MARK = ' ';
  }


/* get preconfigured smart quotes style */
  preselect_quote_style = getenv ("MINEDQUOTES");


/* get selection of Han character information to be displayed */
  env = getenv ("MINEDHANINFO");
  if (env) {
	if (* env) {
		always_disp_Han = True;
		disp_Han_description = False;
		disp_Han_full = False;
	} else {
		always_disp_Han = False;
	}
	if (strchr (env, 'M') != NIL_PTR) {
		disp_Han_Mandarin = True;
	}
	if (strchr (env, 'C') != NIL_PTR) {
		disp_Han_Cantonese = True;
	}
	if (strchr (env, 'J') != NIL_PTR) {
		disp_Han_Japanese = True;
	}
	if (strchr (env, 'S') != NIL_PTR) {
		disp_Han_Sino_Japanese = True;
	}
	if (strchr (env, 'K') != NIL_PTR) {
		disp_Han_Korean = True;
	}
	if (strchr (env, 'V') != NIL_PTR) {
		disp_Han_Vietnamese = True;
	}
	if (strchr (env, 'D') != NIL_PTR) {
		disp_Han_description = True;
	}
	if (strchr (env, 'F') != NIL_PTR) {
		disp_Han_description = True;
		disp_Han_full = True;
	}
  }

/* detect language component of locale */
  language = getenv ("LANG");
  if (! language || ! * language) {
    language = getenv ("LC_ALL");
    if (! language || ! * language) {
      language = getenv ("LC_CTYPE");
    }
  }
  if (language && * language) {
	if (strisprefix ("de", language)) {
		language_tag = 'g';
	} else if (strisprefix ("da", language)) {
		language_tag = 'd';
	} else if (strisprefix ("fr", language)) {
		language_tag = 'f';
	} else if (strisprefix ("tr", language) || strisprefix ("az", language)) {
		language_tag = 't';
		Turkish = True;
	} else if (strisprefix ("lt", language)) {
		language_tag = 'l';
		Lithuanian = True;
	}
  }


/* special cases of terminal capabilities handling (esp. block graphics) */
  if (streq ("linux", envvar ("TERM"))) {
	fine_scrollbar = False;
	if (explicit_border_style == False) {
		if (utf8_screen) {
			/*use_ascii_graphics = True;*/
			menu_border_style = 's';
		} else if (use_vt100_block_graphics == False) {
			use_vga_block_graphics = True;
		}
	}
  }
  if (can_alt_cset == False && use_pc_block_graphics == False && utf8_screen == False) {
	use_ascii_graphics = True;
  }
  if (cjk_term) {
	/*use_bgcolor = False;*/
	if (strisprefix ("rxvt", envvar ("TERM"))) {
		/* seems to work now */
	} else {
		/* cxterm would blink instead of setting 256 color mode */
		colours_256 = False;
		colours_88 = False;
	}
  }
#ifdef debug_graphics
  printf ("ascii %d, vga %d, vt100 %d\n", use_ascii_graphics, use_vga_block_graphics, use_vt100_block_graphics);
#endif

/* get ANSI screen mode configuration */
  get_ansi_modes ();

/* set configured keyboard mapping */
#ifndef msdos
  setKEYMAP (getenv ("MINEDKEYMAP"));
#endif

/* determine terminal-specific escape sequences and restrictions */
  if (strisprefix ("vt100", envvar ("TERM"))) {
	set_fkeymap ("vt100");
  }
  if (strisprefix ("hpterm", envvar ("TERM"))) {
	set_fkeymap ("hp");
	use_ascii_graphics = True;
	use_bold = False;
  }
  if (strisprefix ("9780", envvar ("TERM"))) {
	set_fkeymap ("siemens");
	use_ascii_graphics = True;
  }
  if (standout_glitch) {
	use_bold = False;
  }

/* detect PC terminal on Unix (e.g. telnet from DOS Box or CYGWIN=codepage:oem) */
#ifndef pc_charset
  if (getenv ("TERM") && 
	(strisprefix ("pcansi", getenv ("TERM"))
	|| strisprefix ("nansi", getenv ("TERM"))
	|| strisprefix ("ansi.", getenv ("TERM"))
	|| strstr (getenv ("TERM"), "-emx")
	)
     ) {
	pc_term = True;
	use_vga_block_graphics = True;
  }
  if (strisprefix ("ansi", envvar ("TERM"))) {
	use_ascii_graphics = True;
  }
#endif
/* prevent use of vt100 graphics on rxvt which does not support them */
  if (strisprefix ("rxvt", envvar ("TERM"))) {
	if (! utf8_screen) {
		use_ascii_graphics = True;
	}
  }
/* prevent use of vt100 graphics on kde konsole which does not support them */
  if (getenv ("KONSOLE_DCOP")) {
	if (! utf8_screen) {
		use_ascii_graphics = True;
	}
  }
/* check if cygwin DOS box is configured to be in PC character set mode */
  if (streq (envvar ("TERM"), "cygwin")) {
	if (strstr (envvar ("CYGWIN"), "codepage:oem")) {
#ifndef pc_charset
		pc_term = True;
#endif
	} else {
		use_pc_block_graphics = True;
	}
  }
#ifdef debug_graphics
  printf ("ascii %d, vga %d, vt100 %d\n", use_ascii_graphics, use_vga_block_graphics, use_vt100_block_graphics);
#endif
/* prevent use of vt100 graphics on cygwin xterm which does not support them */
#ifdef __CYGWIN__
  if (streq (envvar ("TERM"), "xterm") && ! utf8_screen) {
	use_ascii_graphics = True;
  }
#endif
  if (cjk_term && ! use_vt100_block_graphics) {
	use_ascii_graphics = True;
  }
#ifdef debug_graphics
  printf ("ascii %d, vga %d, vt100 %d\n", use_ascii_graphics, use_vga_block_graphics, use_vt100_block_graphics);
#endif


/* generate names of paste files and of panic-file */
#ifdef unix
  temp_dir = getenv ("MINEDTMP");
  if (temp_dir == NIL_PTR || temp_dir [0] == '\0' || access (temp_dir, R_OK | X_OK) < 0) {
	temp_dir = getenv ("TMPDIR");
  }
  if (temp_dir == NIL_PTR || temp_dir [0] == '\0' || access (temp_dir, R_OK | X_OK) < 0) {
	temp_dir = getenv ("TMP");
  }
  if (temp_dir == NIL_PTR || temp_dir [0] == '\0' || access (temp_dir, R_OK | X_OK) < 0) {
	temp_dir = getenv ("TEMP");
  }
  if (temp_dir == NIL_PTR || temp_dir [0] == '\0' || access (temp_dir, R_OK | X_OK) < 0) {
	temp_dir = "/usr/tmp";
  }
  if (access (temp_dir, R_OK | X_OK) < 0) {
	temp_dir = "/tmp";
  }
  if (getenv ("MINEDUSER")) {
	build_string (yankie_file, "%s/mined.%s", temp_dir, getenv ("MINEDUSER"));
	build_string (panic_file, "%s/minedpanic.%s.%d", temp_dir, getenv ("MINEDUSER"), getpid ());
  } else if (getenv ("USER")) {
	build_string (yankie_file, "%s/mined.%s", temp_dir, getenv ("USER"));
	build_string (panic_file, "%s/minedpanic.%s.%d", temp_dir, getenv ("USER"), getpid ());
  } else {
	build_string (yankie_file, "%s/mined.%d", temp_dir, geteuid ());
	build_string (panic_file, "%s/minedpanic.%d.%d", temp_dir, geteuid (), getpid ());
  }
#endif
#ifdef vms
  if (getenv ("SYS$MINEDTMP")) {
	temp_dir = "SYS$MINEDTMP";
  } else if (getenv ("SYS$SCRATCH")) {
	temp_dir = "SYS$SCRATCH";
  } else {
  	temp_dir = "SYS$LOGIN";
  }
  if (getenv ("MINEDUSER")) {
	build_string (yankie_file, "%s:$MINED$%s", temp_dir, getenv ("MINEDUSER"));
	build_string (panic_file, "%s:$MINEDPANIC$%s.%d", temp_dir, getenv ("MINEDUSER"), getpid ());
  } else if (getenv ("USER")) {
	build_string (yankie_file, "%s:$MINED$%s", temp_dir, getenv ("USER"));
	build_string (panic_file, "%s:$MINEDPANIC$%s.%d", temp_dir, getenv ("USER"), getpid ());
  } else {
	build_string (yankie_file, "%s:$MINED$%d", temp_dir, geteuid ());
	build_string (panic_file, "%s:$MINEDPANIC$%d.%d", temp_dir, geteuid (), getpid ());
  }
#endif
#ifdef msdos
  temp_dir = getenv ("MINEDTMP");
  if (temp_dir == NIL_PTR || temp_dir [0] == '\0') {
	temp_dir = getenv ("TEMP");
  }
  if (temp_dir == NIL_PTR || temp_dir [0] == '\0') {
	temp_dir = getenv ("TMP");
  }
  if (temp_dir == NIL_PTR || temp_dir [0] == '\0') {
	temp_dir = "\\";
  }
  if (getenv ("MINEDUSER")) {
	build_string (yankie_file, "%s\\mined-%s", temp_dir, getenv ("MINEDUSER"));
	build_string (panic_file, "%s\\minedpan.%s", temp_dir, getenv ("MINEDUSER"));
  } else {
	build_string (yankie_file, "%s\\mined", temp_dir);
	build_string (panic_file, "%s\\mined-pa.nic", temp_dir);
  }
#endif


/* fprot = umask (0); */


/* read filter that defines which CJK encodings may be auto-detected */
  detect_encodings = getenv ("MINEDDETECT");


/* terminal height adjustment / detection */
  if (ansi_esc) {
#ifdef adjust_terminal_height
	if (strisprefix ("xterm", envvar ("TERM"))) {
		/* try to adjust the window to the size the tty assumes;
		   esp. for buggy Cygwin/X xterm size tty assumption,
		   also work-around for various rlogin/telnet size confusions;
		   doesn't work with rxvt (which would become extra large)
		 */
		char resizebuf [19];
		build_string (resizebuf, "\033[%dt", YMAX + 1 + MENU);
		putoutstring (resizebuf);
	}
#else
#ifdef adjust_to_actual_termsize
	unsigned long c;
	/* response will be handled by ANSIseq */
	putoutstring ("\033[18t");
	flush ();
#endif
#endif
  }


/* ----------------------------------------------------------------------- */

/* prepare editing buffer */
  clearscreen ();

  header = tail = alloc_header (); /* Make header of list */
  if (header == NIL_LINE) {
	panic ("Cannot allocate memory", NIL_PTR);
  }
  header->text = NIL_PTR;
  header->next = tail->prev = header;
  header->syntax_marker = syntax_none;

/* load the file (if any) */
  if (fnami == 0) {
	load_file (NIL_PTR, False);
  } else {
	/* This should be applied to all file names, or better, not at all:
	if (length_of (argv [fnami]) > maxLINE_LEN) {
		argv [fnami] [maxLINE_LEN] = '\0';
	}
	*/
	load_wild_file (argv [fnami], False);
  }
  loading = True;	/* keep loading flag True until entering main loop */

  if (initlini != 0) {
     (void) scan_int (argv [initlini] + 1, & initlinenum);
     if (initlinenum > 0) {
	if (initlinenum <= 0 || (initline = proceed (header->next, initlinenum - 1)) == tail) {
	   error2 ("Invalid line number: ", dec_out ((long) initlinenum));
	} else {
	   move_to (x, find_y_w_o_RD (initline));
	   fstatus ("Read", -1L, -1L);
	}
     }
  }

  if (inisearch != NIL_PTR) {
	search_for (inisearch, FORWARD);
	fstatus ("Read", -1L, -1L);
  }

  if (cjk_term && selected_encoding != ' ') {
	error ("Non-CJK encoding not supported in CJK terminal");
  }

  if (wpipe) {
	file_name [0] = '\0'; /* don't let user believe he's editing a file */
	fstatus ("Editing for standard output", -1L, -1L);
  }
  RD ();
  flush ();
  catch_signals ((signalfunc) catch_interrupt);
  loading = False;
  trace_encoding ();

/* main loop of the editor */
  for (;;) {
	if (always_disp_fstat && stat_visible == False) {
		FSTAT ();
	} else if (always_disp_code && stat_visible == False) {
		display_the_code ();
	} else if (always_disp_Han && stat_visible == False) {
		display_Han (cur_text, False);
	}

	if (MENU && top_line_scrolled) {
		displaymenuline ();
		flags_changed = False;
		cursor_somewhere = True;
	}
	if (MENU && flags_changed) {
		displayflags ();
		cursor_somewhere = True;
	}
	if (disp_scrollbar) {
		if (display_scrollbar (update_scrollbar_lazy)) {
			cursor_somewhere = True;
		}
	}
	if (cursor_somewhere) {
		set_cursor_xy ();
	}
	flush ();	/* Flush output (if any) */

#ifdef adjust_to_actual_termsize
	input:
#endif

	inputchar = readcharacter_mapped ();

#ifdef adjust_to_actual_termsize
	if (command (inputchar) == ANSIseq) {
		ANSIseq ();
		goto input;
	}
#endif

	if (always_disp_Han) {
		clean_menus ();
	}

	if (stat_visible) {
		clear_status ();
	}
	if (quit == False) {	/* Call the function for the typed key */
		invoke_key_function (inputchar);
		if (hop_flag > 0) {
			hop_flag --;
			flags_changed = True;
		}
		if (buffer_open_flag > 0) {
			buffer_open_flag --;
#ifdef debug_ring_buffer
			if (buffer_open_flag == 0) {
				flags_changed = True;
			}
#endif
		}
	}
	if (quit) {
		if (hop_flag > 0) {
			flags_changed = True;
		}
		CANCEL ();
		quit = False;
	}
  }
  /* NOTREACHED */
}


/*======================================================================*\
|*				End					*|
\*======================================================================*/
