/***************************************************
	mined keyboard mapping table
	* generated with mkkbmap Katakana
	  from UnicodeData.txt
	* with additions from lib/kbmaps/cxterm/gb/KATAKANA.tit, 
	  fixing buggy multiple choice entries into two-character mappings
	* with additional punctuation mappings
	* with completions corresponding to Hiragana.h
*/
struct keymap keymap_Katakana [] = {
	{"~", "〜 ￣"},
	{"!", "！"},
	{"#", "＃"},
	{"$", "＄ ￥ ￦ ￡ ￠"},
	{"&", "＆"},
	{"(", "（"},
	{")", "）"},
	{",", "、"},
	{".", "。 ・ … ‥"},
	{":", "："},
	{";", "；"},
	{"<", "〈"},
	{"<<", "《"},
	{">", "〉"},
	{">>", "》"},
	{"?", "？"},
	{"@", "＠ ・"},
	{"\\", "￥"},
	{"[", "「"},
	{"{", "「 〈 《 【 『"},
	{"]", "」"},
	{"}", "」 〉 》 】 』"},
	{"%", "％"},
	{"^", "＾"},
	{"_", "＿"},
	{"«", "《"},
	{"»", "》"},
	{"-", "ー"},
	{"/", "／"},
	{"`", "｀"},
	{"*", "＊"},
	{"+", "＋"},
	{"|", "｜"},
	{"1", "１"},
	{"2", "２"},
	{"3", "３"},
	{"4", "４"},
	{"5", "５"},
	{"6", "６"},
	{"7", "７"},
	{"8", "８"},
	{"9", "９"},
	{"0", "０"},

	{"k", "ッ"},
	{"s", "ッ"},
	{"t", "ッ"},
	{"h", "ッ"},
	{"m", "ッ"},
	{"y", "ッ"},
	{"r", "ッ"},
	{"w", "ッ"},
	{"g", "ッ"},
	{"z", "ッ"},
	{"d", "ッ"},
	{"b", "ッ"},
	{"p", "ッ"},
	{"c", "ッ"},
	{"f", "ッ"},
	{"j", "ッ"},
	{"q", "ッ"},
	{"v", "ッ"},
	{"t", "ッ"},

	{"xa", "ァ"},
	{"xi", "ィ"},
	{"xu", "ゥ"},
	{"xe", "ェ"},
	{"xo", "ォ"},
	{"xtu", "ッ"},
	{"xtsu", "ッ"},
	{"xya", "ャ"},
	{"xyu", "ュ"},
	{"xyo", "ョ"},
	{"xwa", "ヮ"},
	{"xka", "ヵ"},
	{"xke", "ヶ"},
	{"xku", "ㇰ"},
	{"xsi", "ㇱ"},
	{"xsu", "ㇲ"},
	{"xto", "ㇳ"},
	{"xnu", "ㇴ"},
	{"xha", "ㇵ"},
	{"xhi", "ㇶ"},
	{"xhu", "ㇷ"},
	{"xhe", "ㇸ"},
	{"xho", "ㇹ"},
	{"xmu", "ㇺ"},
	{"xra", "ㇻ"},
	{"xri", "ㇼ"},
	{"xru", "ㇽ"},
	{"xre", "ㇾ"},
	{"xro", "ㇿ"},

	{"bya", "ビャ"},
	{"byo", "ビョ"},
	{"byu", "ビュ"},
	{"cha", "チャ"},
	{"cho", "チョ"},
	{"chu", "チュ"},
	{"gya", "ギャ"},
	{"gyo", "ギョ"},
	{"gyu", "ギュ"},
	{"hya", "ヒャ"},
	{"hyo", "ヒョ"},
	{"hyu", "ヒュ"},
	{"ja", "ジャ"},
	{"jo", "ジョ"},
	{"ju", "ジュ"},
	{"kya", "キャ"},
	{"kyo", "キョ"},
	{"kyu", "キュ"},
	{"mya", "ミャ"},
	{"myo", "ミョ"},
	{"myu", "ミュ"},
	{"nya", "ニャ"},
	{"nyo", "ニョ"},
	{"nyu", "ニュ"},
	{"oo", "オウ"},
	{"pya", "ピャ"},
	{"pyo", "ピョ"},
	{"pyu", "ピュ"},
	{"rya", "リャ"},
	{"ryo", "リョ"},
	{"ryu", "リュ"},
	{"sha", "シャ"},
	{"sho", "ショ"},
	{"shu", "シュ"},

	{"a", "ア"},
	{"i", "イ"},
	{"u", "ウ"},
	{"e", "エ"},
	{"o", "オ"},
	{"ka", "カ"},
	{"ga", "ガ"},
	{"ki", "キ"},
	{"gi", "ギ"},
	{"ku", "ク"},
	{"gu", "グ"},
	{"ke", "ケ"},
	{"ge", "ゲ"},
	{"ko", "コ"},
	{"go", "ゴ"},
	{"sa", "サ"},
	{"za", "ザ"},
	{"si", "シ"},
	{"zi", "ジ"},
	{"su", "ス"},
	{"zu", "ズ"},
	{"se", "セ"},
	{"ze", "ゼ"},
	{"so", "ソ"},
	{"zo", "ゾ"},
	{"ta", "タ"},
	{"da", "ダ"},
	{"ti", "チ"},
	{"di", "ヂ"},
	{"tu", "ツ"},
	{"du", "ヅ"},
	{"te", "テ"},
	{"de", "デ"},
	{"to", "ト"},
	{"do", "ド"},
	{"na", "ナ"},
	{"ni", "ニ"},
	{"nu", "ヌ"},
	{"ne", "ネ"},
	{"no", "ノ"},
	{"ha", "ハ"},
	{"ba", "バ"},
	{"pa", "パ"},
	{"hi", "ヒ"},
	{"bi", "ビ"},
	{"pi", "ピ"},
	{"hu", "フ"},
	{"bu", "ブ"},
	{"pu", "プ"},
	{"he", "ヘ"},
	{"be", "ベ"},
	{"pe", "ペ"},
	{"ho", "ホ"},
	{"bo", "ボ"},
	{"po", "ポ"},
	{"ma", "マ"},
	{"mi", "ミ"},
	{"mu", "ム"},
	{"me", "メ"},
	{"mo", "モ"},
	{"ya", "ヤ"},
	{"yu", "ユ"},
	{"yo", "ヨ"},
	{"ra", "ラ"},
	{"ri", "リ"},
	{"ru", "ル"},
	{"re", "レ"},
	{"ro", "ロ"},
	{"wa", "ワ"},
	{"wi", "ヰ"},
	{"we", "ヱ"},
	{"wo", "ヲ"},
	{"n", "ン"},
	{"mn", "ン"},
	{"vu", "ヴ"},
	{"va", "ヷ"},
	{"vi", "ヸ"},
	{"ve", "ヹ"},
	{"vo", "ヺ"},

	{"kyi", "キィ"},
	{"kye", "キェ"},
	{"sya", "シャ"},
	{"syi", "シィ"},
	{"syu", "シュ"},
	{"sye", "シェ"},
	{"syo", "ショ"},
	{"shi", "シ"},
	{"she", "シェ"},
	{"tsa", "ツァ"},
	{"tsi", "ツィ"},
	{"tsu", "ツ"},
	{"tse", "ツェ"},
	{"tso", "ツォ"},
	{"tha", "テャ"},
	{"thi", "ティ"},
	{"thu", "テュ"},
	{"the", "テェ"},
	{"tho", "テョ"},
	{"tya", "チャ"},
	{"tyi", "チィ"},
	{"tyu", "チュ"},
	{"tye", "チェ"},
	{"tyo", "チョ"},
	{"chi", "チ"},
	{"che", "チェ"},
	{"nyi", "ニィ"},
	{"nye", "ニェ"},
	{"hyi", "ヒィ"},
	{"hye", "ヒェ"},
	{"fa", "ファ"},
	{"fi", "フィ"},
	{"fu", "フ"},
	{"fe", "フェ"},
	{"fo", "フォ"},
	{"myi", "ミィ"},
	{"mye", "ミェ"},
	{"yi", "イ"},
	{"ye", "イェ"},
	{"la", "ラ"},
	{"li", "リ"},
	{"lu", "ル"},
	{"le", "レ"},
	{"lo", "ロ"},
	{"ryi", "リィ"},
	{"rye", "リェ"},
	{"lya", "リャ"},
	{"lyi", "リィ"},
	{"lyu", "リュ"},
	{"lye", "リェ"},
	{"lyo", "リョ"},
	{"wu", "ウ"},
	{"gyi", "ギィ"},
	{"gye", "ギェ"},
	{"zya", "ジャ"},
	{"zyi", "ジィ"},
	{"zyu", "ジュ"},
	{"zye", "ジェ"},
	{"zyo", "ジョ"},
	{"ji", "ジ"},
	{"je", "ジェ"},
	{"dha", "デャ"},
	{"dhi", "ディ"},
	{"dhu", "デュ"},
	{"dhe", "デェ"},
	{"dho", "デョ"},
	{"dya", "ヂャ"},
	{"dyi", "ヂィ"},
	{"dyu", "ヂュ"},
	{"dye", "ヂェ"},
	{"dyo", "ヂョ"},
	{"byi", "ビィ"},
	{"bye", "ビェ"},
	{"pyi", "ピィ"},
	{"pye", "ピェ"},
	{"gwa", "グヮ"},
	{"gwi", "グィ"},
	{"gwu", "グゥ"},
	{"gwe", "グェ"},
	{"gwo", "グォ"},

	{"_koto", "ヿ"},

	{NIL_PTR}
};
