/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
/*
 * $Id: medussa.h,v 1.19 2003/02/05 04:40:14 kos Exp $
 *
 */

#ifndef _MEDUSSA_H
#define _MEDUSSA_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>

#include "config.h"
#include "keyspace.h"
#include "hashpool.h"
#include "net.h"
#include "common.h"
#include "xmalloc.h"
#include "configfile.h"

#define MEDUSSA_VERSION VERSION

#define MED_LINELEN 1024
#define DEF_BINDADDR "0.0.0.0"
#define DEF_PORT "5444"
#define DEF_VERBOSE "2"
#define DEF_CONFIGCLASS "medussa"
#define DEF_CONFIGFILE "medussarc"
#define DEF_UID "nobody"
#define DEF_GID "nobody"
#define DEF_INTERACTIVE "1"
#define DEF_PIDFILE "/tmp/.medussapid"
#define DEF_CHECKPOINTFILE "/tmp/.medussastat"
#define DEF_CHECKPOINTPERIOD "10"
#define DEF_LOGMETHOD "stderr"

typedef enum {any, initial, client, admin } directive_state_t;

typedef struct medussa_t {
  /* global */
  hashpool_t *h;
  net_t *n;
  config_t *conf;
  pid_t pid;
  /* per thread */
  bstring nonce;
  bstring adminhash;
  net_conn_t *conn;
  directive_state_t state;
  pthread_t listener;
} medussa_t;

typedef int (*dfunction_t)(medussa_t *, net_conn_t *, msg *);

typedef struct directive_t {
  char name[MED_LINELEN];
  dfunction_t func;
  int minargs;
  int maxargs;
  directive_state_t state;
  char help[MED_LINELEN];
} directive_t;

int do_gimme(medussa_t *m, net_conn_t *, msg *);
int do_zilch(medussa_t *m, net_conn_t *, msg *);
int do_cancel(medussa_t *m, net_conn_t *, msg *);
int do_gotit(medussa_t *m, net_conn_t *, msg *);
int do_version(medussa_t *m, net_conn_t *, msg *);
int do_quit(medussa_t *m, net_conn_t *, msg *);
int do_motd(medussa_t *m, net_conn_t *, msg *);
int do_client(medussa_t *m, net_conn_t *, msg *);
int do_ident(medussa_t *m, net_conn_t *, msg *);
int do_help(medussa_t *m, net_conn_t *, msg *);
int do_admin(medussa_t *m, net_conn_t *, msg *);
int do_schedule(medussa_t *m, net_conn_t *, msg *);
int do_hash(medussa_t *m, net_conn_t *, msg *);
int do_pool(medussa_t *m, net_conn_t *, msg *);
int do_stats(medussa_t *m, net_conn_t *, msg *);
int do_parameter(medussa_t *m, net_conn_t *, msg *);
int do_node(medussa_t *m, net_conn_t *, msg *);
int do_fetch(medussa_t *m, net_conn_t *, msg *);

#endif /* _MEDUSSA_H */

