/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*
 * $Id: generator.h,v 1.2 2003/02/05 04:38:37 kos Exp $
 *
 */

#ifndef _GENERATOR_H
#define _GENERATOR_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gmp.h>
#include "array.h"
#include "common.h"

typedef void *(*gen_init)(char *params);
typedef int (*gen_set)(void *, key_index_t index);
typedef int (*gen_fetch)(void *, kchar *, int, int *);
typedef int (*gen_done)(void *);
typedef int (*gen_destroy)(void *);
typedef key_index_t *(*gen_minindex)(void *);
typedef key_index_t *(*gen_maxindex)(void *);
typedef key_index_t *(*gen_curindex)(void *);
typedef int (*gen_minlen)(void *);
typedef int (*gen_maxlen)(void *);

typedef struct generator_impl_t {
  char *name;
  gen_init init;
  gen_set set;
  gen_fetch fetch;
  gen_done done;
  gen_destroy destroy;
  gen_minindex minindex;
  gen_maxindex maxindex;
  gen_curindex curindex;
  gen_minlen minlen;
  gen_maxlen maxlen;
} generator_impl_t;

typedef struct generator_t {
  char name[KSP_LINELEN];
  char opts[KSP_LINELEN];
  generator_impl_t *impl;
  void *context;
} generator_t;

int generator_query(int index, char *buf, int len);
generator_t *generator_init(char *name, char *opts);
#define generator_set(x,y) ((x)->impl->set((x)->context,y))
#define generator_fetch(x,y,z,i) ((x)->impl->fetch((x)->context,y,z,i))
#define generator_done(x) ((x)->impl->done((x)->context))
#define generator_destroy(x) ((x)->impl->destroy((x)->context))
#define generator_minindex(x) ((x)->impl->minindex((x)->context))
#define generator_maxindex(x) ((x)->impl->maxindex((x)->context))
#define generator_curindex(x) ((x)->impl->curindex((x)->context))
#define generator_minlen(x) ((x)->impl->minlen((x)->context))
#define generator_maxlen(x) ((x)->impl->maxlen((x)->context))

#endif /* _GENERATOR_H */
