/*
 MeCab -- Yet Another Part-of-Speech and Morphological Analyzer

 $Id: connector.h,v 1.8 2004/08/06 18:05:14 taku-ku Exp $;

 Copyright (C) 2001-2002  Taku Kudo <taku-ku@is.aist-nara.ac.jp>
 All rights reserved.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later verjsion.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
*/
#ifndef _MECAB_CONNECTOR_H
#define _MECAB_CONNECTOR_H

#include "mmap.h"
#include "common.h"

namespace MeCab 
{
  class Connector
  {
  private:
    Mmap <unsigned short> mmmap;
    unsigned short *matrix;
    unsigned int size1;
    unsigned int size2;
    unsigned int size3;
    std::string _what;

  public:
    void clear () { /* do nothing */ };

    inline unsigned int 
       getCost (const Node *lNode2, const Node *lNode, const Node *rNode)
    {
       return matrix [size3 * (size2 * lNode2->token->rcAttr2 
			      + lNode->token->rcAttr1) + rNode->token->lcAttr] + rNode->token->cost;
    }

    bool open (Param &param)
    {
       try {
	  std::string fileName = createFileName (param.getProfileString ("dicdir"), CONNECTION_FILE);

	  if (! mmmap.open (fileName.c_str()))
	    throw std::runtime_error (mmmap.what ());

	  size1 = mmmap[0]; size2 = mmmap[1]; size3 = mmmap[2];
	  if (size1 * size2 * size3 != (mmmap.size()-3))
	    throw std::runtime_error ("file size is invalid");
	  
	  matrix = mmmap.begin () + 3;
	  return true;
       }

       catch (std::exception &e) {
	  close ();
	  _what = std::string ("Connector::open(): ") + e.what ();
	  return false;
       }
    }
     
    bool close ()
    {
       return mmmap.close();
    }

    Connector (Param &param) 
    {
       if (! open (param)) throw std::runtime_error (_what);
    }
     
    ~Connector () {};
  };
}
#endif
