# $Id: Result.pm,v 1.11 2003/06/22 16:10:20 tsuchiya Exp $
package Juman::Result;
require 5.000;
use Exporter;
use Juman::Morpheme;
use Juman::MList;
use strict;
use vars qw/ @ISA /;
@ISA = qw/ Juman::MList Exporter /;

=head1 NAME

Juman::Result - ǲϷ̥֥ in Juman

=head1 SYNOPSIS

  $result = new Juman::Result( "...\n...\nEOS\n", "^EOS$" );

=head1 DESCRIPTION

Juman ˤǲϤη̤ݻ륪֥ȡ

=head1 CONSTRUCTOR

=over 4

=item new ( RESULT, EOS_PATTERN )

Juman νϤԤñ̤ȤƳǼ줿ꥹȤФե RESULT
ȡβϷ̤ü뤿Υѥ EOS_PATTERN ȤƸƤ
ФȡηǲϷ̤ɽ֥Ȥ롥

=cut
sub new {
    my( $class, $result, $pattern ) = @_;
    my $this = {};
    bless $this, $class;

    my( $str );
    while ( defined( $str = shift @$result ) ) {
	if ( $str =~ m!$pattern! and @$result == 0 ) {
	    last;
	} elsif ( $str =~ m!\A\@ \@ \@ [^\@]! ){
	    # @פΤߤʤ̤
	    $this->push_mrph( new Juman::Morpheme( $str, scalar($this->mrph) ) );
	} elsif ( $str =~ s!\A\@ !! ) {
	    # @פƬˤƱ
	    ( $this->mrph )[-1]->push_doukei( new Juman::Morpheme( $str, scalar($this->mrph) ) );
	} else {
	    $this->push_mrph( new Juman::Morpheme( $str, scalar($this->mrph) ) );
	}
    }
    $this->set_readonly();

    $this;
}

=back

=head1 METHODS

ܥ֥Ȥϡ󥪥֥ C<Juman::MList> Ѿ褦
Ƥ롥äơ󥪥֥ȤФͭʰʲΥ
åɤѲǽǤ롥

=over 4

=item mrph

=item spec

=back

=head1 SEE ALSO

L<Juman::Morpheme>, L<Juman::MList>.

=head1 AUTHORS

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

# ߴݤĤΥ᥽å
sub all {
    my( $this ) = @_;
    $this->spec();
}

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
