#! /usr/bin/perl
#
# $Header: //sapdb/TOOLSRC/develop/sys/src/BuildPackage/WinLink.pm#2 $
# $DateTime: 2002/06/10 14:15:26 $
# $Change: 22128 $
#
# Desc:
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#

#
# A few basics right at the beginning:
my %ienv = %ENV;
close STDERR;
open STDERR, ">&STDOUT";

$| = 1; # Nur zur Sicherheit, damit das (unntige) Buffering ausgeschaltet wird.

if ($^O =~ /MSWin32/i) {
	require File::DosGlob ;
	import  File::DosGlob 'glob';
	require WinLink;
	import  WinLink;
	require Win32::TieRegistry;
	import  Win32::TieRegistry;
	require Win32::Process;
	import  Win32::Process;
	system("NET USE L: \\\\pwdfm017\\LC_POOL");
}

use testdb;

my $motd_msg = 
  "###############################################################\n"
. "# BENCHMARKS ARE RUNNING - PLEASE DO NOT WORK ON THIS MACHINE #\n"
. "#  Currently, a benchmark is running on this machine. Please  #\n"
. "#  log out and try not to create any load on this machine     #\n"
. "#  except you REALLY know what you are doing. Please refer to #\n"
. "#  the testmonitor to see the currently running benchmarks.   #\n"
. "#  If you have any more questions ask falko.flessner\@sap.com  #\n"
. "###############################################################\n";

&motd_addmsg ($motd_msg);

my @testq;

my $init_path = $ENV{'PATH'};


$ENV{'PATH'} = $init_path;
my $tst_7600 = testdb->new({'version' => '7600', 'status' => 'DEV'});

$ENV{'PATH'} = $init_path;
my $tst_7501 = testdb->new({'version' => '7501', 'status' => 'DEV'}); 

$ENV{'PATH'} = $init_path;
my $tst_7500 = testdb->new({'version' => '7500', 'status' => 'DEV'});

$ENV{'PATH'} = $init_path;
my $tst_7403 = testdb->new({'version' => '7403', 'status' => 'DEV'});

$tst_7403->preClean();
$tst_7403->installLC();
$tst_7403->installTF();

$tst_7500->preClean();
$tst_7500->installLC();
$tst_7500->installTF();

$tst_7501->preClean();
$tst_7501->installLC();
$tst_7501->installTF();

$tst_7600->preClean();
$tst_7600->installLC();
$tst_7600->installTF();

$tst_7403->run_single_test('wisconsinReferenceRun');
$tst_7500->run_single_test('wisconsinReferenceRun');
$tst_7501->run_single_test('wisconsinReferenceRun');
$tst_7600->run_single_test('wisconsinReferenceRun');

&motd_remove();

sub motd_addmsg {
	my $msg = shift;
	my $motd_path = "/etc/motd";
	if (not (defined $msg)) {
		-1;
		return;
	}
	
	open (MOFH, ">>$motd_path") or return;
	
	$msg =~ s/^/WISCONSIN: /gm;
	print MOFH $msg;
	
	close (MOFH);
	return;
}

sub motd_remove {
	my $motd_path = "/etc/motd";
	my $iobuf;
	
	open (MOFH, $motd_path) or return;
	
	while (<MOFH>) {
		if (not /^WISCONSIN: /) {
			$iobuf .= $_;
		}
	}
	
	close MOFH;
	open (MOFH, ">$motd_path") or return;
	
	print MOFH $iobuf;
	close MOFH;
}

