/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.util;

import java.io.*;
/**
 *
 */
public abstract class StructuredMem 
    implements Traceable 
{
    /**
     *
     * @return byte[]
     * @param offset int
     * @param len int
     */
    public abstract byte[]
    getBytes (
        int offset,
        int len);
    /**
     * Read a signed one byte integer from <i>offset</i>
     * @return byte
     * @param offset int
     */
    public abstract byte
    getInt1 (
        int offset);
    /**
     * Read a unsigned one byte integer from <i>offset</i>
     * @return int
     * @param offset int
     */
    public abstract int
    getUInt1 (
        int offset);
    /**
     * Read a signed two byte integer from <i>offset</i>
     * @return int
     * @param offset int
     */
    public abstract int
    getInt2 (
        int offset);
    /**
     * Read a signed four byte integer from <i>offset</i>
     * @return int
     * @param offset int
     */
    public abstract int
    getInt4 (
        int offset);
    /**
     *
     * @return com.sap.dbtech.util.StructuredMem
     * @param offset int
     */
    public abstract StructuredMem getPointer (int offset);
    /**
     *
     * @return java.lang.String
     * @param offset int
     * @param len int
     */
    public abstract String
    getString (
        int offset,
        int len);
    /**
     *
     * @return byte[]
     * @param offset int
     * @param len int
     */
    public abstract byte []
    getStrippedBytes (
        int offset,
        int len);
    /**
     *
     * @param offset int
     * @param len int
     */
    public abstract String
    getStrippedString (
        int offset,
        int len);
    /**
     * reads a bigendian unicode character from <i>offset</i>
     *
     * @param offset
     *
     * @return char
     */
    public abstract char
    getBigUnicodeChar (
        int offset);
    /**
     * converts <i>lenInBytes</i> bytes
     * into <i>lenInBytes</i> chars.
     *
     * @param offset
     *
     * @param lenInBytes
     *
     * @return char []
     */
    public abstract char []
    getBigUnicode (
        int offset,
        int lenInBytes);
    /**
     *
     * @param offset int
     */
    public abstract void moveBase (int offset);
    /**
     *
     * @param value byte[]
     * @param offset int
     */
    public abstract void
    putBytes (
        byte [] value,
        int offset);
    /**
     *
     * @param value byte[]
     * @param offset int
     * @param len int
     */
    public abstract void
    putBytes (
        byte [] value,
        int offset,
        int len);
    /**
     *
     * @param value byte[]
     * @param offset int
     * @param len int
     */
    public abstract void
    putStringBytes (
        byte [] value,
        int offset,
        int len);
    /**
     *
     * @param value byte[]
     * @param offset int
     * @param len int
     */
    public abstract void
    putUnicodeBytes (
        byte [] value,
        int offset,
        int len);
    /**
     *
     * @param value char[]
     * @param offset int
     * @param len int
     */
    public abstract void
    putBigUnicode (
        char [] value,
        int offsetInBytes,
        int lenInBytes);
    /**
     * Write a signed one byte integer at <i>offset</i>
     * @param value int
     * @param offset int
     */
    public abstract void
    putInt1 (
        int value,
        int offset);
    /**
     * Write a signed two byte inter at <i>offset</i>
     * @param value int
     * @param offset int
     */
    public abstract void
    putInt2 (
        int value,
        int offset);
    /**
     * Write a signed four byte integer at <i>offset</i>
     * @param value int
     * @param offset int
     */
    public abstract void
    putInt4 (
        int value,
        int offset);
    /**
     *
     * @param value java.lang.String
     * @param offset int
     */
    public abstract int
    putString (
        String value,
        int offset);
    /**
     *
     * @return int
     * @param value java.lang.String
     * @param offset int
     * @param len int
     */
    public abstract int
    putString (
        String value,
        int offset,
        int len);
    /**
     *
     * @return int
     */
    public abstract int size ();
    /**
     *
     * @param outstream java.io.Writer
     */
    public abstract void
    traceOn (
        PrintStream outstream);
    /**
     *
     * @param outstream Writer
     * @param from int
     * @param to int
     */
    public abstract void
    traceOn (
        PrintStream outstream,
        int maxBuf);
    /**
     *
     * @param outstream Writer
     * @param from int
     * @param to int
     */
    public abstract void
    traceOn (
        PrintStream outstream,
        int from,
        int to);
	/**
	 * @param offset
	 * @return
	 */
	public abstract long getInt8(int offset);

	/**
	 * @param lval
	 * @param offset
	 */
	public abstract void putInt8(long lval, int offset);

}
