/*!******************************************************************************

  @file         hak101.h

  ------------------------------------------------------------------------------

  @author       Dirk Thomsen

  @brief        SQLManager

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2003-2004 SAP AG
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HAK101_H
#define HAK101_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\xc7\x3e\x9a\x51\x79\x29\x07\x65\xe2\xb4\xc3\x00\x06\xa1\x4f\xc7'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"
#include "vak001.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void a101_AnalyzeErrorMessageList (
    tak_all_command_glob  VAR_VALUE_REF  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_AttachColumnBuffer (
    tgg00_VoidPtr                        pColBuffer);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_DebuggerAddRemoveBreakPoint (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tgg00_Surrogate       VAR_ARRAY_REF  procId,
    integer                              procKind,
    integer                              procType,
    integer                              pos,
    pasbool                              doRemove);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal integer a101_CreateCatalog ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_CreateErrorHandler ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool a101_DebuggerActive (
    tgg00_TransContext    VAR_VALUE_REF  transContext);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_DebuggerCheckDebugBreak (
    tgg00_TransContext    VAR_VALUE_REF  transContext,
    tgg00_SelectFieldsParam  VAR_VALUE_REF  interpreterContext,
    integer                              currStackEntry,
    tsp00_MoveObjPtr                     pVariables,
    integer                              codePos,
    integer                              codeLength);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_DebuggerCreate (
    tak_all_command_glob  VAR_VALUE_REF  debuggingAcv,
    tak_all_command_glob  VAR_VALUE_REF  debuggedAcv,
    tak_all_command_glob  VAR_VALUE_REF  listenerAcv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_DebuggerGetExecuteInfo (
    tsp00_MoveObjPtr                     pInfo,
    integer                              size);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_DebuggerGetMethodInfo (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tgg00_Surrogate       VAR_ARRAY_REF  methodId,
    integer               VAR_VALUE_REF  methodKind,
    integer               VAR_VALUE_REF  linkage,
    tsp00_MoveObjPtr      VAR_VALUE_REF  pTriggerColumns,
    tsp00_MoveObjPtr      VAR_VALUE_REF  pVariables);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_DebuggerListen (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tgg00_Surrogate       VAR_ARRAY_REF  methodId,
    integer               VAR_VALUE_REF  procKind,
    integer               VAR_VALUE_REF  linkage,
    integer               VAR_VALUE_REF  pos,
    integer               VAR_VALUE_REF  length);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_DebuggerStep (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    integer                              count);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_DebuggerStoreExecuteInfo (
    tsp00_MoveObjPtr                     pInfo,
    integer                              size);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_DetachColumnBuffer (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tgg00_VoidPtr                        pTable);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tak_sysbufferaddress a101_DescribeParseId (
    tgg00_VoidPtr                        pExecuteHandle);

/* Don't edit this file by hand, it is generated by ptocProto.py */


externPascal void a101_DestroyContextMembers (
    tak_all_command_glob  VAR_VALUE_REF  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool a101_DropParseId (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tak_parsid            VAR_VALUE_REF  parsedId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_ExecuteSqlStatement (
    tak_acv_address                      acv_addr,
    tgg00_SelectFieldsParam  VAR_VALUE_REF  sel,
    tsp00_MoveObjPtr                     retcode_addr,
    tgg00_StackList       VAR_ARRAY_REF  StackList,
    tsp00_Int4            VAR_VALUE_REF  qual_ptr,
    tgg00_BasisError      VAR_VALUE_REF  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_GetMySQLScramble (
    tsp00_C8              VAR_ARRAY_REF  scramble);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool a101_CheckMySqlPassword (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tsp00_Name            VAR_ARRAY_REF  password,
    pasbool                              isOldVersion,
    tsp00_C8              VAR_ARRAY_REF  receivedPassword);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_IncrementSyntaxTree (
    tak_all_command_glob  VAR_VALUE_REF  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_InitContextMembers (
    tak_all_command_glob  VAR_VALUE_REF  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool a101_IsStatementActive (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tsp00_Int4                           statementId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tgg00_VoidPtr a101_GetExecuteHandle (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tak_parsid            VAR_VALUE_REF  parsedId,
    pasbool                              CountExecuting);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tgg00_VoidPtr a101_GetPlanElement (
    tgg00_VoidPtr                        pExecuteHandle,
    tgg00_SysInfoKey      VAR_VALUE_REF  syskey);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tgg00_VoidPtr a101_GetPrepareHandle (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    pasbool               VAR_VALUE_REF  isPrepared,
    tak_parsid            VAR_VALUE_REF  masterParsedId,
    tgg00_VoidPtr         VAR_VALUE_REF  pSegment,
    integer               VAR_VALUE_REF  segementLength);

/* Don't edit this file by hand, it is generated by ptocProto.py */


externPascal void a101_GetStatement (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tgg00_VoidPtr                        planHandle,
    tsp00_MoveObjPtr      VAR_VALUE_REF  pStatement,
    integer               VAR_VALUE_REF  statementLength,
    tsp00_MoveObjPtr      VAR_VALUE_REF  pParamDescription,
    integer               VAR_VALUE_REF  paramDescLength,
    tsp00_SqlMode         VAR_VALUE_REF  sqlmode,
    pasbool               VAR_VALUE_REF  prepareFlag,
    pasbool               VAR_VALUE_REF  massCmdFlag);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101PacketError (
    tsp00_C50             VAR_ARRAY_REF  fmt,
    tsp00_Int4                           val1,
    tsp00_Int4                           val2,
    tsp00_Int4                           val3);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_ProcedureCall (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    integer               VAR_VALUE_REF  outParamCount);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool a101_PutParseId (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tgg00_VoidPtr                        pStatementHandle,
    tak_parsid            VAR_VALUE_REF  parseId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_GetModuleName (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tak_parsid            VAR_VALUE_REF  parseId,
    tgg00_VoidPtr         VAR_VALUE_REF  NamePtr,
    tsp00_Int4            VAR_VALUE_REF  Length);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool a101_SetExecuteStatisticData (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tak_parsid            VAR_VALUE_REF  parseId,
    tgg00_Surrogate       VAR_ARRAY_REF  CmdID,
    tsp00_Int4                           ExecuteTimeSec,
    tsp00_Int4                           ExecuteTimeMicroSec,
    tsp00_Int4                           ReadRowCount,
    tsp00_Int4                           QualifiedRowCount,
    tsp00_Int4                           VirtualReadCount,
    tsp00_Int4                           PhysicalReadCount,
    tsp00_Int4                           FetchRowCount,
    tsp00_Int4                           SuspendCount,
    tsp00_Int4                           WaitCount);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_ReleaseExecuteHandle (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tgg00_VoidPtr         VAR_VALUE_REF  planHandle);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_CleanUpAll (
    tak_all_command_glob  VAR_VALUE_REF  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_InvalidateAll (
    tak_all_command_glob  VAR_VALUE_REF  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_ResetSharedSQLStatistics (
    tak_all_command_glob  VAR_VALUE_REF  acv);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 a101_SetMaxParallelServers (
    tsp00_Int4                           max);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool a101_SharedSQL_GetStatusParameter ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_SharedSQL_SetStatusParameter (
    pasbool                              Status);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_SharedSQL_ReadStatusParameter ();

/* Don't edit this file by hand, it is generated by ptocProto.py */


externPascal void a101_SQLMan_ContextDestruct (
    tsp00_Addr            VAR_VALUE_REF  p);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool a101_StorePlan (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tak_parsid            VAR_VALUE_REF  parseId,
    pasbool                              storePlan,
    tgg00_VoidPtr                        prepareHandle);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_ReleasePrepareHandle (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tgg00_VoidPtr         VAR_VALUE_REF  prepareHandle,
    tsp00_Int4                           PrepareTimeSecs,
    tsp00_Int4                           PrepareTimeMicroSecs);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_UserDefinedFunctionCall (
    tgg00_TransContext    VAR_VALUE_REF  transContext,
    tgg00_SelectFieldsParam  VAR_VALUE_REF  interpreterContext,
    const tgg00_StackEntry  VAR_VALUE_REF  functionCode,
    const tgg00_StackEntry  VAR_VALUE_REF  functionId,
    tgg00_BasisError      VAR_VALUE_REF  error);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void a101_StoreTable (
    tak_all_command_glob  VAR_VALUE_REF  acv,
    tak_baserecord        VAR_VALUE_REF  BaseRecord);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 a101_GetMaxJoinHashTableSize ();

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

