/*!***************************************************************************

  module      : Catalog_Interface.hpp

  -------------------------------------------------------------------------

  responsible : ThomasA

  special area: Catalog 
  description : Catalog interface

  last changed: 2000-12-06  19:04
  see also    : example.html ...
  first created:2000-03-09  18:21

  -------------------------------------------------------------------------

  copyright:    (c) 2000-2004 SAP AG




    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/

#ifndef Catalog_Interface_hpp
#define Catalog_Interface_hpp

#include "RunTime/RTE_Types.hpp"

/*!
   @brief defines the interface of the catalog
 */

class Catalog_Interface
{
  public :
#if defined(KERNEL80)
    /*!
       @brief creates the catalog
     */
    virtual int Create() = 0;
#endif
    /*
       @brief requires or releases a ddl share lock. This disables DDL actions that invalidate the whole shared sql cache
    */
    virtual void DDLShareLock(bool releaseLock, RTE_TaskId pid) = 0;
    /*
       @brief requires or releases a ddl exclusive lock. This lock is required when the whole shared sql cache is invalidated
    */
    virtual void DDLExclusiveLock(bool releaseLock, RTE_TaskId pid) = 0;
    /*
      @brief returns a reference to the instance implementing the interface, see Catalog_Instance.cpp
     */
    static Catalog_Interface& GetInstance();
};

#endif