/*!******************************************************************************

  module:		 SAPDBFields_FieldList.cpp

  ------------------------------------------------------------------------------

  responsible:  Uwe H
  authors:      StefanB, TillL

  special area: Field Container classes

  description:  Definition for class SAPDBFields_FieldList.

  ------------------------------------------------------------------------------

  copyright:             (c) 1999-2004 SAP AG




    ========== licence begin  GPL
    Copyright (c) 1999-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*******************************************************************************/


// Include for memmove
#include <string.h>

#include "SAPDBCommon/Fields/SAPDBFields_FieldList.hpp"


/*******************************************************************************
    class SAPDBFields_FieldList
*******************************************************************************/

/*******************************************************************************
    public member functions
*******************************************************************************/

SAPDBFields_Field& SAPDBFields_FieldList::GetField(IndexType N, SAPDBFields_Field& Field) const
{
   const OffsetType *OffsetPtr1, *OffsetPtr2;

   SAPDBERR_ASSERT_STATE(IsAssigned());
   SAPDBERR_ASSERT_ARGUMENT(N < GetFieldCount());

   OffsetPtr1 = GetOffsetAddress(N);
   OffsetPtr2 = OffsetPtr1+1;

   Field.Assign(GetDataPtr() + *OffsetPtr1, *OffsetPtr2 - *OffsetPtr1);
   return Field;
}


SAPDBFields_Field::SizeType 
SAPDBFields_FieldList::Write(SAPDBFields_Field            &Destination,
                             SAPDBFields_Field::IndexType  Offset,
                             IndexType                     Begin,
                             IndexType                     End) const
{
/*
    +++++++++++++++
   SAPDBERR_ASSERT_ARGUMENT(Begin < GetFieldCount());
   SAPDBERR_ASSERT_ARGUMENT(End <= GetFieldCount());
   const SizeType length = *GetOffsetAddress(End) - *GetOffsetAddress(Begin);
   Destination.Assign( GetDataPtr() + *GetOffsetAddress(Begin),
                       length );
   return length;
*/
    return 0;
}


SAPDBFields_Field::SizeType
SAPDBFields_FieldList::Create(SAPDBFields_Field &Destination, SAPDBFields_IFieldSequence &Seq)
{
    /*
   OffsetType Offset;     // Write only 2 byte offsets.
   SAPDB_UInt OffsetPos;
   IndexType n, Count;

   // Determine the number of fields to write.
   Count = Seq.GetFieldCount();
   // Write all fields sequentially at the position behind the offsets.
   Offset = GetOffsetLength(Seq);
   Seq.Write(Destination, Offset, 0, Count);
   // Write all offsets at the beginning of the field list.
   OffsetPos = 0;
   for (n=0; n<Count; ++n) {
      // Write <Offset> into field list.
      *reinterpret_cast<SAPDB_UInt2 const *>(Destination.GetDataPtr()+OffsetPos) = Offset;
      // Calculate offset and offset position of next field.
      Offset += Seq.GetFieldLength(n);
      OffsetPos += sizeof(SAPDB_UInt2);
   }
   // Write last offset into field list (equal to length of field list).
   *reinterpret_cast<SAPDB_UInt2 const *>(Destination.GetDataPtr()+OffsetPos) = Offset;
   Assign(Destination.GetPointer(0, Offset), Offset);
   return static_cast<SizeType>(Offset);
   */
   return 0;
}


/*******************************************************************************
    protected member functions
*******************************************************************************/

void SAPDBFields_FieldList::Print(SAPDB_OStream& os) const
{
/* +++++++++++++++++++++++++++++++++++++++++++++++++
   SAPDBFields_Field F;
   IndexType n;

   IndexType Count = GetFieldCount();
   os << "Field list: " << static_cast<const SAPDBFields_Field>(*this) << NewLine;
   for (n=0; n<Count; ++n) {
      GetField(n, F);
      os << ToStr(n) << ": " << F << NewLine;
   }
 +++++++++++++++++++++++++++++++++++++++++++++++++*/
}


