#ifndef __OMS_CLASSHASH_HPP
#define __OMS_CLASSHASH_HPP

#include "Oms/OMS_IGuidHash.hpp"

class OMS_Context;
class OMS_ClassInfo;
class OMS_FreeListHeader;
class OMS_GuidEntry;
class OMS_DumpInterface;

class OMS_ClassHash : public OMS_IGuidHash {
public:
#define GUID_HASH_ENTRIES_CO13 49

  OMS_ClassHash();
  ~OMS_ClassHash();
  void Create(OMS_Context* context);
  void HashInsert(OMS_ClassInfo* pClassInfo, OMS_FreeListHeader* freeHead, OMS_FreeListHeader* freeHeadInVersion);
  OMS_GuidEntry *HashFind(const ClassIDRef guid);
  void Dump(OMS_DumpInterface& dumpObj) const;
private :
  OMS_Context*   m_context;
  OMS_GuidEntry* m_head[GUID_HASH_ENTRIES_CO13];
};

#endif // __OMS_CLASSHASH_HPP
