#!/usr/bin/perl
# installdoc.pl
#
# @(#)install.pl  7.5.0  2004-11-29 
#
# runs Precompiler Testfiles and differs results
# 
# Thomas Simenec
#
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

&if $OSSPEC in [ WIN32 ]
$EXEC_EXT=".exe";
&else
$EXEC_EXT="";
&endif

use Env;
$Trace=1 if ($ENV{PCTOOL_TRACE});
$Trace++ if ($Trace);
use FileHandle;
use File::Copy;

sub _changenames;
sub _mkdir;
sub _copydir;
sub _system;
sub GetOWN;

do $TOOLVARS;

if ( !defined $OWN ) {
  print "getOWN=".GetOWN."\n" if ($Trace);
  $OWN = GetOWN;
}

$PHP5_VERSION = "5.0.3";

$INSTALL_ROOT="$OWN/sys/wrk/obj/SAPDB/Interfaces/PHP";
&if $OSSPEC in [ LINUX ]
$PHPDOC_TOOLS="PHP_I386_LINUX_32_DOC_TOOLS.TGZ";
&endif
$PHPDOC_CVS="PHPDOC_CVS.TGZ";
$PHPDOC_XML="maxdb-php-xmldocu-7_5_00_$BUILDPRAEFIX.tgz";
$PHPDOC_HTML="maxdb-php-docu-7_5_00_$BUILDPRAEFIX.tgz";

chdir $INSTALL_ROOT;

if (! -f "$OWN/usr/pgm/php$PHP5_VERSION$EXEC_EXT" ) {
  print ("$OWN/usr/pgm/php$PHP5_VERSION$EXEC_EXT not found\n");
  return -1;
}

$cmd = "tar -C $OWN -xvzf $PHPDOC_TOOLS > /dev/null";
_system ($cmd);

$cmd = "tar -xvzf $PHPDOC_CVS > /dev/null";
_system ($cmd);

_mkdir ("$INSTALL_ROOT/phpdoc_cvs/en/reference/maxdb");
_mkdir ("$INSTALL_ROOT/phpdoc_cvs/en/reference/maxdb/functions");
_copydir ("$INSTALL_ROOT/phpdoc", "$INSTALL_ROOT/phpdoc_cvs/en/reference/maxdb");
_copydir ("$INSTALL_ROOT/phpdoc/functions", "$INSTALL_ROOT/phpdoc_cvs/en/reference/maxdb/functions");

chdir "$INSTALL_ROOT/phpdoc_cvs/en/reference/maxdb/functions";
_changenames ("$INSTALL_ROOT/phpdoc_cvs/en/reference/maxdb/functions");

chdir "$INSTALL_ROOT/phpdoc_cvs/en/reference";

$cmd = "tar -cvzf $PHPDOC_XML maxdb/* > /dev/null";
_system ($cmd);

if (! -f "$OWN/sys/wrk/fast/install") {
  _mkdir ("$OWN/sys/wrk/fast/install");
}

move ("$INSTALL_ROOT/phpdoc_cvs/en/reference/$PHPDOC_XML",
      "$OWN/sys/wrk/fast/install/$PHPDOC_XML");

chdir "$INSTALL_ROOT/phpdoc_cvs";

$cmd = "autoconf";
_system ($cmd);

$cmd = "d2u$TOOLEXT $INSTALL_ROOT/phpdoc_cvs/configure";
_system ($cmd);

chmod 0775, 'configure';

$cmd = "$INSTALL_ROOT/phpdoc_cvs/configure --with-php=$OWN/usr/pgm/php$PHP5_VERSION$EXEC_EXT --with-jade=$OWN/usr/bin/jade$EXEC_EXT";
$cmd .= " --with-nsgmls=$OWN/usr/bin/nsgmls$EXEC_EXT --with-lang=en";
_system ($cmd);

$cmd = "make html";
_system ($cmd);

$cmd = "tar -cvzf $PHPDOC_HTML html/*maxdb*";
_system ($cmd);

move ("$INSTALL_ROOT/phpdoc_cvs/$PHPDOC_HTML",
      "$OWN/sys/wrk/fast/install/$PHPDOC_HTML");

sub _changenames {
  opendir(DIR, $_[0]) || die "can't opendir: $!";
  @files = readdir(DIR);
  closedir(DIR);
  foreach $i (@files) {
    rename $i, join ('-', split (/_/, $i));
  }
}

sub _mkdir
{
  if (! -d $_[0] ) {
    print "_mkdir $_[0]" if ( $Trace );
&if $OSSPEC in [ WIN32 ]	
      mkdir ($_[0], 0);
&else
      mkdir ($_[0], 0775);
&endif
  }
}

sub _copydir
{
  opendir(DIR, $_[0]) || die "can't opendir $!";
  @files = readdir(DIR);
  closedir(DIR);
  
  foreach $i (@files) {
    copy ("$_[0]/$i", "$_[1]/$i");
  }
}

sub _system
{
  print "$_[0]\n";
  return system($_[0]);
}

sub GetOWN
{
  if ( defined $ENV{OWN} ) {
    return ("$ENV{OWN}");
  }
  else {
    if ( defined $ENV{TEST_ROOT} ) {
      return ("$ENV{TEST_ROOT}/..");
    }
    else {
      if ( defined $ENV{JTEST_ROOT} ) {
        return ("$ENV{JTEST_ROOT}/../..");
      }
    }
  }
  return (".");
}
