#!/usr/bin/perl
# install.pl
#
# @(#)install.pl  7.5.0  2004-11-23 
#
# runs Precompiler Testfiles and differs results
# 
# Thomas Simenec
#
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

&if $OSSPEC in [ WIN32 ]
$EXEC_EXT=".exe";
&else
$EXEC_EXT="";
&endif

use Env;
$Trace=1 if ($ENV{PCTOOL_TRACE});
$Trace++ if ($Trace);
use FileHandle;
use File::Copy;

sub _mkdir;
sub _copydir;
sub _system;
sub GetOWN;

do $TOOLVARS;

if ( !defined $OWN ) {
  print "getOWN=".GetOWN."\n" if ($Trace);
  $OWN = GetOWN;
}

$PHP5_VERSION = "5.0.3";

$INSTALL_ROOT="$OWN/sys/wrk/obj/SAPDB/Interfaces/PHP";
$PHP_ARCH="maxdb-php-source-7_5_00_$BUILDPRAEFIX.tgz";
$PHP_WIN32_ARCH="maxdb-php5-win-32bit-7_5_00_$BUILDPRAEFIX.tgz";

foreach $i (@ARGV) {
  if ($i =~ /.*-debug*/ ) {
    $DEBUG="YES";
  }
}

chdir $INSTALL_ROOT;

$cmd = "tar -cvpzf $PHP_ARCH ext";
_system ($cmd);

if (! -f "$WRK/fast/install") {
  _mkdir ("$WRK/fast/install");
}

move ("$PHP_ARCH", "$WRK/fast/install/$PHP_ARCH");

&if $OSSPEC in [ WIN32 ]
$cmd = "tar -xvzf php_$PHP5_VERSION.tar.gz > NUL";
&else
$cmd = "tar -xvzf php_$PHP5_VERSION.tar.gz > /dev/null";
&endif
_system ($cmd);

&if $OSSPEC in [ WIN32 ]
$cmd = "tar -xvzf PHP_WIN32_BUILD_TOOLS.tar.gz > NUL";
_system ($cmd);
&endif

chdir $INSTALL_ROOT."/ext";

_mkdir ("$INSTALL_ROOT/php-$PHP5_VERSION/ext/maxdb");
_mkdir ("$INSTALL_ROOT/php-$PHP5_VERSION/ext/maxdb/tests");

_copydir ("$INSTALL_ROOT/ext/maxdb", "$INSTALL_ROOT/php-$PHP5_VERSION/ext/maxdb");
_copydir ("$INSTALL_ROOT/ext/maxdb/tests", "$INSTALL_ROOT/php-$PHP5_VERSION/ext/maxdb/tests");

chdir $INSTALL_ROOT."/php-$PHP5_VERSION";

&if $OSSPEC in [ WIN32 ]
$cmd = "$INSTALL_ROOT/php-$PHP5_VERSION/buildconf";
_system ($cmd);
$cmd = "cscript /nologo $INSTALL_ROOT/php-$PHP5_VERSION/configure.js --enable-prefix=$INSTROOT\\pgm";
$cmd .= " --with-maxdb=shared,$INSTROOT --disable-cgi --without-libxml --without-dom --without-wddx";
$cmd .= " --without-xml --with-config-file-scan-dir=$INSTROOT\\lib";
if (defined $DEBUG && $DEBUG eq "YES") {
  $cmd .= " --enable-debug";
}
_system ($cmd);
&else
if (-f "$INSTALL_ROOT/php-$PHP5_VERSION/configure") {
  unlink "$INSTALL_ROOT/php-$PHP5_VERSION/configure";
}
$cmd = "$INSTALL_ROOT/php-$PHP5_VERSION/buildconf --force";
_system ($cmd);
$cmd = "$INSTALL_ROOT/php-$PHP5_VERSION/configure --prefix=$INSTROOT --bindir=$INSTROOT/pgm";
$cmd .= " --with-maxdb=$INSTROOT --disable-cgi --disable-libxml --with-config-file-path=$INSTROOT/lib";
if (defined $DEBUG && $DEBUG eq "YES") {
  $cmd .= " --enable-debug";
}
_system ($cmd);
&endif

&if $OSSPEC in [ WIN32 ]
  $cmd = "nmake install";
  _system ($cmd);
&else
  $cmd = "make install";
  _system ($cmd);
&endif

if (! -f "$INSTROOT/lib/php.ini") {
  copy ("$INSTALL_ROOT/php-$PHP5_VERSION/php.ini-recommended", "$INSTROOT/lib/php.ini");
}

if (-f "$INSTROOT/pgm/php$PHP5_VERSION$EXEC_EXT") {
  unlink "$INSTROOT/pgm/php$PHP5_VERSION$EXEC_EXT";
}

rename "$INSTROOT/pgm/php$EXEC_EXT","$INSTROOT/pgm/php$PHP5_VERSION$EXEC_EXT";

&if $OSSPEC in [ WIN32 ]
if (-f "$INSTROOT/pgm/php_maxdb.dll") {
  rename "$INSTROOT/pgm/php_maxdb.dll","$INSTROOT/pgm/php_maxdb$PHP5_VERSION.dll";
}
&endif

&if $OSSPEC in [ WIN32 ]
  if (defined $DEBUG && $DEBUG eq "YES") {
    chdir $INSTALL_ROOT."/php-$PHP5_VERSION/Debug_TS";
  } else {
    chdir $INSTALL_ROOT."/php-$PHP5_VERSION/Release_TS";
  }
  if (-f "$PHP_WIN32_ARCH") {
    unlink "$PP_WIN32_ARCH";
  }
  $cmd = "touch PHP-$PHP5_VERSION";
  _system ($cmd);
  $cmd = "tar -cvpzf $PHP_WIN32_ARCH php_maxdb.dll PHP-$PHP5_VERSION";
  _system ($cmd);
  move ("$PHP_WIN32_ARCH", "$WRK/fast/install/$PHP_WIN32_ARCH");
&endif

sub _mkdir
{
  if (! -d $_[0] ) {
    print "_mkdir $_[0]" if ( $Trace );
&if $OSSPEC in [ WIN32 ]	
      mkdir ($_[0], 0);
&else
      mkdir ($_[0], 0775);
&endif
  }
}

sub _copydir
{
  opendir(DIR, $_[0]) || die "can't opendir $!";
  @files = readdir(DIR);
  closedir(DIR);
  
  foreach $i (@files) {
    copy ("$_[0]/$i", "$_[1]/$i");
  }
}

sub _system
{
  print "$_[0]\n";
  return system($_[0]);
}

sub GetOWN
{
  if ( defined $ENV{OWN} ) {
    return ("$ENV{OWN}");
  }
  else {
    if ( defined $ENV{TEST_ROOT} ) {
      return ("$ENV{TEST_ROOT}/..");
    }
    else {
      if ( defined $ENV{JTEST_ROOT} ) {
        return ("$ENV{JTEST_ROOT}/../..");
      }
    }
  }
  return (".");
}

