--TEST--
maxdb_fetch_object with classes
--FILE--
<?php
	include "connect.inc";
	
	class test_class {
		function __construct($arg1, $arg2) {
			echo __METHOD__ . "($arg1,$arg2)\n";
		}
	}
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE test_fetch");
        maxdb_report (MAXDB_REPORT_ERROR);
  	maxdb_query($link,"CREATE TABLE test_fetch(c1 smallint,
                                                     c2 smallint,
                                                     c3 smallint,
                                                     c4 smallint,
                                                     c5 smallint,
                                                     c6 smallint,
                                                     c7 smallint)");

	maxdb_query($link, "INSERT INTO test_fetch VALUES ( -23, 3599, NULL, -500, -999, -0, 0)"); 

	$result = maxdb_query($link, "SELECT * FROM test_fetch");
	$test = maxdb_fetch_object($result);
	maxdb_free_result($result);

	var_dump($test);

	maxdb_close($link);
	
	echo "Done\n";
?>
--EXPECTF--
%s
  ["C1"]=>
  int(-23)
  ["C2"]=>
  int(3599)
  ["C3"]=>
  NULL
  ["C4"]=>
  int(-500)
  ["C5"]=>
  int(-999)
  ["C6"]=>
  int(0)
  ["C7"]=>
  int(0)
}
Done

