/*!
  \file    DBMSrvCmd_BackupHistory.hpp
  \author  TiloH
  \ingroup DBMServer commands
  \brief   declaration of classes handling DBMServer
           backup history commands

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (C) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif
*/

#if !defined(DBMSrvCmd_BackupHistory_hpp)
#define DBMSrvCmd_BackupHistory_hpp


//-----------------------------------------------------------------------------
// classes
//-----------------------------------------------------------------------------

/*! \brief A class for handling the DBMServer command backup_history_open
    
    The runCommand (re)creates the global backup history session object,
    reads the backup history files and stores the data into the new global
    backup history session object */
class DBMSrvCmd_BackupHistoryOpen
{
  public:
    //! a static string containing the explain information for the backup_history_open command
    static const char * longHelp;
};


/*! \brief A class for handling the DBMServer command backup_history_list
    
    The runCommand lists the first lines of the backup history from the
    global backup history session, that fit into the reply buffer */
class DBMSrvCmd_BackupHistoryList
{
  public:
    //! a static string containing the explain information for the backup_history_list command
    static const char * longHelp;
};


/*! \brief A class for handling the DBMServer command backup_history_listnext
    
    The runCommand lists the next lines of the backup history from the
    global backup history session, that fit into the new reply buffer */
class DBMSrvCmd_BackupHistoryListNext
{
  public:
    //! a static string containing the explain information for the backup_history_listnext command
    static const char * longHelp;
};


/*! \brief A class for handling the DBMServer command backup_history_close
    
    The runCommand deletes the global backup history session */
class DBMSrvCmd_BackupHistoryClose
{
  public:
    //! a static string containing the explain information for the backup_history_close command
    static const char * longHelp;
};


/*! \brief A class for handling the DBMServer command backup_history_date
    
    The runCommand writes the date of the backup history file (dbm.knl) into the reply */
class DBMSrvCmd_BackupHistoryDate
{
  public:
    //! a static string containing the explain information for the backup_history_date command
    static const char * longHelp;
};

#endif
