/*!
  \file     DBMP2F_Null.cpp
  \author   TiloH
  \ingroup  pipe2file
  \brief    class implementing a null device
  
  \if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------

#include "SAPDB/DBM/Pipe2File/DBMP2F_Null.hpp"


// -----------------------------------------------------------------------------
// member functions DBMP2F_Null
// -----------------------------------------------------------------------------

DBMP2F_Null::DBMP2F_Null(DBMP2F_DeviceDirection::DeviceDirection TheDirection)
:DBMP2F_Device(TheDirection)
{
}

int DBMP2F_Null::Open()
{
    return 1;
}

int DBMP2F_Null::TransferData(DBMP2F_TransferBuffer & Buffer,
                              unsigned int            BytesToTransfer,
                              unsigned int          & BytesTransfered)
{
    BytesTransfered=BytesToTransfer;
    ChangeUsedBufferSpace(Buffer, BytesTransfered);

    return 1;
}

int DBMP2F_Null::Close()
{
    return 1;
}

int DBMP2F_Null::IsGood()
{
    return 1;   //what could be wrong with a NULL device?
}
