/*!
  -----------------------------------------------------------------------------
  module: vcn10.cpp
  -----------------------------------------------------------------------------

  responsible:  BerndV

  special area: DBMServer

  description:  "main" file for DBMServer

                implementing ctrlservopen()
                             ctrlservclose()
                             ctrlservcommand()

  copyright:    (c) 2000-2004 SAP AG-2004

  -----------------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



  -----------------------------------------------------------------------------
*/

/*
  -----------------------------------------------------------------------------
  includes
  -----------------------------------------------------------------------------
*/
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "vsp001.h"
#include "vsp009c.h"

#include "hsp100.h"
#include "heo02.h"
#include "heo06.h"

#include "hcn10.h"
#include "hcn20.h"
#include "hcn30.h"
#include "hcn31.h"
#include "hcn32.h"
#include "hcn40.h"
#include "hcn41.h"
#include "hcn42.h"
#include "hcn43.h"
#include "hcn45.h"
#include "hcn46.h"
#include "hcn50.h"
#include "hcn51.h"
#include "hcn80.h"
#include "hcn81.h"
#include "hcn82.h"
#include "hcn83.h"
#include "hcn84.h"
#include "hcn85.h"
#include "hcn90.h"

#include "DBM/Srv/HSS/DBMSrvHSS_Nodes.hpp"
#ifndef _WIN32
  #include "RunTime/RTE_UNIXAuthenticate.hpp" // nocheck
#endif

#include "SAPDB/DBM/Srv/BackupHistory/DBMSrvBHist_RestorePlanner.hpp"

#include "SAPDB/DBM/Srv/Commands/BackupHistory/DBMSrvCmdBHist_BackupHistoryAppend.hpp"
#include "SAPDB/DBM/Srv/Commands/DBMSrvCmd_BackupHistory.hpp"
#include "SAPDB/DBM/Srv/Commands/DBMSrvCmd_DbmVersion.hpp"
#include "SAPDB/DBM/Srv/Commands/DBMSrvCmd_DbmExecuteServerprocess.hpp"
#include "SAPDB/DBM/Srv/Commands/DBMSrvCmd_Explain.hpp"
#include "SAPDB/DBM/Srv/Commands/DBMSrvCmd_Help.hpp"
#include "SAPDB/DBM/Srv/Commands/DBMSrvCmd_HssCopyFile.hpp"
#include "SAPDB/DBM/Srv/Commands/DBMSrvCmd_InstInfo.hpp"
#include "SAPDB/DBM/Srv/Commands/Medium/DBMSrvCmdMedium_MediumDelete.hpp"
#include "SAPDB/DBM/Srv/Commands/Medium/DBMSrvCmdMedium_MediumDeleteNoDistribute.hpp"
#include "SAPDB/DBM/Srv/Commands/Medium/DBMSrvCmdMedium_MediumPut.hpp"
#include "SAPDB/DBM/Srv/Commands/Medium/DBMSrvCmdMedium_MediumPutNoDistribute.hpp"
#include "SAPDB/DBM/Srv/Commands/SQL/DBMSrvCmdSQL_SqlUpdatestatPerSystemtable.hpp"

/*!
  -----------------------------------------------------------------------------
  Chapter: Private types
  -----------------------------------------------------------------------------
 */

/*! Declaration: DBMServer command structure */
typedef struct DBMServerCommand {
  const char               * name;
  bool                       bNeedDBMLogon;
  bool                       bNeedSAPDBAdmi;
  bool                       bStaticAvailable;
  tsp00_Int2                 nDBNameState;
  tsp00_Int2                 nMinParam;
  tsp00_Int2                 nMaxParam;
  tsp00_Int2                 nTokens2Log;
  cnFunctionPrototype_CN00 * cnFunction;
  const char              *  shortHelp;
  bool                       bHSS;
  tsp00_Uint4                nRights;
} DBMServerCommand;
/*! EndDeclaration: DBMServer command structure */

/*! Declaration: DBMServer  obsolete command structure */
typedef struct DBMServerObsoleteCommand {
  const char               * pOldName;
  const char               * pNewName;
} DBMServerObsoleteCommand;
/*! EndDeclaration: DBMServer obsolete command structure */

/*!
  -----------------------------------------------------------------------------
  EndChapter: Private types
  -----------------------------------------------------------------------------
 */

/*!
  -----------------------------------------------------------------------------
  Chapter: Private macros
  -----------------------------------------------------------------------------
 */

/*! Declaration: DBMServer command protocol values */
#define CMD_PROT_NO            (-1)
#define CMD_PROT_ALL           (-2)
#define CMD_PROT_NOERR         (-3)
#define CMD_PROT_YES           (0)
/*! EndDeclaration: DBMServer command protocol values */

/*! Declaration: DBName  values */
#define DBNAME_YES      1
#define DBNAME_NO       2
#define DBNAME_EGAL     3
/*! EndDeclaration: DBMServer command protocol values */

#ifndef DBROOT_ENV_VAR
  #define DBROOT_ENV_VAR         "DBROOT"
#endif

const int CommandT::InvalidIndex = -1;

/*!
  -----------------------------------------------------------------------------
  EndChapter: Private macros
  -----------------------------------------------------------------------------
 */

/*!
  -----------------------------------------------------------------------------
  Chapter: Private functions
  -----------------------------------------------------------------------------
 */

/*!
  -------------------------------------------------------------------------
  function:     cn10_AnalyzeCommand
  -------------------------------------------------------------------------
  description:  DBMServer command analyzer

                This function searches in an array for the properties
                of the specified DBMServer command.

  arguments:    szData     [INOUT] - buffer with the command and parameters
                nDataLen   [IN]    - the name of the database
                DBMCommand [INOUT] - structur for the analyzed command

  -------------------------------------------------------------------------
*/
static void cn10_AnalyzeCommand
      ( const char  * szData,
        const int      nDataLen,
        CommandT     & DBMCommand );

/*!
  -------------------------------------------------------------------------
  function:     cn10_HSSExecute
  -------------------------------------------------------------------------
  description:  Hot Standby Execute

                Here will be executed the hss_execute

  arguments:    vcontrol    [INOUT]  - DBMServer session data
                command     [IN]     - DBMServer command
                replyData   [OUT]    - reply buffer
                replyLen    [OUT]    - lenght of reply
                replyLenMax [IN]     - max. length of reply buffer

  return value: error code specified in gcn00c.h

  -------------------------------------------------------------------------
*/
static tcn00_Error cn10_HSSExecute (
    VControlDataT * vcontrol,
    CommandT      * command,
    char          * replyData,
    int           * replyLen,
    int             replyLenMax);


/*!
  -------------------------------------------------------------------------
  function:     cn10_dbmRelease
  -------------------------------------------------------------------------
  description:  Release

                Here will be executed the release command.

  arguments:    vcontrol    [INOUT]  - DBMServer session data
                command     [IN]     - DBMServer command
                replyData   [OUT]    - reply buffer
                replyLen    [OUT]    - lenght of reply
                replyLenMax [IN]     - max. length of reply buffer

  return value: error code specified in gcn00c.h

  -------------------------------------------------------------------------
*/
static tcn00_Error cn10_dbmRelease (
    VControlDataT * vcontrol,
    CommandT      * command,
    char          * replyData,
    int           * replyLen,
    int             replyLenMax);

/*!
  -------------------------------------------------------------------------
  function:     cn10_LogCommand
  -------------------------------------------------------------------------
  description:  Command log

                This functions logs the specified command.

  arguments:    command     [IN]     - DBMServer command

  -------------------------------------------------------------------------
*/
static void cn10_LogCommand (
    CommandT      * command );

/*!
  -------------------------------------------------------------------------
  function:     cn10_LogError
  -------------------------------------------------------------------------
  description:  Error log

                This functions logs the specified error text.

  arguments:    szError     [IN]     - error text
                nCmdRc      [IN]     - numeric error code

  -------------------------------------------------------------------------
*/
static void cn10_LogError (
      const char       * szError,
      const tcn00_Error   nCmdRc );

/*!
  -----------------------------------------------------------------------------
  EndChapter: Private functions
  -----------------------------------------------------------------------------
 */
static DBMServerObsoleteCommand obsoletesC[] = {
  {"autosave_on"       , "autolog_on"},
  {NULL                , NULL        }
};

static cn10DBMServerCommand namesC[] = {
#ifndef STARTSTOP
// name                        Logon Sys    DBNameState       Min  Max  Protocol
//                             Function
//                             Short Help
//                             Long Help
//                             HSS    DBMRights
{"archive_stage"              ,true , false, false, DBNAME_YES ,   2,   6, CMD_PROT_ALL
                              ,cn31BackupStage
                              ,"<medium> <stage> [verify|noverify] [remove|keep]\n                         [FileNumberList <list>]"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"archive_stage_repeat"       ,true , false, false, DBNAME_YES ,   1,   3, CMD_PROT_ALL
                              ,cn31BackupStageRepeat
                              ,"<medium> [verify|noverify] [remove|keep]"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"autolog_cancel"             ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_YES
                              ,cn31AutosaveCancel
                              ,"                              (needs util session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"autosave_cancel"            ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_YES
                              ,cn31AutosaveCancel
 /*** obsolete ***/           ,"(obsolete version of autolog_cancel)              "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"autolog_off"                ,true , false, false, DBNAME_YES ,   0 ,   0, CMD_PROT_YES
                              ,cn31AutosaveEnd
                              ,"                              (needs util session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"autosave_off"               ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_YES
                              ,cn31AutosaveEnd
 /*** obsolete ***/           ,"(obsolete version of autolog_off)                 "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"autolog_on"                 ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_YES
                              ,cn31AutosaveOn
                              ,"[<medium>]                    (needs util session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"autosave_on"                ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_YES
                              ,cn31AutosaveOn
 /*** obsolete ***/           ,"(obsolete version of autolog_on)                  "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"autolog_show"               ,true , false, false, DBNAME_YES ,   0 ,   0, CMD_PROT_NO
                              ,cn31AutosaveShow
                              ,"                              (needs util session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{"autorecover"                ,true , false, false, DBNAME_YES ,   0,   8, CMD_PROT_ALL
                              ,DBMSrvBHist_RestorePlanner::AutomaticRecovery
                              ,"[LOG] [UNTIL <date> <time>] [IBID <int_backup_ID>]\n"
                               "                                                       (needs util session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"autosave_show"              ,true , false, false, DBNAME_YES ,   0 ,   0, CMD_PROT_NO
                              ,cn31AutosaveShow
 /*** obsolete ***/           ,"(obsolete version of autolog_show)                "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{""                           ,true , false, false, DBNAME_EGAL ,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,false, DBMMaskNothing_CN50 },
{"backup_cancel"              ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupSaveCancel
                              ,"                            (needs backup session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_save_cancel"         ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupSaveCancel
 /*** obsolete ***/           ,"(obsolete version of autolog_on)                  "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_cancel_req"          ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupSaveCancelRequest
                              ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_save_cancel_req"     ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupSaveCancelRequest
 /*** obsolete ***/           ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_command"             ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_ALL
                              ,cn31BackupCommand
                              ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_command_req"         ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_ALL
                              ,cn31BackupCommandRequest
                              ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_ext_ids_forget"      ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn32ForgetEBIDs
                              ,"                                                  "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{"backup_ext_ids_get"         ,true , false, false, DBNAME_YES ,   1,   3, CMD_PROT_ALL
                              ,cn32GetEBIDs
                              ,0
                              ,LongHelp_GetEBIDS_cn32
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{"backup_ext_ids_list"        ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn32ListNextEBIDs
                              ,"                                                  "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{"backup_ext_ids_listnext"    ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn32ListNextEBIDs
                              ,"                                                  "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },

{"backup_history_append"      ,true , false, false, DBNAME_YES ,   1,   256, CMD_PROT_ALL
                              ,DBMSrvCmdBHist_BackupHistoryAppend::runCommand
                              ,0 //hidden command
                              ,0 //hidden command
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },

{"backup_history_close"       ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn32BackupHistoryClose
                              ,0
                              ,DBMSrvCmd_BackupHistoryClose::longHelp
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{"backup_history_date"        ,true , false, false, DBNAME_YES ,   0,   0,CMD_PROT_NO
                              ,cn32BackupHistoryDate
                              ,0
                              ,DBMSrvCmd_BackupHistoryDate::longHelp
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{"backup_history_list"        ,true , false, false, DBNAME_YES ,   0,  10,CMD_PROT_NO
                              ,cn32BackupHistoryList
                              ,"[-c <col,col,...>] [-k <key>] [-l <label>]\n                         [-a <action>] [-r <restore_flag>] [-m] [-e]\n                         [-Inverted]"
                              ,DBMSrvCmd_BackupHistoryList::longHelp
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{"backup_history_listnext"    ,true , false, false, DBNAME_YES ,   0,   0,CMD_PROT_NO
                              ,cn32BackupHistoryListNext
                              ,"                                                  "
                              ,DBMSrvCmd_BackupHistoryListNext::longHelp
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{"backup_history_open"        ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_NO
                              ,cn32BackupHistoryOpen
                              ,"[-e]                                              "
                              ,DBMSrvCmd_BackupHistoryOpen::longHelp
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{"backup_ignore"              ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupSaveIgnore
                              ,"                            (needs backup session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_save_ignore"         ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupSaveIgnore
 /*** obsolete ***/           ,"(obsolete version of backup_ignore)               "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_ignore_req"          ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupSaveIgnoreRequest
                              ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_save_ignore_req"     ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupSaveIgnoreRequest
 /*** obsolete ***/           ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_replace"             ,true , false, false, DBNAME_YES ,   1,   2, CMD_PROT_ALL
                              ,cn31BackupSaveReplace
                              ,"<medium> [<loc>]            (needs backup session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_save_replace"        ,true , false, false, DBNAME_YES ,   1,   2, CMD_PROT_ALL
                              ,cn31BackupSaveReplace
 /*** obsolete ***/           ,"(obsolete version of backup_replace)              "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_replace_req"         ,true , false, false, DBNAME_YES ,   1,   2, CMD_PROT_ALL
                              ,cn31BackupSaveReplaceRequest
                              ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_save_replace_req"    ,true , false, false, DBNAME_YES ,   1,   2, CMD_PROT_ALL
                              ,cn31BackupSaveReplaceRequest
 /*** obsolete ***/           ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_reply_available"     ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn31BackupReplyAvailable
                              ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_reply_receive"       ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupReplyReceive
                              ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_req"                 ,true , false, false, DBNAME_YES ,   1,   3, CMD_PROT_ALL
                              ,cn31BackupSaveRequest
                              ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_save_req"            ,true , false, false, DBNAME_YES ,   1,   3, CMD_PROT_ALL
                              ,cn31BackupSaveRequest
 /*** obsolete ***/           ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_stage"               ,true , false, false, DBNAME_YES ,   2,   6, CMD_PROT_ALL
                              ,cn31BackupStage
                              ,"(obsolete version of archive_stage)     "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_stage_repeat"        ,true , false, false, DBNAME_YES ,   1,   3, CMD_PROT_ALL
                              ,cn31BackupStageRepeat
                              ,"(obsolete version of archive_stage_repeat)     "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_start"               ,true , false, false, DBNAME_YES ,   1,   4, CMD_PROT_ALL
                              ,cn31BackupSave
                              ,"<medium> [RECOVERY|MIGRATION] [DATA|PAGES|LOG]    \n                         [AUTOIGNORE]                  (needs util session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_save"                ,true , false, false, DBNAME_YES ,   1,   4, CMD_PROT_ALL
                              ,cn31BackupSave
 /*** obsolete ***/           ,"(obsolete version of backup_start)                "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_state"               ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn31BackupSaveState
                              ,"                            (needs backup session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_save_state"          ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn31BackupSaveState
 /*** obsolete ***/           ,"(obsolete version of backup_state)                "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"bye"                        ,false, false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,cn10_dbmRelease
                              ,NULL
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{""                           ,true , false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"crash"                      ,false, false, false, DBNAME_EGAL,   0,  -1, CMD_PROT_NO
                              ,cn40Crash
                              ,NULL
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"db_activate"                ,true , false, false, DBNAME_YES ,   0,   9, CMD_PROT_YES
                              ,cn80DBActivate
                              ,"<sysdba>,<pwd> | RECOVER <recoveroptions>         "
                              ,0
                              ,true , DBMRightAccessUtility_CN50 },
{"db_activate_req"            ,true , false, false, DBNAME_YES ,   0,   9, CMD_PROT_YES
                              ,cn80DBActivateRequest
                              ,NULL
                              ,0
                              ,true , DBMRightAccessUtility_CN50 },
{"db_addvolume"               ,true , false, false, DBNAME_YES ,   4,   6, CMD_PROT_ALL
                              ,cn40DbAddDevice
                              ,"<mod> <nam> <typ> <siz> <mnam> <mtyp>             "
                              ,0
                              ,true , DBMRightAccessUtility_CN50 | DBMRightParamFull_CN50},
{"db_adddevspace"             ,true , false, false, DBNAME_YES ,   4,   6, CMD_PROT_ALL
                              ,cn40DbAddDevice
 /*** obsolete ***/           ,"(obsolete version of db_addvolume)                "
                              ,0
                              ,true , DBMRightAccessUtility_CN50 | DBMRightParamFull_CN50},
{"db_adddevice"               ,true , false, false, DBNAME_YES ,   4,   6, CMD_PROT_ALL
                              ,cn40DbAddDevice
 /*** obsolete ***/           ,"(obsolete version of db_addvolume)                "
                              ,0
                              ,true , DBMRightAccessUtility_CN50 | DBMRightParamFull_CN50},
{"db_clear"                   ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn40DBClear
                              ,"                                    (needs dbname)"
                              ,0
                              ,true , DBMRightDBStop_CN50 },
{"db_admin"                   ,true , false, false, DBNAME_YES ,   0,   2, CMD_PROT_ALL
                              ,cn40DBCold
                              ,"[-immediate|-fast|-quick|-slow]     (needs dbname)"
                              ,0
                              ,true , DBMRightDBStop_CN50 },
{"db_cold"                    ,true , false, false, DBNAME_YES ,   0,   2, CMD_PROT_ALL
                              ,cn40DBCold
/*** obsolete ***/            ,"(obsolete version of db_admin)                    "
                              ,0
                              ,true , DBMRightDBStop_CN50 },
{"dbcold"                     ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_ALL
                              ,cn40DBCold
 /*** obsolete ***/           ,"(obsolete version of db_admin)                    "
                              ,0
                              ,true , DBMRightDBStop_CN50 },
{"db_cons"                    ,true , false, false, DBNAME_YES ,   1,  -1, CMD_PROT_NO
                              ,cn40DBConsole
                              ,"<console command>                                 "
                              ,0
                              ,true , DBMRightDBStop_CN50 },
{"db_connect"                 ,true , false, false, DBNAME_YES ,   0,   2, CMD_PROT_NO
                              ,cn85DBConnect
                              ,"[<user>,<password>]                 (needs dbname)"
                              ,0
                              ,true , DBMRightAccessSQL_CN50 | DBMRightAccessUtility_CN50 | DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50},
{"db_create"                  ,false, false, false, DBNAME_NO  ,   2,   7, 1
                              ,cn40DBCreate
                              ,"[-a] [-u] [-g <supportgroup>] <dbname> <usr>,<pwd>\n                         [<osusr>,<pwd>]"
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"db_drop"                    ,true , false, true , DBNAME_YES ,   0,   1, CMD_PROT_NO
                              ,cn40DBDrop
                              ,"[WITHOUTFILES]                      (needs dbname)"
                              ,0
                              ,true , DBMRightInstallMgm_CN50 },
{"db_enum"                    ,false, false, false, DBNAME_EGAL,   0,   1, CMD_PROT_NO
                              ,cn40DBEnum
                              ,"[-s]                                              "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"enum_dbs"                   ,false, false, false, DBNAME_EGAL,   0,   1, CMD_PROT_NO
                              ,cn40DBEnum
 /*** obsolete ***/           ,"(obsolete version of db_enum)                     "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"db_execute"                 ,true , false, false, DBNAME_YES ,   0,  -1, 2
                              ,cn85DBExecute
                              ,"<statement>                                       "
                              ,0
                              ,true , DBMRightAccessSQL_CN50 | DBMRightAccessUtility_CN50 },
{"db_executenice"             ,true , false, false, DBNAME_YES ,   0,  -1 ,          2
                              ,cn85DBExecuteNice
                              ,"<statement>                                       "
                              ,0
                              ,true , DBMRightAccessSQL_CN50 | DBMRightAccessUtility_CN50 },
{"db_executesql"              ,true , false, false, DBNAME_YES ,   0,  -1, CMD_PROT_NOERR
                              ,cn85DBExecuteSQL
                              ,"<statement>                                       "
                              ,0
                              ,true , DBMRightAccessSQL_CN50 },
{"db_fetch"                   ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NOERR
                              ,cn85DBFetch
                              ,"                            (needs kernel session)"
                              ,0
                              ,true , DBMRightAccessSQL_CN50 | DBMRightAccessUtility_CN50 },
{"db_fetchnice"               ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NOERR
                              ,cn85DBFetchNice
                              ,"                            (needs kernel session)"
                              ,0
                              ,true , DBMRightAccessSQL_CN50 | DBMRightAccessUtility_CN50 },
{"db_migratecatalog"          ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn45MigrateCatalog
                              ,"                                                  "
                              ,0
                              ,true , DBMRightAccessUtility_CN50},
{"db_offline"                 ,true , false, false, DBNAME_YES ,   0,   2, CMD_PROT_YES
                              ,cn40DBOffline
                              ,"[-immediate] [-dump]                (needs dbname)"
                              ,0
                              ,true , DBMRightDBStop_CN50 },
{"dboffline"                  ,true , false, false, DBNAME_YES ,   0,   2, CMD_PROT_ALL
                              ,cn40DBOffline
 /*** obsolete ***/           ,"(obsolete version of db_offline)                  "
                              ,0
                              ,true , DBMRightDBStop_CN50 },
{"db_online"                  ,true , false, false, DBNAME_YES ,   0,   4, CMD_PROT_ALL
                              ,cn40DBWarm
                              ,"[(-f|-q|-s)] [-u <yyyymmdd> <hhmmss>]             "
                              ,0
                              ,true , DBMRightDBStart_CN50 },
{"db_release"                 ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn85DBRelease
                              ,"                            (needs kernel session)"
                              ,0
                              ,true , DBMRightAccessSQL_CN50 | DBMRightAccessUtility_CN50 | DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50},
{"db_warm"                    ,true , false, false, DBNAME_YES ,   0,   4, CMD_PROT_ALL
                              ,cn40DBWarm
 /*** obsolete ***/           ,"(obsolete version of db_online)                   "
                              ,0
                              ,true , DBMRightDBStart_CN50 },
{"dbwarm"                     ,true , false, false, DBNAME_YES ,   0,   4, CMD_PROT_ALL
                              ,cn40DBWarm
 /*** obsolete ***/           ,"(obsolete version of db_online)                    "
                              ,0
                              ,true , DBMRightDBStart_CN50 },
{"db_reg"                     ,true , false, false, DBNAME_YES ,   0,   2, 1
                              ,cn40DBRegister
                              ,"[-R <path>|-g <group>|-a [OFF]|-u OFF|-u <usr>,<pwd>]"
                              ,0
                              ,true , DBMRightInstallMgm_CN50 },
{"db_register"                ,true , false, false, DBNAME_YES ,   0,   2, 1
                              ,cn40DBRegister
 /*** obsolete ***/           ,"(obsolete version of db_reg)                       "
                              ,0
                              ,true , DBMRightInstallMgm_CN50 },
{"db_reinstall"               ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn45Reinstall
                              ,"                                                  "
                              ,0
                              ,true , DBMRightAccessUtility_CN50},
{"db_restart"                 ,true , false, false, DBNAME_YES ,   0,   6, CMD_PROT_ALL
                              ,cn40DBRestart
                              ,"[(-f|-q|-s)] [-i] [-d] [-u <yyyymmdd> <hhmmss>]   "
                              ,0
                              ,true , DBMRightDBStop_CN50 },
{"dbrestart"                  ,true , false, false, DBNAME_YES ,   0,   6, CMD_PROT_ALL
                              ,cn40DBRestart
 /*** obsolete ***/           ,"(obsolete version of db_restart)                   "
                              ,0
                              ,true , DBMRightDBStop_CN50 },
{"db_restartinfo"             ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn31BackupRestartInfo
                              ,"                              (needs util session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"backup_restart_info"        ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn31BackupRestartInfo
 /*** obsolete ***/           ,"(obsolete version of db_restartinfo)              "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"db_speed"                   ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn40DBSpeed
                              ,"                                    (needs dbname)"
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"db_standby"                 ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_ALL
                              ,cn46DBStandby
                              ,"<node>                                            "
                              ,0
                              ,true , DBMRightDBStart_CN50 },
{"db_state"                   ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn40DBState
                              ,"                                    (needs dbname)"
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"db_start"                   ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_ALL
                              ,cn40DBStart
                              ,"[(-fast|-quick|-slow)]              (needs dbname)"
                              ,0
                              ,true , DBMRightDBStart_CN50 },
{"start"                      ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_ALL
                              ,cn40DBStart
 /*** obsolete ***/           ,"(obsolete version of db_start)                     "
                              ,0
                              ,true , DBMRightDBStart_CN50 },
{"db_stop"                    ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_ALL
                              ,cn40DBStop
                              ,"[-dump]                             (needs dbname)"
                              ,0
                              ,true , DBMRightDBStop_CN50 },
{"stop"                       ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_ALL
                              ,cn40DBStop
 /*** obsolete ***/           ,"(obsolete version of db_stop)                      "
                              ,0
                              ,true , DBMRightDBStop_CN50 },
{"dban_delete"                ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn43DBanalyzerDelete
                              ,"                                                  "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"dban_start"                 ,true , false, false, DBNAME_YES ,   0,  -1, CMD_PROT_NO
                              ,cn43DBanalyzerStart
                              ,"                                                  "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"dban_stop"                  ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn43DBanalyzerStop
                              ,"                                                  "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"dban_state"                 ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NOERR
                              ,cn43DBanalyzerState
                              ,"                                                  "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"dbm_configset"              ,true , false, false, DBNAME_YES ,   2,   3, 1
                              ,cn41DBMSetValue
                              ,"[-raw] <name> <value>               (needs dbname)"
                              ,0
                              ,true , DBMRightInstallMgm_CN50 },
{"dbm_configget"              ,true , false, false, DBNAME_YES ,   1,   2, CMD_PROT_NO
                              ,cn41DBMGetValue
                              ,"[-raw] <name>                       (needs dbname)"
                              ,0
                              ,true , DBMRightInstallMgm_CN50 },
{"dbm_execute_serverprocess"  ,true , false, false, DBNAME_YES ,   1,  -1, CMD_PROT_NO
                              ,DBMSrvCmd_DbmExecuteServerprocess::runCommand
                              ,0
                              ,NULL
                              ,true  ,DBMMaskNothing_CN50 },
{"dbm_getpath"                ,false, false, true , DBNAME_EGAL,   1,   1, CMD_PROT_NO
                              ,cn40DBMGetPath
                              ,"[IndepDataPath|IndepProgPath]                     "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"dbm_next"                   ,false, false, false, DBNAME_EGAL ,  0 ,   0, CMD_PROT_NO , cn40DBMNext
                              ,NULL
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"dbm_setpath"                ,false, false, true , DBNAME_EGAL,   2,   2, CMD_PROT_NO
                              ,cn40DBMSetPath
                              ,"[IndepDataPath|IndepProgPath] <path>              "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"dbm_version"                ,false, false, true , DBNAME_EGAL,   0,   1, CMD_PROT_NO
                              ,DBMSrvCmd_DbmVersion::runCommand
                              ,0
                              ,DBMSrvCmd_DbmVersion::m_LongHelp
                              ,true  ,DBMMaskNothing_CN50 },
{"diag_histlist"              ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_NO
                              ,cn42DiagHistList
                              ,"                                    (needs dbname)"
                              ,0
                              ,true , DBMRightDBFileRead_CN50 },
{"diag_pack"                  ,true , false, false, DBNAME_YES ,   0,   3, CMD_PROT_NO
                              ,cn42DiagPack
                              ,"<content spec>                      (needs dbname)"
                              ,0
                              ,true , DBMRightDBFileRead_CN50 },
{""                           ,true , false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"event_list"                 ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn82EventList
                              ,"                                                  "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"event_set"                  ,true , false, false, DBNAME_YES ,   1,   4, CMD_PROT_ALL
                              ,cn82EventSet
                              ,"<event> [<prio> [<values>]]   (needs util session)"
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"event_delete"               ,true , false, false, DBNAME_YES ,   1,   3, CMD_PROT_ALL
                              ,cn82EventDelete
                              ,"<event> [<values>]            (needs util session)"
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"event_release"              ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn82EventRelease
                              ,"                                                  "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"event_wait"                 ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn82EventWait
                              ,"                                                  "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"exec_lcinit"                ,true , false, false, DBNAME_YES ,   0,  -1, CMD_PROT_YES
                              ,cn40ExecLcInit
                              ,"                                                  "
                              ,0
                              ,true , DBMRightSystemCmd_CN50 },
{"exec_nipingsrv"             ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_NO
                              ,cn40ExecNiPingSrv
                              ,"[<idletime>]                                      "
                              ,0
                              ,true , DBMRightSystemCmd_CN50 },
{"exec_xpu"                   ,true , false, false, DBNAME_YES ,   0,  -1, CMD_PROT_YES
                              ,cn40ExecXPU
                              ,"                                                  "
                              ,0
                              ,true , DBMRightAccessSQL_CN50 },
{"exec_sdbinfo"               ,false, false, false, DBNAME_EGAL,   0,  -1, CMD_PROT_NO
                              ,cn40ExecSDBInfo
                              ,"[<parameters>]                                    "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"exit"                       ,false, false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,cn10_dbmRelease
                              ,NULL
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"explain"                    ,false, false, false, DBNAME_EGAL,   1,   4, CMD_PROT_NO
                              ,DBMSrvCmd_Explain::runCommand
                              ,0
                              ,DBMSrvCmd_Explain::longHelp
                              ,true  ,DBMMaskNothing_CN50 },
{""                           ,true , false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"file_backup"                ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn42FileBackup
                              ,"<fileid>                            (needs dbname)"
                              ,0
                              ,true , DBMRightDBFileRead_CN50 },
{"file_getfirst"              ,true , false, false, DBNAME_YES ,   1,   3, CMD_PROT_NO
                              ,cn42FileGet
                              ,"<fileid> [LINE=<n>|DATE=<yyyymmdd>] (needs dbname)"
                              ,0
                              ,true , DBMRightDBFileRead_CN50 },
{"file_getlist"               ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_NO
                              ,cn42FileGetList
                              ,"[<showlevel>]                       (needs dbname)"
                              ,0
                              ,true , DBMRightDBFileRead_CN50 },
{"file_getnext"               ,true , false, false, DBNAME_YES ,   2,   2, CMD_PROT_NO
                              ,cn42FileGetNext
                              ,"<fileid> <file handle>              (needs dbname)"
                              ,0
                              ,true , DBMRightDBFileRead_CN50 },
{"file_operation"             ,true , false, false, DBNAME_YES ,   2,   3, CMD_PROT_ALL
                              ,cn42FileOperation
                              ,"<fileid> OP=<operid> [DATE=<date>|LINE=<line>]    "
                              ,0
                              ,true , DBMRightDBFileRead_CN50 },
{"file_restore"               ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn42FileRestore
                              ,"<fileid>                            (needs dbname)"
                              ,0
                              ,true , DBMRightDBFileRead_CN50 },
{""                           ,true , false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"help"                       ,false, false, false, DBNAME_EGAL,   0,   2, CMD_PROT_NO
                              ,DBMSrvCmd_Help::runCommand
                              ,0
                              ,DBMSrvCmd_Help::m_LongHelp
                              ,true  ,DBMMaskNothing_CN50 },
{"hss_addstandby"             ,true , false, false, DBNAME_YES ,   2,   4, 1
                              ,cn46AddStandby
                              ,"<node> login=<osusr>,<pwd> [path=<instroot>     \n                         delay=<delay>]"
                              ,0
                              ,false,DBMRightInstallMgm_CN50 },
{"hss_copyfile"               ,true, false, true , DBNAME_YES,     0,   2, CMD_PROT_ALL
                              ,DBMSrvCmd_HssCopyFile::runCommand
                              ,0
                              ,DBMSrvCmd_HssCopyFile::m_LongHelp
                              ,true  ,DBMRightInstallMgm_CN50 },
{"hss_enable"                 ,true , false, false, DBNAME_YES ,   0,   2, CMD_PROT_ALL
                              ,cn46Enable
                              ,"[node=<officialnode>] [lib=<hsslibrary>]          "
                              ,0
                              ,false,DBMRightInstallMgm_CN50 },
{"hss_execute"                ,false, false, false, DBNAME_YES ,   2,  -1, 2
                              ,cn10_HSSExecute
                              ,"<node> <dbmcommand> [<parameters>]                "
                              ,0
                              ,false  ,DBMMaskNothing_CN50 },
{"hss_getnodes"               ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn46GetNodes
                              ,"                                                  "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50  },
{"hss_removestandby"          ,true , false, false, DBNAME_YES ,   1,   1, 1
                              ,cn46RemoveStandby
                              ,"<node>                                            "
                              ,0
                              ,false,DBMRightInstallMgm_CN50 },
{""                           ,true , false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"info"                       ,true , false, false, DBNAME_YES ,   1,  -1, CMD_PROT_NO
                              ,cn81Info
                              ,"<name>                         (needs sql session)"
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"info_next"                  ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn81InfoNext
                              ,"                               (needs sql session)"
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"inst_enum"                  ,false, false, false, DBNAME_EGAL,   0,   1, CMD_PROT_NO
                              ,cn40InstEnum
                              ,"[-k]                                              "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"inst_info"                  ,false, false, true , DBNAME_EGAL,   0,   2, CMD_PROT_NO
                              ,DBMSrvCmd_InstInfo::runCommand
                              ,0
                              ,DBMSrvCmd_InstInfo::m_LongHelp
                              ,true  ,DBMMaskNothing_CN50 },
{"installation_enum"          ,false, false, false, DBNAME_EGAL,   0,   1, CMD_PROT_NO
                              ,cn40InstEnum
 /*** obsolete ***/           ,"(obsolete version of inst_enum)                   "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"enum_installations"         ,false, false, false, DBNAME_EGAL,   0,   1, CMD_PROT_NO
                              ,cn40InstEnum
 /*** obsolete ***/           ,"(obsolete version of inst_enum)                   "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"inst_reg"                   ,false, true , false, DBNAME_NO,     0,   5, CMD_PROT_ALL
                              ,cn40InstReg
                              ,"[<dbroot>] [[-v]  <version>] [-k <key>]           "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"installation_register"      ,false, true , false, DBNAME_NO,     0,   5, CMD_PROT_ALL
                              ,cn40InstReg
 /*** obsolete ***/           ,"(obsolete version of inst_reg)                    "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"register_installation"      ,false, true , false, DBNAME_NO,     0,   5, CMD_PROT_ALL
                              ,cn40InstReg
 /*** obsolete ***/           ,"(obsolete version of inst_reg)                    "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"inst_unreg"                 ,false, true , false, DBNAME_NO,     0,   1, CMD_PROT_ALL
                              ,cn40InstUnreg
                              ,"[<dbroot>]                                        "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"installation_unregister"    ,false, true , false, DBNAME_NO,     0,   1, CMD_PROT_ALL
                              ,cn40InstUnreg
 /*** obsolete ***/           ,"(obsolete version of inst_unreg)                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"unregister_installation"    ,false, true , false, DBNAME_NO,     0,   1, CMD_PROT_ALL
                              ,cn40InstUnreg
 /*** obsolete ***/           ,"(obsolete version of inst_unreg)                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{""                           ,true , false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"load_systab"                ,true , false, false, DBNAME_YES ,   0,   4, CMD_PROT_YES
                              ,cn40LoadSysTab
                              ,"[-u <user>,<pwd>] [-ud <domainpwd>] (needs dbname)"
                              ,0
                              ,true , DBMRightLoadSysTab_CN50 | DBMRightExecLoad_CN50},
{"load_lcapps"                ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_YES
                              ,cn40LoadLcApps
                              ,"[<sapuser>,<pw>]                    (needs dbname)"
                              ,0
                              ,true , DBMRightExecLoad_CN50 | DBMRightLoadSysTab_CN50},
{"load_r3tab"                 ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_YES
                              ,cn40LoadR3Tab
                              ,"                                    (needs dbname)"
                              ,0
                              ,true , DBMRightLoadSysTab_CN50 | DBMRightExecLoad_CN50},
{"load_tutorial"              ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn40LoadTutorial
                              ,"                                    (needs dbname)"
                              ,0
                              ,true , DBMRightExecLoad_CN50 | DBMRightLoadSysTab_CN50},
{""                           ,true , false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"medium_date"                ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn30BackupMediaDate
                              ,"                                                  "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{"backup_media_date"          ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn30BackupMediaDate
 /*** obsolete ***/           ,"(obsolete version of medium_date)                 "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{"medium_delete"              ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_ALL
                              ,DBMSrvCmdMedium_MediumDelete::runCommand
                              ,0
                              ,DBMSrvCmdMedium_MediumDelete::m_LongHelp
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"medium_delete_nodistribute" ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_ALL
                              ,DBMSrvCmdMedium_MediumDeleteNoDistribute::runCommand
                              ,0 //hidden command
                              ,0 //hidden command
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_media_delete"        ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_ALL
                              ,DBMSrvCmdMedium_MediumDelete::runCommand
 /*** obsolete ***/           ,"(obsolete version of medium_delete)               "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"medium_get"                 ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn30BackupMediaGet
                              ,"<name>                                            "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{"backup_media_get"           ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn30BackupMediaGet
 /*** obsolete ***/           ,"(obsolete version of medium_get)                  "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{"medium_getall"              ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn30BackupMediaGetAll
                              ,"                                                  "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{"backup_media_getall"        ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn30BackupMediaGetAll
 /*** obsolete ***/           ,"(obsolete version of medium_getall)               "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{"medium_label"               ,true , false, false, DBNAME_YES ,   1,   2, CMD_PROT_NO
                              ,cn31BackupLabel
                              ,"<medium> [<nnn>]              (needs util session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_label"               ,true , false, false, DBNAME_YES ,   1,   2, CMD_PROT_NO
                              ,cn31BackupLabel
 /*** obsolete ***/           ,"(obsolete version of medium_label)                "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"medium_labeloffline"        ,true , false, false, DBNAME_YES ,   1,   2, CMD_PROT_NO
                              ,cn31BackupLabelOffline
                              ,"<medium> [<nnn>]                                  "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_labeloffline"        ,true , false, false, DBNAME_YES ,   1,   2, CMD_PROT_NO
                              ,cn31BackupLabelOffline
 /*** obsolete ***/           ,"(obsolete version of medium_labeoffline)          "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"medium_put"                 ,true , false, false, DBNAME_YES ,   2,  10, CMD_PROT_ALL
                              ,DBMSrvCmdMedium_MediumPut::runCommand
                              ,0
                              ,DBMSrvCmdMedium_MediumPut::m_LongHelp
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"medium_put_nodistribute"    ,true , false, false, DBNAME_YES ,   2,  10, CMD_PROT_ALL
                              ,DBMSrvCmdMedium_MediumPutNoDistribute::runCommand
                              ,0 //hidden command
                              ,0 //hidden command
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_media_put"           ,true , false, false, DBNAME_YES ,   2,  10, CMD_PROT_ALL
                              ,DBMSrvCmdMedium_MediumPut::runCommand
 /*** obsolete ***/           ,"(obsolete version of medium_put)                  "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"medium_migrate"             ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn30BackupMediaMigrate
                              ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 | DBMRightDBInfoRead_CN50 },
{""                           ,true , false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"package_info"               ,false, false, false, DBNAME_EGAL,   1,   1, CMD_PROT_NO
                              ,cn40ExecSDBInst
                              ,"<directory>                                         "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"param_abortsession"         ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn20ParamAbortSession
                              ,"                             (needs param session)"
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_addvolume"            ,true , false, false, DBNAME_YES ,   4,   5, CMD_PROT_ALL
                              ,cn20ParamAddDevSpace
                              ,"<num> <mod> <nam> <typ> <siz>       (needs dbname)"
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 },
{"param_adddevspace"          ,true , false, false, DBNAME_YES ,   4,   5, CMD_PROT_ALL
                              ,cn20ParamAddDevSpace
 /*** obsolete ***/           ,"(obsolete version of param_addvolume)             "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 },
{"param_checkall"             ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_ALL
                              ,cn20ParamCheckAll
                              ,"[<mode>]                            (needs dbname)"
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 },
{"param_commitsession"        ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_ALL
                              ,cn20ParamCommitSession
                              ,"                             (needs param session)"
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 },
{"param_copy"                 ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn20ParamCopy
                              ,"<sourcedb>                   (needs param session)"
                              ,0
                              ,true , DBMRightInstallMgm_CN50 },
{"param_delvolume"            ,true , false, false, DBNAME_YES ,   2,   2, CMD_PROT_ALL
                              ,cn20ParamDelDevSpace
                              ,NULL
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 },
{"param_deldevspace"          ,true , false, false, DBNAME_YES ,   2,   2, CMD_PROT_ALL
                              ,cn20ParamDelDevSpace
                              ,NULL
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 },
{"param_directdel"            ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_ALL
                              ,cn20ParamDirectDel
                              ,"<keyname>                                         "
                              ,0
                              ,true , DBMRightParamFull_CN50 },
{"param_directget"            ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn20ParamDirectGet
                              ,"<keyname>                                         "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamRead_CN50 },
{"param_directgetall"         ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn20ParamDirectGetAll
                              ,"                                                  "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamRead_CN50 },
{"param_directgetallnext"     ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn20ParamDirectGetAllNext
                              ,"                                                  "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamRead_CN50 },
{"param_directput"            ,true , false, false, DBNAME_YES ,   2,   2, CMD_PROT_ALL
                              ,cn20ParamDirectPut
                              ,"<keyname> <value>                                 "
                              ,0
                              ,true , DBMRightParamFull_CN50 },
{"param_extget"               ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn20ParamExtGet
                              ,"<keyname>                                         "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_extgetall"            ,true , false, false, DBNAME_YES ,   0,  -1, CMD_PROT_NO
                              ,cn20ParamExtGetAll
                              ,"[<property>=<value>]                              "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_extgetallnext"        ,true , false, false, DBNAME_YES ,   0,  -1, CMD_PROT_NO
                              ,cn20ParamExtGetAllNext
                              ,"[<property>=<value>]                              "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_getdefault"           ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn20ParamGetDefault
                              ,"<keyname>                                         "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_getexplain"           ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn20ParamGetExplain
                              ,"<keyname>                                         "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_getfull"              ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn20ParamGetFull
                              ,"<keyname>                                         "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_gethelp"              ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn20ParamGetHelp
                              ,"<keyname>                                         "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_gethistory"           ,true , false, false, DBNAME_YES ,   0,   5, CMD_PROT_NO
                              ,cn20ParamHistory
                              ,"                                                  "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_gethistorynext"       ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn20ParamHistoryNext
                              ,"                                                  "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_getproperties"        ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn20ParamGetProperties
                              ,"<keyname>                                         "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_gettype"              ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn20ParamGetType
                              ,"<keyname>                                         "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_getvalue"             ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn20ParamGetValue
                              ,"<keyname>                                         "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_getvolsall"           ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_NO
                              ,cn20ParamGetDevSpaceAll
                              ,"[<mod>]                                           "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_getdevsall"           ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_NO
                              ,cn20ParamGetDevSpaceAll
 /*** obsolete ***/           ,"(obsolete version of param_getvolsall)            "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_getvolume"            ,true , false, false, DBNAME_YES ,   2,   2, CMD_PROT_NO
                              ,cn20ParamGetDevSpace
                              ,"<num> <mod>                                       "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_getdevspace"          ,true , false, false, DBNAME_YES ,   2,   2, CMD_PROT_NO
                              ,cn20ParamGetDevSpace
 /*** obsolete ***/           ,"(obsolete version of param_getvolume)             "
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_init"                 ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_NO
                              ,cn20ParamInit
                              ,"[<instance type>]            (needs param session)"
                              ,0
                              ,true , DBMRightInstallMgm_CN50 },
{"param_put"                  ,true , false, false, DBNAME_YES ,   2,   3, CMD_PROT_ALL
                              ,cn20ParamPut
                              ,"<keyname> <value>            (needs param session)"
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 },
{"param_restore"              ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_ALL
                              ,cn20ParamRestore
                              ,"<version number>                    (needs dbname)"
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 },
{"param_rmfile"               ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn20ParamRmFile
                              ,"                                    (needs dbname)"
                              ,0
                              ,true , DBMRightInstallMgm_CN50 },
{"param_startsession"         ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn20ParamStartSession
                              ,"                                    (needs dbname)"
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{"param_versions"             ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn20ParamVersions
                              ,"                                    (needs dbname)"
                              ,0
                              ,true , DBMRightParamFull_CN50 | DBMRightParamCheckWrite_CN50 | DBMRightParamRead_CN50 },
{""                           ,true , false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"quit"                       ,false, false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,cn10_dbmRelease
                              ,NULL
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{""                           ,true , false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,true ,DBMMaskNothing_CN50 },
{"recover_req"                ,true , false, false, DBNAME_YES ,   1,   8, CMD_PROT_ALL
                              ,cn31BackupRestoreRequest
                              ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"backup_restore_req"         ,true , false, false, DBNAME_YES ,   1,   8, CMD_PROT_ALL
                              ,cn31BackupRestoreRequest
 /*** obsolete ***/           ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"recover_cancel"             ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupRestoreCancel
                              ,"                            (needs backup session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"backup_restore_cancel"      ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupRestoreCancel
 /*** obsolete ***/           ,"(obsolete version of recover_cancel)              "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"recover_cancel_req"         ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupRestoreCancelRequest
                              ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"backup_restore_cancel_req"  ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupRestoreCancelRequest
 /*** obsolete ***/           ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"recover_check"              ,true , false, false, DBNAME_YES ,   1,   10, CMD_PROT_ALL
                              ,cn31BackupRestoreCheck
                              ,"<medium> <savetype> [ExternalBackupID <ext_backup_ID>]\n                         [<nnn>] [UNTIL <date> <time>] [LABEL <label>]        \n                                                    (needs service session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_restore_check"       ,true , false, false, DBNAME_YES ,   1,   8, CMD_PROT_ALL
                              ,cn31BackupRestoreCheck
 /*** obsolete ***/           ,"(obsolete version of recover_check)               "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"recover_check_req"          ,true , false, false, DBNAME_YES ,   1,   8, CMD_PROT_ALL
                              ,cn31BackupRestoreCheckRequest
                              ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_restore_check_req"   ,true , false, false, DBNAME_YES ,   1,   8, CMD_PROT_ALL
                              ,cn31BackupRestoreCheckRequest
 /*** obsolete ***/           ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"recover_config"             ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_ALL
                              ,cn31BackupRestoreConfig
                              ,"<medium>                   (needs service session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"backup_restore_config"      ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_ALL
                              ,cn31BackupRestoreConfig
 /*** obsolete ***/           ,"(obsolete version of recover_config)              "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"recover_ignore"             ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupRestoreIgnore
                              ,"                            (needs backup session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_restore_ignore"      ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupRestoreIgnore
 /*** obsolete ***/           ,"(obsolete version of recover_ignore)              "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"recover_ignore_req"         ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupRestoreIgnoreRequest
                              ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_restore_ignore_req"  ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_ALL
                              ,cn31BackupRestoreIgnoreRequest
 /*** obsolete ***/           ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"recover_replace"            ,true , false, false, DBNAME_YES ,   1,   4, CMD_PROT_ALL
                              ,cn31BackupRestoreReplace
                              ,"<medium> [ExternalBackupID <ext_backup_ID>]\n                         [<loc> [<nnn>]]    (needs backup session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_restore_replace"     ,true , false, false, DBNAME_YES ,   1,   4, CMD_PROT_ALL
                              ,cn31BackupRestoreReplace
 /*** obsolete ***/           ,"(obsolete version of recover_replace)             "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"recover_replace_req"        ,true , false, false, DBNAME_YES ,   1,   3, CMD_PROT_ALL
                              ,cn31BackupRestoreReplaceRequest
                              ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_restore_replace_req" ,true , false, false, DBNAME_YES ,   1,   3, CMD_PROT_ALL
                              ,cn31BackupRestoreReplaceRequest
 /*** obsolete ***/           ,NULL
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"recover_start"              ,true , false, false, DBNAME_YES ,   1,   11, CMD_PROT_ALL
                              ,cn31BackupRestore
                              ,"<medium> <savetype> [ExternalBackupID <ext_backup_ID>]\n                         [<nnn>] [UNTIL <date> <time>] [AUTOIGNORE]\n                         [LABEL <label>]               (needs util session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"backup_restore"             ,true , false, false, DBNAME_YES ,   1,   11, CMD_PROT_ALL
                              ,cn31BackupRestore
 /*** obsolete ***/           ,"(obsolete version of recover_start)               "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"recover_state"              ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn31BackupRestoreState
                              ,"                            (needs backup session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"backup_restore_state"       ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn31BackupRestoreState
 /*** obsolete ***/           ,"(obsolete version of revocer_state)               "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"recover_state_check"        ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn31BackupRestoreStateCheck
                              ,"                            (needs backup session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"backup_restore_state_check" ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn31BackupRestoreStateCheck
 /*** obsolete ***/           ,"(obsolete version of recover_state_check)         "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"recover_volume"             ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_ALL
                              ,cn31BackupRestoreDevspace
                              ,"<devicename>                  (needs util session)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"recover_devspace"           ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_ALL
                              ,cn31BackupRestoreDevspace
 /*** obsolete ***/           ,"(obsolete version of recover_volume)              "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"backup_restore_devspace"    ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_ALL
                              ,cn31BackupRestoreDevspace
 /*** obsolete ***/           ,"(obsolete version of recover_volume)              "
                              ,0
                              ,true , DBMRightBackupRestore_CN50 },
{"release"                    ,false, false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,cn10_dbmRelease
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{""                           ,true , false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"show"                       ,true , false, false, DBNAME_YES ,   1,  -1, CMD_PROT_NO
                              ,cn40ShowSomething
                              ,"<SHOW command>                                    "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"show_list"                  ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn40ShowList
                              ,"                                                  "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"show_next"                  ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn40ShowNext
                              ,"                                                  "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 },
{"service_connect"            ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn80ServiceConnect
                              ,"                                    (needs dbname)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"service_release"            ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn80ServiceRelease
                              ,"                                    (needs dbname)"
                              ,0
                              ,true , DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50 },
{"sql_connect"                ,true , false, false, DBNAME_YES ,   0,   2, CMD_PROT_NO
                              ,cn80SQLUserConnect
                              ,"[<user>,<password>]                 (needs dbname)"
                              ,0
                              ,true , DBMRightAccessSQL_CN50 | DBMRightDBInfoRead_CN50 },
{"sql_execute"                ,true , false, false, DBNAME_YES ,   0,  -1, CMD_PROT_NOERR
                              ,cn80SQLUserExecute
                              ,"<statement>                                       "
                              ,0
                              ,true , DBMRightAccessSQL_CN50 },
{"sql_fetch"                  ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn80SQLUserFetch
                              ,"                                                  "
                              ,0
                              ,true , DBMRightAccessSQL_CN50 },
{"sql_info"                   ,true , false, false, DBNAME_YES ,   0,  -1, CMD_PROT_NO
                              ,cn80SQLUserInfo
                              ,"<statement>                                       "
                              ,0
                              ,true , DBMRightAccessSQL_CN50 },
{"sql_recreateindex"          ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_ALL
                              ,cn83RecreateIndex
                              ,"\"<scheme>\".\"<table>\".\"<index>\"              "
                              ,0
                              ,true , DBMRightAccessSQL_CN50 },
{"sql_release"                ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn80SQLUserRelease
                              ,"                                                  "
                              ,0
                              ,true , DBMRightAccessSQL_CN50 | DBMRightDBInfoRead_CN50 },
{"sql_updatestat"             ,true , false, false, DBNAME_YES ,   0,  -1, CMD_PROT_ALL
                              ,cn83UpdateStat
                              ,"[<table or column spec>]                          "
                              ,0
                              ,true , DBMRightAccessSQL_CN50 },
{"sql_updatestat_per_systemtable",true , false, false, DBNAME_YES ,   0,  0, CMD_PROT_ALL
                              ,DBMSrvCmdSQL_SqlUpdatestatPerSystemtable::runCommand
                              ,0
                              ,DBMSrvCmdSQL_SqlUpdatestatPerSystemtable::m_LongHelp
                              ,true , DBMRightAccessSQL_CN50 },
{""                           ,true , false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"test"                       ,false, false, false, DBNAME_EGAL,   0,  -1, CMD_PROT_ALL
                              ,cn40Test
                              ,NULL
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"trace_show"                 ,true , false, false, DBNAME_YES ,   0,   1, CMD_PROT_YES
                              ,cn84TraceShow
                              ,"                                                  "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 | DBMRightDBFileRead_CN50 },
{"trace_on"                   ,true , false, false, DBNAME_YES ,   1,  -1, CMD_PROT_YES
                              ,cn84TraceOn
                              ,"<option> [<level>]                                "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 | DBMRightDBFileRead_CN50 },
{"trace_off"                  ,true , false, false, DBNAME_YES ,   1,  -1, CMD_PROT_YES
                              ,cn84TraceOff
                              ,"<option>                                          "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 | DBMRightDBFileRead_CN50 },
{"trace_flush"                ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_YES
                              ,cn84TraceFlush
                              ,"                                                  "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 | DBMRightDBFileRead_CN50 },
{"trace_clear"                ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_YES
                              ,cn84TraceClear
                              ,"                                                  "
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 | DBMRightDBFileRead_CN50 },
{"trace_protopt"              ,false, false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,cn84TraceProtOpt
                              ,NULL
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 | DBMRightDBFileRead_CN50 },
{"trace_prot"                 ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_YES
                              ,cn84TraceProt
                              ,"[a[b[k[m[e[n[s[t[x]]]]]]]]]         (needs dbname)"
                              ,0
                              ,true , DBMRightDBInfoRead_CN50 | DBMRightDBFileRead_CN50 },
{""                           ,true , false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"user_create"                ,true , false, false, DBNAME_YES ,   1,   2, CMD_PROT_YES
                              ,cn41UserCreate
                              ,"<username>,<pwd> [<templateuser>]   (needs dbname)"
                              ,0
                              ,true , DBMRightUserMgm_CN50 },
{"user_delete"                ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_ALL
                              ,cn41UserDelete
                              ,"<username>                          (needs dbname)"
                              ,0
                              ,true , DBMRightUserMgm_CN50 },
{"user_domain"                ,false, false, false, DBNAME_YES ,   1,   1, CMD_PROT_YES
                              ,cn41UserDomain
                              ,NULL
                              ,0
                              ,true , DBMRightUserMgm_CN50 },
{"user_get"                   ,true , false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn41UserGet
                              ,"<username>                          (needs dbname)"
                              ,0
                              ,true , DBMRightUserMgm_CN50 },
{"user_getall"                ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn41UserGetAll
                              ,"                                    (needs dbname)"
                              ,0
                              ,true , DBMRightUserMgm_CN50 },
{"user_getrights"             ,true , false, false, DBNAME_YES ,   2,   2, CMD_PROT_NO
                              ,cn41UserGetRights
                              ,"<username> SERVERRIGHTS|GUIRIGHTS   (needs dbname)"
                              ,0
                              ,true , DBMRightUserMgm_CN50 },
{"user_logon"                 ,false, false, false, DBNAME_YES ,   1,   1, CMD_PROT_NO
                              ,cn41UserLogon
                              ,"<username>,<pwd>                    (needs dbname)"
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"user_put"                   ,true , false, false, DBNAME_YES ,   2,  -1, 1
                              ,cn41UserPut
                              ,"<username> <property>=<value> ...   (needs dbname)"
                              ,0
                              ,true , DBMRightUserMgm_CN50 },
{"user_sap"                   ,false, false, false, DBNAME_YES ,   1,   1, CMD_PROT_YES
                              ,cn41UserSap
                              ,NULL
                              ,0
                              ,true , DBMRightUserMgm_CN50 },
{"user_sysdba"                ,false, false, false, DBNAME_YES ,   1,   1, CMD_PROT_YES
                              ,cn41UserSysdba
                              ,NULL
                              ,0
                              ,true , DBMRightUserMgm_CN50 },
{"user_system"                ,false, false, false, DBNAME_EGAL,   1,   1, CMD_PROT_NO
                              ,cn41UserSystem
                              ,NULL
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"util_connect"               ,true , false, false, DBNAME_YES ,   0,   2, CMD_PROT_NO
                              ,cn80UtilConnect
                              ,"[<user>,<password>]                 (needs dbname)"
                              ,0
                              ,true , DBMRightAccessUtility_CN50 | DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50},
{"util_execute"               ,true , false, false, DBNAME_YES ,   0,  -1, CMD_PROT_ALL
                              ,cn80UtilExecute
                              ,"<statement>                   (needs util session)"
                              ,0
                              ,true , DBMRightAccessUtility_CN50 },
{"util_release"               ,true , false, false, DBNAME_YES ,   0,   0, CMD_PROT_NO
                              ,cn80UtilRelease
                              ,"                              (needs util session)"
                              ,0
                              ,true , DBMRightAccessUtility_CN50 | DBMRightBackupRestore_CN50 | DBMRightBackupSave_CN50},
{""                           ,true , false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
{"version"                    ,false, false, true , DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,cn40GetVersion
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 },
#else // STARTSTOP
{"db_offline"                 ,false, false, false, DBNAME_YES ,   0,   2, CMD_PROT_YES
                              ,cn40DBOffline
                              ,"[-immediate] [-dump]                (needs dbname)"
                              ,0
                              ,true , DBMMaskNothing_CN50 },
{"db_online"                  ,false, false, false, DBNAME_YES ,   0,   4, CMD_PROT_ALL
                              ,cn40DBWarm
                              ,"[(-f|-q|-s)] [-u <yyyymmdd> <hhmmss>]             "
                              ,0
                              ,true , DBMMaskNothing_CN50 },
#endif // STARTSTOP
{NULL                         ,true , false, false, DBNAME_EGAL,   0,   0, CMD_PROT_NO
                              ,NULL
                              ,"                                                  "
                              ,0
                              ,true  ,DBMMaskNothing_CN50 }
};

const cn10DBMServerCommand * DBMServerCommandsArray_cn10=namesC;

/*!
  -----------------------------------------------------------------------------
  Chapter: static variables
  -----------------------------------------------------------------------------
 */
 VControlDataT * cn00DBMServerData::m_vcontrol = NULL;
/*!
  -----------------------------------------------------------------------------
  EndChapter: static variables
  -----------------------------------------------------------------------------
 */

/*!
  -----------------------------------------------------------------------------
  Chapter: Public functions
  -----------------------------------------------------------------------------
 */

/*!
  -------------------------------------------------------------------------
  function:     ctrlservopen
  -------------------------------------------------------------------------
  description:  DBMServer startup

                This function initializes the DBMServer session data. The
                function will be called by the DBMServer framework at the
                startup of the DBMServer.

  arguments:    vcontrolData   [OUT]  - pointer for DBMServer session data
                dbname         [IN]   - name of database
                dbroot         [IN]   - dbroot path
                pfCancelFlag   [IN]   - the cancel flag
                bVerifiedLocalCommunication [IN]   - the 'administrator' local communication flag
                couldLogOn     [IN]   - could call sqlxidlogon (callerId) (obsolete)
                callerId       [IN]   - user id of calling process (obsolete)

  -------------------------------------------------------------------------
*/
void ctrlservopen (
            void      ** vcontrolData,
            const char * dbname,
            const char * dbroot,
            tsp00_Bool * pfCancelFlag,
            tsp00_Bool   bVerifiedLocalCommunication,
            tsp00_Bool   /* couldLogOn */,
            int          /* callerId */)
{
  FUNCTION_DBG_MCN00_1("vcn10::ctrlservopen");

  VControlDataT * vcontrol  = NULL;

  // enable global protocol
  if ((dbname == NULL) || strlen(dbname) == 0) {
    tin100_GlobalLog * aLog = tin100_GlobalLog::createObject();
    if (aLog != NULL) {
      tsp00_Pathc   szLogFile;
      tsp00_DbNamec szDbName;
      szDbName.Init();
      cn42GetFileName(szDbName, FGET_DBMSRV_CN42, szLogFile);
      tin105_SequentialLogFile * aLogFile = new tin105_SequentialLogFile(szLogFile, LOG_ALL_MIN105);

      if (aLogFile != NULL) {
        aLog->addFile(aLogFile, true);
        aLogFile->checkFile();
      } // end if
    } // end if
  } // end if

  SAPDBErr_MessageList oMsg;

#if defined _WIN32 || defined DBMCLI
  if (true) {
#else
  if (RTE_SetSapdbOwnerAndGroupId (oMsg)) {
#endif

    vcontrol = new VControlDataT;
    if (vcontrol != NULL) {
      vcontrol->bIsSAPDBAdmi = (bVerifiedLocalCommunication != false);
      vcontrol->active          = true;
      SAPDB_strcpy (vcontrol->dbname, (dbname == NULL) ? "" : dbname);
      cn90StrUpperCopy(vcontrol->dbname, vcontrol->dbname, false);
      SAPDB_strcpy (vcontrol->dbroot, (dbroot == NULL) ? "" : dbroot);
      vcontrol->pHSSNodes       = new DBMSrvHSS_Nodes;
      vcontrol->pfCancelFlag    = (bool *) pfCancelFlag;
      vcontrol->pCurrentUser    = new cn50DBMUser;
#ifdef STARTSTOP
      vcontrol->pCurrentUser->setDBName   ( vcontrol->dbname )
                             .setUserName ( cn50DBMUser::getColdUser(vcontrol->dbname))
                             .reload();
#endif

      cn00DBMServerData::setVcontrol(vcontrol);

      //set DBROOT environment variable (PTS: 1107753)
      if (vcontrol->dbroot.length() > 0) {
        static char szEnvVar[512];
        SAPDB_strcpy(szEnvVar, DBROOT_ENV_VAR);
        strcat(szEnvVar, "=");
        strcat(szEnvVar, vcontrol->dbroot);
        putenv(szEnvVar);
      }

    } // end if

  } else {
  // Log Command
    teo200_EventList aRTE(FUNCTION_NAME_MCN00_1, oMsg.ID(), TERR_CN00_1, "DBM", oMsg.Message());
    teo200_EventList aDBM(aRTE, FUNCTION_NAME_MCN00_1, ERR_RTE_CN00_1);
    tin100_GlobalLog::writeEntry (aDBM);

  } // end if

  *vcontrolData = (void *) vcontrol;

} /* end ctrlservopen */

/*!
  -------------------------------------------------------------------------
  function:     ctrlserverclose
  -------------------------------------------------------------------------
  description:  DBMServer shutdown

                This function cleans up the DBMServer session data. The
                function will be called by the DBMServer framework at the
                shutdown of the DBMServer.

  arguments:    vcontrolData   [INOUT]  - pointer for DBMServer session data

  -------------------------------------------------------------------------
*/
void ctrlservclose (
      void * vcontrolData)
{
  VControlDataT * vcontrol = (VControlDataT *) vcontrolData;

  if (vcontrol != NULL) {
    cn20FreeXParamSection(vcontrol);
    cn31FreeBackupSession(vcontrol);
    cn31FreeBackupStageSession(vcontrol);
    cn80FreeUtilSession(vcontrol);
    cn80FreeSQLUserSession(vcontrol);
    cn80FreeServiceSession(vcontrol);
    cn85FreeKernelSession(vcontrol);
    cn32FreeHistorySession(vcontrol);
    cn32FreeEBIDList(vcontrol);
    cn82FreeEventSession(vcontrol);
    cn40FreeCommandObj(vcontrol);
    cn20FreeParamHistory(vcontrol);
    if (vcontrol->pCurrentUser != NULL) {
      delete vcontrol->pCurrentUser;
      vcontrol->pCurrentUser = NULL;
    } // end if

    delete vcontrol;
  } // end if

  tin100_GlobalLog::deleteObject ();

} // end ctrlserverclose

/*!
  -------------------------------------------------------------------------
  function:     ctrlservcommand
  -------------------------------------------------------------------------
  description:  DBMServer command

                This function executes one DBMServer command. The
                function will be called by the DBMServer framework.

  arguments:    vcontrolData   [INOUT]  - pointer for DBMServer session data
                requestData    [IN]     - pointer to the request buffer
                requestLen     [IN]     - length of request buffer
                replyData      [INOUT]  - pointer to the reply buffer
                replyLen       [OUT]    - length of replied data buffer
                replyLenMax    [IN]     - max. length of reply buffer

  return value: csp9_ctrl_release for stopping the DBMServer, otherwise
                csp9_ctrlcmd_ok

  -------------------------------------------------------------------------
*/
int ctrlservcommand (
      void   * vcontrolData,
      char   * requestData,
      int      requestLen,
      char   * replyData,
      int    * replyLen,
      int      replyLenMax)
{
  FUNCTION_DBG_MCN00_1("vcn10::ctrlservcommand");

  VControlDataT      * vcontrol  = (VControlDataT*) vcontrolData;;
  CommandT             command;
  tcn00_Error          nCmdRc    = OK_CN00;

  *replyLen = 0;

  // analyze request command
  requestData[requestLen] = CHAR_STRINGTERM_CN90;
  replyLenMax = replyLenMax - requestLen - 200;
  cn10_AnalyzeCommand (requestData, requestLen, command);

  if (command.nIndex != CommandT::InvalidIndex) {

    // log command
//    namesC[command.nIndex].nTokens2Log = CMD_PROT_ALL;
    if ((namesC[command.nIndex].nTokens2Log != CMD_PROT_NO   ) &&
        (namesC[command.nIndex].nTokens2Log != CMD_PROT_NOERR)    ) {
      cn10_LogCommand(&command);
    } // end if

    if (namesC[command.nIndex].name == NULL) {
      nCmdRc = cn90AnswerIError(replyData, replyLen, ERR_COMMAND_CN00);
    } else if  (namesC[command.nIndex].nDBNameState == DBNAME_YES &&
                vcontrol->dbname[0] == CHAR_STRINGTERM_CN90 ) {
      // dbname required
      nCmdRc = cn90AnswerIError(replyData, replyLen, ERR_NODBNAME_CN00);
    } else if  (namesC[command.nIndex].nDBNameState == DBNAME_NO  &&
                vcontrol->dbname[0] != CHAR_STRINGTERM_CN90 ) {
      // no dbname
      nCmdRc = cn90AnswerIError(replyData, replyLen, ERR_DBNAME_CN00);
    } else if (namesC[command.nIndex].bNeedDBMLogon && !vcontrol->pCurrentUser->isLoggedOn()) {
      // Logon check
      nCmdRc = cn90AnswerIError(replyData, replyLen, ERR_NEEDLOGON_CN00);
    } else if  (namesC[command.nIndex].bNeedSAPDBAdmi  && !vcontrol->bIsSAPDBAdmi) {
      // system logon
      nCmdRc = cn90AnswerIError(replyData, replyLen, ERR_NEEDADMI_CN00);
    } else if  (!vcontrol->pCurrentUser->isServerRight(namesC[command.nIndex].nRights)) {
      // check rights
      nCmdRc = cn90AnswerIError(replyData, replyLen, ERR_MISSRIGHT_CN00);
    } else if  (namesC[command.nIndex].nMinParam > 0 &&
                !cn90GetToken(command.args, NULL, namesC[command.nIndex].nMinParam, -1)) {
      // min param count
      nCmdRc = cn90AnswerIError(replyData, replyLen, ERR_TOOFEWPARAM_CN00);
    } else if  (namesC[command.nIndex].nMaxParam > -1 && cn90GetToken(command.args, NULL, namesC[command.nIndex].nMaxParam + 1, -1)) {
      // max param count
      nCmdRc = cn90AnswerIError(replyData, replyLen, ERR_TOOMANYPARAM_CN00);
    } else {
      if ( namesC[command.nIndex].cnFunction != 0 ) {
        // remove old next command
        if (namesC[command.nIndex].cnFunction != cn40DBMNext) {
          vcontrol->szNextCommand.rawAssign("");
          vcontrol->nNextCommandSkip = 0;
        } // end if
        // call function pointer
        nCmdRc = namesC[command.nIndex].cnFunction (vcontrol, &command, replyData, replyLen, replyLenMax);
      } else {
        teo200_EventList aEvent(FUNCTION_NAME_MCN00_1, ERR_COMMAND_CN00_1, namesC[command.nIndex].name);
        nCmdRc = cn90AnswerEvent(replyData, replyLen, aEvent);
      } // end if
    } // end if

    // in case of error log command always
    if ((namesC[command.nIndex].nTokens2Log == CMD_PROT_NO     ) &&
        (nCmdRc                             != OK_CN00         ) &&
        (nCmdRc                             != ERR_NOREPLY_CN00) &&
        (vcontrol->active                                      )    ) {
      cn10_LogCommand(&command);
    } // end if

  } else {
    char   szToken[PARAMETER_MAXLEN_CN90];

    cn90GetToken(requestData, szToken, 1, PARAMETER_MAXLEN_CN90);
    teo200_EventList aEvent(FUNCTION_NAME_MCN00_1, ERR_COMMAND_CN00_1, szToken);
    nCmdRc = cn90AnswerEvent(replyData, replyLen, aEvent);
  } // end if

  // in case of error log answer
  if ((nCmdRc                             != OK_CN00         ) &&
      (nCmdRc                             != ERR_NOREPLY_CN00) &&
      (namesC[command.nIndex].nTokens2Log != CMD_PROT_NOERR  )    ) {
    cn10_LogError(replyData, nCmdRc);
  } // end if

  return (vcontrol->active) ? csp9_ctrlcmd_ok : csp9_ctrl_release;
} // end ctrlservcommand

/*!
  -----------------------------------------------------------------------------
  EndChapter: Public functions
  -----------------------------------------------------------------------------
 */

/*
  -----------------------------------------------------------------------------
  IMPLEMENTATION PRIVATE FUNCTION cn10_LogCommand
  -----------------------------------------------------------------------------
*/
static void cn10_LogCommand
      ( CommandT   * command )
{
  size_t nPosition =  0;
  size_t nMaxLen   =  0;
  size_t argLen    =  strlen(command->args);
  int    nToken    =  0;

  if (namesC[command->nIndex].nTokens2Log == CMD_PROT_ALL) {
    nPosition = argLen + 1;
  } else {
    while (nPosition < argLen && nToken < namesC[command->nIndex].nTokens2Log) {
      ++nPosition;
      if (isspace(command->args[nPosition])     != 0 &&
          isspace(command->args[nPosition - 1]) == 0    ) {
        ++nToken;
      } // end if
    } // end while
  } // end if

  nMaxLen = MAX_ARGUMENT_LENGTH_EO200 - (int)strlen((namesC[command->nIndex].name == NULL) ? "" : namesC[command->nIndex].name) - 1;
  nPosition = (nPosition > nMaxLen) ? nMaxLen : nPosition;

  // Log Command
  teo200_EventList aEvent("", INF_DBMCMD_CN00_1,
                              (namesC[command->nIndex].name == NULL) ? "" : namesC[command->nIndex].name,
                              nPosition ,
                              command->args);

  tin100_GlobalLog::writeEntry (aEvent);

} // end cn10_LogCommand

/*
  -----------------------------------------------------------------------------
  IMPLEMENTATION PRIVATE FUNCTION cn10_LogError
  -----------------------------------------------------------------------------
*/
static void cn10_LogError
      ( const char       * szError,
        const tcn00_Error   nCmdRc )
{
  const char  * pError     = strstr(szError, LINE_SEPSTRING_CN00);
  const char  * pSecond    = NULL;

  if (pError != NULL) {
    pError = pError + strlen(LINE_SEPSTRING_CN00);
    pError = strstr(pError, TOKEN_SEPSTRING_CN00);
    if (pError != NULL) {
      pError++;

      int nPosition  = (int)(strstr(pError, LINE_SEPSTRING_CN00) - pError);

      nPosition = (nPosition < 0) ? 80 : nPosition;

      pSecond = strstr(pError, LINE_SEPSTRING_CN00);
      if (pSecond != NULL) {
        pSecond = pSecond + strlen(LINE_SEPSTRING_CN00);
        if (strlen(pSecond) > 0) {
          int nSecond = (int)(strstr(pSecond, LINE_SEPSTRING_CN00) - pSecond);
          nSecond = (nSecond < 0) ? 80 : nSecond;

          // Log Command
          teo200_EventList aSecond("", nCmdRc,  TERR_CN00_1, "DBM", "%.*s", nSecond, pSecond);
          teo200_EventList aEvent (aSecond, "", nCmdRc,  TERR_CN00_1, "DBM", "%.*s", nPosition, pError);
          tin100_GlobalLog::writeEntry (aEvent);
        } else {
          // Log Command
          teo200_EventList aEvent("", nCmdRc,  TERR_CN00_1, "DBM", "%.*s", nPosition, pError);
          tin100_GlobalLog::writeEntry (aEvent);
        } // end if

      } else {
        // Log Command
        teo200_EventList aEvent("", nCmdRc,  TERR_CN00_1, "DBM", "%.*s", nPosition, pError);
        tin100_GlobalLog::writeEntry (aEvent);
      } // end if

    } // end if
  } // end if

} // end cn10_LogError

/*
  -----------------------------------------------------------------------------
  IMPLEMENTATION PRIVATE FUNCTION cn10_AnalyzeCommand
  -----------------------------------------------------------------------------
*/
static void cn10_AnalyzeCommand
      ( const char  *  szData,
        const int      nDataLen,
        CommandT     & DBMCommand )
{
  int            nIndex   = 0;
  const char  *  pCommand = szData;

  while (isspace(*pCommand) && ((pCommand - szData) < nDataLen)) {
    ++pCommand;
  } // end while

  for (nIndex = 0;namesC[nIndex].name != NULL; ++nIndex) {
    if (cn90CheckKeyword(pCommand, namesC[nIndex].name, false)) {
      DBMCommand.nIndex = nIndex;
      // fill CommandT
      while (!isspace(*pCommand) && ((pCommand - szData) < nDataLen)) {
        ++pCommand;
      } // end while
      // skip white spaces
      while (isspace(*pCommand) && ((pCommand - szData) < nDataLen)) {
        ++pCommand;
      } // end while
      DBMCommand.setArgs (pCommand);
      break;
    } // end if
  } // end for

} // end cn10_AnalyzeCommand

/*
  -----------------------------------------------------------------------------
  IMPLEMENTATION PRIVATE FUNCTION cn10_HSSExecute
  -----------------------------------------------------------------------------
*/
static tcn00_Error cn10_HSSExecute (
    VControlDataT * vcontrol,
    CommandT      * command,
    char          * replyData,
    int           * replyLen,
    int             replyLenMax)
{
  FUNCTION_DBG_MCN00_1("vcn10.cpp::cn10_HSSExecute");

  tcn00_Error nFuncReturn = OK_CN00;
  char        szNode   [PARAMETER_MAXLEN_CN90];
  char        szCommand[PARAMETER_MAXLEN_CN90];
  int         nIndex      = 0;

  // extract node
  cn90GetToken(command->args, szNode,   1, PARAMETER_MAXLEN_CN90);
  cn90GetToken(command->args, szCommand, 2, PARAMETER_MAXLEN_CN90);

  // search command
  while (namesC[nIndex].name != NULL) {
    if ( stricmp(szCommand, namesC[nIndex].name) == 0) {
      break;
    } // end if
    ++nIndex;
  } // end while

  if (namesC[nIndex].name == NULL) {
     teo200_EventList aEvent(FUNCTION_NAME_MCN00_1, ERR_COMMAND_CN00_1, szCommand);
     nFuncReturn = cn90AnswerEvent(replyData, replyLen, aEvent);
  } // end if

  if (nFuncReturn == OK_CN00) {
    if (!namesC[nIndex].bHSS) {
     teo200_EventList aEvent(FUNCTION_NAME_MCN00_1, ERR_NOHSS_CN00_1, szCommand);
     nFuncReturn = cn90AnswerEvent(replyData, replyLen, aEvent);
    } // end if
  } // end if

  if (nFuncReturn == OK_CN00) {
    Tools_DynamicUTF8String sAnswer;

    if (vcontrol->pHSSNodes->Execute(szNode, strstr(command->args, szCommand), sAnswer)) {
      sprintf(replyData, "%.*s", replyLenMax, sAnswer.CharPtr());
      *replyLen = (int) strlen (replyData);
    } else {
      if ((((int) vcontrol->pHSSNodes->LastMessage().ID()) < -100) && (sAnswer.Length() > 0)) {
        sprintf(replyData, "%.*s", replyLenMax, sAnswer.CharPtr());
        *replyLen = (int) strlen (replyData);
      } else {
        nFuncReturn = cn90AnswerMessage(replyData, replyLen, vcontrol->pHSSNodes->LastMessage());
      } // end if
    } // end if
  } // end if

  return nFuncReturn;
} // end cn10_HSSExecute

/*
  -----------------------------------------------------------------------------
  IMPLEMENTATION PRIVATE FUNCTION cn10_dbmRelease
  -----------------------------------------------------------------------------
*/
static tcn00_Error cn10_dbmRelease (
    VControlDataT * vcontrol,
    CommandT      * command,
    char          * replyData,
    int           * replyLen,
    int             replyLenMax)
{
  vcontrol->active = false;
  return  cn90AnswerOK (replyData, replyLen, NULL);
} // end cn10_dbmRelease

/*
  -----------------------------------------------------------------------------
  IMPLEMENTATION PUBLIC FUNCTION cn10CheckStatic
  -----------------------------------------------------------------------------
*/
bool cn10CheckStatic
   ( const char * pCommand,
     bool       & bStaticAvailable,
     bool       & bNeedsDatabase,
     bool       & bNeedsUser )
{
  CommandT oCommand;
  cn10_AnalyzeCommand (pCommand, (int) strlen(pCommand), oCommand);

  if (oCommand.nIndex == CommandT::InvalidIndex) {
    return false;
  } // end if

  bStaticAvailable = namesC[oCommand.nIndex].bStaticAvailable;
  bNeedsUser       = namesC[oCommand.nIndex].bNeedDBMLogon;
  bNeedsDatabase   = (namesC[oCommand.nIndex].nDBNameState == DBNAME_YES);

  return true;
} // end cn10CheckStatic
