//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//


//
// Define the severity codes
//
#define STATUS_SEVERITY_WARNING          0x2
#define STATUS_SEVERITY_SUCCESS          0x0
#define STATUS_SEVERITY_INFORMATIONAL    0x1
#define STATUS_SEVERITY_ERROR            0x3


//
// MessageId: MSG_EVTHNDL_ERROR_TEMPLATE
//
// MessageText:
//
//  %1%2%3
//
#define MSG_EVTHNDL_ERROR_TEMPLATE       ((DWORD)0xC0000001L)

//
// MessageId: MSG_EVTHNDL_WARNING_TEMPLATE
//
// MessageText:
//
//  %1%2%3
//
#define MSG_EVTHNDL_WARNING_TEMPLATE     ((DWORD)0x80000002L)

//
// MessageId: MSG_EVTHNDL_INFO_TEMPLATE
//
// MessageText:
//
//  %1%2%3
//
#define MSG_EVTHNDL_INFO_TEMPLATE        ((DWORD)0x40000003L)

