#ifndef __OMS_PACKED_HPP
#define __OMS_PACKED_HPP

#include "Oms/OMS_AFX.h"
#include "livecachetypes.h" // nocheck

#define OMS_PACKED_HIGH(X) (X >> 4)
#define OMS_PACKED_LOW(X)  (X & 0x0F)

#define  BCDPLUS           0xc
#define  BCDMINUS          0xd

class AFX_EXT_CLASS OmsPacked {
public:
  OmsTypeInt64 toInt64_16();
  void   toPacked(OmsTypeInt64, int);
private:
  /* PTS 1107752 */
  int digit15() { return OMS_PACKED_HIGH(m_packed[0]); }
  int digit14() { return OMS_PACKED_LOW (m_packed[0]); }
  int digit13() { return OMS_PACKED_HIGH(m_packed[1]); }
  int digit12() { return OMS_PACKED_LOW (m_packed[1]); }
  int digit11() { return OMS_PACKED_HIGH(m_packed[2]); }
  int digit10() { return OMS_PACKED_LOW (m_packed[2]); }
  int digit9 () { return OMS_PACKED_HIGH(m_packed[3]); }
  int digit8 () { return OMS_PACKED_LOW (m_packed[3]); }
  int digit7 () { return OMS_PACKED_HIGH(m_packed[4]); }
  int digit6 () { return OMS_PACKED_LOW (m_packed[4]); }
  int digit5 () { return OMS_PACKED_HIGH(m_packed[5]); }
  int digit4 () { return OMS_PACKED_LOW (m_packed[5]); }
  int digit3 () { return OMS_PACKED_HIGH(m_packed[6]); }
  int digit2 () { return OMS_PACKED_LOW (m_packed[6]); }
  int digit1 () { return OMS_PACKED_HIGH(m_packed[7]); }
  int sign   () { return OMS_PACKED_LOW (m_packed[7]); }
  unsigned char m_packed[16];      
};

#endif  // __OMS_PACKED_HPP