#ifndef __OMS_HRESULT_HPP
#define __OMS_HRESULT_HPP

#include "Oms/OMS_Defines.h"
#include "Oms/OMS_DbpError.hpp"

class OMS_HResult {
public :
  OMS_HResult() : m_hresult(0) {}

  OMS_HResult(HRESULT hr) : m_hresult(hr) {
    if (FAILED(hr)) {
      throw DbpError(DbpError::HRESULT_ERROR, hr, __MY_FILE__, __LINE__);
    }
  }

  void operator= (HRESULT hr) {
    if (FAILED(hr)) {
      throw DbpError(DbpError::HRESULT_ERROR, hr, __MY_FILE__, __LINE__);
    }
    m_hresult = hr;
  }
private :
  HRESULT m_hresult;
};

#endif  // __OMS_HRESULT_HPP
