#include "Oms/OMS_GuidEntry.hpp"
#include "Oms/OMS_FreeListHeader.hpp"
#include "Oms/OMS_VarObjInfo.hpp"
#include "Oms/OMS_Context.hpp"
#include "Oms/OMS_Session.hpp"

void OMS_GuidEntry::ChainFree (OMS_Context&c, OmsAbstractObject* po, int caller) 
{
  if (NULL != po) {
    OmsObjectContainerPtr p = OmsObjectContainer::containerPtr(po);

#ifdef USE_SYSTEM_ALLOC_CO13
    if (p->VarObjFlag()) {
      REINTERPRET_CAST(OMS_VarObjInfo*, po)->freeVarObj(&c);
    }
    c.deallocate(p);
#else
    if (p->IsVerNewObject()) {
#ifdef _ASSERT_OMS
      OmsObjectContainerPtr curr = m_freeHeadInVersion->free;
      while (curr) {
        if (curr == p) {
          throw DbpError (-10, "Duplicate in freelist", __MY_FILE__, __LINE__); 
        }
        curr = curr->GetNextFreeList();
      }
#endif
      p->InitializeForFreeList(caller);
      p->SetNextFreeList(m_freeHeadInVersion->free);
      m_freeHeadInVersion->free = p;
    } else {
#ifdef _ASSERT_OMS
      OmsObjectContainerPtr curr = m_freeHead->free;
      while (curr) {
        if (curr == p) {
          throw DbpError (-10, "Duplicate in freelist", __MY_FILE__, __LINE__); 
        }
        curr = curr->GetNextFreeList();
      }
#endif
      if (p->VarObjFlag()) {
        REINTERPRET_CAST(OMS_VarObjInfo*, po)->freeVarObj(&c);
      }
      p->InitializeForFreeList(caller);
      p->SetNextFreeList(m_freeHead->free);
      m_freeHead->free = p;
    }
#endif
  }
}

/*----------------------------------------------------------------------*/

void OMS_GuidEntry::ChainFree (OMS_Context&c, OmsObjectContainerPtr& p, int caller) 
{
  if (NULL != p) {
#ifdef USE_SYSTEM_ALLOC_CO13
    if (p->VarObjFlag()) {
      REINTERPRET_CAST(OMS_VarObjInfo*, &p->m_pobj)->freeVarObj(&c);
    }
    c.deallocate(p);
    p = NULL;
#else
    if (p->IsVerNewObject()) {
#ifdef _ASSERT_OMS
      OmsObjectContainerPtr curr = m_freeHeadInVersion->free;
      while (curr) {
        if (curr == p) {
          throw DbpError (-10, "Duplicate in freelist", __MY_FILE__, __LINE__); 
        }
        curr = curr->GetNextFreeList();
      }
#endif
      p->InitializeForFreeList(caller);
      p->SetNextFreeList(m_freeHeadInVersion->free);
      m_freeHeadInVersion->free = p;
      p = NULL;
    } else {
#ifdef _ASSERT_OMS
      OmsObjectContainerPtr curr = m_freeHead->free;
      while (curr) {
        if (curr == p) {
          throw DbpError (-10, "Duplicate in freelist", __MY_FILE__, __LINE__); 
        }
        curr = curr->GetNextFreeList();
      }
#endif
      if (p->VarObjFlag()) {
        REINTERPRET_CAST(OMS_VarObjInfo*, &p->m_pobj)->freeVarObj(&c);
      }
      p->InitializeForFreeList(caller);
      p->SetNextFreeList(m_freeHead->free);
      m_freeHead->free = p;
      p = NULL;
    }
#endif
  }
}
