--TEST--
maxdb fetch float values
--SKIPIF--
<?php require 'skipif.inc'; ?>
--INI--
precision=12
--FILE--
<?php
	include "connect.inc";
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);	
  	maxdb_query($link,"DROP TABLE test_bind_fetch");
        maxdb_report (MAXDB_REPORT_ERROR);

 	maxdb_query($link,"CREATE TABLE test_bind_fetch(c1 float(3),
                                                     c2 float,
                                                     c3 float,
                                                     c4 float,
                                                     c5 float,
                                                     c6 float,
                                                     c7 float(10))");


	maxdb_query($link, "INSERT INTO test_bind_fetch (c1,c2,c3,c4,c5,c6,c7) VALUES (3.1415926535,-0.000001, -5, 999999999999,
											sin(0.6), 1.00000000000001, 888888888888888)");

	$stmt = maxdb_prepare($link, "SELECT * FROM test_bind_fetch");
	maxdb_bind_result($stmt, $c1, $c2, $c3, $c4, $c5, $c6, $c7);
	maxdb_execute($stmt);
	maxdb_fetch($stmt);

	$test = array($c1,$c2,$c3,$c4,$c5,$c6,$c7);

	var_dump($test);

	maxdb_stmt_close($stmt);
	maxdb_close($link);
?>
--EXPECT--
array(7) {
  [0]=>
  float(3.14)
  [1]=>
  float(-1.0E-6)
  [2]=>
  float(-5)
  [3]=>
  float(999999999999)
  [4]=>
  float(0.564642473395)
  [5]=>
  float(1)
  [6]=>
  float(8.888888889E+14)
}
