/* @(#) $Id: //sapdb/V75/c_00/b_24/sys/src/sap/640/sapuc.h#1 $ SAP*/
/* CCQ_CCU_FILE_OFF */

#ifndef SAPUC_H
#define SAPUC_H "$Id: //sapdb/V75/c_00/b_24/sys/src/sap/640/sapuc.h#1 $"

/*******************************************************************************
 * (c) Copyright SAP AG, Walldorf, 1996 - 2002
 *
 *
 *              SSSS   AAA   PPPP          U   U   CCCC
 *             S      A   A  P   P         U   U  C
 *              SSS   AAAAA  PPPP          U   U  C
 *                 S  A   A  P             U   U  C
 *             SSSS   A   A  P      =====   UUU    CCCC
 *
 *
 * This is one of the central include files which should be included by all
 * SAP sources.
 *
 * Implementation of the system function interface for the R/3 Unicode
 * kernel.  The functions declared here are to replace those system
 * functions which handle variables of type char. The implementation
 * of the external functions is in nlsui?.c, ? = 1, 2, 3, ... and in
 * the project i18n/sapu16.  The Unicode specific behavior of the
 * functions is documented in flat/nlsuidoc.htm and flat/sapu16doc.htm .
 *
 ******************************************************************************/

/*-HISTORY----------------------------------------------------------------------
 * 04.04.2004 meb      isdigitU: Use isdigit09 also in non-Unicode case
 * 01.11.2003 mit      Correct an ifdef .. defined ..400
 *
 * ?          ?        <see p4 filelog -l >
 *
 * 05.08.2003 ms       add reentrant functions for hostnames and services
 * 04.08.2003 bs       simplify usage of __SAP_DLL_DECLSPEC
 * 29.07.2003 meb      memcpy with check for overlapping buffers (in debug mode)
 * 25.07.2003 bs       statU: make sure <sys/stat> is included before our
 *                     own declarations
 * 17.07.2003 bs       readdir_rU()
 * 28.03.2003 bs       __SAP_DLL_DECLSPEC for Unicode ctype functions (for ITS)
 * 26.03.2003 bs       make ICU normalization available
 * 26.11.2002 meb      Make sccsid/sccsidU thread-safe
 *                     Remove static buffer in convertSCCSID_w
 *                     Malloc pointer instead and stored it into static variable
 * 25.11.2002 meb      Remove hack for Fujitsu Compiler concerning include of
 *                     <wchar.h> vs <cwchar>
 * 11.11.2002 mit      Modifiy mblenU() to accept  0  instead of pointer
 * 06.11.2002 mit      Modifiy mblenU() from UCS-2 to
 *                     real UTF-16
 * 02.10.2002 iseries  SAP_E8 is "char" on PASE too.
 * 17.07.2002 meb      support AIX 5.1 32-bit compilation (wchar_t is 2-Byte)
 * 27.05.2002 ub       strtoupperU etc.
 * 21.05.2002 meb      arabic shaping
 * 12.04.2002 bs       reorganized SAPwithICU* macros
 * 13.03.2002 ub       loadU and nlistU deleted
 * 07.02.2002 ub       statU, lstatU corrected
 * 21.01.2002 ub       __cdecl for functions which are exported on NT.
 * 05.12.2001 bs       prepare ICU on OSF1
 * 30.10.2001 bd       os390 support dllload -> support dllloadU
 * 06.11.2001 ub       fget_strU etc.
 * 05.10.2001 bs       prepare ICU on NT
 * 04.10.2001 bs       remove strcollU() and strxfrmU()
 * 07.08.2001 meb      remove include <widec.h> used for Sun dbgU for C
 *                     compilation
 *                     <wchar.h> and <wctype.h> is enough
 *                     keep <widec.h> for C++ compilation because there are
 *                     inconsistencies with namespace std
 * 07.06.2001 bs       iU()
 * 18.05.2001 bs       mktempU()
 * 27.04.2001 hm       RFC-SDK only: add conversion wchar_t <> SAP_UC.
 * 06.04.2001 meb      mark printfU and similiar functions with special comment
 *                     PRINTFLIKE to enable ccQ to check format strings
 *                     redefine standard macro offsetoff for ccQ to mark it as
 *                     byte length
 * 04.04.2001 meb      load sapu16lib via mainU
 * 12.03.2001 bs       ICU on sun_64 and rs6000_64
 * 05.03.2001 bs       ICU on SunOS
 * 16.02.2001 bs       enable access to ICU i18n shared lib via mainU()
 * 13.02.2001 ub       strtollU(), strtoullU()
 * #50
 * 26.01.2001 meb      remove obsolete macros SAPccUu and SAPccUp
 * 19.01.2001 bs       use ICU for ctype U-functions on AIX and Linux
 * #39
 * 04.01.2001 meb      move SAPUNICODEOK comments in marco RAW2UC to end of cast
 *                     to avoid warnings if casted parameter exceeds one line
 * 03.01.2001 ub       snprintfU, vsnprintfU
 * #37
 * 20.12.2000 meb      on RS6000 compiling forward declaration struct tm fails
 *                     if <ctime> has been included before (compiler bug)
 *                     workaround: suppress declaring time.h if
 *                     CPP_USE_NEW_C_HEADERS is set on RS6000
 * #23
 * 08.12.2000 meb      correct parameter names for macro splitpathU
 * #22
 * 16.11.2000 meb      make usage of C standard library header and functions
 *                     compatible to C and C++ standard
 * #21
 * 12.10.2000 bs       add CAST_RAW2UC()
 * #17
 * 25.09.2000 bs       asctime_rU(), ctime_rU()
 * #11
 * 23.08.2000 meb      Add SAP_UC <-> SAP_UC_MB
 * #10
 * 26.07.2000 bs       strcasecmpU(), strncasecmpU()
 * #6
 * 17.07.2000 ub       Use UTF-16 (SAP_UC_is_UTF16_without_wchar) for SAPonLIN
 * #5
 * 12.07.2000 ub       Use our [f]putsU function on AIX; the first parameter
 *                     is const SAP_UC* ;
 * #4
 * 07.07.2000 ub       NlsuiTraceLevel, nlsui_set_trace()
 * #83
 * 06.07.2000 ub       Add a cast to wint_t for isxxxU and toupper/lowerU on NT.
 *                     Similar for strchrU.
 * #76
 * 15.06.2000 meb      hp_64 support dlopen -> support dlopenU
 * #75
 * 25.04.1000 bs       statvfsU()
 * #68
 * 22.03.2000 meb      Make the isxxxU and toupper/lowerU functions to macros
 *                     also when compiling on NT in unicode debug mode.
 *                     Reasons:
 *                     - Avoid creating different code in debug and release mode
 *                     - NT iswxxx functions can be called directly allthough
 *                       they expect wint_t as paramter instead of int, because
 *                       the conversion is done implicitly
 * 22.03.2000 meb      Use _waccess for accessU in unicode mode on NT
 * 22.03.2000 meb      Add an empty implementation of nlsui_initial_setlocale
 *                     for NT because currently there is not UTF8 locale,
 *                     but offering the function now will probably make it
 *                     easier to use UTF8 locale when it is available
 * #66
 * 09.03.2000 bs       Linux port, part 1: make the Unicode case compilable
 * #65
 * 01.03.2000 bs       strtokU() on AIX; forward declarations for some structs
 * #63
 * 29.02.2000 ub       ungetcU removed because it does not exist on NT
 * #60
 * 16.02.2000 meb      add _splitpathU for NT
 *                     remove errorneous trailing ; in
 *                     #define removeU and renameU for NT
 * #58
 * 05.01.2000 bs       ccQ treats mem..U() macros as functions
 * 30.11.1999 bs       introduce SAPccQ preprocessor flag
 * #54
 * 09.11.1999 meb      solve problems with U functions isascii, chdir, exec...
 *                     isascii: declare a prototype for ccQ on NT
 *                     chdir: declare chdirU additionally to _chdirU
 *                     exec... declare for NT
 *                     map getoptU in Unicode case on NT to an external
 *                     function like on other platforms
 *                     remove old separate ccQ part for ccQ version before 2.3
 * #51
 * 27.10.1999 meb      define _XOPEN_SOURCE always with a numeric value
 * 20.10.1999 bs       #undef SAP_UC_is_4B for ccQ
 * 06.10.1999 ub       environU for OS400 ASCII (Non-Unicode case)
 * #47
 * 24.09.1999 meb      avoid ccQ warning because of sapuc.h macros
 *                     replace char* in single byte branches with SAP_CHAR
 *                     use special ccQ definition for main, setvbufU
 * #46
 * 21.09.1999 meb      use PATH_MAX only if it is defined
 *                     use dummy definition for fgetsR for all ccQ versions
 * #45
 * 21.09.1999 meb      map SAP_UC_is_4B to SAP_UC_is_2B for all ccQ versions
 * #44
 * 08.09.1999 meb      add getpassU
 * #43
 * 08.09.1999 meb      begining with ccQ version 2.3.0 use same defintions for
 *                     normale compiler and ccQ
 * #40
 * 27.08.1999 meb      define sizeofR/U as sizeofccQ not as (size_t)4 when ccQ
 *                     is running to enable correct compile time compilations
 * #38
 * 09.08.1999 meb      remove #include <netdb.h> for SunOS
 *                     it is not needed and causes ccQ compiler errors on
 *                     SunOS 5.6 if only _POSIX_SOURCE is defined
 * #37
 * 06.08.1999 bs       #include "ntport.h" always (undo change #32)
 * #34
 * 19.07.1999 meb      fix forward declaration for struct DIR on NT
 *                     the underlying struct is named _DIR
 * #32
 * 15.07.1999 bs       #include "ntport.h" only if not C++; otherwise it is
 *                     enough to declare struct DIR;
 * #30
 * 18.06.1999 bs       SAPccU: p and u mode of ccU now see the same code
 *                     some str..U() functions names now usable as function  ptr
 * 14.05.1999 HJL      What string for unicode object file identification
 *                     inserted.
 * #27
 * 15.04.1999 bs       #include <wchar.h> on NT also in case of C++ compilation
 * #19
 * 31.03.1999 bs       #undef for all function names in SAPccU section
 * #18
 * 29.03.1999 bs       xdr_stringU: enable on HP-UX 11
 * #15
 * 19.03.1999 bs       #define SAP_UC_is_2B and similar switches for
 *                     internal use of ccU even if SAP_UC is 4 bytes long
 * #8
 * 18.02.1999 bs       always include <stdarg.h> in the Unicode case
 *-
 * 05.02.1999 tk       some corrections for AS/400
 *-
 * 28.11.1998 tk, fs   Functions for SAP_UC_is_UTF16_without_wchar added.
 *                     Support for Unicode on SUN.
 *                     HP_UX switch _INCLUDE_POSIX_SOURCE not necessary for
 *                     each Unicode compilation.
 *-
 * 24.11.1998 mit      SAP_E8 is "char" on OS/400 and "unsigned char" elsewhere.
 *            /else/   mainO4 enhanced.
 *-
 * 16.11.1998 mit      Move alternative character types from sapuc2.h to
 *                     sapuc.h . Now they can be used in other include
 *                     files for prototypes or field definitions.
 *                     For using data of these types, you still have to
 *                     include sapuc2.h .
 *-20.70
 * 09.10.98 ub         types in prototypes changed from wchar_t to
 *                     SAP_UC and SAP_CHAR;
 *                     Preprocessor switch SAP_UC_is_UTF16_without_wchar
 *                     introduced
 *-20.61
 * 22.09.98 js         main4U renamed to mainO4, static function removed
 * 16.09.98 bs         struct groupU, getgrdgid
 * 10.09.98 js         main4U - only for AS/400 command processing programs
 * 06.08.98 bs         return type of mem..U() is always SAP_UC*, not sometimes
 *                     void *. Three new function names on NT
 *-20.51
 * 23.07.98 bs         remove parentheses from some macro definitions: enable
 *                     usage in function pointers
 *-20.50
 * 23.06.98 ub         getoptU
 *-20.49
 * 05.06.98 ub         basic support for HP_UX
 *-20.48
 * 22.05.98 ub         fwriteU, freadU, putcharU, getcharU
 *-20.47
 *-20.46
 * 11.05.98 ub         mainU, main3U, environment
 *          bs         introduce preprocessor switch SAPccU
 *-20.45
 *          ub         printf, scanf, put, get family for NT and DEC OSF1.
 *                     Type WINT_T introduced as return type / argument
 *                     type of fgetcU, fputcU, tolowerU, toupperU,
 *                     isalnum,  ..., isxdigit.
 *-20.43
 * 10.03.98 bs         typedef of SAP_UC and some Unicode preprocessor
 *                     switches moved to saptypeb.h
 *-20.42
 * 04.03.98 ub         printf, scanf, putc, getc, puts, gets etc.
 *                     reorganized; implemented for AIX.
 *
 *          on         SAPonOS400
 *-20.41
 * 21.01.98 bs         enabled double inclusion of sapuc.h
 *-20.40
 * 20.01.98 bs         removed all SAPuses... switches
 *                     started re-implementation of prinf-like functions
 *                     according to the new specification
 *                     made the Unicode case compilable: no more #error for
 *                     missing functions, but dummy implementations in rscpw1.c
 *-20.39
 * 08.01.98 bs         preconversion to unsigned char will not take place:
 *                     remove SAPwithUCHAR and SAPwithSTDC_CHAR and all
 *                     casts to char* or SAP_UC*
 *                     remove also UNS_CH and the ..T() macros
 *-20.38
 * 17.12.97 bs         more parentheses: (SAP_UC*)f(x) -> ((SAP_UC*)f(x))
 *-20.35
 * 15.12.97 bs         treat functions for SAPonOS2_2x from o2port.h
 *                     like system functions
 *                     introduced precompiler switch SAPwithSTDC_CHAR
 *-20.34
 * 11.12.97 bs         Parentheses in macro definitions for all parameters
 *                     which are cast: (char*)s -> (char*)(s)
 *-20.32
 * 09.12.97 bs         sapuc3.h merged into sapuc.h; new preprocessor
 *                     switches: SAPuses... for the use of U-structures
 *-20.31
 * 03.12.97 bs         added U-macros and T-macros for the snc interface
 *-20.28
 * 26.11.97 bs         Casts in the ...U() -macros for the non-Unicode Kernel.
 *                     New type UNS_CH and new macros ...T() added.
 *                     They are identical to type SAP_UC and ...U() macros.
 *-20.27
 * 12.11.97 bs         no more double parentheses necessary for U-functions
 *                     with variable parameter list
 *-20.26
 * 11.11.97 bs         struct utsnameU moved from sapuc3.h (back in 20.31)
 *-20.23
 * 10.10.97 bs         macro SCCSID added
 *-20.21
 * 20.09.97 bs         SAPwithUCHAR added: typedef unsigned char SAP_UC
 *-20.19
 * 03.06.97 bs         I/O streams now handle always UCS2 Little Endian
 *                     Added mblenU(), redefinition of MB_CUR_MAX, etc.
 *                     Reorganized derived preprocessor switches
 *-20.18
 * 29.05.1997 mit      SAP_RAW moved to satypeb.h
 *-20.16
 * 07.05.97 bs         NT port for the case SAPwithUNICODE
 *-20.15
 * 16.04.97 bs         added macros memcpyR(), memsetR() etc.
 *-20.13
 * 07.03.97 bs         more new functions added
 *-20.10
 * 27.01.97 B. Schilling (bs)
 *                     Completely new coding; new naming convention:
 *                       system function      SAP function
 *                          name()        ->    nameU()
 *                     many new functions
 *-END-HISTORY----------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
 * sapuc.h  - compilation switches
 *
 *  There are some compilations switches which have to be derived
 *  from the global switch SAPwithUNICODE and platform switches.
 *  For every platform that supports Unicode,  the following switches must
 *  be set:
 *
 *   SAP_UC_is_1B   or  SAP_UC_is_wchar  or  SAP_UC_is_UTF16_without_wchar
 *
 *                   WCHAR_is_UCS2 or WCHAR_is_UTF16 or WCHAR_is_UCS4
 *
 *  The typedef for SAP_UC (SAP_UC_is_...) has been made in saptypeb.h already.
 *  SAPwithICU is set for all platforms where we use the ICU shared libraries.
 *  The switch
 *    WCHAR_is_2B  or  WCHAR_is_4B
 *  is needed for the definition of SAP_UTF16 and thus also in the non-Unicode
 *  case.
 *----------------------------------------------------------------------------*/
#if defined(SAPonNT)      || \
    defined(SAPonOS400)   || \
    defined(SAPonOS390)   || \
    defined(SAPonAIX) && defined(SAPonAIX_wchar_is_2B)
  #define WCHAR_is_2B

#elif defined(SAPonOSF1)  || \
      defined(SAPonHP_UX) || \
      defined(SAPonSUN)   || \
      defined(SAPonPTX)   || \
      defined(SAPonLIN)   || \
      defined(SAPonRM600) || \
      defined(SAPonAIX) && defined(SAPonAIX_wchar_is_4B)
  #define WCHAR_is_4B
#endif

#if defined (SAP_UC_is_wchar)

  #if defined(WCHAR_is_2B)
    #define WCHAR_is_UCS2

  /* the following lines would apply only if SAP_UC were UCS4 */
  #elif defined(WCHAR_is_4B)
    #define WCHAR_is_UCS4

  #else
    #error "Please edit sapuc.h for this platform"

  #endif /* different platforms */

#endif /* SAP_UC_is_wchar */

#if defined(SAPonAIX)   || \
    defined(SAPonHP_UX) || \
    defined(SAPonLIN)   || \
    defined(SAPonSUN)   || \
    defined(SAPonOSF1)  || \
    defined(SAPonOS390) || \
    defined(SAPonOS400) || \
    defined(SAPonNT)
  /* platforms where ICU is available */
  #if defined(SAPwithUNICODE)
    #define SAPwithICU_CTYPE
    #define SAPwithICU_COLL
    #define SAPwithICU_NORM
  #endif
  #define SAPwithICU_BIDI
  #define SAPwithICU_SHAPING
#endif

#if defined(SAPwithICU_CTYPE)   || \
    defined(SAPwithICU_COLL)    || \
    defined(SAPwithICU_BIDI)    || \
    defined(SAPwithICU_SHAPING)
  #define SAPwithICU
#endif

#if defined(SAPwithoutICU)
  #undef SAPwithICU_CTYPE
  #undef SAPwithICU_COLL
  #undef SAPwithICU_BIDI
  #undef SAPwithICU_SHAPING
  #undef SAPwithICU
  #undef SAPwithICU_I18N
#endif

#if defined(SAPwithUNICODE)
  #define SAPwithU16LIB
  #if defined(SAPonUNIX) || defined(SAPonOS400)
    #define SAPwithU16LIBLinked
  #else
    #define SAPwithU16LIBDyn
  #endif
#endif

#if defined( SAPwithU16LIBDyn ) || \
    defined( SAPwithICU_CTYPE ) || \
    defined( SAPwithICU_I18N )
  #define SAPwithACTIVE_MAINU
#endif

#if defined(SAP_UC_is_1B)
  #define SAPwithOS_LOCALE
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h   - check compilation switches
 *
 * The case           #if defined(SAP_UC_is_1B)
 * is identical to    #if !defined(SAPwithUNICODE)
 *
 * The Unicode implementation is currently based on the type
 * --  wchar_t     if (sizeof(wchar_t)==2)
 * --  wchar_t     if (sizeof(wchar_t)==4)  and  SAP_UC_is_wchar
 * -- unsigned short    if (sizeof(wchar_t)==4)
 *                         and SAP_UC_is_UTF16_without_wchar
 *                         and SAP_UC is defined as unsigned short
 * --  wchar_t     if (sizeof(wchar_t)==4)
 *                         and SAP_UC_is_UTF16_without_wchar
 *                         and SAP_UC is defined as wchar_t ; this
 *                         is for temporary testing only.
 *
 *
 * SAP_UC_is_wchar or SAP_UC_is_UTF16_without_wchar
 * are defined in saptypeb.h .
 *
 * In sapuc.h we distinguish as follows:
 *
 * #ifndef SAPwithUNICODE
 *         ... /o    No Unicode   o/
 * #else
 *             /o    Unicode U-functions that are independent of
 *                   the definition of SAP_UC      o/
 *   #if defined(SAP_UC_is_wchar)
 *             /o    Unicode U-functions or macros that use wchar_t       o/
 *   #elif defined(SAP_UC_is_UTF16_without_wchar)
 *             /o    Unicode U-functions that are necessary in the case
 *                   that SAP_UC is not wchar_t                           o/
 *   #endif
 * #endif
 *
 *
 * Source code that depends on SAPwithUNICODE but not on the implementation
 * of Unicode should look like:
 *
 * #if defined(SAPwithUNICODE)
 *         ...
 * #else
 *         ...
 * #endif
 *
 *----------------------------------------------------------------------------*/
#if defined(SAPwithUNICODE)

  #if !defined(SAPwithINT_BIGENDIAN) && !defined(SAPwithINT_LITTLEENDIAN)
      #error "SAPwithINT_LITTLEENDIAN/BIGENDIAN)__is_not_defined"
  #endif

  #if defined(SAP_UC_is_wchar)

    #if !defined(WCHAR_is_UCS2) && !defined(WCHAR_is_UTF16) \
       && !defined(WCHAR_is_UCS4)
      #error "WCHAR_is_?  is not defined"
    #endif

  #elif defined(SAP_UC_is_UTF16_without_wchar)
          /* Some checks may be inserted here            XXX? */

  #else

    #error "Which type shall I use for Unicode?"

  #endif  /* SAP_UC_is_? */

#else /* not SAPwithUNICODE */

  #if !defined(SAP_UC_is_1B)

    #error "SAP_UC_is_1B  not defined"

  #endif

#endif  /* SAPwithUNICODE or not */


/*-----------------------------------------------------------------------------
 * sapuc.h   -   derive further compilation switches for convenience
 *
 *  Length of Unicode in bytes:     Little endian or big endian byte order:
 *
 *   SAP_UC_is_2B, SAP_UC_is_4B      SAP_UC_is_2B_L, SAP_UC_is_4B_B  etc.
 *
 *  What kind of Unicode is used:
 *
 *   SAP_UC_is_UCS2L    UCS-2, little endian format
 *   SAP_UC_is_UCS4B    UCS-4, big endian format
 *         etc.
 *
 * Remark: Using two bytes is regarded as identical to using either
 * UCS-2 or UTF-16. If it should become necessary to distinguish between
 * UCS-4 and 4-byte UCS2, the following case distinctions must be extended.
 *
 *----------------------------------------------------------------------------*/
#if defined(SAP_UC_is_wchar)

  #if defined(WCHAR_is_UCS2)

    #define SAP_UC_is_2B
    #if defined(SAPwithINT_LITTLEENDIAN)
      #define SAP_UC_is_2B_L
    #else
      #define SAP_UC_is_2B_B
    #endif

    /* Even when wchar_t is UCS-2, SAP will use it for
     * UTF-16.
     *
     * #define SAP_UC_is_UCS2
     * #if defined(SAPwithINT_LITTLEENDIAN)
     *   #define SAP_UC_is_UCS2_L
     * #else
     *   #define SAP_UC_is_UCS2_B
     * #endif
     *
     */

    #define SAP_UC_is_UTF16
    #if defined(SAPwithINT_LITTLEENDIAN)
      #define SAP_UC_is_UTF16_L
    #else
      #define SAP_UC_is_UTF16_B
    #endif

  #elif defined(WCHAR_is_UTF16)

    #define SAP_UC_is_2B
    #define SAP_UC_is_UTF16
    #if defined(SAPwithINT_LITTLEENDIAN)
      #define SAP_UC_is_2B_L
      #define SAP_UC_is_UTF16_L
    #else
      #define SAP_UC_is_2B_B
      #define SAP_UC_is_UTF16_B
    #endif

  #elif defined(WCHAR_is_UCS4)

    #define SAP_UC_is_4B
    #define SAP_UC_is_UCS4
    #if defined(SAPwithINT_LITTLEENDIAN)
      #define SAP_UC_is_4B_L
      #define SAP_UC_is_UCS4_L
    #else
      #define SAP_UC_is_4B_B
      #define SAP_UC_is_UCS4_B
    #endif

  #endif /* WCHAR_is_? */

#elif defined(SAP_UC_is_UTF16_without_wchar)

    #define SAP_UC_is_2B
    #define SAP_UC_is_UTF16
    #if defined(SAPwithINT_LITTLEENDIAN)
      #define SAP_UC_is_2B_L
      #define SAP_UC_is_UTF16_L
    #else
      #define SAP_UC_is_2B_B
      #define SAP_UC_is_UTF16_B
    #endif

#endif  /* SAP_UC_is_... */

/*
 * For internal use of ccQ only:
 * SAPccQ    ccQ is running
 */
#if !defined(SAPccQ) && defined(CCQ_VERSION)
  #define SAPccQ     CCQ_VERSION
#endif

/*-----------------------------------------------------------------------------
 * sapuc.h   - further includes
 *
 * Via saptype.h most neccessary headers are known, including
 * <limits.h>, <stddef.h>, <stdio.h>, <stdlib.h>, and <string.h>
 *----------------------------------------------------------------------------*/

#if defined(SAPonOS400) && defined(__LLP64_IFC__) && defined(USE_CPYBYTES)
  #include <mih/cpybytes.h>
#endif

#if defined(SAPwithUNICODE) || defined(SAPU16C_LIB)

  #if defined(CPP_USE_NEW_C_HEADERS)
    #include <cstdarg>
  #else
    #include <stdarg.h>
  #endif

  #ifdef SAPonNT
    #if defined(CPP_USE_NEW_C_HEADERS)
      #include <cwchar>
    #else
      #include <wchar.h>
    #endif

  #elif defined(SAPonOS400)	/* wchar.h does not include time.h. */
    #ifndef _POSIX_LOCALE
      #define _POSIX_LOCALE
    #endif
    #if defined(CPP_USE_NEW_C_HEADERS)
      #include <cwchar>
      #include <cwctype>
      #include <clocale>
    #else
      #include <wchar.h>
      #include <wctype.h>
      #include <locale.h>
    #endif
      #include <dirent.h>
      #include <ifs.h>
      #include <time.h>
      #include <spawn.h>

  #elif defined(SAPonAIX)
    #ifndef _XOPEN_SOURCE
      #define not_XOPEN_SOURCE
      #define _XOPEN_SOURCE 1
    #endif
    #if defined(CPP_USE_NEW_C_HEADERS)
      #include <cwchar>
      /* struct tm forward declaration does not work because of compiler bug */
	  #define CPP_SUPPRESS_TM_FORWARD
    #else
      #include <wchar.h>
    #endif
    #ifdef not_XOPEN_SOURCE
      #undef _XOPEN_SOURCE
      #undef not_XOPEN_SOURCE
    #endif
    #include <dirent.h>

  #elif defined(SAPonOSF1)
    #if defined(CPP_USE_NEW_C_HEADERS)
      #include <cwchar>
    #else
      #include <wchar.h>
    #endif
    #include <dirent.h>

  #elif defined(SAPonHP_UX)
    #if defined(CPP_USE_NEW_C_HEADERS)
      #include <cwchar>
      /* New compiler version seems to need the following (cf. AIX).
       * But this is just experimental (TODO).  d025846 2001-07-19 */
      #define CPP_SUPPRESS_TM_FORWARD
    #else
      #include <wchar.h>
    #endif
    #include <dirent.h>
    #ifndef _INCLUDE__STDC__
      #define not_INCLUDE__STDC__
      #define _INCLUDE__STDC__
    #endif
    #if defined(CPP_USE_NEW_C_HEADERS)
      #include <clocale>
    #else
      #include <locale.h>  /* this is necessary !        XXX? */
    #endif
    #ifdef not_INCLUDE__STDC__
      #undef _INCLUDE__STDC__
      #undef not_INCLUDE__STDC__
    #endif
    #if defined(_LOCALE_INCLUDED) && !defined(LC_CTYPE)
      #error "Something went wrong when #including <locale.h>"
    #endif

  #elif defined(SAPonSUN)
    #if defined(CPP_USE_NEW_C_HEADERS)
      /* This is just experimental (TODO), cf. AIX.  d025846 2001-11-20 */
      #define CPP_SUPPRESS_TM_FORWARD
    #endif
    #if defined(CPP_USE_NEW_C_HEADERS)
      #include <cwchar>
      #include <clocale>
	  #include <widec.h>
    #else
      #include <wchar.h>
      #include <locale.h>
    #endif
    #include <dirent.h>

  #elif defined(SAPonLIN)
    #if defined(CPP_USE_NEW_C_HEADERS)
      #include <cwchar>
      #include <cwctype>      /* isw..() */
    #else
      #include <wchar.h>
      #include <wctype.h>     /* isw..() */
    #endif
    #include <sys/types.h>  /* other platforms include it already in stdio.h */
    #include <dirent.h>

  #elif defined(SAPonOS390)
    #if defined(CPP_USE_NEW_C_HEADERS)
      #include <cwchar>
      #include <cwctype>      /* isw..() */
    #else
      #include <wchar.h>
      #include <wctype.h>     /* isw..() */
    #endif
    #include <dirent.h>
    #include <dll.h>
    #include <spawn.h>

  #elif defined(SAPonRM600)
    #if defined(CPP_USE_NEW_C_HEADERS)
      #include <cwchar>
    #else
      #include <wchar.h>
    #endif
    #include <dirent.h>

  #else /* other platforms */
    #error "Please edit sapuc.h for this platform"
  #endif /* different platforms */

#endif /* SAPwithUNICODE */


/*-----------------------------------------------------------------------------
 * sapuc.h  -  Default system code page
 *----------------------------------------------------------------------------*/

#if defined(SAP_UC_is_1B)
  #ifdef SAPwithCHAR_EBCDIC
    #define SAP_SYS_CP_STR cU("0120")
    #define SAP_SYS_CP_C4  {cU('0'),cU('1'),cU('2'),cU('0')}
  #else /* ASCII */
    #define SAP_SYS_CP_STR cU("1100")
    #define SAP_SYS_CP_C4  {cU('1'),cU('1'),cU('0'),cU('0')}
  #endif
#elif defined(SAP_UC_is_UCS2_B)
    #define SAP_SYS_CP_STR cU("4100")
    #define SAP_SYS_CP_C4  {cU('4'),cU('1'),cU('0'),cU('0')}
#elif defined(SAP_UC_is_UCS2_L)
    #define SAP_SYS_CP_STR cU("4101")
    #define SAP_SYS_CP_C4  {cU('4'),cU('1'),cU('0'),cU('1')}
#elif defined(SAP_UC_is_UCS4_B)
    #define SAP_SYS_CP_STR cU("4104")
    #define SAP_SYS_CP_C4  {cU('4'),cU('1'),cU('0'),cU('4')}
#elif defined(SAP_UC_is_UCS4_L)
    #define SAP_SYS_CP_STR cU("4105")
    #define SAP_SYS_CP_C4  {cU('4'),cU('1'),cU('0'),cU('5')}
#elif defined(SAP_UC_is_UTF16_B)
    #define SAP_SYS_CP_STR cU("4102")
    #define SAP_SYS_CP_C4  {cU('4'),cU('1'),cU('0'),cU('2')}
#elif defined(SAP_UC_is_UTF16_L)
    #define SAP_SYS_CP_STR cU("4103")
    #define SAP_SYS_CP_C4  {cU('4'),cU('1'),cU('0'),cU('3')}
#else
 #error "SAP_UC_is_?"
#endif

/*-----------------------------------------------------------------------------
 * sapuc.h  -   macros for AS/400 -
 *----------------------------------------------------------------------------*/
#ifndef SAPonOS400					/* default for other platforms	*/

  #define AS4_EXT_PTR
  #define SAP_Fptr cU("%p")
  #define PRINT_PTR(ptr)     (ptr)
  #define PRINT_PTR_EXT(ptr) (ptr)

#else								/* now for AS/400				 */

  #ifdef SAPccQ
	#define __ptr128
  #endif

  #ifdef SAPwithUNICODE
    #define SAP_Fptr cU("%p")
  #else
    #define SAP_Fptr cU("%s")
  #endif

  #ifdef SAPwithCHAR_ASCII
    #define C_PAGE_O4 0
  #else
    #define C_PAGE_O4 1
  #endif

  #ifndef __LLP64_IFC__				/* version before teraspace 2	 */

    #define AS4_EXT_PTR
    #define SAP_FptrX cU("%.8x %.8x %.8x %.8x")

    #ifndef SAPwithUNICODE
      externC SAP_UC* o4ptr2str(void* ptr, int cp);
	  #define PRINT_PTR(ptr)     o4ptr2str(ptr,C_PAGE_O4)
      #define PRINT_PTR_EXT(ptr) o4ptr2str(ptr,C_PAGE_O4)
    #else
      #define PRINT_PTR(ptr)     (ptr)
      #define PRINT_PTR_EXT(ptr) (ptr)
    #endif

  #else								/* version with teraspace 2		*/

    #define AS4_EXT_PTR __ptr128
    #define SAP_FptrX cU("%.8x %.8x")

    #ifndef SAPwithUNICODE
      externC SAP_UC* o4ptr2str (void* ptr, int cp);
	  externC SAP_UC* o4ptr16str(void*__ptr128 ptr, int cp);
      #define PRINT_PTR(ptr)     o4ptr2str (ptr,C_PAGE_O4)
	  #define PRINT_PTR_EXT(ptr) o4ptr16str(ptr,C_PAGE_O4)
    #else
	  externC SAP_UC* o4ptr16str(void*__ptr128 ptr, int cp);
      #define PRINT_PTR(ptr)    (ptr)
	  #define PRINT_PTR_EXT(ptr) o4ptr16str(ptr,C_PAGE_O4)
    #endif

  #endif							/* Teraspace 2 or not			*/

#endif								/* OS/400 or others				*/
/*-----------------------------------------------------------------------------
 * sapuc.h  -   end of macros for AS/400 -
 *----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
 * sapuc.h  -  Calling convention on MS Windows
 *             CDCL_U will be #undef'd at the end of sapuc.h
 *----------------------------------------------------------------------------*/
#ifdef SAPonNT
  #define CDCL_U  __cdecl
#else
  #define CDCL_U
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -  Return type of fgetcU
 *----------------------------------------------------------------------------*/
/* We want that the following code works:
 *   int c;   c = fgetcU(f);   if (c==EOF) ...
 *  Under NT, wchar.h defines:
 *  typedef unsigned short wchar_t;
 *  typedef wchar_t wint_t;
 *  #define WEOF (wint_t)(0xFFFF)
 *  Now  WEOF != EOF !!!         We don't like this.
 *  So we use WINT_T and WINT_EOF instead.
 *  Outside sapuc.h and nlsui1.c it is not necessary to use WINT_T .
 */
#if defined(SAPwithUNICODE) && !defined(NLSUI_WINT_T)
                /* also for SAP_UC_is_UTF16_without_wchar */
  #define NLSUI_WINT_T
  #if defined(SAPonNT)
    typedef int WINT_T;
    #define WINT_EOF (-1)
                      /* Now WINT_EOF == EOF */
  #elif defined(SAPonUNIX) || defined(SAPonOS400)
    typedef wint_t WINT_T;
    #define WINT_EOF WEOF
  #else
    #error "type WINT_T not defined on this platform"
  #endif
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  - macro for a safe cast to SAP_UC/SAP_CHAR
 *
 * If compiled in debug mode, a warning will be written to stderr
 * when the alignment is not sufficient on all platforms.
 *----------------------------------------------------------------------------*/
#if defined(SAPwithUNICODE) && !defined(NDEBUG)
  externC SAP_UC * CDCL_U nlsui_cast_raw2uc( const void *, SAP_UC *, int );
  #define CAST_RAW2UC( x )   /* SAPUNICODEOK_CAST_RAW2UC */ nlsui_cast_raw2uc( x, cU(__FILE__), __LINE__ )
  #define CAST_RAW2CHAR( x ) /* SAPUNICODEOK_CAST_RAW2UC */ nlsui_cast_raw2uc( x, cU(__FILE__), __LINE__ )

#else /* not Unicode or opt */
  #define CAST_RAW2UC( x )   ((SAP_UC *)(x) /* SAPUNICODEOK_CAST *//* SAPUNICODEOK_CAST_RAW2UC */)
  #define CAST_RAW2CHAR( x ) ((SAP_CHAR *)(x) /* SAPUNICODEOK_CAST *//* SAPUNICODEOK_CAST_RAW2UC */)

#endif

/*-----------------------------------------------------------------------------
 * sapuc.h  -  The SCCSID macro
 *----------------------------------------------------------------------------*/
#define sccsidR   sccsid

#ifndef SAPwithUNICODE
  #define SCCSID  sccsid
  #define sccsidU sccsid     /* nicer name than SCCSID */

#else /* Now SAPwithUNICODE */
  /* Every object file will contain the static pointer sccsidU16.
   * When the sccsidU macro is used for the first time, we call malloc(),
   * convert the sccsid and store the pointer in sccsidU16.
   * If malloc() fails, we return a pointer to static memory.
   * ********* NOTE: free() will never be called! ************ */
  static SAP_UC* sccsidU16 = NULL;
  #define SCCSID sccsidU
  /* convert sccsid to Unicode and store in sccsidU16 if not already done
     return sccsidU16 in any case */
  #define sccsidU (sccsidU16!=NULL ? sccsidU16 : (sccsidU16=ConvertSCCSID_w(sccsid)))
  /* ********* Do not call the following function directly! *********** */
  externC SAP_UC* CDCL_U ConvertSCCSID_w( const char *sccsid );
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -  macros for length calculations
 *----------------------------------------------------------------------------*/

#ifndef SAPwithUNICODE
  #define SAP_UC_LN          (1U)
  #define SAP_UC_SF          (0U)  /* shift factor: logarithm of SAP_UC_LN */
  #define SAP_UC_ALIGN_MASK  (0U)  /* # bits necessary to check alignment  */

#elif defined(SAP_UC_is_2B)
  #define SAP_UC_LN          (2U)
  #define SAP_UC_SF          (1U)
  #define SAP_UC_ALIGN_MASK  (1U)

#elif defined(SAP_UC_is_4B)
  #define SAP_UC_LN          (4U)
  #define SAP_UC_SF          (2U)
  #define SAP_UC_ALIGN_MASK  (3U)

#endif


#ifdef SAPccQ
  #ifdef SAP_UC_is_4B                 /* SAP_UC_is_4B is not implemented  ... */
    #define SAP_UC_is_2B              /* ... in the entire source code        */
    #define SAP_UC_is_UTF16
    #undef SAP_UC_is_4B
    #ifdef SAPwithINT_LITTLEENDIAN
      #define SAP_UC_is_2B_L
      #define SAP_UC_is_UTF16_L
    #else
      #define SAP_UC_is_2B_B
      #define SAP_UC_is_UTF16_B
    #endif
  #endif
#endif



#define sizeofR(par)         sizeof(par)

#ifndef SAPwithUNICODE
  #define sizeofU(par)       sizeof(par)
#else
  #define sizeofU(par)       (sizeofR(par)/sizeofR(SAP_UC))
#endif


/*----------------------------------------------------------------------------
 * sapuc.h  -  character constants and string constants
 *---------------------------------------------------------------------------*/
#define cR(par)         par
#define cNtoS(par)      cNtoS_HELP( par )
#define cNtoS_HELP(par) #par

#ifndef SAPwithUNICODE
  #define cU(par)       par
  #define iU(par)       par

#else /* SAPwithUNICODE */

  #if defined(SAP_UC_is_wchar)
   /* String literals can be written as L"abc" */
   #define cU(par)      cU_HELP(par) /* if par is a macro, it must be ...    */
   #define cU_HELP(par) L##par       /* ... resolved before the 'L' is added */
   #define iU(par)      iU_HELP(par)
   #define iU_HELP(par) L##par

  #elif defined(SAP_UC_is_UTF16_without_wchar)
    #if defined(SAPwithoutUTF16_LITERALS) && !defined(SAPccQ)
      /* prepare for a special conversion tool */
      #define cU(par)      cU_HELP(par)
      #define cU_HELP(par) _U16_LIT_cU par
      #define iU(par)      iU_HELP(par)
      #define iU_HELP(par) _U16_LIT_iU par

    #else
      /* String literals can be written as u"abc" */
      #define cU(par)      cU_HELP(par)
      #define cU_HELP(par) u##par
      #define iU(par)      iU_HELP(par)
      #define iU_HELP(par) u##par

    #endif
  #endif /* SAP_UC_is_UTF16_without_wchar */
#endif /* SAPwithUNICODE */


/*----------------------------------------------------------------------------
 * sapuc.h  -  helper to declare functions of libsapu16
 *---------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE
  #define SAPU16_FUNC(f)  f
#else
  #ifdef SAPwithU16LIBLinked
    #define SAPU16_FUNC(f)  f##16
  #else
    #define SAPU16_FUNC(f)  f
    /* ntprtlib should not export function pointers from libsapu16:
     * MS-Windows-specific problems (2001-11-22).
     * What is best for OS/400? */
  #endif
#endif /* SAPwithUNICODE */


/*----------------------------------------------------------------------------
 * sapuc.h  -  macro to guarantee an unsigned char in the non-Unicode case
 *---------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE
  #define U_CHAR(par)    ((unsigned char)(par))
#else
  #define U_CHAR(par)    (par)
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  - 'what'-identifier definition for distinguishing unicode
 *            from non unicode object files.
 *----------------------------------------------------------------------------*/
#if SAP_RELEASE_NO >= 5010
  #ifdef SAPwithUNICODE
   static SAP_RAW unicodeId[] = cR("@(#)     Unicode");
  #else
   static SAP_RAW unicodeId[] = cR("@(#) non-Unicode");
  #endif
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  - Debug helper function that checks correct 2-byte alignment of
 *            strings. Calls to this function will be inserted automatically
 *            by the u16lit parser.
 *----------------------------------------------------------------------------*/

externC SAP_UC * CDCL_U SAPU16_FUNC(dbgAlignCheckStringU)( char * );	/* _never_ change that "char *" ! */

/*-----------------------------------------------------------------------------
 * sapuc.h  -   Function that counts number of bytes to write
 *----------------------------------------------------------------------------*/

#ifndef SAPwithUNICODE
  #define UcnToFileLenR(data, n)  (n)
#else
  externC size_tR CDCL_U UcnToFileLenR( SAP_CHAR *data, size_tU n );
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -  Functions for string handling:  str...
 *
 * A few ..U() functionnames are available both as macro and as function.
 * For the use in function pointers, #undef the macro first.
 *----------------------------------------------------------------------------*/

#ifdef SAPonOS400
  #if ( ( ! defined (__EXTENDED__) ) || ( ! defined ( __cplusplus ) ) )
    #pragma datamodel(P128)
    /* for some weird reason IBM only defines certain string functions for C++ in its */
    /* header files */
    /* the following lines are copied from string.h from a V5R1 machine */
    char *strdup(const char *);
    char *strnset(char *, int c, size_t);
    char *strset(char *, int c);
    #pragma map(strdup, "__strdup")
    #pragma map(strnset, "__strnset")
    #pragma map(strset, "__strset")
    #pragma datamodel(pop)
  #endif
#endif /* SAPonOS400 */

/* available as function: */
BEGIN_NS_STD_C_HEADER
  externC SAP_UC * CDCL_U strchrU ( const SAP_UC *, int );
  externC int      CDCL_U strcmpU ( const SAP_UC *, const SAP_UC * );
  externC SAP_UC * CDCL_U strcpyU (       SAP_UC *, const SAP_UC * );
END_NS_STD_C_HEADER

/* to be used both in the Unicode and the non Unicode case: */
externC int CDCL_U strcasecmpU  ( const SAP_UC *, const SAP_UC * );
externC int CDCL_U strncasecmpU ( const SAP_UC *, const SAP_UC *, size_tU );
externC SAP_UC * CDCL_U strtoupperU ( SAP_UC * s1 );
externC SAP_UC * CDCL_U strtolowerU ( SAP_UC * s1 );
externC SAP_UC * CDCL_U strntoupperU ( SAP_UC * s1, size_tU len );
externC SAP_UC * CDCL_U strntolowerU ( SAP_UC * s1, size_tU len );
externC SAP_UC * CDCL_U strcpytoupperU ( SAP_UC * dst, const SAP_UC * src );
externC SAP_UC * CDCL_U strcpytolowerU ( SAP_UC * dst, const SAP_UC * src );

#ifndef SAPwithUNICODE

  #define strcatU(  s1, s2 )              strcat(  s1, s2 )
  #define strchrU(  s,  c  )              strchr( s, U_CHAR(c) )
  #define strrchrU( s,  c  )              strrchr( s, U_CHAR(c) )
  #define strcmpU(  s1, s2 )              strcmp(  s1, s2 )
  #define strcpyU(  s1, s2 )              strcpy(  s1, s2 )
  #define strcspnU( s1, s2 )              strcspn( s1, s2 )
  #ifdef SAPonNT
    #define _strcmpiU(  s1, s2 )          _strcmpi(  s1, s2 )
    #define strcmpiU(   s1, s2 )          _strcmpi(  s1, s2 )
    #define _stricmpU(  s1, s2 )          _stricmp(  s1, s2 )
    #define stricmpU(   s1, s2 )          _stricmp(  s1, s2 )
    #define _strnicmpU( s1, s2, n )       _strnicmp( s1, s2, n )
    #define strnicmpU(  s1, s2, n )       _strnicmp( s1, s2, n )
    #define _strdupU(   s1 )              _strdup( s1 )
    #define strdupU(    s1 )              _strdup( s1 )
  #elif defined ( SAPonOS400 )
    #define strcmpiU( s1, s2 )           strcasecmpU(  s1, s2 )
    #define stricmpU( s1, s2 )           strcasecmpU(  s1, s2 )
    #define strnicmpU( s1, s2, n )       strncasecmpU( s1, s2, n )
    #define strdupU( s1 )                strdup(s1 )
  #else
    #define strdupU(s1)                   strdup(s1)
  #endif
  #define strlenU(s)                      strlen(s)
  #define strncatU( s1, s2, n )           strncat( s1, s2, n )
  #define strncmpU( s1, s2, n )           strncmp( s1, s2, n )
  #define strncpyU( s1, s2, n )           strncpy( s1, s2, n )
  #define strpbrkU( s1, s2 )              strpbrk( s1, s2 )
  #define strspnU(  s1, s2 )              strspn(  s1, s2 )
  #define strstrU(  s1, s2 )              strstr(  s1, s2 )
  #define strtodU(  s,  end )             strtod(  s,  end )
  #define strtokU(  s1, s2 )              strtok(  s1, s2 )
  #ifndef SAPonNT  /* strtok_r does not exist on NT */
    #define strtok_rU( s1, s2, ptr )      strtok_r( s1, s2, ptr )
  #endif
  #define strtolU(  s,  end, base )       strtol(  s,  end, base )
  #define strtoulU( s,  end, base )       strtoul( s,  end, base )
  #ifdef SAPonNT
    #define strtollU(  s,  end, base )    _strtoi64(  s,  end, base )
    #define strtoullU( s,  end, base )    _strtoui64( s,  end, base )
  #else
    /* ATTENTION: strtoll() and strtoull() do not yet exist on some platforms,
     * e.g. HP-UX 11.00. */
    #define strtollU(  s,  end, base )    strtoll(  s,  end, base )
    #define strtoullU( s,  end, base )    strtoull( s,  end, base )
  #endif

#else /* Now SAPwithUNICODE */

 #if defined(SAP_UC_is_wchar)
   BEGIN_NS_STD_C_HEADER
    #define strcatU(  s1, s2 )              wcscat(  s1, s2 )
    #ifdef SAPonNT    /* Cast to avoid warning (d025846) */
    #define strchrU(  s,  c  )              wcschr(  s,  (wchar_t)(c) )
      #define strrchrU( s1, c  )            wcsrchr( s1, (wchar_t)(c) )
    #else
      #define strchrU(  s,  c  )            wcschr(  s,  c  )
      #define strrchrU( s1, c  )            wcsrchr( s1, c  )
    #endif
    #define strcmpU(  s1, s2 )              wcscmp(  s1, s2 )
    #define strcpyU(  s1, s2 )              wcscpy(  s1, s2 )
    #define strcspnU( s1, s2 )              wcscspn( s1, s2 )
    #ifdef SAPonNT
      #define _strcmpiU(  s1, s2 )          _wcsicmp(  s1, s2 )
      #define strcmpiU(   s1, s2 )          _wcsicmp(  s1, s2 )
      #define _stricmpU(  s1, s2 )          _wcsicmp(  s1, s2 )
      #define stricmpU(   s1, s2 )          _wcsicmp(  s1, s2 )
      #define _strnicmpU( s1, s2, n )       _wcsnicmp( s1, s2, n )
      #define strnicmpU(  s1, s2, n )       _wcsnicmp( s1, s2, n )
      #define _strdupU(   s1 )              _wcsdup(   s1 )
      #define strdupU(    s1 )              _wcsdup(   s1 )
    #else
      externC SAP_UC * SAPU16_FUNC(strdupU)(const SAP_UC *);
      #ifdef SAPwithU16LIBLinked
        #define strdupU( s1 )               strdupU16( s1 )
      #endif
      #if defined(SAPonOS400)
        #define strcmpiU( s1, s2 )           strcasecmpU(  s1, s2 )
        #define stricmpU( s1, s2 )           strcasecmpU(  s1, s2 )
        #define strnicmpU( s1, s2, n )       strncasecmpU( s1, s2, n )
      #endif /* SAPonOS400 */
    #endif
    #define strlenU(s)                      wcslen(s)
    #define strncatU( s1, s2, n )           wcsncat( s1, s2, n )
    #define strncmpU( s1, s2, n )           wcsncmp( s1, s2, n )
    #define strncpyU( s1, s2, n )           wcsncpy( s1, s2, n )
    #define strpbrkU( s1, s2 )              wcspbrk( s1, s2 )
    #define strspnU(  s1, s2 )              wcsspn(  s1, s2 )
    #ifdef SAPonLIN
      #define strstrU(  s1, s2 )            wcsstr(  s1, s2 )
    #else
      #define strstrU(  s1, s2 )            wcswcs(  s1, s2 )
    #endif
    #define strtodU( s, end )               wcstod( s, end )
    #if defined (SAPonNT)
      #define strtokU( s1, s2 )             wcstok( s1, s2 )
      /* strtok_r does not exist on NT */
    #else
      externC SAP_UC * CDCL_U SAPU16_FUNC(strtokU)(   SAP_UC *, const SAP_UC * );
      externC SAP_UC * CDCL_U SAPU16_FUNC(strtok_rU)( SAP_UC *, const SAP_UC *, SAP_UC ** );
      #ifdef SAPwithU16LIBLinked
        #define strtokU(   s1, s2 )      strtokU16(   s1, s2 )
        #define strtok_rU( s1, s2, p )   strtok_rU16( s1, s2, p )
      #endif
    #endif
    #define strtolU(  s, end, base )        wcstol(  s, end, base )
    #define strtoulU( s, end, base )        wcstoul( s, end, base )
    #ifdef SAPonNT
      #define strtollU(  s, end, base )     _wcstoi64(  s, end, base )
      #define strtoullU( s, end, base )     _wcstoui64( s, end, base )
    #else
      /* ATTENTION: strtoll() and strtoull() do not yet exist on some platforms,
       * e.g. HP-UX 11.00. */
      #define strtollU(  s, end, base )     wcstoll(  s, end, base )
      #define strtoullU( s, end, base )     wcstoull( s, end, base )
    #endif
   END_NS_STD_C_HEADER

  #elif defined(SAP_UC_is_UTF16_without_wchar)
    BEGIN_NS_STD_C_HEADER
      externC SAP_UC * SAPU16_FUNC(strcatU) (       SAP_UC *, const SAP_UC * );
      externC size_tU  SAPU16_FUNC(strcspnU)( const SAP_UC *, const SAP_UC * );
      externC SAP_UC * SAPU16_FUNC(strdupU) ( const SAP_UC *                 );
      externC size_tU  SAPU16_FUNC(strlenU) ( const SAP_UC *                 );
      externC SAP_UC * SAPU16_FUNC(strncatU)(       SAP_UC *, const SAP_UC *, size_tU );
      externC int      SAPU16_FUNC(strncmpU)( const SAP_UC *, const SAP_UC *, size_tU );
      externC SAP_UC * SAPU16_FUNC(strncpyU)(       SAP_UC *, const SAP_UC *, size_tU );
      externC SAP_UC * SAPU16_FUNC(strpbrkU)( const SAP_UC *, const SAP_UC * );
      externC SAP_UC * SAPU16_FUNC(strrchrU)( const SAP_UC *,       int );
      externC size_tU  SAPU16_FUNC(strspnU) ( const SAP_UC *, const SAP_UC * );
      externC SAP_UC * SAPU16_FUNC(strstrU) ( const SAP_UC *, const SAP_UC * );
      externC double   SAPU16_FUNC(strtodU) ( const SAP_UC *, SAP_UC **      );
      externC SAP_UC * SAPU16_FUNC(strtokU) (       SAP_UC *, const SAP_UC * );
      externC SAP_UC * SAPU16_FUNC(strtok_rU)(      SAP_UC *, const SAP_UC *, SAP_UC **);
      externC          long SAPU16_FUNC(strtolU) ( const SAP_UC *, SAP_UC **, int );
      externC unsigned long SAPU16_FUNC(strtoulU)( const SAP_UC *, SAP_UC **, int );
      /* ATTENTION: strtoll() and strtoull() do not yet exist on some platforms,
       * e.g. HP-UX 11.00.  */
      externC          long long SAPU16_FUNC(strtollU) ( const SAP_UC *, SAP_UC **, int );
      externC unsigned long long SAPU16_FUNC(strtoullU)( const SAP_UC *, SAP_UC **, int );
      #ifdef SAPwithU16LIBLinked
        externC SAP_UC * SAPU16_FUNC(strchrU) ( const SAP_UC *, int );
        externC int      SAPU16_FUNC(strcmpU) ( const SAP_UC *, const SAP_UC * );
        externC SAP_UC * SAPU16_FUNC(strcpyU) (       SAP_UC *, const SAP_UC * );
        #define strchrU( s1, c )        strchrU16( s1, c)
        #define strcmpU( s1, s2 )       strcmpU16( s1, s2 )
        #define strcpyU( s1, s2 )       strcpyU16( s1, s2 )

        #define strcatU(   s1, s2 )     strcatU16(   s1, s2 )
        #define strcspnU(  s1, s2 )     strcspnU16(  s1, s2 )
        #define strdupU(   s1 )         strdupU16(   s1 )
        #define strlenU(   s1 )         strlenU16(   s1 )
        #define strncatU(  s1, s2, n )  strncatU16(  s1, s2, n )
        #define strncmpU(  s1, s2, n )  strncmpU16(  s1, s2, n )
        #define strncpyU(  s1, s2, n )  strncpyU16(  s1, s2, n )
        #define strpbrkU(  s1, s2 )     strpbrkU16(  s1, s2 )
        #define strrchrU(  s1, c )      strrchrU16(  s1, c )
        #define strspnU(   s1, s2 )     strspnU16(   s1, s2 )
        #define strstrU(   s1, s2 )     strstrU16(   s1, s2 )
        #define strtodU(   s, end )     strtodU16(   s, end )
        #define strtokU(   s1, s2 )     strtokU16(   s1, s2 )
        #define strtok_rU( s1, s2, p )  strtok_rU16( s1, s2, p )
        #define strtolU(   s, end, base )     strtolU16(   s, end, base )
        #define strtoulU(  s, end, base )     strtoulU16(  s, end, base )
        #define strtollU(  s, end, base )     strtollU16(  s, end, base )
        #define strtoullU( s, end, base )     strtoullU16( s, end, base )
      #endif
     END_NS_STD_C_HEADER
  #endif
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h - functions for string handling: conversion to numeric types
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define atoiU(s)                   atoi(s)
  #define atofU(s)                   atof(s)
  #define atolU(s)                   atol(s)
  #if defined(SAPonNT)
    #define atollU(s)                _atoi64(s)
  #else
    #define atollU(s)                atoll(s)
  #endif /* !SAPonNT */

#else  /* Now SAPwithUNICODE */
 #if defined(SAP_UC_is_wchar)

  #define atoiU(s)                   ((int)wcstol(s, (SAP_UC **)0, 10))
  #define atofU(s)                   wcstod(s, (SAP_UC **)0)
  #define atolU(s)                   wcstol(s, (SAP_UC **)0, 10)
  #if defined(SAPonNT)
    #define atollU(s)                _wtoi64(s)
  #else
    #define atollU(s)                wcstoll(s, (SAP_UC **)0, 10)
  #endif /* !SAPonNT */

 #elif defined(SAP_UC_is_UTF16_without_wchar)

  #define atoiU(s)                   ((int)strtolU(s, (SAP_UC **)0, 10))
  #define atofU(s)                   strtodU(s, (SAP_UC **)0)
  #define atolU(s)                   strtolU(s, (SAP_UC **)0, 10)
  #define atollU(s)                  strtollU(s, (SAP_UC **)0, 10)

 #endif
#endif

/*-----------------------------------------------------------------------------
 * sapuc.h - further functions for string handling
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define getoptU(ac, av, op)        getopt(ac, av, op)
  /* In NT's C runtime lib, there is no getopt.
   * There are several getopt clones in the R/3 sources, and for NT the
   * obove #define is necessary in order to be able to use such a clone
   */
  #define optargU                    optarg

#else /* Now SAPwithUNICODE */

  externC int CDCL_U getoptU(int argc, SAP_UC * const argv[], const SAP_UC * optstr);

  /* __SAP_DLL_DECLSPEC for NT, as optargU is data pointer. See more comment below. */
  externC __SAP_DLL_DECLSPEC SAP_UC *optargU;

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h - Memory operations
 *
 * The macros memcmpR(), memcpyR(), memmoveR(), etc. should  be
 * used in those cases where the length parameter counts the number
 * of bytes even in a Unicode system.
 *
 * The ..R function names can be used in function pointer expressions
 * directly as they are defined as macros without parameter list.
 * The ..U function names are available both as macros and functions.
 * Normally the macro is used; if the function name is to be used in a
 * function pointer expression, #undef the macro first.
 * The functions you get then are less perfomant than the macros.
 *----------------------------------------------------------------------------*/
#define mallocR                   malloc
#define reallocR                  realloc
#define callocR                   calloc
#define memcmpR                   memcmp
#if defined(SAPonOS400) && defined(__LLP64_IFC__) && defined(USE_CPYBYTES)
#define memcpyR                   _CPYBYTES
#else
#define memcpyR                   memcpy
#endif
#define memmoveR                  memmove
#define memchrR                   memchr
#define memsetR                   memset
#define bzeroR                    bzero

/* available as function: */
BEGIN_NS_STD_C_HEADER
  externC SAP_CHAR * CDCL_U mallocU  ( size_tU );
  externC SAP_CHAR * CDCL_U reallocU (       SAP_CHAR *,                   size_tU );
  externC SAP_CHAR * CDCL_U callocU  (       size_t,                       size_tU );
  externC int        CDCL_U memcmpU  ( const SAP_CHAR *, const SAP_CHAR *, size_tU );
  externC SAP_CHAR * CDCL_U memcpyU  (       SAP_CHAR *, const SAP_CHAR *, size_tU );
  externC SAP_CHAR * CDCL_U memmoveU (       SAP_CHAR *, const SAP_CHAR *, size_tU );
  externC SAP_CHAR * CDCL_U memchrU  ( const SAP_CHAR *,       int,        size_tU );
  externC SAP_CHAR * CDCL_U memsetU  (       SAP_CHAR *,       int,        size_tU );
END_NS_STD_C_HEADER

#ifndef SAPwithUNICODE

  #define mallocU( len )           ((SAP_CHAR *)malloc( len ))
  #define reallocU( s,      len )  ((SAP_CHAR *)realloc( s,      len ))
  #define callocU(  number, len )  ((SAP_CHAR *)calloc(  number, len ))
  #define memcmpU(  s1, s2, len )               memcmp(  s1, s2, len )
  #if defined(SAPonOS400) && defined(__LLP64_IFC__) && defined(USE_CPYBYTES)
    #define memcpyU(  s1, s2, len )  (_CPYBYTES(  s1, s2, len ))
  #else
    #define memcpyU(  s1, s2, len )  ((SAP_CHAR *)memcpy(  s1, s2, len ))
  #endif
  #define memmoveU( s1, s2, len )  ((SAP_CHAR *)memmove( s1, s2, len ))
  #define memchrU(  s,  c,  len )  ((SAP_CHAR *)memchr(  s, U_CHAR(c), len ))
  #define memsetU(  s,  c,  len )  ((SAP_CHAR *)memset(  s, U_CHAR(c), len ) )

  #define bzeroU( s, len )         bzero( s, len )

#else /* Now SAPwithUNICODE */

  #define mallocU(       len )  ((SAP_CHAR *) malloc(       (len)*SAP_UC_LN))
  #define reallocU( s,   len )  ((SAP_CHAR *) realloc( s,   (len)*SAP_UC_LN))
  #define callocU(  num, len )  ((SAP_CHAR *) calloc(  num, (len)*SAP_UC_LN))

  #if defined(SAP_UC_is_wchar)                           && \
      ( defined(SAPonOS400)                              || \
        defined(SAPonOSF1)                               || \
        defined(SAPonLIN)                                || \
        (defined(SAPonNT)  && defined(__cplusplus))      || \
        defined(SAPonAIX)                                  )
      /* on these platforms there are wmem..() functions available */
      #define memcmpU(  s1, s2, len )  wmemcmp(  s1, s2, len )
      #define memcpyU(  s1, s2, len )  wmemcpy(  s1, s2, len )
      #define memmoveU( s1, s2, len )  wmemmove( s1, s2, len )
      #define memchrU(  s,  wc, len )  wmemchr(  s,  wc, len )
      #define memsetU(  s,  wc, len )  wmemset(  s,  wc, len )

      #if defined(SAPonAIX) &&  _XOPEN_SOURCE-500 != 0
        /* The prototypes are not visible on AIX 4.3 /usr/include/wchar.h 1.13.2.2 */
        externC int wmemcmp(const wchar_t *, const wchar_t *, size_t);
        externC wchar_t *wmemcpy(wchar_t *, const wchar_t *, size_t);
        externC wchar_t *wmemmove(wchar_t *, const wchar_t *, size_t);
        externC wchar_t *wmemchr(const wchar_t *, wchar_t, size_t);
        externC wchar_t *wmemset(wchar_t *, wchar_t, size_t);
      #endif
  #else  /* SAP_UC is not wchar_t or no wmem...() functions are available:
          * use own implementations; either macros or the external functions
          * declared above or functions from libsapu16.
          */
    #define          memcpyU(  s1, s2, len )              \
         ((SAP_CHAR*)memcpy(   s1, s2, (len)*SAP_UC_LN ))
    #define          memmoveU( s1, s2, len )              \
         ((SAP_CHAR*)memmove(  s1, s2, (len)*SAP_UC_LN ))
    #if defined(SAPwithINT_BIGENDIAN)
      #define       memcmpU(   s1, s2, len )              \
                    memcmp(    s1, s2, (len)*SAP_UC_LN )
    #endif
    #ifdef SAPwithU16LIBLinked
     BEGIN_NS_STD_C_HEADER
      /* Use the functions from libsapu16. (Thus the kernel does not need
       * to export.) */
      externC SAP_CHAR * SAPU16_FUNC(memchrU)( const SAP_CHAR *, int, size_tU );
      externC SAP_CHAR * SAPU16_FUNC(memsetU)(       SAP_CHAR *, int, size_tU );
      #define memchrU( s1, c, n )   memchrU16( s1, c, n )
      #define memsetU( s1, c, n )   memsetU16( s1, c, n )
      #if !defined(SAPwithINT_BIGENDIAN)
        externC int SAPU16_FUNC(memcmpU) ( const SAP_CHAR *, const SAP_CHAR *, size_tU );
        #define memcmpU( s1, s2, n )    memcmpU16( s1, s2, n )
      #endif
     END_NS_STD_C_HEADER
    #endif /* SAPwithU16LIBLinked */
  #endif /* different platforms */

  #define bzeroU( s, len )             memsetU( s, (WINT_T)0, len )

#endif /* SAPwithUNICODE */

#if defined(SAPccQ) && defined(SAPwithUNICODE)

  /* for len check ccQ requires that the memU... functions are
     declared as functions
     therefore undef macros to make function declarations behind visible */
  #undef mallocU
  #undef reallocU
  #undef callocU
  #undef memcpyU
  #undef memmoveU
  #undef memchrU
  #undef memsetU
  #undef memcmpU

  /* treat offesetof as byte length */
  #undef offsetof
  #define offsetof(s,m)   ((size_tR)1)

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h - Functions that handle type char pointers (no string handling):
 *          1. functions that pass a type char pointer
 *              to the non-unicode world
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define accessU(path, amode)         access(path, amode)
  #define chdirU(path)                 chdir(path)
  #define fdopenU(filedes, mode)       fdopen(filedes, mode)
  #define fopenU(path, mode)           fopen(path, mode)
  #if !defined(SAPonNT) && !defined(SAPonOSF1)
    #define fopen64U(path, mode)       fopen64(path, mode)  /* rb002 */
  #endif
  #define freopenU(path, mode, stream) freopen(path, mode, stream)
  #define gethostnameU(name, len)      gethostname(name, len)
  #define opendirU(path)               opendir(path)
      /* For NT, opendir and readdir are defined in ntport.h, ntuxport.c */
  #ifdef SAPonNT
    #define _openU                     _open
    #define openU                      _open
  #else
    #define openU                      open
  #endif
  #define perrorU(program)             perror(program)
  #define removeU(path)                remove(path)
  #define renameU(from ,to)            rename(from, to)
  #define systemU(s)                   system(s)
  #define strftimeU(s, maxsize, format, tptr) \
          strftime (s, maxsize, format, tptr)

  #ifdef SAPonNT
    #define _utimeU(path, time)         _utime(path, time)
    #define utimeU(path, time)          _utime(path, time)
    #define _mkdirU(path)               _mkdir(path)
    #define _creatU(path, mode)         _creat(path, mode)
    #define creatU(path, mode)          _creat(path, mode)
    #define _chmodU(path, mode)         _chmod(path, mode)
    #define chmodU(path, mode)          _chmod(path, mode)
    #define _popenU(command, type)      _popen(command, type)
    #define popenU(command, type)       _popen(command, type)
    #define _rmdirU(path)               _rmdir(path)
    #define rmdirU(path)                _rmdir(path)
    #define _unlinkU(path)              _unlink(path)
    #define unlinkU(path)               _unlink(path)
  #else
    #define utimeU(path, time)          utime(path, time)
    #define mkdirU(path, mode)          mkdir(path, mode)
    #define mkfifoU(path, mode)         mkfifo(path, mode)
    #define creatU(path, mode)          creat(path, mode)
    #define chmodU(path, mode)          chmod(path, mode)
    #define popenU(command, type)       popen(command, type)
    #define rmdirU(path)                rmdir(path)
    #define unlinkU(path)               unlink(path)
  #endif

  #if defined(SAPonUNIX) || defined(SAPonOS400)
    #define linkU(path1, path2)         link(path1, path2)
    #define symlinkU(path1, path2)      symlink(path1, path2)
    #define readlinkU(path, buf, size)  readlink(path, buf, size)
    #define chownU(path, owner, group)  chown(path, owner, group)
  #endif

  #if defined(SAPonHP_UX)
    #define shl_findsymU(handle, sym, type, value) \
                                       shl_findsym(handle, sym, type, value)
    #define shl_loadU(path, fl, addr)  shl_load(path, fl, addr)
  #endif
  #if defined(SAPonSUN) || defined(SAPonSINIX) || defined(SAPonOSF1) \
        || defined (SAPonLIN) || defined(SAPonAIX) || defined(SAPonPTX) \
        || ( defined(SAPonHP_UX) && defined(SAPwith64_BIT) ) \
        || defined (SAPonDARW)
    #define dlopenU(path, mode)        dlopen(path, mode)
    #define dlsymU(handle, name)       dlsym(handle, name)
    #define dlerrorU                   dlerror
  #endif
  #if defined(SAPonOS390)
    #define dllloadU(path)             dllload(path)
    #define dllqueryfnU(handle, sym)   dllqueryfn(handle, sym)
  #endif


#else  /* Now SAPwithUNICODE */

  #if defined(SAPonNT)
    #define accessU(path, amode)         _waccess(path, amode)
  #else
    externC int  accessU  ( const SAP_UC *path,    int  mode );
  #endif

  BEGIN_NS_STD_C_HEADER
    #ifdef SAPonNT
      #define fdopenU(fildes, type)	 _wfdopen(fildes, type)
    #else
      externC FILE * fdopenU  ( int filedes, const SAP_UC *type );
    #endif

    externC FILE * CDCL_U fopenU   ( const SAP_UC *path,    const SAP_UC *mode );
    externC FILE * CDCL_U freopenU ( const SAP_UC *path,    const SAP_UC *mode,
  	      FILE   *stream );
    #if !defined(SAPonNT) && !defined(SAPonOSF1)
      externC FILE * CDCL_U fopen64U( const SAP_UC *path, const SAP_UC *mode ); /* rb002 */
    #endif
  END_NS_STD_C_HEADER

  externC int CDCL_U openU   ( const SAP_UC *wpath, int oflag, ... );

  externC int CDCL_U gethostnameU( SAP_UC * name, size_tU len );
  #ifdef SAPonNT
    #define opendirU(path)               opendir(path)
  #else
    #if !defined(SAPonHP_UX) || \
        (defined(SAPonHP_UX) && defined (_INCLUDE_POSIX_SOURCE))
      externC DIR   * CDCL_U opendirU ( const SAP_UC *path );
    #endif
  #endif

  BEGIN_NS_STD_C_HEADER
    externC void   CDCL_U perrorU  ( const SAP_UC *program );
    #ifdef SAPonNT
      #define removeU(path)	_wremove(path)
      #define renameU(from,to)	_wrename(from,to)
    #else
      externC int    removeU  ( const SAP_UC *path );
      externC int    renameU  ( const SAP_UC *from,    const SAP_UC *to );
    #endif
  END_NS_STD_C_HEADER

  #if defined(SAPonNT)
    #define _utimeU(wpath, time)         _wutime(wpath, time)
    #define utimeU(wpath, time)          _wutime(wpath, time)
    #define _chdirU(wpath)               _wchdir(wpath)
    #define chdirU(wpath)                _wchdir(wpath)
    #define _mkdirU(wpath)               _wmkdir(wpath)
    #define _creatU(wpath, mode)         _wcreat(wpath, mode)
    #define creatU(wpath, mode)          _wcreat(wpath, mode)
    #define _chmodU(wpath, mode)         _wchmod(wpath, mode)
    #define chmodU(wpath, mode)          _wchmod(wpath, mode)
    #define _openU                       openU
    #define _popenU(wcommand, wtype)     _wpopen(wcommand, wtype)
    #define popenU(wcommand, wtype)      _wpopen(wcommand, wtype)
    #define _rmdirU(wpath)               _wrmdir(wpath)
    #define rmdirU(wpath)                _wrmdir(wpath)
    #define systemU(wcs)                 _wsystem(wcs)
    #define _unlinkU(wpath)              _wunlink(wpath)
    #define unlinkU(wpath)               _wunlink(wpath)
  #else
    #if (!defined (SAPonHP_UX)) || defined (_MODE_T)
      externC int mkdirU( const SAP_UC *wpath, mode_t mode );
      externC int mkfifoU(const SAP_UC *wpath, mode_t mode );
      externC int chmodU( const SAP_UC *wpath, mode_t mode );
      externC int creatU( const SAP_UC *wpath, mode_t mode );
    #endif
    externC int chdirU( const SAP_UC *wpath );
    #if defined(SAPonUNIX) || defined(SAPonOS400)
      struct utimbuf;
      externC int utimeU( const SAP_UC *wpath, const struct utimbuf *time );
    #endif
    #ifndef SAPonOS400
      externC NS_STD_C_HEADER FILE *popenU( const SAP_UC *wcomm, const SAP_UC *wtype );
    #endif
    externC int rmdirU  ( const SAP_UC *wpath );
    externC int systemU ( const SAP_UC *wcs );
    externC int unlinkU ( const SAP_UC *path );
  #endif

  BEGIN_NS_STD_C_HEADER
    #if defined(SAPonNT) || defined(SAPonOS400)
      #define strftimeU(s, maxs, format, tptr) wcsftime(s, maxs, format, tptr)
    #elif defined(SAPonUNIX)
      #ifndef CPP_SUPPRESS_TM_FORWARD
        struct tm;
      #endif
      externC size_t strftimeU( SAP_UC *wcs, size_t len, const SAP_UC *format,
                                const struct tm *tmdate );
      /* OSF1 and AIX 4.3: Depending on compiler switches, there are different
       * wcsftime prototypes in wchar.h;  for now: use our own implementation
       */
    #else
      #error "strftimeU() not yet implemented on this platform"
    #endif
  END_NS_STD_C_HEADER

  #if defined(SAPonUNIX) || defined(SAPonOS400)
    externC int linkU     ( const SAP_UC *path1, const SAP_UC *path2 );
    externC int symlinkU  ( const SAP_UC *path1, const SAP_UC *path2 );
    externC int readlinkU ( const SAP_UC *path,  SAP_UC *buf,
                            NS_STD_C_HEADER size_t size );
    externC int chownU    ( const SAP_UC *path,  SAP_UINT owner,
                            SAP_UINT group );
  #endif

  #if defined(SAPonAIX) && defined(_ALL_SOURCE)
    externC int *loadU( const SAP_UC *wfilepath, uint flags,
                        const SAP_UC *wlibpath );
  #endif
  #if defined(SAPonHP_UX) && defined(_DL_INCLUDED)
    externC shl_t shl_loadU( const SAP_UC *path, int  flags, long address );
    externC int shl_findsymU( shl_t *handle, const SAP_UC *sym,
                              short  type,   void *value );

  #endif
  #if ( defined(SAPonSUN) || defined(SAPonSINIX) || defined(SAPonOSF1) || \
        defined(SAPonLIN) || defined(SAPonAIX) ) || \
        ( defined(SAPonHP_UX) && defined(SAPwith64_BIT) )
    externC void *   dlopenU( const SAP_UC * path, int mode );
    externC void *   dlsymU( void *handle, const SAP_UC *name );
    externC SAP_UC * dlerrorU( void );
  #endif /* different platforms */
  #if defined(SAPonOS390)
    externC void *   dllloadU( const SAP_UC *path );
    externC void *   dllqueryfnU( dllhandle *handle, const SAP_UC *sym );
  #endif /* SAPonOS390 */


#endif


#if defined(SAPonOS400) || defined(SAPwithPASE400)
    /* stuefe: for AS/400 and PASE we popenU->as4_popenU, pclose->as4_pclose
     * (Notice that this in itself isn't sufficient though, you still need to
     * use as4_pfgetsU/AS4_pfreadU instead of fgetsU and freadU, otherwise
     * you'll get EBCDIC garbage
     * Notice that these function prototypes are copies from as4exec.h */
    externC FILE* as4_popenU ( const SAP_UC* command, const SAP_UC* type );
    externC int as4_pclose ( FILE* f );
    externC size_t as4_pfreadU ( SAP_UC* buffer, size_t size, size_t count,
            FILE* f );
    externC SAP_UC* as4_pfgetsU ( SAP_UC* string, int n, FILE* f );
    #undef popenU
    #define popenU as4_popenU
    #define pclose as4_pclose
#endif



/*-----------------------------------------------------------------------------
 * sapuc.h - Functions that handle type char pointers:
 *          2. functions that return a type char pointer
 *             from the non-unicode world
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define asctimeU(timeptr)                 asctime(timeptr)
  #define ctimeU(timer)                     ctime(timer)
  #define strerrorU(errnum)                 strerror(errnum)
  #define setlocaleU(cat, locale)           setlocale(cat, locale)
  #define tmpnamU(s)                        tmpnam(s)
  #define tempnamU(s, t)                    tempnam(s, t)
  #define dirnameU(path)                    dirname(path)
  #define basenameU(path)                   basename(path)

  #if defined(SAPonNT)
    #define _ecvtU(value, ndig, dptr, sign) _ecvt(value, ndig, dptr, sign)
    #define ecvtU(value, ndig, dptr, sign)  _ecvt(value, ndig, dptr, sign)
  #elif defined(SAPonOS400) || defined(SAPonLIN) || defined(SAPonPTX)
    #define ecvtU(value, ndig, dptr, sign)  nlsui_ecvt(value, ndig, dptr, sign)
    externC char *nlsui_ecvt(double value, int ndigit, int *decpt, int *sign);
  #else
    #define ecvtU(value, ndig, dptr, sign)  ecvt(value, ndig, dptr, sign)
  #endif

  #if defined(SAPonNT)
    #define _mktempU(template)              _mktemp(template)
    #define mktempU(template)               _mktemp(template)
    #define _getcwdU(buf, size)             _getcwd(buf, size)
    #define getcwdU(buf, size)              _getcwd(buf, size)

  #else
    #define asctime_rU(timeptr, bufptr)     asctime_r(timeptr, bufptr)
    #define ctime_rU(timer, bufptr)         ctime_r(timer, bufptr)
    #define mktempU(template)               mktemp(template)
    #define getcwdU(buf, size)              getcwd(buf, size)
    #define ttynameU(filedes)               ttyname(filedes)

  #endif  /* different platforms */

#else  /* Now SAPwithUNICODE */

  #if defined (SAPonNT)

    BEGIN_NS_STD_C_HEADER
      #define asctimeU(timeptr)               _wasctime(timeptr)
      #define ctimeU(timer)                   _wctime(timer)
      #define _ecvtU(value, ndig, dptr, sign) ecvtU(value, ndig, dptr, sign)
      externC SAP_UC * CDCL_U ecvtU( double value, int ndig, int *dptr, int *sign );
    END_NS_STD_C_HEADER

    #define _getcwdU(buf, size)             _wgetcwd(buf, size)
    #define getcwdU(buf, size)              _wgetcwd(buf, size)
    #define setlocaleU(category, locale)    _wsetlocale(category, locale)
    BEGIN_NS_STD_C_HEADER
      externC SAP_UC * CDCL_U strerrorU ( int errnum );
    END_NS_STD_C_HEADER
    #define tmpnamU(cbuf)                   _wtmpnam(cbuf)
    #define tempnamU(cbuf, pref)            _wtempnam(cbuf, pref)
    #define dirnameU(path)                  dirname(path)
    #define basenameU(path)                 basename(path)
    #define _mktempU(template)              _wmktemp(template)
    #define mktempU(template)               _wmktemp(template)

  #elif defined(SAPonUNIX) || defined(SAPonOS400)

    BEGIN_NS_STD_C_HEADER
      #ifndef CPP_SUPPRESS_TM_FORWARD
          struct tm;
      #endif
      externC SAP_UC *asctimeU(   const struct tm *timeptr );
      externC SAP_UC *asctime_rU( const struct tm *timeptr, SAP_CHAR * bufptr );

      externC SAP_UC *ctimeU  ( const time_t *timer );
      externC SAP_UC *ctime_rU( const time_t *timer, SAP_CHAR * bufptr );
      externC SAP_UC *ecvtU ( double value, int ndig, int *dptr, int *sign );
    END_NS_STD_C_HEADER

    externC SAP_UC *getcwdU   ( SAP_UC *wbuf, size_tU size );
    externC SAP_UC *setlocaleU( int category, const SAP_UC *w_inPtr);
    BEGIN_NS_STD_C_HEADER
      externC SAP_UC *strerrorU ( int errnum );
    END_NS_STD_C_HEADER
    externC SAP_UC *tmpnamU   ( SAP_UC *wbuf );
    externC SAP_UC *tempnamU  ( SAP_UC *dir, SAP_UC *prefix );
    externC SAP_UC *mktempU   ( SAP_UC *templ ); /* 'template' is C++ keeyword*/
    externC SAP_UC *ttynameU  ( int filedes  );
    externC SAP_UC *dirnameU  ( SAP_UC *path );
    externC SAP_UC *basenameU ( SAP_UC *path );

  #else
    #error "ctimeU() etc. not yet implemented on this platform"
  #endif /* different platforms */

#endif
/*-----------------------------------------------------------------------
 * Continuous local time functionality (d023243, 12/2001)
 *
 * The C-Lib Functions
 * - localtime ( time_t -> tm )
 * - mktime    ( tm -> time_t )
 * - ctime     (= asctime(localtime()))
 * are dealing with local times that are discontinuous.
 * In time zones with daylight saving time (dst), the switch from summer
 * to winter time (dst -> non-dst) comes with one hour that is passed
 * through twice ("doubled hour"). One hour with dst, one without.
 * This functions solve the problem of the "doubled hour" by
 * retarding the time and making the time of two hours to only one hour.
 * See file .../src/flat/contloct.c
 *----------------------------------------------------------------------- */
#if defined(USE_CONT_LOCTIME)
  #if defined(CPP_USE_NEW_C_HEADERS)
    #include <ctime>
  #else
    #include <time.h>
  #endif
  externC struct tm* CDCL_U localtime_cont(const time_t * t);
  externC struct tm* CDCL_U localtime_cont_r(const time_t * t, struct tm* res);
  externC time_t CDCL_U mktime_cont( struct tm * tm_in);
  externC SAP_CHAR* CDCL_U ctime_cont(const time_t* timer);
  externC SAP_CHAR* CDCL_U ctime_cont_r(const time_t* timer, SAP_CHAR* res);
  externC int IsDoubleInterval(time_t t);
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h - Functions that handle type char pointers:
 *
 *   3. I/O streams
 *
 *     including the printf and scanf function families
 *     and the fputc and fgetc function families
 *
 *     On a Unicode system, the ...U() which write to disk or read from disk
 *     convert between the Unicode format used in the memory and UTF-8.
 *     The ...R() functions read and write raw data without any conversion.
 *
 *     Some details of these functions are documented in flat/sapu16doc.htm
 *---------------------------------------------------------------------------*/
#define fgetcR(stream)                   fgetc(stream)
#define getcR(stream)                    getc(stream)
#define ungetcR(c, stream)               ungetc(c, stream)
#define fputcR(rawdata, stream)          fputc(rawdata, stream)
#define putcR(rawdata, stream)           putc(rawdata, stream)
#define fwriteR(rawdata, s, n, stream)   fwrite(rawdata, s, n, stream)
#define freadR( rawdata, s, n, stream)   fread( rawdata, s, n, stream)

#ifdef SAPccQ
  BEGIN_NS_STD_C_HEADER
    externC void * fgetsR  ( void *s, intR n, FILE *f );
    externC int   setvbufR ( FILE *stream, void *buf, int m, size_tR n );
  END_NS_STD_C_HEADER
#else
  #define fgetsR( s, n, stream )         fgets( (char*)(s), n, stream )
  #define setvbufR(stream, buf, m, n )   setvbuf( stream, (char*)(buf), m, n )
#endif

#ifndef SAPwithUNICODE

  #define printfU                        printf
  #define fprintfU                       fprintf
  #define sprintfU                       sprintf
  #define vprintfU(p1, p2)               vprintf(p1, p2)
  #define vfprintfU(p1, p2, p3)          vfprintf(p1, p2, p3)
  #define vsprintfU(p1, p2, p3)          vsprintf(p1, p2, p3)
  #if defined(SAPonNT)
  /* ATTENTION: On NT, snprintfU and vsnprintfU do not write a
   * terminating zero if the output buffer is full. */
    #define snprintfU                    _snprintf
    #define vsnprintfU(p1, p2, p3, p4)   _vsnprintf(p1, p2, p3, p4)
  #elif defined(SAPonOS400)
    /* stuefe: AS/400 non-unicode: QADRT is lacking functions like snprintf etc,
     * so we use our own impl in o4printf.c */
    externC intU as4_snprintfU
        ( SAP_UC* buffer, size_tU count, const SAP_UC* format, ... );
    externC intU as4_vsnprintfU
        ( SAP_UC* buffer, size_tU count, const SAP_UC* format, va_list argptr );
    #define snprintfU           as4_snprintfU
    #define vsnprintfU(a,b,c,d) as4_vsnprintfU(a,b,c,d)
  #else
  /* ATTENTION: The return codes of snprintfU and vsnprintfU are
   * platform dependent and may be different in the Unicode and
   * non-Unicode case. For details see the documentation in flat/sapu16doc.htm.
   */
    #define snprintfU                    snprintf
    #define vsnprintfU(p1, p2, p3, p4)   vsnprintf(p1, p2, p3, p4)
  #endif

  #define scanfU                         scanf
  #define fscanfU                        fscanf
  #define sscanfU                        sscanf

  #define fgetcU(stream)                 fgetc(stream)
  #define getcU(stream)                  getc(stream)
  #define fputcU(c, stream)              fputc(c, stream)
  #define putcU(c, stream)               putc(c, stream)

  #define fgetsU(s, n, stream)           fgets(s, n, stream)
  #define getsU(s)                       gets(s)
  #define fputsU(s, stream)              fputs(s, stream)
  #define putsU(s)                       puts(s)

  #define putcharU(c)                    putchar(c)
  #define getcharU                       getchar

  #define fwriteU(rawdata, s, n, stream)   fwrite(rawdata, s, n, stream)
  #define  freadU(rawdata, s, n, stream)    fread(rawdata, s, n, stream)

  #define setvbufU(stream, buf, mod, n)    setvbuf(stream, buf, mod, n)

#else  /* Now SAPwithUNICODE */

  BEGIN_NS_STD_C_HEADER

    #if defined(SAPonNT) && !defined(SAPccQ)
      /* NT implementation of formatted output functions to array,
         ccQ needs no implementation and uses purely declarative section (same as Unix)
		 to allow PRINTFLIKE comment */
      #define      sprintfU                swprintf
      #define     vsprintfU(p1, p2, p3)    vswprintf(p1, p2, p3)
      #define       sscanfU                swscanf

      /* ATTENTION: On NT, snprintfU and vsnprintfU do not write a
       * terminating zero if the output buffer is full. */
      #define snprintfU                    _snwprintf
      #define vsnprintfU(p1, p2, p3, p4)   _vsnwprintf(p1, p2, p3, p4)

    #elif defined(SAPonOS400)
      /* Implementations in nlsui4.c, nlsui5.c call vvfprintfU16. */
      externC intU  sprintfU( SAP_UC *s, const SAP_UC *format, ... );
      externC intU vsprintfU( SAP_UC *s, const SAP_UC *format, va_list ap );
      externC int   sscanfU( const SAP_UC *s, const SAP_UC *format, ... );

      externC intU  snprintfU( SAP_UC *s, size_t n, const SAP_UC *format, ...);
      externC intU vsnprintfU( SAP_UC *s, size_t n, const SAP_UC *format,
			       va_list ap );

    #else


      externC intU SAPU16_FUNC(sprintfU)(  SAP_UC *s, const SAP_UC *format, ... ) /* PRINTFLIKE2 */;
      externC intU SAPU16_FUNC(vsprintfU)( SAP_UC *s, const SAP_UC *format, va_list ap );
      externC int SAPU16_FUNC(sscanfU)( const SAP_UC *s, const SAP_UC *format, ... ) /* SCANFLIKE2 */;

      /* ATTENTION: The return codes of snprintfU and vsnprintfU are
       * platform dependent and may be different in the Unicode and
       * non-Unicode case. For details see the documentation in flat/sapu16doc.htm .
       */

      externC intU SAPU16_FUNC( snprintfU)( SAP_UC *s, size_t n, const SAP_UC *format, ...) /* PRINTFLIKE3 */;
      externC intU SAPU16_FUNC(vsnprintfU)( SAP_UC *s, size_t n, const SAP_UC *format,
			       va_list ap );
      #ifdef SAPwithU16LIBLinked
        #define   sprintfU     sprintfU16
        #define  vsprintfU    vsprintfU16
        #define    sscanfU      sscanfU16
        #define  snprintfU    snprintfU16
        #define vsnprintfU   vsnprintfU16
      #endif
    #endif

    /* Note on Implementation:
     * For the following printf and scanf functions, we use the
     * implementations in nlsui5.c which call vvfprintfU16.
     * Advantage: We do not need to call GetProcAddress() for
     * variadic functions on NT (which might cause problems).
     * For uniformity, we use the implementations in nlsui5.c
     * on all platforms.
     * Disadvantage: Shared libraries which use one of these functions
     * have to link $(SY)prtlib . */


    externC int CDCL_U   printfU(          const SAP_UC *format, ... ) /* PRINTFLIKE1 */;
    externC int CDCL_U  fprintfU( FILE *s, const SAP_UC *format, ... ) /* PRINTFLIKE2 */;
    externC int CDCL_U  vprintfU(          const SAP_UC *format, va_list ap );
    externC int CDCL_U vfprintfU( FILE *s, const SAP_UC *format, va_list ap );

    externC int CDCL_U   printfU_count_bytes(         size_tR *, const SAP_UC *, ... ) /* PRINTFLIKE2 */;
    externC int CDCL_U  fprintfU_count_bytes( FILE *, size_tR *, const SAP_UC *, ... ) /* PRINTFLIKE3 */;
    externC int CDCL_U  vprintfU_count_bytes(         size_tR *, const SAP_UC *, va_list );
    externC int CDCL_U vfprintfU_count_bytes( FILE *, size_tR *, const SAP_UC *, va_list );


    externC int CDCL_U   scanfU(          const SAP_UC *format, ... ) /* SCANFLIKE1 */; /* Deprecated. */
    externC int CDCL_U  fscanfU( FILE *s, const SAP_UC *format, ... ) /* SCANFLIKE2 */; /* Deprecated. */
    /* fget_lineU, fget_strU, fget_longU, fget_intU and sscanfU
     * should be used instead of scanfU and fscanfU.
     */

    /*************************************************************
     * ATTENTION:
     * Functions like fgetcU, fgetsU, freadU etc. convert from UTF-8
     * to UTF-16. If the input is not valid UTF-8, the functions stop
     * reading, set errno to EILSEQ and return the value for
     * unsuccessful completion. For a different error handling,
     * use fget_lineU, fget_strU, fget_longU, fget_intU.
     * See flat/sapu16doc.htm for details.
     *************************************************************/

    externC int CDCL_U SAPU16_FUNC(fgetcU)( FILE *stream );
    externC int CDCL_U SAPU16_FUNC(fputcU)( int wc,  FILE *stream );
    #ifdef SAPwithU16LIBLinked
      #define  fgetcU( stream )           fgetcU16( stream )
      #define  fputcU( wc, stream )       fputcU16( wc, stream )
    #endif
    #define         getcU( stream )       fgetcU( stream )
    #define         putcU( wc, stream )   fputcU( wc, stream )
    #define getcharU()                    getcU( stdin )
    #define putcharU( wc )                putcU( wc, stdout )

                  /* ungetcU not implemented. ungetwc on NT 4.0 cannot push back
		   * more than two bytes, and moreover there is no UTF-8
		   * locale (March 98). Similar problems on Linux.  */

    externC SAP_UC * CDCL_U SAPU16_FUNC(fgetsU)( SAP_UC *wcs, intU n, FILE *stream );
    externC SAP_UC * CDCL_U SAPU16_FUNC( getsU)( SAP_UC *wcs );
    externC intU     CDCL_U SAPU16_FUNC(fputsU)( const SAP_UC *wcs, FILE *stream );
    externC intU     CDCL_U SAPU16_FUNC( putsU)( const SAP_UC *wcs );

    externC size_t CDCL_U SAPU16_FUNC(freadU)( SAP_CHAR *, size_tU, size_t, FILE * );

    externC size_t CDCL_U SAPU16_FUNC(u16_fwriteU)( const SAP_CHAR *, size_tU, size_t,
					     FILE *, size_t* );

    #ifdef SAPwithU16LIBLinked
      #define    fgetsU( s, n, stream )     fgetsU16( s, n, stream )
      #define     getsU( s )                 getsU16( s )
      #define    fputsU( s, stream )        fputsU16( s, stream )
      #define     putsU( s )                 putsU16( s )
      #define    freadU( s, n, m, stream )  freadU16( s, n, m, stream )
      #define u16_fwriteU( s, n, m, f, i )  u16_fwriteU16( s, n, m, f, i )
    #endif

    #define fwriteU(buf, size, n, stream) u16_fwriteU(buf, size, n, stream, NULL)
    #ifndef SAPccQ
      #define setvbufU(stream, buf, mod, n)  \
              setvbuf(stream, (char*)(buf), mod, (n)*SAP_UC_LN)
             /* Here n counts the number of SAP_CHAR characters; buf may be of
	      * type SAP_CHAR* . The usefulness may be quite limited;
	      * consider using setvbufR instead.
	      */
    #else
      extern int setvbufU( FILE *stream, SAP_CHAR *buf, int mod, size_tU n );
    #endif
  END_NS_STD_C_HEADER


#endif /* SAPwithUNICODE or not */

/*-----------------------------------------------------------------------------
 * sapuc.h - Functions that handle type char pointers:
 *   3a. Functions to avoid fscanf
 *       See flat/sapu16doc.htm for details.
 *----------------------------------------------------------------------------*/
  /* Prototypes for Unicode and non-Unicode */
  externC int CDCL_U SAPU16_FUNC(   fget_strU)( SAP_UC *s, int n, FILE *stream, SAP_CHAR repl_char );
  externC int CDCL_U SAPU16_FUNC(  fget_lineU)( SAP_UC *s, int n, FILE *stream, SAP_CHAR repl_char );
  externC int CDCL_U SAPU16_FUNC(  fget_longU)( long int* ptr, FILE *stream );
  externC int CDCL_U SAPU16_FUNC(   fget_intU)(      int* ptr, FILE *stream );
#ifdef SAPwithU16LIBLinked
  #define  fget_strU(s, n, stream, r)   fget_strU16(s, n, stream, r)
  #define  fget_lineU(s, n, stream, r)  fget_lineU16(s, n, stream, r)
  #define  fget_longU(p, stream)        fget_longU16(p, stream)
  #define  fget_intU(p, stream)         fget_intU16(p, stream)
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h - Functions that handle type char pointers:
 *         4. exec family
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define execlU                         execl
  #define execleU                        execle
  #define execlpU                        execlp
  #define execvU(p1, p2)                 execv(p1, p2)
  #define execveU(p1, p2, p3)            execve(p1, p2, p3)
  #define execvpU(p1, p2)                execvp(p1, p2)
  #ifdef SAPonOS390
    #define spawnU(p1,p2,p3,p4,p5,p6)    spawn(p1,p2,p3,p4,(const char **)(p5),(const char **)(p6))
  #endif

#else  /* Now SAPwithUNICODE */

  #ifdef SAPonUNIX
    externC int execlU ( const SAP_UC *path, const SAP_UC *arg, ... );
    externC int execleU( const SAP_UC *path, const SAP_UC *arg, ... );
    externC int execlpU( const SAP_UC *file, const SAP_UC *arg, ... );
    externC int execvU ( const SAP_UC *path, SAP_UC* const argv[] );
    externC int execveU( const SAP_UC *path, SAP_UC* const argv[],
			 SAP_UC* const wenv[] );
    externC int execvpU( const SAP_UC *file, SAP_UC* const argv[] );
    #ifdef SAPonOS390
     externC int spawnU( const SAP_UC *path,
                         const int     fd_count,
                         const int     fd_map[],
                         const struct  inheritance *inherit,
                         SAP_UC* const argv[],
                         SAP_UC* const wenv[]);
    #endif

  #elif defined(SAPonNT)

    #define execlU                         _wexecl
    #define execleU                        _wexecle
    #define execlpU                        _wexeclp
    #define execvU(p1, p2)                 _wexecv(p1, p2)
    #define execveU(p1, p2, p3)            _wexecve(p1, p2, p3)
    #define execvpU(p1, p2)                _wexecvp(p1, p2)

  #elif defined(SAPonOS400)
    /* exec..() not used on OS400 */

  #else
    #error "exec..U() not yet implemented on this platform"
  #endif /* different platforms */

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h -  Environment handling and main
 *
 * Usage of the mainU() and main3U() macros:
 * The source code looks like this:
 *
 *     int mainU (int argc, SAP_UC *argv[ ] ) { .... }
 *
 *     int main3U (int argc, SAP_UC *argv[ ], SAP_UC *envp[ ] ) { .... }
 *
 * For a documentation of the following macros and an example of
 * their use, see the docu in flat/nlsuidoc.htm:
 *    environU, DECLAREenvironU, GETenvironU, FREEenvironU
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define mainU                          main
  #define main3U                         main

  BEGIN_NS_STD_C_HEADER
    #define getenvU(name)                  getenv(name)
    #define putenvU(s)                     putenv(s)
    #ifdef SAPonNT
      #define _putenvU(s)                  _putenv(s)
    #endif
  END_NS_STD_C_HEADER

  #define environU                       environ
  #ifdef SAPonNT
    #define DECLAREenvironU              short nlsui_env_unused_var
                          /* dummy variable for syntax reasons;
			   * [_]environ is a macro in stdlib.h */
  #else
    #define DECLAREenvironU              extern SAP_UC ** environ
  #endif
  #ifdef SAPonOS400
    #define GETenvironU                  /*CCQ_NO_EFFECT_OK*/ \
                                         ((Qp0zInitEnv() == 0) ? environ : NULL)
  #else
    #define GETenvironU                  /*CCQ_NO_EFFECT_OK*/ environ
  #endif
  #define FREEenvironU                   /*CCQ_NO_EFFECT_OK*/ (1)

#else  /* Now SAPwithUNICODE */

  /* declare nlsui_main before calling it */
  externC int  nlsui_main       ( int argc, SAP_UC *argv[] );
  externC int  nlsui_main3      ( int argc, SAP_UC *argv[],
                                            SAP_UC *envp[] );
  #if defined( SAPwithACTIVE_MAINU )
    externC void CDCL_U nlsui_initialize ( void );
    #define NLSUI_INITIALIZE()  nlsui_initialize()
  #else
    #define NLSUI_INITIALIZE()  (1)
  #endif
  #if defined(SAPwithICU_I18N)
    externC void CDCL_U nlsui_access_i18n( void );
    #define NLSUI_ACCESS_I18N() nlsui_access_i18n()
  #else
    #define NLSUI_ACCESS_I18N() (1)
  #endif

  #ifdef SAPonNT

    #define mainU                                                \
      wmain( int argc, wchar_t *argv[ ] )                        \
      {                                                          \
        NLSUI_INITIALIZE();                                      \
        NLSUI_ACCESS_I18N();                                     \
        return nlsui_main( argc, argv );                         \
      }                                                          \
      int nlsui_main /* (...) */

    #define main3U                                               \
      wmain( int argc, wchar_t *argv[ ], wchar_t *envp[ ] )      \
      {                                                          \
        NLSUI_INITIALIZE();                                      \
        NLSUI_ACCESS_I18N();                                     \
        return nlsui_main3( argc, argv, envp );                  \
      }                                                          \
      int nlsui_main3 /* (...) */

    #define _putenvU(wcs)                _wputenv(wcs)
    #define putenvU(wcs)                 _wputenv(wcs)
    #define getenvU(wname)               _wgetenv(wname)
    #define environU                     _wenviron
    #define DECLAREenvironU              short nlsui_env_unused_var
                          /* dummy variable for syntax reasons;
			   * _wenviron is a macro in stdlib.h */
    #define GETenvironU             /*CCQ_NO_EFFECT_OK*/ _wenviron
    #define FREEenvironU            /*CCQ_NO_EFFECT_OK*/ (1)

  #else /* other platforms than NT */

    #define mainU                                                \
      main( int argc, char *argv[ ] )                            \
      {                                                          \
        SAP_UC **w_argv;                                         \
        w_argv = nlsui_alloc_wcsar( argc, argv );                \
        NLSUI_INITIALIZE();                                      \
        NLSUI_ACCESS_I18N();                                     \
        return nlsui_main( argc, w_argv );                       \
      }                                                          \
      int nlsui_main /* (...) */

    #define main3U                                               \
      main( int argc, char *argv[ ], char *envp[ ] )             \
      {                                                          \
        SAP_UC **w_argv, **w_envp;                               \
        w_argv = nlsui_alloc_wcsar( argc, argv );                \
        w_envp = nlsui_alloc_env( envp );                        \
        NLSUI_INITIALIZE();                                      \
        NLSUI_ACCESS_I18N();                                     \
        return nlsui_main3( argc, w_argv, w_envp );              \
      }                                                          \
      int nlsui_main3 /* (...) */

    BEGIN_NS_STD_C_HEADER
      externC int      putenvU( const SAP_UC *wcs );
      externC SAP_UC * getenvU( const SAP_UC *wname );
    END_NS_STD_C_HEADER
    #define environU             nlsui_environ
    #define DECLAREenvironU      SAP_UC **nlsui_environ_i, **nlsui_environ
    #define GETenvironU          nlsui_environ = nlsui_environ_i \
                                               = nlsui_getenvironU()
    #define FREEenvironU         nlsui_freeenvironU(nlsui_environ_i)

    /* The following prototypes are for internal use only.
     * (Don't move the prototypes for nlsui_main etc. into the
     *  corresponding macros. ) */
    externC SAP_UC ** nlsui_getenvironU  ( void );
    externC int       nlsui_freeenvironU ( SAP_UC ** );
    externC SAP_UC ** nlsui_alloc_wcsar  ( int argc,  char *argv[]);
    externC int       nlsui_wcsar2mbsar  ( int cnt,   SAP_UC *wp[],
                                           char *p[], int plen[] );
    externC SAP_UC ** nlsui_alloc_env    ( char **envp );
    externC int       nlsui_main         ( int argc,  SAP_UC *w_argv[] );
    externC int       nlsui_main3        ( int argc,  SAP_UC *w_argv[],
                                           SAP_UC *w_envp[] );
    #ifdef SAPonOS400
      extern int     nlsui_o4_main       ( int o4_argc, SAP_UC *w_argv[] );
    #endif /* SAPonOS400 */

  #endif /* different platforms */

#endif /* SAPwithUNICODE or not */

/* function to load ICU without using the mainU() macro */
#ifdef SAPwithICU
externC void CDCL_U loadIcu( void );
#endif

/* ccQ complains about main expansion with char, so let mainU, main3U be
 * simple functions
 */
#ifdef SAPccQ
  /* extern int mainU   ( int argc, SAP_UC **argv ); */
  /* extern int main3U  ( int argc, SAP_UC **argv, SAP_UC **envptr ); */
  #undef mainU
  #undef main3U
#endif


/*---------------------------------------------------------------------
 * sapuc.h  -  NLS specific functions (multibyte functions)
 *
 *  mblen() and MB_CUR_MAX are always 1 in a Unicode system.
 *
 *       Matthias Mittelstein on Nov. 06 2002 :
 *       Who has written that? And why?
 *       .
 *       Is MB_CUR_MAX talking about the old multi-byte code pages.
 *       Then the value is locale dependent. And that causes problems,
 *       because we no longer switch the locale !
 *       .
 *       It would be better to have MB_CUR_MAX_R and MB_CUR_MAX_U !
 *       .
 *       mblenU has to answer 2 when looking at a surrogate pair.
 *
 *  Conversions between multibyte and wide characters are reduced
 *  to a memcpy in the Unicode case.
 *--------------------------------------------------------------------*/

    /* Do a #undef mblenU if you need a real function.
     */
    int mblenU( const SAP_UC *mbptr, size_tU units );



#if !defined(SAPwithUNICODE)

  #define mblenU(mbptr, nbytes)           mblen(mbptr, nbytes)

#else /* SAPwithUNICODE */

  #if defined(SAPonNT)
    #if !defined(_INC_CTYPE) && !defined(_INC_STDLIB)
      #error "stdlib.h or ctype.h must be included before sapuc.h"
    #endif

  #elif defined(SAPonAIX)
    #if !defined(_H_STDLIB)
      #error "stdlib.h must be included before sapuc.h"
    #endif

  #elif defined(SAPonOSF1)
    #if !defined(_STDLIB_H_)
      #error "stdlib.h or ctype.h must be included before sapuc.h"
    #endif

  #elif defined(SAPonHP_UX)
    #if !defined(_STDLIB_INCLUDED)
      #error "stdlib.h must be included before sapuc.h"
    #endif

  #elif defined(SAPonOS400)
    #if !defined(__stdlib_h)
      #error "stdlib.h must be included before sapuc.h"
    #endif

  #elif defined(SAPonSUN) || defined (SAPonLIN)
    #if !defined (_STDLIB_H)
      #error "stdlib.h must be included before sapuc.h"
    #endif

  #elif defined(SAPonOS390)
    #if !defined(__stdlib)
      #error "stdlib.h must be included before sapuc.h"
    #endif

  #elif defined(SAPonRM600)
    #if !defined(_STDLIB_H)
      #error "stdlib.h or ctype.h must be included before sapuc.h"
    #endif

  #else
    #error "Redefinition of MB_CUR_MAX not yet implemented"
    /* please make sure that MB_CUR_MAX cannot be re-redefined if the
     * standard header file should be included again later.
     */

  #endif /* different platforms */

  #ifdef SAP_UC_is_UCS2

    #undef MB_CUR_MAX
    #define MB_CUR_MAX                     (1)
    /* ?    MB_CUR_MAX_R ? */
    /* ?    MB_CUR_MAX_U ? */
    #define mblenU(mbptr, units)           (1)

  #else /* UTF-16 */

    #undef MB_CUR_MAX
    #define MB_CUR_MAX                     (1)
    /* ?    MB_CUR_MAX_R ? */
    #define MB_CUR_MAX_U                   (2)

    /* Remember important constants for UTF-16:
     *
     * The first 16-bit code value of surrogate characters is in the
     * range from 0xD800UL thru 0xDBFFUL.
     * The second 16-bit code value of surrogate characters is in the
     * range from 0xDC00UL thru 0xDFFFUL.
     */

    #define mblenU(mbptr, units)                                       \
    ( ( ((const SAP_UC*)(mbptr)) == (SAP_UC*)0 )                       \
      ? /* UTF-16 is state-less */                                  0  \
      : ( (     *((const SAP_UC*)(mbptr)) < 0xD800UL )                 \
	  ? /* normal char U-0000 .. U-D7FF */                      1  \
	  : ( ( *((const SAP_UC*)(mbptr)) > 0xDBFFUL   )               \
	      ? /* normal char U-E000 .. U-FFFD */                  1  \
	      : ( ( units > (size_tU)1 )                               \
		  ? ( (    ((const SAP_UC*)(mbptr))[1] >= 0xDC00UL     \
			&& ((const SAP_UC*)(mbptr))[1] <= 0xDFFFUL )   \
		      ? /* surrogate char */                        2  \
		      : /* 2nd half not valid */                   -1  \
		    )                                                  \
		  :     /* 2nd half missing   */                   -1  \
		)                                                      \
	    )                                                          \
	)                                                              \
    )

    /* For performance reasons I do not test for callers
     * giving me 0 units. I hope it will never happen.
     */

  #endif  /* UCS-2 / UTF-16 */

#endif  /* SAPwithUNICODE */


#ifndef SAPwithUNICODE
  #define mbstowcsU(dest, source, len)   mbstowcs(dest, source, len)
  #define wcstombsU(dest, source, len)   wcstombs(dest, source, len)
  #define mbtowcU(wcptr, mbptr, nbytes)  mbtowc(wcptr, mbptr, nbytes)
  #define wctombU(mbptr, wc)             wctomb(mbptr, wc)

#else   /* Now SAPwithUNICODE */
  #define mbstowcsU(dest, source, noch)  wcstowcs(dest, source, noch)
  #define wcstombsU(dest, source, noch)  wcstowcs(dest, source, noch)
  externC size_tU CDCL_U wcstowcs(SAP_UC *dest, const SAP_UC *source, size_tU noch);
  #define mbtowcU(wcptr, mbptr, nbytes)  ( (wcptr)!=NULL && (mbptr)!=NULL ? \
                                           ( *(wcptr)=*(mbptr), (size_t)1 ) : \
                                           (size_t)0  )
  #define wctombU(mbptr, wc)             ( (mbptr)!=NULL ? \
                                           ( *(mbptr)=(wc), (size_t)1) : \
                                           (size_t)0  )

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -  structures which contain elements of type char
 *             and functions which use these stuctures
 *
 * the following defintions should only be present if _POSIX_SOURCE is defined
 *----------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------
 * sapuc.h  - Definition of some preprocessor constants
 *
 *  Other similar constants are defined in nlsui1.c and nlsui2.c.
 *  If used as string length, the terminating zero is included in this length.
 *----------------------------------------------------------------------------*/
#define MAX_ALIASES           64       /* hostname aliases (struct hostentU)  */
#define MAX_ADDRESSES         64       /* hostname adresses (struct hostentU) */

#if defined(SAPonNT)
#elif defined(SAPonOS400)
 #define MAX_PATH_LN     _QP0L_DIR_NAME  /* see qsyuinc/h.dirent              */
 #define SAP_SYS_NMLN    32              /* see "o4port.h"                    */
#elif !defined(PATH_MAX)                /* PATH_MAX <limits.h> not present XXX? */
 #define MAX_PATH_LN     1024
 #define SAP_SYS_NMLN    256
#else
 #define MAX_PATH_LN     PATH_MAX+1      /* <sys/limits.h>, no terminating 0  */
 #define SAP_SYS_NMLN    256
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  - struct utsname and function uname()
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define utsnameU              utsname
  #define unameU(name_ptr)      uname(name_ptr)

#else  /* Now SAPwithUNICODE */

  #ifdef SAPonNT
    #define utsnameU              utsname
    #define unameU(name_ptr)      uname(name_ptr)
  #else
    struct utsnameU {
      SAP_UC sysname[SAP_SYS_NMLN];
      SAP_UC nodename[SAP_SYS_NMLN];
      SAP_UC release[SAP_SYS_NMLN];
      SAP_UC version[SAP_SYS_NMLN];
      SAP_UC machine[SAP_SYS_NMLN];
    };
    externC int unameU( struct utsnameU  *name );
  #endif

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  - struct dirent and function readdir()
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define direntU               dirent
  #define readdirU(dirp)        readdir(dirp)
  #define readdir_rU( dirp, entry, result ) \
          readdir_r(  dirp, entry, result )

#else  /* Now SAPwithUNICODE */

  #ifdef SAPonNT
    #define direntU               dirent
    #define readdirU(dirp)        readdir(dirp)
  #else
    #if (!defined (SAPonHP_UX)) || defined (_INCLUDE_POSIX_SOURCE)
      struct direntU {
      #if ! defined (SAPonNT)
        ino_t       d_ino;
      #endif
      #if defined(SAPonOS400)
        SAP_USHORT  d_namelen;
      #elif defined(SAPonSUN) || defined(SAPonLIN)
        /* there is no namelen entry */
      #else
        SAP_USHORT  d_namlen;
      #endif
        SAP_UC      d_name[MAX_PATH_LN];
      };
    #endif
  #endif

  #if defined(SAPonAIX) || defined(SAPonOSF1) || defined(SAPonLIN)   || \
      defined(SAPonSUN) || defined(SAPonOS400)|| defined(SAPonOS390) || \
     (defined(SAPonHP_UX) && defined(_INCLUDE_POSIX_SOURCE))
    externC struct direntU * readdirU( DIR *dirp );
  #endif

  #if defined(SAPonUNIX)
    /* other platforms may be added later */
    externC int readdir_rU( DIR *dirp, struct direntU  * entry,
                                       struct direntU ** result );
  #endif

#endif /* +/- SAPwithUNICODE */


/*-----------------------------------------------------------------------------
 * sapuc.h  - struct passwd and functions getpw...()
 *            For the Unicode case, uid_t and gid_t are replaced by
 *            SAP_UINT. Therefore it is not necessary to include
 *            <sys/types.h> here.
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define passwdU               passwd
  #define getpwuidU(uid)        getpwuid(uid)
  #define getpwnamU(name)       getpwnam(name)

#else  /* Now SAPwithUNICODE */

  struct passwdU {
    SAP_UC *pw_name;
 #ifndef SAPonOS400
    SAP_UC *pw_passwd;
 #endif
    SAP_UINT pw_uid;
    SAP_UINT pw_gid;
 #ifndef SAPonOS400
    SAP_UC *pw_gecos;
 #endif
    SAP_UC *pw_dir;
    SAP_UC *pw_shell;
  };
  externC struct passwdU * AS4_EXT_PTR CDCL_U getpwuidU( SAP_UINT uid );
  externC struct passwdU * AS4_EXT_PTR CDCL_U getpwnamU( const SAP_UC *name );

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  - struct hostent and struct servent
 *            and the functions
 *            gethostent(), gethostbyname(), gethostbyaddr(),
 *            getservbyname(), getservbyport(),
 *            gethostbyname_r(), gethostbyaddr_r(),
 *            getservbyname_r(), getservbyport_r(),
 *            rexecU()
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define hostentU                        hostent
  #define serventU                        servent
  #define gethostbyaddrU(addr, len, type) gethostbyaddr(addr, len, type)
  #define gethostbynameU(name)            gethostbyname(name)
  #define gethostentU()                   gethostent()
  #define getservbynameU(name, proto)     getservbyname(name, proto)
  #define getservbyportU(port, proto)     getservbyport(port, proto)

  #ifndef SAPonNT
   #define rexecU(host, port, name, pass, cmd, fd2p)  \
					rexec(host, port, name, pass, cmd, fd2p)
  #endif

#else  /* Now SAPwithUNICODE */

  struct hostentU {
    SAP_UC  * h_name;                    /* official name of host         */
    SAP_UC  * h_aliases[MAX_ALIASES];    /* alias list                    */
    SAP_INT   h_addrtype;                /* host address type             */
    SAP_INT   h_length;                  /* length of address in bytes    */
    SAP_RAW * h_addr_list[MAX_ADDRESSES];/* list of addr. from name server*/
    #define   h_addr  h_addr_list[0]     /* address, for backw. compatib. */
  };
  struct serventU {
    SAP_UC   * s_name;                  /* official service name */
    SAP_UC   * s_aliases[MAX_ALIASES];  /* alias list            */
    SAP_INT    s_port;                  /* port #                */
    SAP_UC   * s_proto;                 /* protocol to use       */
  };

  externC struct hostentU * CDCL_U gethostentU   ( void );
  externC struct hostentU * CDCL_U gethostbyaddrU( const void *addr, int len, int type );
  externC struct hostentU * CDCL_U gethostbynameU( const SAP_UC *name );
  externC struct serventU * CDCL_U getservbynameU( const SAP_UC *name,
                                           const SAP_UC *proto );
  externC struct serventU * CDCL_U getservbyportU( int port, const SAP_UC *proto );

  #if defined(SAPonHP_UX) || defined(SAPonSUN) || defined(SAPonAIX) || \
      defined(SAPonOSF1)  || defined(SAPonLIN) || defined(SAPonOS390)

   externC int CDCL_U rexecU( SAP_UC **, int, const SAP_UC *, const SAP_UC *,
			     const SAP_UC *, int * );
  #endif

#endif

externC struct hostentU * CDCL_U gethostbyname_rU(SAP_UC          * pName,
                                                  struct hostentU * pResultU,
                                                  char            * pBuffer,
                                                  int               bufLen,
                                                  int             * pErrno);

externC struct hostentU * CDCL_U gethostbyaddr_rU(char            * pAddr,
                                                  int               length,
                                                  int               type,
                                                  struct hostentU * pResultU,
                                                  char            * pBuffer,
                                                  int               bufLen,
                                                  int             * pErrno);

externC struct serventU * CDCL_U getservbyname_rU(SAP_UC          * pName,
                                                  SAP_UC          * pProto,
                                                  struct serventU * pResultU,
                                                  char            * pBuffer,
                                                  int               bufLen,
                                                  int             * pErrno);

externC struct serventU * CDCL_U getservbyport_rU(int               port,
                                                  SAP_UC          * pProto,
                                                  struct serventU * pResultU,
                                                  char            * pBuffer,
                                                  int               bufLen,
                                                  int             * pErrno);


/*-----------------------------------------------------------------------------
 * sapuc.h  -  struct group and function getgrgid()
 *----------------------------------------------------------------------------*/

#ifndef SAPwithUNICODE

 #define groupU              group
 #define getgrgidU( gid )    getgrgid( gid )
 #ifdef SAPonOS400
 #define getgrnamU( grname ) getgrnam( grname )
 #endif

#else  /* Now SAPwithUNICODE */

  #if defined(SAPonUNIX) || defined(SAPonOS400)
    struct groupU {
      SAP_UC        *gr_name;
    #ifndef SAPonOS400
      SAP_UC        *gr_passwd;
    #endif
      unsigned long  gr_gid;
      SAP_UC       **gr_mem;
    };
    externC struct groupU * AS4_EXT_PTR getgrgidU( unsigned long gid );
    #ifdef SAPonOS400
    externC struct groupU * AS4_EXT_PTR getgrnamU( SAP_UC *grname );
    #endif

  #elif defined(SAPonNT)
   /* struct group does not exist */

  #else
    #error "struct groupU not yet implemented on this platform"

  #endif /* different platforms */

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -  function getpass
 *----------------------------------------------------------------------------*/

#ifndef SAPwithUNICODE

  #define getpassU( prompt )  getpass( prompt )

#else  /* Now SAPwithUNICODE */

  #if defined(SAPonUNIX) || defined(SAPonOS400)
    externC SAP_UC *getpassU( SAP_UC *prompt );

  #elif defined(SAPonNT)
    #define getpassU( prompt )  getpass( prompt )

  #else
    #error "getpassU not yet implemented on this platform"

  #endif /* different platforms */

#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -  statvfs()
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE
  #define statvfsU( path, buf )        statvfs( path, buf )
#else
  #ifndef SAPonNT
    struct statvfs;
    externC int statvfsU( const SAP_UC * path, struct statvfs * buf );
  #endif
#endif /* SAPwithUNICODE */


/*-----------------------------------------------------------------------------
 * sapuc.h  -  xdr_string()
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define xdr_stringU(xdrs, sp, maxsize) xdr_string(xdrs, sp, maxsize)

#else  /* Now SAPwithUNICODE */
  #if defined(SAPonAIX)   &&   defined(_RPC_XDR_H)        \
   || defined(SAPonSUN)   &&   defined(_RPC_XDR_H)        \
   || defined(SAPonHP_UX) && ( defined(_RPC_XDR_INCLUDED) \
                            || defined(_RPC_XDR_H) )      \
   || defined(SAPonOSF1)  &&   defined(_rpc_xdr_h)        \
   || defined(SAPonOS390) &&   defined(__XDR_HEADER__)    \
   || defined(SAPonLIN)   &&   defined(_RPC_XDR_H)
    externC bool_t xdr_stringU ( XDR* xdrs, SAP_UC **sp, u_int maxsize );
  #endif /* different platforms */

  /* if defined(SAPonNT) || defined(SAPonOS400)   xdr_string() not used */

#endif /* SAPwithUNICODE */


/*-----------------------------------------------------------------------------
 * sapuc.h  -  _splitpath() (for NT only)
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #ifdef SAPonNT
    #define _splitpathU( path, drive, dir, fname, ext ) \
            _splitpath(  path, drive, dir, fname, ext )
  #endif

#else  /* Now SAPwithUNICODE */

  #ifdef SAPonNT
    #define _splitpathU( path, drive, dir, fname, ext )  \
            _wsplitpath( path, drive, dir, fname, ext )
  #endif

#endif

/*-----------------------------------------------------------------------------
 * sapuc.h - re-definition of memcpy to check for overlapping buffers
 *           only in debug mode and only inside SAP (not in RFC SDK)
 *----------------------------------------------------------------------------*/
#if !defined(NDEBUG) && defined(SAPTYPE_H)

  BEGIN_NS_STD_C_HEADER

    externC void* memcpyRChk( void* pDst, const void* pSrc, size_t nLen, SAP_RAW* file, int line );
    #undef memcpyR
    #define memcpyR(t,s,l) memcpyRChk(t,s,l,(SAP_RAW*)cR(__FILE__),__LINE__)
    externC void* memcpyUChk( SAP_UC* pDst, const SAP_UC* pSrc, size_t nLen, SAP_RAW* file, int line );
    #undef memcpyU
    #define memcpyU(t,s,l) memcpyUChk(t,s,l,(SAP_RAW*)cR(__FILE__),__LINE__)

  END_NS_STD_C_HEADER

#endif /* checked memcpy */


/*-----------------------------------------------------------------------------
 * sapuc.h - re-definition of the memory related functions in order
 *           to activate runtime Unicode debugger functionality
 *----------------------------------------------------------------------------*/
#if defined(SAPonAIX) && defined(SAPwithUNICODE) && defined(UNICODE_DEBUG)

  BEGIN_NS_STD_C_HEADER

    /* memory allocation functions  */
    externC void    * mallocRD  (           size_t, const SAP_RAW *, long );
    externC SAP_UC  * mallocUD  (           size_t, const SAP_RAW *, long );
    externC void    * reallocRD ( void *,   size_t, const SAP_RAW *, long );
    externC SAP_UC  * reallocUD ( SAP_UC *, size_t, const SAP_RAW *, long );
    externC void    * callocRD  ( size_t,   size_t, const SAP_RAW *, long );
    externC SAP_UC  * callocUD  ( size_t,   size_t, const SAP_RAW *, long );
    externC void      freeD     ( void *,           const SAP_RAW *, long );
    #define malloc(     len )         \
            mallocRD(  (len), (SAP_RAW *) __FILE__, __LINE__ )
    #define calloc(     num,   len )  \
            callocRD(  (num), (len), (SAP_RAW *) __FILE__, __LINE__ )
    #define realloc(    ptr,   len )  \
            reallocRD( (ptr), (len), (SAP_RAW *) __FILE__, __LINE__ )
    #undef  mallocR
    #define mallocR(    len )         \
            mallocRD(  (len),        (SAP_RAW *) __FILE__, __LINE__ )
    #undef  mallocU
    #define mallocU(    len )         \
            mallocUD(  (len),        (SAP_RAW *) __FILE__, __LINE__ )
    #undef  callocR
    #define callocR(    num,   len )  \
            callocRD(  (num), (len), (SAP_RAW *) __FILE__, __LINE__ )
    #undef  callocU
    #define callocU(    num,   len )  \
            callocUD(  (num), (len), (SAP_RAW *) __FILE__, __LINE__ )
    #undef  reallocR
    #define reallocR(   ptr,   len )  \
            reallocRD( (ptr), (len), (SAP_RAW *) __FILE__, __LINE__ )
    #undef  reallocU
    #define reallocU(   ptr,   len )  \
            reallocUD( (ptr), (len), (SAP_RAW *) __FILE__, __LINE__ )
    #define free( p )    freeD( (p), (SAP_RAW *)__FILE__, __LINE__ )

    /* memory functions     */
    externC void     * memsetRD( void *,     int, size_t, const SAP_RAW*, long );
    externC SAP_CHAR * memsetUD( SAP_CHAR *, int, size_t, const SAP_RAW*, long );
    externC int        memcmpRD( const void *,     const void *,     size_t,
                                 const SAP_RAW *,  long );
    externC int        memcmpUD( const SAP_CHAR *, const SAP_CHAR *, size_t,
                                 const SAP_RAW *,  long );
    externC void*      memcpyRD(       void *,     const void *,     size_t,
                                 const SAP_RAW *,  long );
    externC SAP_CHAR * memcpyUD(       SAP_CHAR *, const SAP_CHAR *, size_t,
                                 const SAP_RAW*,   long );
    #undef  memsetR
    #define memsetR(   s,    c,    len )  \
            memsetRD( (s),  (c),  (len), (SAP_RAW *) __FILE__, __LINE__ )
    #undef  memsetU
    #define memsetU(   s,    c,    len )  \
            memsetUD( (s),  (c),  (len), (SAP_RAW *) __FILE__, __LINE__ )
    #undef  memcmpR
    #define memcmpR(   s1,   s2,   len ) \
            memcmpRD( (s1), (s2), (len), (SAP_RAW *) __FILE__, __LINE__ )
    #undef  memcmpU
    #define memcmpU(   s1,   s2,   len ) \
            memcmpUD( (s1), (s2), (len), (SAP_RAW *) __FILE__, __LINE__ )
    #undef  memcpyR
    #define memcpyR(   s1,   s2,   len ) \
            memcpyRD( (s1), (s2), (len), (SAP_RAW *) __FILE__, __LINE__ )
    #undef  memcpyU
    #define memcpyU(   s1,   s2,   len ) \
            memcpyUD( (s1), (s2), (len), (SAP_RAW *) __FILE__, __LINE__ )

    /* string functions     */
    externC size_t   strlenUD( const SAP_UC *,
                               const SAP_RAW *, long );
    externC int      strcmpUD( const SAP_UC *,  const SAP_UC *,
                               const SAP_RAW *, long );
    externC SAP_UC * strcpyUD(       SAP_UC *,  const SAP_UC *,
                               const SAP_RAW *, long );
    #undef  strlenU
    #define strlenU(   p )        \
            strlenUD( (p),        (SAP_RAW *) __FILE__, __LINE__ )
    #undef  strcmpU
    #define strcmpU(   s1,   s2 ) \
            strcmpUD( (s1), (s2), (SAP_RAW *) __FILE__, __LINE__ )
    #undef  strcpyU
    #define strcpyU(   s1,   s2 ) \
            strcpyUD( (s1), (s2), (SAP_RAW *) __FILE__, __LINE__ )

  END_NS_STD_C_HEADER

#endif /* UNICODE_DEBUG */


#ifdef SAPccQ
  #if defined(CPP_USE_NEW_C_HEADERS)
    #include <cstdarg>
  #else
    #include <stdarg.h>
  #endif
  #undef  va_arg
  #define va_arg( p, type ) (((type *)0)[0])
  #undef  va_start
  #define va_start( list, parmN )
  #undef  va_end
  #define va_end( list )
#endif

#if defined(SAPccQ) && defined(SAPonLIN)
  /* ccQ does not accept function declarations without parameters.
   * On Linux, errno may be a macro which resolves to such a declaration.
   */
 #undef errno
#endif




/**********************************************************************/
/*                                                                    */
/* If you need C types to handle single characters or strings with a  */
/* large character set, you have the choice between six of them.      */
/* Please handle them distinctly! Some pairs may be compatible on     */
/* one platform but not on the others.                                */
/*                                                                    */
/* Each type has some advantages and some disadvantages. That is the  */
/* reason, why we could not drop any one.                             */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                        .---------.                                 */
/*                        | wchar_t |                                 */
/*                       .'         `----------.                      */
/*                       | XPG4 wide char      |                      */
/*                       | + "all" characters  |                      */
/*                       | + fast              |                      */
/*                       | - unknown coding    |                      */
/*                       | + many functions    |                      */
/*                       | - unknown size      |                      */
/*                       | + but size is fixed |                      */
/*                       `---------------------'                      */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*   .---------.                              .--------.              */
/*   |  char   |                              |   UC   |              */
/*  .'         `----------.                  .'        `-----------.  */
/*  | Standard C character|                  | universal character |  */
/*  | - 1 byte            |                  | + "all" characters  |  */
/*  | - variing coding    |                  | + fast              |  */
/*  | + many functions    |                  | - platform dependent|  */
/*  | - also used for     |                  | - unknown size      |  */
/*  |   multi-byte strings|                  | + but size is fixed |  */
/*  | - also used for     |                  | . zero-terminated   |  */
/*  |   raw bytes         |                  |   strings           |  */
/*  `---------------------'                  `---------------------'  */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*   .---------.                              .--------.              */
/*   |   B8    |                              | CHAR   |              */
/*  .'         `----------.                  .'        `-----------.  */
/*  | multibyte           |                  | universal character |  */
/*  | - variable size     |                  | + "all" characters  |  */
/*  | - variing coding    |                  | + fast              |  */
/*  | + many functions    |                  | - platform dependent|  */
/*  | - cannot single char|                  | - unknown size      |  */
/*  | + 'char' compatible |                  | + but size is fixed |  */
/*  `---------------------'                  | . blank-padded      |  */
/*                                           |   strings           |  */
/*                                           `---------------------'  */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


/**********************************************************************/
/*                                                                    */
/*  .----.  .------.  .------.  .---------.  .----.                   */
/*  | UC |  | CHAR |  | char |  | wchar_t |  | B8 |                   */
/*  `----'  `------'  `------'  `---------'  `----'                   */
/*                                                                    */
/* Beside of these three types there are some more character types:   */
/*                                                                    */
/*                                                                    */
/*   .--------.                                                       */
/*   |   U2   |                                                       */
/*  .'        `----------------.                                      */
/*  | ISO Unicode UCS-2        |            The real UCS-2            */
/*  | + 60000 characters       |                                      */
/*  | + coding = UCS-2         |                                      */
/*  | + size   = 2 B           |                                      */
/*  | - unknown byte order     |                                      */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/*   .--------.                                                       */
/*   |  UTF8  |                                                       */
/*  .'        `----------------.                                      */
/*  | Unicode Transfer Format  |       Used within some database.     */
/*  | - variable size          |       Used in some files.            */
/*  | - cannot single char     |       Can be used for filenames.     */
/*  | + 2000000000 characters  |                                      */
/*  | + 'char' compatible      |                                      */
/*  | + "file system safe"     |                                      */
/*  | + easy UCS-2 convertable |                                      */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/*   .--------.                                                       */
/*   |  UTF7  |                                                       */
/*  .'        `----------------.                                      */
/*  | Unicode Transfer Format  |       Used on some data stream.      */
/*  | - variable size          |       i.e. e-mail                    */
/*  | - cannot single char     |                                      */
/*  | + 2000000000 characters  |                                      */
/*  | + 'char' compatible      |                                      */
/*  | + 7-Bit ASCII compatible |                                      */
/*  | + "file system safe"     |                                      */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/*   .--------.                                                       */
/*   |  UTF16 |                                                       */
/*  .'        `----------------.                                      */
/*  | Unicode Transfer Format  |       Unicode 2.0 (with surrogates)  */
/*  | - variable (even) size   |       ISO: UTF-16                    */
/*  | - cannot single char     |       Used in JAVA.                  */
/*  | + 1060000 characters     |                                      */
/*  | + UCS-2 compatible       |                                      */
/*  | + easy UCS-4 convertable |                                      */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/*   .--------.                                                       */
/*   |   U4   |                                                       */
/*  .'        `----------------.                                      */
/*  | Unicode 4 byte Format    |       Unicode 2.0  &  ISO            */
/*  | + 2000000000 characters  |                                      */
/*  | + coding = UCS-4         |                                      */
/*  | + size   = 4 B           |                                      */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/*   .------.                                                         */
/*   |  B7  |                                                         */
/*  .'      `------------------.                                      */
/*  | Character from 7-Bit set |       "Old C", US-ASCII              */
/*  | - single byte chars      |                                      */
/*  | . zero terminated strings|       Can be 8 bit if used on        */
/*  | + 'char' compatible      |       EBCDIC machine !               */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/*   .------.                                                         */
/*   |  A7  |                                                         */
/*  .'      `------------------.                                      */
/*  | 7-bit-US-ASCII           |       US-ASCII                       */
/*  | - single byte chars      |                                      */
/*  | . zero terminated strings|       Is always ASCII. Even on an    */
/*  | + 'char' compatible      |       EBCDIC machine !               */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/*   .------.                                                         */
/*   |  E8  |                                                         */
/*  .'      `------------------.                                      */
/*  | 8-bit-IBM-500-EBCDIC     |       "international" EBCDIC         */
/*  | - single byte chars      |                                      */
/*  | . IBM-500 coding always  |       even in other countries        */
/*  | + 'char' compatible      |                                      */
/*  `--------------------------'                                      */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


/**********************************************************************/
/* wchar_t :   wide character for fast processing                     */
/*             with platform dependent coding.                        */
/*--------------------------------------------------------------------*/
/* This is the C data type as defined by XPG4.                        */
/* A variable of this type can store a wide character.                */
/* The size of this type is platform dependent: often 2 or 4 bytes.   */
/* The coding used is platform dependent and OS release specific.     */
/*--------------------------------------------------------------------*/
/* This type gives direct access to many functions, as has been       */
/* defined in XPG4 and should be implemented everywhere.              */
/*    Classification of a single character:                           */
/*       iswalnum                                                     */
/*       iswalpha                                                     */
/*       iswcntrl                                                     */
/*       iswupper      (Note: most scripts do not have cases.)        */
/*       iswlower                                                     */
/*       iswdigit                                                     */
/*       iswprint                                                     */
/*       wcwidth                                                      */
/*    Simple handling of w-zero terminated strings:                   */
/*       wcscat / wcsncat                                             */
/*       wcscmp / wcsncmp                                             */
/*       wcscpy / wcsncpy                                             */
/*       wcslen                                                       */
/*       wcschr / wcsrchr                                             */
/*       wcspbrk                                                      */
/*       wcsspn / wcscspn                                             */
/*       wcswcs                                                       */
/*       wcstok / wcstok_r                                            */
/*       wcswidth                                                     */
/*    Locale dependent handling of w-zero terminated strings:         */
/*       wcscoll                                                      */
/*       wcsxfrm                                                      */
/*    Conversion functions:                                           */
/*       wcstod / wcstol / wcstoul                                    */
/*       mbtowc / mbstowcs / wctomb / wcstombs                        */
/* Note:                                                              */
/*       wcsftime cannot be used!                                     */
/*--------------------------------------------------------------------*/


/**********************************************************************/
/* SAP_UC:   universal character                                      */
/*--------------------------------------------------------------------*/
/* The size of an universal character is constant and platform        */
/* dependent.                                                         */
/* The coding is platfrom dependent also.                             */
/* It is implementations dependent, wether the coding can vary during */
/* runtime ! ( see setlocale() ).                                     */
/* It is implementations dependent, how many distinct characters can  */
/* be stored. But often all important characters of the world are     */
/* possible.                                                          */
/* To give an idea, why there is this distinction between declared    */
/* features and those which are left 'implementations dependent':     */
/* A specific implementation may map 'SAP_UC' onto                    */
/*  + UCS-2  (16-Bit Unicode, most likely)                            */
/*  + UTF-16 in 32-Bit                                                */
/*  + wchar_t with some propietary coding                             */
/*  + Latin-1 or some other ISO-8859-1 single byte code               */
/*                                                                    */
/* This type gives access to many SAP specific functions.             */
/*--------------------------------------------------------------------*/


/**********************************************************************/
/* SAP_U2:   wide character for Unicode UCS-2                         */
/*--------------------------------------------------------------------*/
/* A variable of this type can store a Unicode UCS-2 character.       */
/* The size of this type is two bytes.                                */
/* The coding used is UCS-2 (ISO 10646). The release of that          */
/* ISO norm is not specified here. It is the most recent release,     */
/* is supported by SAP.                                               */
/* If not explicitelly labeled UTF-16 or SAP_UTF16, surrogates are    */
/* neither expected nor handled.                                      */
/*--------------------------------------------------------------------*/
/* This type gives access to some generic functions, which are        */
/* handled differently on the different platforms, but give the same  */
/* result to all SAP applications.                                    */
/*    Classification of a single character:                           */
/*       <none. Processing is done using SAP_UC.>                     */
/*    Simple handling of zero terminated strings:                     */
/*       <none. Processing is done using SAP_UC.>                     */
/*    Conversion functions:                                           */
/*       SAP_U2_...                                                   */
/*--------------------------------------------------------------------*/

#define U2Null ((SAP_U2)0)

#if defined(WCHAR_is_UCS2) && defined(WCHAR_is_2B)

  typedef wchar_t   SAP_U2;
  typedef wchar_t * SAP_U2S;

#else /* not wchar_t: UCS-2 and 2B */

  typedef SAP_USHORT   SAP_U2 ;
  typedef SAP_USHORT * SAP_U2S;

#endif /* +/- wchar_t: UCS-2 and 2B */

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_U4:   wide character for Unicode UCS-4 (UTF-32)                */
/*--------------------------------------------------------------------*/
/* A variable of this type can store a Unicode UCS-4                  */
/* character. The size of this type is four bytes.                    */
/* The coding used is UCS-4 (ISO 10646). The release of that          */
/* ISO norm is not specified here. It is the most recent release      */
/* which is supported by SAP.                                         */
/* We do not make a difference between UCS-4 and UTF-32.              */
/*--------------------------------------------------------------------*/
/* This type gives access to some generic functions, which are        */
/* handled differently on the different platforms, but give the same  */
/* result to all SAP applications.                                    */
/*    Classification of a single character:                           */
/*       <none. Processing is done using SAP_UC.>                     */
/*    Simple handling of zero terminated strings:                     */
/*       <none. Processing is done using SAP_UC.>                     */
/*    Conversion functions:                                           */
/*       SAP_U4_...                                                   */
/*--------------------------------------------------------------------*/

#define U4Null ((SAP_U4)0)

#if defined(WCHAR_is_UCS4) && defined(WCHAR_is_4B)

  typedef wchar_t   SAP_U4;
  typedef wchar_t * SAP_U4S;

#else /* not wchar_t: UCS-4 and 4B */

  typedef SAP_UINT   SAP_U4 ;
  typedef SAP_UINT * SAP_U4S;

#endif /* +/- wchar_t: UCS-4 and 4B */

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_UTF16:   wide character for Unicode UTF16                      */
/*--------------------------------------------------------------------*/
/* This type cannot be used to define a variable for a single         */
/* character !                                                        */
/* The size of this type is two bytes.                                */
/* The coding used is UTF16 (ISO 10646). The release of that          */
/* ISO norm is not specified here. It is the most recent release      */
/* which is supported by SAP.                                         */
/* This is the same as "Unicode 2.0" with surrogates.                 */
/*--------------------------------------------------------------------*/
/* This type gives access to some generic functions, which are        */
/* handled differently on the different platforms, but give the same  */
/* result to all SAP applications.                                    */
/*    Classification of a single character:                           */
/*       <none. Processing is done using SAP_UC.>                     */
/*    Simple handling of zero terminated strings:                     */
/*       <none. Processing is done using SAP_UC.>                     */
/*    Conversion functions:                                           */
/*       SAP_UTF16_...                                                */
/*--------------------------------------------------------------------*/

#define UTF16Null ((SAP_UTF16)0)

#if defined(WCHAR_is_2B)

  typedef wchar_t   SAP_UTF16;
  typedef wchar_t * SAP_UTF16S;

#else /* not wchar_t: UCS-2 or UTF-16 and 2B */

  typedef SAP_USHORT   SAP_UTF16 ;
  typedef SAP_USHORT * SAP_UTF16S;

#endif /* +/- wchar_t: UCS-2 or UTF16 and 2B */

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_B8:   bytes storing multibyte characters                       */
/*--------------------------------------------------------------------*/
/* This type cannot be used to define a variable for a single         */
/* character !                                                        */
/* A string of this type can store characters using one or more bytes */
/* for each character.                                                */
/* The coding varies during runtime ! ( see setlocale() ).            */
/* The type SAP_B8 is compatible to char. It is used for              */
/* documentation purposes. It marks char[] which may contain          */
/* multibyte characters.                                              */
/*--------------------------------------------------------------------*/
/* This type gives direct access to many functions, as has been       */
/* defined in ANSI C and XPG4 and should be implemented everywhere.   */
/*    Classification of a single character:                           */
/*       mblen                                                        */
/*    Simple handling of zero terminated strings:                     */
/*       strcat                                                       */
/*       strcmp                                                       */
/*       strcpy                                                       */
/*       strlen    (not number of chars, but number of bytes!)        */
/*    Conversion functions:                                           */
/*       strcoll / strxfrm                                            */
/*       mbtowc / mbstowcs / wctomb / wcstombs                        */
/* Note:                                                              */
/* The character classification functions isprint, isalpha,.. are     */
/* only valid, if(mblen(ptr)==1)                                      */
/*--------------------------------------------------------------------*/

typedef char   SAP_B8 ;
#define        B8Null   ((SAP_B8)0)

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_UTF8:   bytes storing multibyte characters with UTF-8 coding   */
/*--------------------------------------------------------------------*/
/* This type cannot be used to define a variable for a single         */
/* character !                                                        */
/* A string of this type can store characters using one or more bytes */
/* for each character.                                                */
/* The coding is defined with Unicode.                                */
/* The type SAP_UTF8 is compatible to char. It is used for            */
/* documentation purposes. It marks char[] which may contain          */
/* UTF-8 multibyte characters.                                        */
/*--------------------------------------------------------------------*/
/* This type gives direct access to some functions, as has been       */
/* defined in ANSI C and XPG4 and should be implemented everywhere.   */
/*    Simple handling of zero terminated strings:                     */
/*       strcat                                                       */
/*       strcmp                                                       */
/*       strcpy                                                       */
/*       strlen    (not number of chars, but number of bytes!)        */
/*--------------------------------------------------------------------*/

typedef unsigned char   SAP_UTF8 ;
#define                 UTF8Null    ((SAP_UTF8)0)

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_UTF7:   bytes storing multibyte characters with UTF-7 coding   */
/*--------------------------------------------------------------------*/
/* This type cannot be used to define a variable for a single         */
/* character !                                                        */
/* A string of this type can store characters using one or more bytes */
/* for each character.                                                */
/* The coding is defined with Unicode.                                */
/* The type SAP_UTF7 is compatible to char. It is used for            */
/* documentation purposes. It marks char[] which may contain          */
/* UTF-7 multibyte characters.                                        */
/* Note: UTF-7 encoding has modes! You always have to convert a whole */
/*       chunck of data (i.e. whole lines)                            */
/*--------------------------------------------------------------------*/
/* This type gives direct access to some functions, as has been       */
/* defined in ANSI C and XPG4 and should be implemented everywhere.   */
/*    Simple handling of zero terminated strings:                     */
/*       strlen    (not number of chars, but number of bytes!)        */
/*--------------------------------------------------------------------*/

typedef unsigned char   SAP_UTF7 ;
#define                 UTF7Null     ((SAP_UTF7)0)

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_A7:   a byte storing a 7-bit-US-ASCII character                */
/*--------------------------------------------------------------------*/
/* The coding is defined as 7-Bit US-ASCII. This is platform          */
/* independent. Even on an EBCDIC machine, variables of type SAP_A7   */
/* contain ASCII. Also it never contains national characters.         */
/* SAP_A7 values are compatible to UTF-8. (Only one direction.)       */
/* When text fields of SAP_A7 are defined, we expect a terminating    */
/* null.                                                              */
/* SAP_A7_A has same implementation as SAP_A7. It shall be used, when */
/* blank-padded non-terminated text fields are defined.               */
/*--------------------------------------------------------------------*/

typedef char   SAP_A7;
#define        A7Null   ((SAP_A7)0)

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_B7:   byte storing an English character or simple symbol       */
/*--------------------------------------------------------------------*/
/* The coding is defined either 7-Bit US-ASCII or a subset of EBCDIC. */
/* The type SAP_B7 is compatible to char. It is used for              */
/* documentation purposes. It marks char[] which never contain        */
/* national characters.                                               */
/*--------------------------------------------------------------------*/

typedef char SAP_B7;
#define      B7Null    ((SAP_B7)0)

/* All other routines are in "sapuc2.h". */


/**********************************************************************/
/* SAP_E8:   a byte storing a 7-bit-US-ASCII character                */
/*--------------------------------------------------------------------*/
/* The coding is defined as 8-Bit IBM 500 EBCDIC. This is platform    */
/* independent. Even on an ASCII machine, variables of type SAP_E8    */
/* contain EBCDIC. If it contains national characters, these are from */
/* the western European area.                                         */
/* When text fields of SAP_E8 are defined, we expect a terminating    */
/* null.                                                              */
/* SAP_E8_A has same implementation as SAP_E8. It shall be used, when */
/* blank-padded non-terminated text fields are defined.               */
/*--------------------------------------------------------------------*/

#if defined (SAPonOS400) || defined (SAPwithPASE400)
  typedef          char   SAP_E8;
#else /* normal UNIX or NT */
  typedef unsigned char   SAP_E8;
#endif
#define                   E8Null   ((SAP_E8)0)


/**********************************************************************/
/* SAP_UC_MB: multibyte character representation of SAP_UC            */
/*--------------------------------------------------------------------*/
/* This type contains the multibyte character representation          */
/* of SAP_UC                                                          */
/* - In Unicode mode this is UTF-8.                                   */
/* - In non-Unicode mode the encoding is determined by the active     */
/*   codepage ( see setlocale() ) and thereby varies during runtime.  */
/* The type SAP_UC_MB is compatible to char and can be used to call   */
/* platform functions if they support UTF-8.                          */
/*--------------------------------------------------------------------*/

typedef char            SAP_UC_MB;
#define                 UCMBNull   ((SAP_UC_MB)0)

/* All other routines are in "sapuc2.h". */


/*-----------------------------------------------------------------------------
 * sapuc.h  -  Function to print trace and error messages.
 * Further documentation in flat/nlsuidoc.htm
 *----------------------------------------------------------------------------*/
typedef enum
{ none = 0,
  low = 1,
  medium = 4,
  high = 16
} NlsuiTraceLevel ;

#if defined(SAPU16C_LIB)
  typedef void (* TRACE_FUNC_T) (const SAP_UTF16 *  buffer,
				 int                number_of_chars );
#else
  typedef void (* TRACE_FUNC_T) (const SAP_CHAR *  buffer,
				 int               number_of_chars );
#endif

#if !defined(SAPwithUNICODE) && !defined(SAPU16C_LIB)
  #define nlsui_set_trace(p, l)        (1)
#else
  externC void CDCL_U nlsui_set_trace( TRACE_FUNC_T p, NlsuiTraceLevel l );
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -   Functions that test character properties (ctype functions)
 *
 *   These function declarations are located after the typedefs for
 *   SAP_U4, because we use SAP_U4 for the ICU function declarations.
 *
 *   sizeofR(c) is not evaluated at run time. Therefore these macro definitions
 *   are no problem in expressions like isprint(c++).
 *----------------------------------------------------------------------------
 * __SAP_DLL_DECLSPEC is a marker for symbols that must be imported from a
 * shared library. It is necessary
 * - only on NT
 * - only for variables (function pointers), not for functions
 * - only if the port-library comes as part of a shared library. To activate it
 * on NT, set the Macro __SAP_DESIGNATED_DLL (or use sapucx.h).
 * See also saptype.h.
 *----------------------------------------------------------------------------*/

typedef signed char          ICU_BOOL;
#define isdigit09( c )       ((unsigned int)((c)-cU('0')) <  10)

#ifndef SAPwithUNICODE
  #define isalnumU(c)        ( sizeofR(c) == sizeofR(SAP_CHAR) ? \
                               isalnum(U_CHAR(c)):                 \
                               /*LINTED_SIGNEDCHAR*/isalnum(c)     )
  #define isasciiU(c)        ( sizeofR(c) == sizeofR(SAP_CHAR) ? \
                               isascii(U_CHAR(c)):                 \
                               /*LINTED_SIGNEDCHAR*/isascii(c)     )
  #define isalphaU(c)        ( sizeofR(c) == sizeofR(SAP_CHAR) ? \
                               isalpha(U_CHAR(c)):                 \
                               /*LINTED_SIGNEDCHAR*/isalpha(c)     )
  #define iscntrlU(c)        ( sizeofR(c) == sizeofR(SAP_CHAR) ? \
                               iscntrl(U_CHAR(c)):                 \
                               /*LINTED_SIGNEDCHAR*/iscntrl(c)     )
  #define isdigitU(c)        ( sizeofR(c) == sizeofR(SAP_CHAR) ? \
                               isdigit09(U_CHAR(c)):               \
                               /*LINTED_SIGNEDCHAR*/isdigit09(c)   )
  #define isgraphU(c)        ( sizeofR(c) == sizeofR(SAP_CHAR) ? \
                               isgraph(U_CHAR(c)):                 \
                               /*LINTED_SIGNEDCHAR*/isgraph(c)     )
  #define islowerU(c)        ( sizeofR(c) == sizeofR(SAP_CHAR) ? \
                               islower(U_CHAR(c)):                 \
                               /*LINTED_SIGNEDCHAR*/islower(c)     )
  #define isprintU(c)        ( sizeofR(c) == sizeofR(SAP_CHAR) ? \
                               isprint(U_CHAR(c)):                 \
                               /*LINTED_SIGNEDCHAR*/isprint(c)     )
  #define ispunctU(c)        ( sizeofR(c) == sizeofR(SAP_CHAR) ? \
                               ispunct(U_CHAR(c)):                 \
                               /*LINTED_SIGNEDCHAR*/ispunct(c)     )
  #define isspaceU(c)        ( sizeofR(c) == sizeofR(SAP_CHAR) ? \
                               isspace(U_CHAR(c)):                 \
                               /*LINTED_SIGNEDCHAR*/isspace(c)     )
  #define isupperU(c)        ( sizeofR(c) == sizeofR(SAP_CHAR) ? \
                               isupper(U_CHAR(c)):                 \
                               /*LINTED_SIGNEDCHAR*/isupper(c)     )
  #define isxdigitU(c)       ( sizeofR(c) == sizeofR(SAP_CHAR) ? \
                               isxdigit(U_CHAR(c)):                \
                               /*LINTED_SIGNEDCHAR*/isxdigit(c)    )

#else /* Now SAPwithUNICODE */

  #define isasciiU( c ) isascii( c )
  #define isdigitU( c ) isdigit09( c )


  #if defined (SAPwithICU)
    /* We use the external functions provided in ICU */
    /* The function pointers are mapped in mainU().  */
    BEGIN_NS_STD_C_HEADER
      externC __SAP_DLL_DECLSPEC ICU_BOOL (CDCL_U *isalnumU)( SAP_U4 c );
      externC __SAP_DLL_DECLSPEC ICU_BOOL (CDCL_U *isalphaU)( SAP_U4 c );
      externC __SAP_DLL_DECLSPEC ICU_BOOL (CDCL_U *iscntrlU)( SAP_U4 c );
      externC __SAP_DLL_DECLSPEC ICU_BOOL (CDCL_U *islowerU)( SAP_U4 c );
      externC __SAP_DLL_DECLSPEC ICU_BOOL (CDCL_U *isprintU)( SAP_U4 c );
      externC __SAP_DLL_DECLSPEC ICU_BOOL (CDCL_U *isspaceU)( SAP_U4 c );
      externC __SAP_DLL_DECLSPEC ICU_BOOL (CDCL_U *isupperU)( SAP_U4 c );
    END_NS_STD_C_HEADER

    /* The following functions are missing in ICU. They are implemented
     *  in nlsui1.c, using the existing ICU ctype functions.  */
    BEGIN_NS_STD_C_HEADER
      externC ICU_BOOL CDCL_U isgraphU   ( SAP_U4 c );
      externC ICU_BOOL CDCL_U ispunctU   ( SAP_U4 c );
      externC ICU_BOOL CDCL_U isxdigitU  ( SAP_U4 c );
    END_NS_STD_C_HEADER

  #else /* not ICU */
    #if defined(SAPonNT)
      /* A cast to wint_t (16-bit) is needed. Otherwise the compiler issues
       * "integral size mismatch in argument" if c is an int. */
      #define isalnumU(c)        iswalnum((wint_t)(c))
      #define isalphaU(c)        iswalpha((wint_t)(c))
      #define iscntrlU(c)        iswcntrl((wint_t)(c))
      #define islowerU(c)        iswlower((wint_t)(c))
      #define isgraphU(c)        iswgraph((wint_t)(c))
      #define isprintU(c)        iswprint((wint_t)(c))
      #define ispunctU(c)        iswpunct((wint_t)(c))
      #define isspaceU(c)        iswspace((wint_t)(c))
      #define isupperU(c)        iswupper((wint_t)(c))
      #define isxdigitU(c)       iswxdigit((wint_t)(c))

    #else
      /* We use the w-functions even for SAP_UC_is_UTF16_without_wchar */
      #define isalnumU(c)        iswalnum(c)
      #define isalphaU(c)        iswalpha(c)
      #define iscntrlU(c)        iswcntrl(c)
      #define islowerU(c)        iswlower(c)
      #define isgraphU(c)        iswgraph(c)
      #define isprintU(c)        iswprint(c)
      #define ispunctU(c)        iswpunct(c)
      #define isspaceU(c)        iswspace(c)
      #define isupperU(c)        iswupper(c)
      #define isxdigitU(c)       iswxdigit(c)

    #endif /* different platforms */
  #endif /* SAPwithICU or not */
#endif /* SAPwithUNICODE */


#if defined(SAPccQ) && defined(SAPonNT)
  /* ccQ requires that if function is a realized as macro that there is a real
   * function behind the macro. This is not the case for isascii on NT.
   * Therefore we declare a prototype ourselves here.
   */
  BEGIN_NS_STD_C_HEADER
    #undef isascii
    externC int isascii ( int c );
  END_NS_STD_C_HEADER
#endif


/*-----------------------------------------------------------------------------
 * sapuc.h  -   toupper and tolower
 *----------------------------------------------------------------------------*/
#ifndef SAPwithUNICODE

  #define tolowerU(c)        ( sizeof(c) == SAP_UC_LN \
                               ? tolower(U_CHAR(c))   \
                               : /*LINTED_SIGNEDCHAR*/ tolower(c) )
  #define toupperU(c)        ( sizeof(c) == SAP_UC_LN \
                               ? toupper(U_CHAR(c))   \
                               : /*LINTED_SIGNEDCHAR*/ toupper(c) )

#else /* Now SAPwithUNICODE */

  #if defined (SAPwithICU)
    BEGIN_NS_STD_C_HEADER
      externC __SAP_DLL_DECLSPEC SAP_U4 (CDCL_U *tolowerU)( SAP_U4  c );
      externC __SAP_DLL_DECLSPEC SAP_U4 (CDCL_U *toupperU)( SAP_U4  c );
    END_NS_STD_C_HEADER

  #else /* not ICU */
    #if defined(SAPonNT)
      /* A cast to wint_t (16-bit) is needed. Otherwise the compiler issues
       * "integral size mismatch in argument" if c is an int. */
      #define tolowerU(c)        towlower((wint_t)(c))
      #define toupperU(c)        towupper((wint_t)(c))

    #else
      /* We use the w-functions even for SAP_UC_is_UTF16_without_wchar */
      #define tolowerU(c)        towlower(c)
      #define toupperU(c)        towupper(c)

    #endif /* different platforms */
  #endif /* SAPwithICU or not */
#endif /* SAPwithUNICODE */


/*-----------------------------------------------------------------------------
 *
 * sapuc.h  -   Declaration and Implementation of functions which must be in
 *              the same translation unit as the code which calls them.
 *----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
 * sapuc.h  -  struct stat_U and functions statU, lstatU, fstatU
 *
 * struct stat_U must be used on OS/400, because struct stat contains a
 * char array. On the other platforms, stat_U and stat are identical.
 *
 * Attention:  SAPUC_H_WITH_statU must be #defined BEFORE including sapuc.h.
 *----------------------------------------------------------------------------*/
#if defined(SAPUC_H_WITH_statU)   || defined(SAPUC_H_WITH_lstatU) || \
    defined(SAPU16C_WITH_statU16) || defined(SAPU16C_WITH_lstatU16)

  #include <sys/stat.h>   /* In case it has not yet been included. This file
                           * may define 'stat' to be 'stat64', for example.
                           */
  /*---------------------------------------------------------------------------
   * sapuc.h - declaration part for statU, lstatU etc.
   *--------------------------------------------------------------------------*/
  #ifndef SAPwithUNICODE

    #ifdef SAPonNT
      #define stat_U                      _stat
      #define _statU( path, buffer )      _stat( path, buffer )
      #ifdef SAPUC_H_WITH_statU
        #define  statU( path, buffer )    _stat( path, buffer )
      #endif
      /* lstat() does not exist */
      #define fstatU( fdes, buffer )      _fstat( fdes, buffer )
    #else
      #define stat_U                       stat
      #ifdef SAPUC_H_WITH_statU
        #define  statU( path, buffer )     stat( path, buffer )
      #endif
      #ifdef SAPUC_H_WITH_lstatU
        #define lstatU( path, buffer )     lstat( path, buffer )
      #endif
      #define fstatU( fdes, buffer )       fstat( fdes, buffer )
    #endif

  #else  /* Now SAPwithUNICODE */

    #if defined(SAPonOS400)
      struct stat_U {
        mode_t          st_mode;
        ino_t           st_ino;
        nlink_t         st_nlink;
        uid_t           st_uid;
        gid_t           st_gid;
        off_t           st_size;
        time_t          st_atime;
        time_t          st_mtime;
        time_t          st_ctime;
        dev_t           st_dev;
        size_t          st_blksize;
        unsigned long   st_allocsize;
        SAP_UC          st_objtype[11];
        unsigned short  st_ccsid;
        unsigned short  st_codepage;
        unsigned int    st_ino_gen_id;
      };
    #elif defined(SAPonNT)
      #define stat_U    _stat
    #else
      #define stat_U    stat
    #endif

    #if defined(SAPonOS400)
      #ifdef SAPUC_H_WITH_statU
        externC int statU ( const SAP_UC *path, struct stat_U *buffer );
      #endif
      #ifdef SAPUC_H_WITH_lstatU
        externC int lstatU( const SAP_UC *path, struct stat_U *buffer );
      #endif
      externC int fstatU( int fdes,           struct stat_U *buffer );
      #elif defined(SAPonNT)
      #define _statU( wpath, buffer )       _wstat( wpath, buffer )
      #ifdef SAPUC_H_WITH_statU
        #define  statU( wpath, buffer )     _wstat( wpath, buffer )
      #endif
      #define fstatU( fdes,  buffer )       _fstat( fdes,  buffer )
    #elif defined(SAPonUNIX)
      struct stat_U;
      #ifdef SAPUC_H_WITH_statU
        static int statU ( const SAP_UC *path, struct stat_U *buffer );
      #endif
      #ifdef SAPUC_H_WITH_lstatU
        static int lstatU( const SAP_UC *path, struct stat_U *buffer );
      #endif
      #define fstatU( fdes, buffer )         fstat( fdes, buffer )
    #else
      #error "statU() not yet implemented on this platform"
    #endif /* different platforms */

  #endif /* SAPwithUNICODE */

  /*---------------------------------------------------------------------------
   * sapuc.h - implementation part for statU, lstatU etc.
   *
   * stat() can be a macro which maps to different functions, depending
   * on feature-test macros (e.g. Tru64). sizeof(struc stat) and the
   * sizes of its members may also depend on feature-test macros.
   * The only way to ensure that users of statU() make the same assumptions
   * on struct stat as statU() itself is to have everything in one
   * translation unit.
   *--------------------------------------------------------------------------*/
  #if defined(SAPwithUNICODE) || defined(SAPU16C_LIB)

  /* Auxiliary definitiones, includes and prototypes. */
  #if defined(SAPU16C_LIB)
    /* Function names ending with U16 */
    #define FN_U16(fn)  fn ## 16
  #else
    #define FN_U16(fn)  fn
  #endif

  #include <errno.h>
  externC size_t U2sToUtf8s (char *     , const SAP_UTF16 *, size_t);
  #define nlsui_u2conv_error(dest, src, len, fileId, line)  do ; while(0)

  #if defined(SAPUC_H_WITH_statU) || defined(SAPU16C_WITH_statU16)
  #if defined(SAPonUNIX)

  static int FN_U16(statU) ( const SAP_UTF16 *wpath, struct stat_U *buffer )
  {
    char cpath[MAX_PATH_LN];
    char *cpath1Ptr;
    size_t nchar;

    if (NULL == wpath) cpath1Ptr = NULL;
    else
    {
      nchar = U2sToUtf8s(cpath, wpath, MAX_PATH_LN);
      if ((size_t)-1 == nchar)
      {
        nlsui_u2conv_error(cpath, wpath, MAX_PATH_LN, __FILE__, __LINE__);
        return -1;
      }
      if( (size_t)MAX_PATH_LN == nchar )
      {
        errno = ENAMETOOLONG;
        return -1;
      }
      cpath1Ptr = cpath;
    }
    return stat(cpath1Ptr, buffer);
  } /*  statU() */

  #endif /* platform */
  #endif /* SAPUC_H_WITH_statU */

  #if defined(SAPUC_H_WITH_lstatU) || defined(SAPU16C_WITH_lstatU16)
  #if defined(SAPonUNIX)

  static int FN_U16(lstatU) ( const SAP_UTF16 *wpath, struct stat_U *buffer )
  {
    char cpath[MAX_PATH_LN];
    char *cpath1Ptr;
    size_t nchar;

    if (NULL == wpath) cpath1Ptr = NULL;
    else
    {
      nchar = U2sToUtf8s(cpath, wpath, MAX_PATH_LN);
      if ((size_t)-1 == nchar)
      {
        nlsui_u2conv_error(cpath, wpath, MAX_PATH_LN, __FILE__, __LINE__);
        return -1;
      }
      if( (size_t)MAX_PATH_LN == nchar )
      {
        errno = ENAMETOOLONG;
        return -1;
      }
      cpath1Ptr = cpath;
    }
    return lstat(cpath1Ptr, buffer);
  } /*  lstatU() */

  #endif /* platform */
  #endif /* SAPUC_H_WITH_lstatU */

  #undef FN_U16

  #endif /* defined(SAPwithUNICODE) || defined(SAPU16C_LIB) */

#endif /* SAPUC_H_WITH_statU etc */

/*-----------------------------------------------------------------------------
 * sapuc.h  -   undef CDCL_U
 *----------------------------------------------------------------------------*/
#undef CDCL_U
/*----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
 * sapuc.h  -   includes for AS/400 -
 *----------------------------------------------------------------------------*/
#if defined(SAPonOS400) || defined(SAPwithPASE400)
  #include "o4global.h"
#endif
/*-----------------------------------------------------------------------------
 * sapuc.h  -   end of includes for AS/400 -
 *----------------------------------------------------------------------------*/

#endif /* SAPUC_H */
