/*!**************************************************************************

  module      : vpc13.h

  -------------------------------------------------------------------------

  responsible : MarcoP

  special area:
  description : 

  last changed: 2000-01-20
  see also    :

  -------------------------------------------------------------------------



    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/


#ifndef VPC13_H
#define VPC13_H



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/
#include "gpr01.h"
#include "vpc00c.h"
#include "vpc0013c.h"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/
void p13intcat (char *buf, const char *cast, int npar, const tsp00_Int4 par []);
void p13dynparameter (void (*outstmt) (tpc_globals*),
	void (*outcnt) (tpc_globals*), tpc_globals *pc, tpcCode *scode);
void p13bsqlstart (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13esqlstart (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13start (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13whenever (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13va2bind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode, int va2no);
void p13va3bind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode, int va3no);
void p13cabind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13xabind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13pabind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode, int pano);
void p13kabind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode, int kano);
void p13prbind (void (*outstmt) (tpc_globals*), void (*outcnt) (tpc_globals*),
	void (*quocnt) (tpc_globals*), tpc_globals *pc, tpcCode *scode,
	int prno);
void p13stbind (void (*outstmt) (tpc_globals*), void (*outcnt) (tpc_globals*),
	void (*quocnt) (tpc_globals*), tpc_globals *pc, tpcCode *scode,
	int stno, int rstno, tpr01_SQLStatementOptionEnum fOption);
void p13sdbind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode, int sdno);
void p13atbind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode, int atno);
void p13cancel (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13version (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13fnbind (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode, int fnno);
void p13daaddr (void (*outstmt) (tpc_globals*),
	void (*outcnt) (tpc_globals*), tpc_globals *pc, tpcCode *scode);
void p13sqlstm (void (*outstmt) (tpc_globals*), void (*outcnt) (tpc_globals*),
	void (*quocnt) (tpc_globals*), tpc_globals *pc, tpcCode *scode);
void p13option (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13trace (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13trcline (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13modtrace (void (*outstmt) (tpc_globals*), void (*outcnt) (tpc_globals*),
	void (*quocnt) (tpc_globals*), tpc_globals *pc, tpcCode *scode);
void p13macro (void (*outstmt) (tpc_globals*), tpc_globals *pc, tpcCode *scode,
	int macno);
void p13prepare (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13describe (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13nolog (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13open (void (*outstmt) (tpc_globals*), tpc_globals *pc, tpcCode *scode,
	int openno);
void p13declare (void (*outstmt) (tpc_globals*), tpc_globals *pc, tpcCode *scode, int prno);
void p13immediateexecute (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode, int statemno);
void p13command (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13dbsname (void (*outstmt) (tpc_globals*),
	void (*outcnt) (tpc_globals*), void (*quocnt) (tpc_globals*),
	tpc_globals *pc, tpcCode *scode,
	int gano, int dbpos, int dblen, int nodepos, int nodelen);
void p13reconnect (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13exit (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);
void p13dexit (void (*outstmt) (tpc_globals*), tpc_globals *pc,
	tpcCode *scode);


#endif  /* VPC13_H */
