/*



    ========== licence begin  GPL
    Copyright (c) 1998-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*/
#if defined(CN72) && defined(_WIN32)
  #line 3 "d:\\v72\\sys\\src\\cn\\hcn23.h"
#endif 

/* ==================================================================
 * @lastChanged: "1998-05-07  13:23"
 *
 * @filename:    hcn23.h
 * @purpose:     "param calculation"
 * @release:     7.1.0.0
 * @see:         "-.-"
 *
 * @copyright:   (c) 1998-2004 SAP AG"
 *
 * ==================================================================
 *
 * responsible:   Bernd Vorsprach (D025588 - Bernd.Vorsprach@SAP-AG.de)
 *
 * created:       1998-02-10 by Bernd Vorsprach
 *
 * purpose:       calculation module for parameter management
 *                               
 * ==================================================================
 */

#ifndef _HCN23_H_
#define _HCN23_H_

/* ------------------------------------------------------------------
 * INCLUDES
 * ------------------------------------------------------------------
 */
#include "gcn00.h"
#include "gcn002.h"

/* SPECIFICATION PUBLIC FUNCTION cn23InitializeChecking
 * ------------------------------------------------------------------
 * purpose: assign the current value (szInput) of all parameters
 *          to the calculation value (szCalc) an set the calculation
 *          status to unknown
 */
void cn23InitializeChecking (
      tcn002_XParameter * pParameter);

/* SPECIFICATION PUBLIC FUNCTION cn23PrintDependencies
 * ------------------------------------------------------------------
 */
void cn23PrintDependencies (
      tcn002_XParameter * pFirst);

/* SPECIFICATION PUBLIC FUNCTION cn23CheckConstraint
 * ------------------------------------------------------------------
 */
tcn00_Error cn23CheckConstraint (
      tcn002_XParamData * pXParamData,
      tcn002_XParameter * pParameter,
      char              * replyData,
      int               * replyLen);

/* SPECIFICATION PUBLIC FUNCTION cn23CalculateParameter
 * ------------------------------------------------------------------
 */
tcn00_Error cn23CalculateParameter (
      tcn002_XParamData * pXParamData,
      tcn002_XParameter * pParameter,
      char             * replyData,
      int              * replyLen);

/* SPECIFICATION PUBLIC FUNCTION cn23GetCalcState
 * ------------------------------------------------------------------
 * purpose: analyze the check state and print an error/request in the
 *          answer buffer
 */
tcn00_Error cn23GetCalcState (
      tcn002_XParameter * pParameter,
      char             * pBuffer,
      tcn002_XPPropValue  nVisible);

#endif /* _HCN23_H_ */
