#include "gos00k.h"
#include "geo007_1.h"
#include "gos74.h"
#include "RunTime/Tasking/RTETask_IScheduling.hpp"

extern "C" VOID sql55k_remote_vendexcl ( PPTASK_CTRL_REC ppCTask,
                                         PTASK_CTRL_REC  pFromTask,
                                         PPDLQ_REC       ppCurrReq,
                                         ULONG           ulDummyParam );

class RTETask_SchedulingNT : public RTETask_IScheduling
{
public:
    void ActivateTaskInOtherUKT(RTE_TCB TCB,RTE_UKT UKTCB,RTE_TCB nextTCB)
    {
        sql74k_UToU_enqu_and_wake ( UKTCB, TCB, nextTCB.ukt(),nextTCB, sql55k_remote_vendexcl, 0 );
    }

    void PutTaskToRavQueue(RTE_TCB TCB,RTE_UKT UKTCB,SAPDB_ULong reqType)
    {
        UKTCB.numRegWait()--;
        TCB.requestType() = REQ_VENDEXCL;
        sql74k_RUN_enqu ( UKTCB, TCB, &(TCB.queueElem()), BASE_PRIO_RAV );
    }

    void PutTaskToRexQueue(RTE_TCB TCB,RTE_UKT UKTCB,SAPDB_ULong reqType,SAPDB_Bool condition)
    {
        TCB.requestType()     = (ULONG)reqType;
        sql74k_RUN_enqu ( UKTCB, TCB, &(TCB.queueElem()),BASE_PRIO_REX );
    }

    void Reschedule(RTE_UKT &UKT)
    {
        PUKT_CTRL_REC uktCtrlRec = UKT;
        GOTO_DISP(&uktCtrlRec);
        UKT = uktCtrlRec;   // uktCtrlRec may have been changed by GOTO_DISP() 
    }
private:
    RTETask_SchedulingNT(){};
    static RTETask_SchedulingNT m_Instance;

friend class RTETask_IScheduling;
};

RTETask_SchedulingNT RTETask_SchedulingNT::m_Instance;

RTETask_IScheduling& RTETask_IScheduling::Instance()
{
    return RTETask_SchedulingNT::m_Instance;
}

