/*
        ========== licence begin  GPL
        Copyright (C) 2005 SAP AG

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
        ========== licence end
 */
#ifndef RTE_MESSAGES_HPP
#define RTE_MESSAGES_HPP

// Generated Header file RTE_Messages.hpp.
// Generated by genmsg V2.2 DO NOT EDIT

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"

#define RTEERR_TLS_KEY_CREATE                          SAPDBErr_MessageList::Error,0,"Thread local storage key create failed",0
#define RTEERR_TLS_KEY_CREATE_ID 0
#define RTEERR_TLS_KEY_DELETE                          SAPDBErr_MessageList::Error,1,"Thread local storage key %s delete failed",1
#define RTEERR_TLS_KEY_DELETE_ID 1
#define RTEERR_TLS_GET                                 SAPDBErr_MessageList::Error,2,"Thread local storage key %s get value failed",1
#define RTEERR_TLS_GET_ID 2
#define RTEERR_TLS_SET                                 SAPDBErr_MessageList::Error,3,"Thread local storage key %s set value %s failed",2
#define RTEERR_TLS_SET_ID 3
#define RTEERR_ALLOCATION_FAILED                       SAPDBErr_MessageList::Error,4,"Allocation of %s failed",1
#define RTEERR_ALLOCATION_FAILED_ID 4
#define RTEERR_FORMATTING_FAILED                       SAPDBErr_MessageList::Error,5,"Formatting failed :%s",1
#define RTEERR_FORMATTING_FAILED_ID 5
#define RTEERR_START_FAILED                            SAPDBErr_MessageList::Error,6,"Starting %s failed",1
#define RTEERR_START_FAILED_ID 6
#define RTEERR_SYS_LOAD_DLL                            SAPDBErr_MessageList::Error,7,"Loading DLL %s failed",1
#define RTEERR_SYS_LOAD_DLL_ID 7
#define RTEERR_SYS_LOAD_DLL_FUNC                       SAPDBErr_MessageList::Error,8,"Loading function %s failed",1
#define RTEERR_SYS_LOAD_DLL_FUNC_ID 8
#define RTEERR_SYS_ALLOC_INST                          SAPDBErr_MessageList::Error,9,"No more memory for %s instance available",1
#define RTEERR_SYS_ALLOC_INST_ID 9
#define RTEERR_SYS_ALLOC_ARRAY_INST                    SAPDBErr_MessageList::Error,10,"No more memory for array of %s %s instances available",2
#define RTEERR_SYS_ALLOC_ARRAY_INST_ID 10
#define RTEERR_SYS_FREE_DLL                            SAPDBErr_MessageList::Error,11,"Release DLL %s failed",1
#define RTEERR_SYS_FREE_DLL_ID 11
#define RTEERR_SYS_COULD_NOT_CALCULATE_MEMSIZE         SAPDBErr_MessageList::Error,12,"size of memory block could not be calculated",0
#define RTEERR_SYS_COULD_NOT_CALCULATE_MEMSIZE_ID 12
#define RTEERR_SYS_COULD_NOT_ALLOCATE_MEMORY           SAPDBErr_MessageList::Error,13,"could not allocate any memory",0
#define RTEERR_SYS_COULD_NOT_ALLOCATE_MEMORY_ID 13
#define RTEERR_SYS_MEM_TYPE_NOT_AVAILABLE              SAPDBErr_MessageList::Error,14,"%s memory not available",1
#define RTEERR_SYS_MEM_TYPE_NOT_AVAILABLE_ID 14
#define RTEERR_SYNTAX_ERROR                            SAPDBErr_MessageList::Error,15,"Error allocating %s memory: wrong syntax in expression %s",2
#define RTEERR_SYNTAX_ERROR_ID 15
#define RTEERR_CONF_COULD_NOT_OPEN_FILE_FOR_READ       SAPDBErr_MessageList::Error,16,"Could not open file %s for read, rc = %s",2
#define RTEERR_CONF_COULD_NOT_OPEN_FILE_FOR_READ_ID 16
#define RTEERR_CONF_COULD_NOT_READ_FROM_FILE           SAPDBErr_MessageList::Error,17,"Could not read from file %s, rc = %s",2
#define RTEERR_CONF_COULD_NOT_READ_FROM_FILE_ID 17
#define RTEERR_CONF_COULD_NOT_OPEN_FILE_FOR_WRITE      SAPDBErr_MessageList::Error,18,"Could not open file %s for write, rc = %s",2
#define RTEERR_CONF_COULD_NOT_OPEN_FILE_FOR_WRITE_ID 18
#define RTEERR_CONF_COULD_NOT_WRITE_TO_FILE            SAPDBErr_MessageList::Error,19,"Could not write to file %s, rc = %s",2
#define RTEERR_CONF_COULD_NOT_WRITE_TO_FILE_ID 19
#define RTEERR_CONF_COULD_NOT_SEEK_IN_FILE             SAPDBErr_MessageList::Error,20,"Could not seek in file %s, rc = %s",2
#define RTEERR_CONF_COULD_NOT_SEEK_IN_FILE_ID 20
#define RTEERR_CONF_COULD_NOT_CLOSE_FILE               SAPDBErr_MessageList::Error,21,"Could not close file %s, rc = %s",2
#define RTEERR_CONF_COULD_NOT_CLOSE_FILE_ID 21
#define RTEERR_CONF_UNKNOWN_FILETYPE                   SAPDBErr_MessageList::Error,22,"file %s has unknown type",1
#define RTEERR_CONF_UNKNOWN_FILETYPE_ID 22
#define RTEERR_CONF_NEVER_VERIFIED                     SAPDBErr_MessageList::Error,23,"configuration has never been verified by kernel",0
#define RTEERR_CONF_NEVER_VERIFIED_ID 23
#define RTEERR_CONF_PARAMETER_NAME_TOO_LONG            SAPDBErr_MessageList::Error,24,"Length of Parameter name %s exceeds maximum length of %s characters",2
#define RTEERR_CONF_PARAMETER_NAME_TOO_LONG_ID 24
#define RTEERR_CONF_STRING_VALUE_TOO_LONG              SAPDBErr_MessageList::Error,25,"Length of string value %s exceeds maximum length of %s characters",2
#define RTEERR_CONF_STRING_VALUE_TOO_LONG_ID 25
#define RTEERR_CONF_COULD_NOT_BUILD_COMPLETE_PATH      SAPDBErr_MessageList::Error,26,"could not build complete path for file name %s (error %s - code %s)",3
#define RTEERR_CONF_COULD_NOT_BUILD_COMPLETE_PATH_ID 26
#define RTEERR_CONF_PARAMFILE_NOT_FOUND                SAPDBErr_MessageList::Error,27,"Parameter file for database %s not found, rc = %s",2
#define RTEERR_CONF_PARAMFILE_NOT_FOUND_ID 27
#define RTEERR_CONF_PARAMNAME_LENGTH_TOO_BIG           SAPDBErr_MessageList::Error,28,"length of parameter names in parameter file (%s) exceeds length configured for kernel (%s)",2
#define RTEERR_CONF_PARAMNAME_LENGTH_TOO_BIG_ID 28
#define RTEERR_CONF_PARAMVALUE_LENGTH_TOO_BIG          SAPDBErr_MessageList::Error,29,"length of parameter string values in parameter file (%s) exceeds length configured for kernel (%s)",2
#define RTEERR_CONF_PARAMVALUE_LENGTH_TOO_BIG_ID 29
#define RTEERR_CONF_NOT_ENOUGH_SPACE_FOR_STRING_PARAM  SAPDBErr_MessageList::Error,30,"not enough space for string parameter: found %s bytes, needed %s bytes",2
#define RTEERR_CONF_NOT_ENOUGH_SPACE_FOR_STRING_PARAM_ID 30
#define RTEERR_CONF_TYPE_MISMATCH                      SAPDBErr_MessageList::Error,31,"parameter type mismatch: found %s, needed %s",2
#define RTEERR_CONF_TYPE_MISMATCH_ID 31
#define RTEERR_CONF_INCONSISTENT_HSS_CONFIG            SAPDBErr_MessageList::Error,32,"the list of configured HotStandBy nodes is not consistent",0
#define RTEERR_CONF_INCONSISTENT_HSS_CONFIG_ID 32
#define RTEERR_CONF_LOCAL_NODE_NOT_FOUND_IN_HSS_CONFIG SAPDBErr_MessageList::Error,33,"the local node name (%s) could not be found in the list of configured HotStandBy nodes",1
#define RTEERR_CONF_LOCAL_NODE_NOT_FOUND_IN_HSS_CONFIG_ID 33
#define RTEERR_CONF_MISSING_DEFAULT_HSS_NODE           SAPDBErr_MessageList::Error,34,"there are HotStandBy nodes configured, but the default node (node #1) is missing",0
#define RTEERR_CONF_MISSING_DEFAULT_HSS_NODE_ID 34
#define RTEERR_CONF_FSIZE_EXCEEDS_ULIMIT1              SAPDBErr_MessageList::Error,35,"The configured volume size of %s MB for %s %s exceeds the limit set by ulimits (%s MB).",4
#define RTEERR_CONF_FSIZE_EXCEEDS_ULIMIT1_ID 35
#define RTEERR_CONF_FSIZE_EXCEEDS_ULIMIT2              SAPDBErr_MessageList::Error,36,"Please adjust the volume size or the ulimit.",0
#define RTEERR_CONF_FSIZE_EXCEEDS_ULIMIT2_ID 36
#define RTEERR_CONF_DUPLICATE_VOLUME_NAME              SAPDBErr_MessageList::Error,37,"Duplicate volume name found: %s",1
#define RTEERR_CONF_DUPLICATE_VOLUME_NAME_ID 37
#define RTEERR_FILE_NOT_FOUND                          SAPDBErr_MessageList::Error,38,"The file '%s' was not found",1
#define RTEERR_FILE_NOT_FOUND_ID 38
#define RTEERR_ACCESS_DENIED_ON_XX                     SAPDBErr_MessageList::Error,39,"Access on '%s' denied",1
#define RTEERR_ACCESS_DENIED_ON_XX_ID 39
#define RTEERR_ACCESS_DENIED                           SAPDBErr_MessageList::Error,40,"Access denied",0
#define RTEERR_ACCESS_DENIED_ID 40
#define RTEERR_SETTING_THRD_PRIO                       SAPDBErr_MessageList::Error,41,"Could not set the thread priority, TID:0x%s",1
#define RTEERR_SETTING_THRD_PRIO_ID 41
#define RTEERR_LOCAL_NODE_TOO_LONG                     SAPDBErr_MessageList::Error,42,"Local node name '%s' too long",1
#define RTEERR_LOCAL_NODE_TOO_LONG_ID 42
#define RTEERR_ITEMREGISTER_CORRUPT                    SAPDBErr_MessageList::Error,43,"RTE_ItemRegister is corrupt! Presumably the item '%s' has been deleted but not deregistered, item is %s, should be %s. ElementCounter is %s",4
#define RTEERR_ITEMREGISTER_CORRUPT_ID 43
#define RTEERR_SYS_LOAD_SHARED_LIB                     SAPDBErr_MessageList::Error,44,"Loading DLL %s failed %s",2
#define RTEERR_SYS_LOAD_SHARED_LIB_ID 44
#define RTEERR_SYS_UNLOAD_SHARED_LIB                   SAPDBErr_MessageList::Error,45,"Unloading DLL %s failed %s",2
#define RTEERR_SYS_UNLOAD_SHARED_LIB_ID 45
#define RTEERR_SYS_GET_PROC_ADDRESS                    SAPDBErr_MessageList::Error,46,"Get address for procedure %s from DLL %s failed %s",3
#define RTEERR_SYS_GET_PROC_ADDRESS_ID 46
#define RTEERR_HSS_API_DLL_NOT_USABLE                  SAPDBErr_MessageList::Error,47,"Call to %s failed since RTEHSS_Api is not usable",1
#define RTEERR_HSS_API_DLL_NOT_USABLE_ID 47
#define RTEERR_HSS_APICALL_FAILED                      SAPDBErr_MessageList::Error,48,"Call to %s failed: Reported result code %s(%s)",3
#define RTEERR_HSS_APICALL_FAILED_ID 48
#define RTEERR_XP_INVALID_LOG_MODE                     SAPDBErr_MessageList::Error,49,"Invalid logmode '%s'",1
#define RTEERR_XP_INVALID_LOG_MODE_ID 49
#define RTEERR_GATEWAY_PARM_FOUND                      SAPDBErr_MessageList::Error,50,"GATEWAY configuration found - KERNEL can't be started",0
#define RTEERR_GATEWAY_PARM_FOUND_ID 50
#define RTEERR_XP_INVALID_FORMATTING_MODE              SAPDBErr_MessageList::Error,51,"Invalid formatting mode '%s'",1
#define RTEERR_XP_INVALID_FORMATTING_MODE_ID 51
#define RTEERR_XP_TOO_MANY_DEVSPACES                   SAPDBErr_MessageList::Error,52,"Too many volumes, type='%s', allowed=%s",2
#define RTEERR_XP_TOO_MANY_DEVSPACES_ID 52
#define RTEERR_MALLOC_FAILED_FOR                       SAPDBErr_MessageList::Error,53,"memory allocation failed for '%s'",1
#define RTEERR_MALLOC_FAILED_FOR_ID 53
#define RTEERR_XP_TOO_MANY_TASKCLUSTER                 SAPDBErr_MessageList::Error,54,"Too many Taskclusters, wanted=%s, allowed=%s",2
#define RTEERR_XP_TOO_MANY_TASKCLUSTER_ID 54
#define RTEERR_INVALID_DEVSPACE_NO                     SAPDBErr_MessageList::Error,55,"Invalid volume number %s",1
#define RTEERR_INVALID_DEVSPACE_NO_ID 55
#define RTEERR_ILLEGAL_XP_TYPE                         SAPDBErr_MessageList::Error,56,"Illegal xp_type %s   ",1
#define RTEERR_ILLEGAL_XP_TYPE_ID 56
#define RTEERR_DEVSPACE_ALREADY_EXISTS                 SAPDBErr_MessageList::Error,57,"Volume '%s' already exists",1
#define RTEERR_DEVSPACE_ALREADY_EXISTS_ID 57
#define RTEERR_XP_UNKNOWN_PARAM                        SAPDBErr_MessageList::Error,58,"unknown Parameter %s",1
#define RTEERR_XP_UNKNOWN_PARAM_ID 58
#define RTEERR_CANT_CHANGE_PARAMETER_ONLINE            SAPDBErr_MessageList::Error,59,"cannot change parameter %s while database is running",1
#define RTEERR_CANT_CHANGE_PARAMETER_ONLINE_ID 59
#define RTEERR_ITERATION_HAD_NOT_BEEN_STARTED          SAPDBErr_MessageList::Error,60,"iteration through the parameter set had not been started",0
#define RTEERR_ITERATION_HAD_NOT_BEEN_STARTED_ID 60
#define RTEERR_INVALID_NODE_NAME_ENTRY                 SAPDBErr_MessageList::Error,61,"invalid HSS_NODE_NAME entry in parameter file: %s=%s",2
#define RTEERR_INVALID_NODE_NAME_ENTRY_ID 61
#define RTEERR_GENERAL                                 SAPDBErr_MessageList::Error,62,"RTE error %s",1
#define RTEERR_GENERAL_ID 62
#define RTEERR_DBREG_COULD_NOT_READ_RELEASE_VERSION    SAPDBErr_MessageList::Error,63,"could not read release version for installation from registry",0
#define RTEERR_DBREG_COULD_NOT_READ_RELEASE_VERSION_ID 63
#define RTEERR_DBREG_COULD_NOT_WRITE_TO_REGISTRY       SAPDBErr_MessageList::Error,64,"could not write to registry, error message: %s",1
#define RTEERR_DBREG_COULD_NOT_WRITE_TO_REGISTRY_ID 64
#define RTEERR_DBREG_COULD_NOT_READ_FROM_REGISTRY      SAPDBErr_MessageList::Error,65,"could not read from registry, error message: %s",1
#define RTEERR_DBREG_COULD_NOT_READ_FROM_REGISTRY_ID 65
#define RTEERR_DBREG_COULD_NOT_REMOVE_FROM_REGISTRY    SAPDBErr_MessageList::Error,66,"could not remove entry from registry, error message: %s",1
#define RTEERR_DBREG_COULD_NOT_REMOVE_FROM_REGISTRY_ID 66
#define RTEERR_DBREG_COULD_NOT_OPEN_CONSOLE            SAPDBErr_MessageList::Error,67,"Open console failed: last error = %s",1
#define RTEERR_DBREG_COULD_NOT_OPEN_CONSOLE_ID 67
#define RTEERR_DBREG_COULD_NOT_GET_KERNEL_STATE        SAPDBErr_MessageList::Error,68,"Getting Kernel state failed: %s",1
#define RTEERR_DBREG_COULD_NOT_GET_KERNEL_STATE_ID 68
#define RTEERR_DBREG_SERVICE_DB_LOCKED                 SAPDBErr_MessageList::Error,69,"Service database has been locked by another process",0
#define RTEERR_DBREG_SERVICE_DB_LOCKED_ID 69
#define RTEERR_DBREG_SERVICE_NOT_INSTALLED_CORRECTLY   SAPDBErr_MessageList::Error,70,"Service has not been installed correctly",0
#define RTEERR_DBREG_SERVICE_NOT_INSTALLED_CORRECTLY_ID 70
#define RTEERR_DBREG_SERVICE_NOT_INSTALLED             SAPDBErr_MessageList::Error,71,"Service '%s%s (%s)' not installed",3
#define RTEERR_DBREG_SERVICE_NOT_INSTALLED_ID 71
#define RTEERR_DBREG_SERVERDB_NOT_RESPONDING           SAPDBErr_MessageList::Error,72,"Time out, SERVERDB is not responding",0
#define RTEERR_DBREG_SERVERDB_NOT_RESPONDING_ID 72
#define RTEERR_DBREG_SERVICE_LOGON_FAILURE             SAPDBErr_MessageList::Error,73,"'%s%s (%s)' did not start due to a service logon failure",3
#define RTEERR_DBREG_SERVICE_LOGON_FAILURE_ID 73
#define RTEERR_DBREG_COULD_NOT_START                   SAPDBErr_MessageList::Error,74,"'%s' could not be started, rc = %s",2
#define RTEERR_DBREG_COULD_NOT_START_ID 74
#define RTEERR_DBREG_DB_NOT_STARTED                    SAPDBErr_MessageList::Error,75,"Database '%s' has not been started",1
#define RTEERR_DBREG_DB_NOT_STARTED_ID 75
#define RTEERR_DBREG_COULD_NOT_STOP                    SAPDBErr_MessageList::Error,76,"'%s' could not be stopped, rc = %s",2
#define RTEERR_DBREG_COULD_NOT_STOP_ID 76
#define RTEERR_DBREG_NAME_TOO_LONG                     SAPDBErr_MessageList::Error,77,"Database name %s too long",1
#define RTEERR_DBREG_NAME_TOO_LONG_ID 77
#define RTEERR_DBREG_ALREADY_STARTED                   SAPDBErr_MessageList::Error,78,"Database %s already started",1
#define RTEERR_DBREG_ALREADY_STARTED_ID 78
#define RTEERR_DBREG_ERROR_READING_PPID                SAPDBErr_MessageList::Error,79,"error reading pid file for watchdog process: %s",1
#define RTEERR_DBREG_ERROR_READING_PPID_ID 79
#define RTEERR_DBREG_ERROR_READING_PID                 SAPDBErr_MessageList::Error,80,"error reading pid file for database process: %s",1
#define RTEERR_DBREG_ERROR_READING_PID_ID 80
#define RTEERR_DBREG_CANNOT_CREATE_IPC_DB_DIR          SAPDBErr_MessageList::Error,81,"Cannot create ipc db directories for %s",1
#define RTEERR_DBREG_CANNOT_CREATE_IPC_DB_DIR_ID 81
#define RTEERR_DBREG_CANNOT_CREATE_IPC_US_DIR          SAPDBErr_MessageList::Error,82,"Cannot create ipc us directories for %s",1
#define RTEERR_DBREG_CANNOT_CREATE_IPC_US_DIR_ID 82
#define RTEERR_DBREG_IPC_DIR_STILL_EXISTS              SAPDBErr_MessageList::Error,83,"IPC directory '%s' still exists",1
#define RTEERR_DBREG_IPC_DIR_STILL_EXISTS_ID 83
#define RTEERR_DBREG_CANNOT_REMOVE_IPC_RESOURCES       SAPDBErr_MessageList::Error,84,"cannot remove IPC resources: %s",1
#define RTEERR_DBREG_CANNOT_REMOVE_IPC_RESOURCES_ID 84
#define RTEERR_DBREG_CANNOT_CATCH_SIGCLD               SAPDBErr_MessageList::Error,85,"cannot catch SIGCLD, %s",1
#define RTEERR_DBREG_CANNOT_CATCH_SIGCLD_ID 85
#define RTEERR_DBREG_CANNOT_IGNORE_SIGWINCH            SAPDBErr_MessageList::Error,86,"cannot ignore SIGWINCH, %s",1
#define RTEERR_DBREG_CANNOT_IGNORE_SIGWINCH_ID 86
#define RTEERR_DBREG_CANNOT_WAIT_FOR_STARTER           SAPDBErr_MessageList::Error,87,"Cannot wait for kernel starter: %s",1
#define RTEERR_DBREG_CANNOT_WAIT_FOR_STARTER_ID 87
#define RTEERR_DBREG_STARTER_DID_NOT_EXIT_NORMALLY     SAPDBErr_MessageList::Error,88,"Kernel starter process did not exit normally: %s",1
#define RTEERR_DBREG_STARTER_DID_NOT_EXIT_NORMALLY_ID 88
#define RTEERR_DBREG_CANNOT_REDIRECT_STDOUT            SAPDBErr_MessageList::Error,89,"Cannot redirect stdout to '/dev/null'",0
#define RTEERR_DBREG_CANNOT_REDIRECT_STDOUT_ID 89
#define RTEERR_DBREG_CANNOT_REDIRECT_STDERR            SAPDBErr_MessageList::Error,90,"Cannot redirect stderr to '/dev/null'",0
#define RTEERR_DBREG_CANNOT_REDIRECT_STDERR_ID 90
#define RTEERR_DBREG_CANNOT_OPEN_DEV_NULL              SAPDBErr_MessageList::Error,91,"Cannot open '/dev/null' for redirection",0
#define RTEERR_DBREG_CANNOT_OPEN_DEV_NULL_ID 91
#define RTEERR_DBREG_CANNOT_FORK                       SAPDBErr_MessageList::Error,92,"Cannot fork to start kernel",0
#define RTEERR_DBREG_CANNOT_FORK_ID 92
#define RTEERR_DBREG_KERNEL_DIED_BEFORE_ADMIN          SAPDBErr_MessageList::Error,93,"Check knldiag! Kernel died before reaching ADMIN state",0
#define RTEERR_DBREG_KERNEL_DIED_BEFORE_ADMIN_ID 93
#define RTEERR_DBREG_KERNEL_EXITED_BEFORE_ADMIN        SAPDBErr_MessageList::Error,94,"Check knldiag! Kernel exited with '%s' before reaching ADMIN state",1
#define RTEERR_DBREG_KERNEL_EXITED_BEFORE_ADMIN_ID 94
#define RTEERR_DBREG_CANNOT_GET_PID                    SAPDBErr_MessageList::Error,95,"Cannot get PID for %s",1
#define RTEERR_DBREG_CANNOT_GET_PID_ID 95
#define RTEERR_DBREG_GETTING_PID_FAILED                SAPDBErr_MessageList::Error,96,"STOP: Getting Kernel PID failed: %s",1
#define RTEERR_DBREG_GETTING_PID_FAILED_ID 96
#define RTEERR_DBREG_KILL_FAILED                       SAPDBErr_MessageList::Error,97,"STOP: Kill failed: %s",1
#define RTEERR_DBREG_KILL_FAILED_ID 97
#define RTEERR_DBREG_SLEEP_FAILED                      SAPDBErr_MessageList::Error,98,"Sleep failed: %s",1
#define RTEERR_DBREG_SLEEP_FAILED_ID 98
#define RTEERR_DBREG_COULD_NOT_KILL_KERNEL             SAPDBErr_MessageList::Error,99,"The database kernel process could not be killed (the process is still alive %s seconds after the kill command has been issued)",1
#define RTEERR_DBREG_COULD_NOT_KILL_KERNEL_ID 99
#define RTEERR_DBREG_WAITPID_FAILED                    SAPDBErr_MessageList::Error,100,"Waitpid failed: %s",1
#define RTEERR_DBREG_WAITPID_FAILED_ID 100
#define RTEERR_DBREG_KERNEL_EXE_MISSING                SAPDBErr_MessageList::Error,101,"kernel program missing '%s'",1
#define RTEERR_DBREG_KERNEL_EXE_MISSING_ID 101
#define RTEERR_DBREG_KERNEL_NOT_EXECUTABLE             SAPDBErr_MessageList::Error,102,"kernel program not executable '%s'",1
#define RTEERR_DBREG_KERNEL_NOT_EXECUTABLE_ID 102
#define RTEERR_DBREG_NO_RWX_PERMISSION                 SAPDBErr_MessageList::Error,103,"You don't have read+write+execute permission on the run-directory '%s'",1
#define RTEERR_DBREG_NO_RWX_PERMISSION_ID 103
#define RTEERR_DBREG_NO_DBROOT                         SAPDBErr_MessageList::Error,104,"Internal usage error: No dbroot given for '%s'",1
#define RTEERR_DBREG_NO_DBROOT_ID 104
#define RTEERR_DBREG_STOPPED_EV_LOG                    SAPDBErr_MessageList::Error,105,"'%s' has stopped unexpectedly, (view 'Application Event Log')",1
#define RTEERR_DBREG_STOPPED_EV_LOG_ID 105
#define RTEERR_DBREG_SERVICE_ACCOUNT_INVALID           SAPDBErr_MessageList::Error,106,"The account name is invalid or does not exist",0
#define RTEERR_DBREG_SERVICE_ACCOUNT_INVALID_ID 106
#define RTEERR_DBREG_SERVER_NODE_UNKNOWN               SAPDBErr_MessageList::Error,107,"Server node '%s' not available",1
#define RTEERR_DBREG_SERVER_NODE_UNKNOWN_ID 107
#define RTEERR_DBREG_CREAT_SERVICE_NO_ACCESS           SAPDBErr_MessageList::Error,108,"Could not create/update/delete service entry, access denied",0
#define RTEERR_DBREG_CREAT_SERVICE_NO_ACCESS_ID 108
#define RTEERR_DBREG_SERVICE_ERROR                     SAPDBErr_MessageList::Error,109,"Could not install/remove service, rc = %s",1
#define RTEERR_DBREG_SERVICE_ERROR_ID 109
#define RTEERR_DBREG_WRONG_DB_VERSION                  SAPDBErr_MessageList::Error,110,"Incompatible version of running kernel and console!\nRunning kernel-version is: %s\nActual console-version is: %s",2
#define RTEERR_DBREG_WRONG_DB_VERSION_ID 110
#define RTEERR_DBREG_COULD_NOT_CREATE_SERVER_KEY       SAPDBErr_MessageList::Error,111,"Server key not creatable",0
#define RTEERR_DBREG_COULD_NOT_CREATE_SERVER_KEY_ID 111
#define RTEERR_DBREG_SERVER_KEY_INVALID                SAPDBErr_MessageList::Error,112,"Server key file invalid",0
#define RTEERR_DBREG_SERVER_KEY_INVALID_ID 112
#define RTEERR_DBREG_NO_KERNEL_EXE                     SAPDBErr_MessageList::Error,113,"no kernel executable found",0
#define RTEERR_DBREG_NO_KERNEL_EXE_ID 113
#define RTEERR_GET_DBROOT_PGM_PATH                     SAPDBErr_MessageList::Error,114,"Determination of kernel executable path failed: OS_ERROR  %s, RTE_ERROR %s",2
#define RTEERR_GET_DBROOT_PGM_PATH_ID 114
#define RTEERR_DBREG_OPEN_KSS                          SAPDBErr_MessageList::Error,115,"Open kernel shared segment failed, rc = %s",1
#define RTEERR_DBREG_OPEN_KSS_ID 115
#define RTEERR_DBREG_OPEN_KERNEL_PROCESS               SAPDBErr_MessageList::Error,116,"Open kernel process failed, rc = %s",1
#define RTEERR_DBREG_OPEN_KERNEL_PROCESS_ID 116
#define RTEERR_DBREG_FREE_KSS                          SAPDBErr_MessageList::Error,117,"Free kernel shared segment failed, rc = %s",1
#define RTEERR_DBREG_FREE_KSS_ID 117
#define RTEERR_DBREG_WAIT_FOR_KERNEL                   SAPDBErr_MessageList::Error,118,"Wait for kernel process failed, rc = %s",1
#define RTEERR_DBREG_WAIT_FOR_KERNEL_ID 118
#define RTEERR_SYNC_RWREGION_ID_ZERO                   SAPDBErr_MessageList::Error,119,"task %s called %s for region 0",2
#define RTEERR_SYNC_RWREGION_ID_ZERO_ID 119
#define RTEERR_SYNC_RWREGION_ALREADY_ENTERED           SAPDBErr_MessageList::Error,120,"task %s called enter(), but is already in region %s",2
#define RTEERR_SYNC_RWREGION_ALREADY_ENTERED_ID 120
#define RTEERR_SYNC_RWREGION_LEAVE_WITHOUT_ENTER       SAPDBErr_MessageList::Error,121,"task %s called leave(), but region %s is free",2
#define RTEERR_SYNC_RWREGION_LEAVE_WITHOUT_ENTER_ID 121
#define RTEERR_SYNC_RWREGION_INCONSISTENCY             SAPDBErr_MessageList::Error,122,"incosistent state of rw-region %s",1
#define RTEERR_SYNC_RWREGION_INCONSISTENCY_ID 122
#define RTEERR_SYNC_VISEXCL_INVALID_REGION             SAPDBErr_MessageList::Error,123,"task %s called visexcl() for invalid region %s",2
#define RTEERR_SYNC_VISEXCL_INVALID_REGION_ID 123
#define RTEERR_SYNC_RWREGION_INDEFINITE_LOOP           SAPDBErr_MessageList::Error,124,"indefinite loops on region %s",1
#define RTEERR_SYNC_RWREGION_INDEFINITE_LOOP_ID 124
#define RTEERR_FILLING_UCONTEXT                        SAPDBErr_MessageList::Error,125,"Failed to fill ucontext",0
#define RTEERR_FILLING_UCONTEXT_ID 125
#define RTEERR_CREATE_THREAD                           SAPDBErr_MessageList::Error,126,"Failed to create thread '%s':(%s)%s",3
#define RTEERR_CREATE_THREAD_ID 126
#define RTEERR_RESUME_THREAD                           SAPDBErr_MessageList::Error,127,"Failed to resume thread '%s':(%s)%s",3
#define RTEERR_RESUME_THREAD_ID 127
#define RTEERR_COMMAND_PIPE_OPEN                       SAPDBErr_MessageList::Error,128,"Opening command pipe for '%s' failed [%s]",2
#define RTEERR_COMMAND_PIPE_OPEN_ID 128
#define RTEERR_COMMAND_PIPE_CLOSE                      SAPDBErr_MessageList::Error,129,"Closing command pipe for '%s' failed [%s]",2
#define RTEERR_COMMAND_PIPE_CLOSE_ID 129
#define RTEERR_OPEN_OUTPUT_PIPE                        SAPDBErr_MessageList::Error,130,"Open output pipe '%s' failed [%s]",2
#define RTEERR_OPEN_OUTPUT_PIPE_ID 130
#define RTEERR_OUTPUT_PIPE_READ                        SAPDBErr_MessageList::Error,131,"Read output pipe failed [%s]",1
#define RTEERR_OUTPUT_PIPE_READ_ID 131
#define RTEERR_UNEXPECTED_REPLY                        SAPDBErr_MessageList::Error,132,"Command '%s' got unexpected reply '%s'",2
#define RTEERR_UNEXPECTED_REPLY_ID 132
#define RTEERR_AUTOMATIC_RESTART_FAILED                SAPDBErr_MessageList::Error,133,"Database automatic restart failed",0
#define RTEERR_AUTOMATIC_RESTART_FAILED_ID 133
#define RTEERR_AUTOMATIC_SHUTDOWN_FAILED               SAPDBErr_MessageList::Error,134,"Database automatic shutdown failed",0
#define RTEERR_AUTOMATIC_SHUTDOWN_FAILED_ID 134
#define RTEERR_DEPENDEND_PROGRAMPATH_NOT_FOUND         SAPDBErr_MessageList::Error,135,"Installation dependend program path not found ([%s]%s[%s]%s)",4
#define RTEERR_DEPENDEND_PROGRAMPATH_NOT_FOUND_ID 135
#define RTEERR_CREATING_THREAD                         SAPDBErr_MessageList::Error,136,"Creating thread '%s' failed [%s]:%s",3
#define RTEERR_CREATING_THREAD_ID 136
#define RTEERR_RESUMING_THREAD                         SAPDBErr_MessageList::Error,137,"Resuming thread '%s' failed [%s]:%s",3
#define RTEERR_RESUMING_THREAD_ID 137
#define RTEERR_USER_UNKNOWN                            SAPDBErr_MessageList::Error,138,"UNIX user '%s' unknown",1
#define RTEERR_USER_UNKNOWN_ID 138
#define RTEERR_USERNAME_TOO_LONG                       SAPDBErr_MessageList::Error,139,"UNIX user name [%s] -> '%s' too long",2
#define RTEERR_USERNAME_TOO_LONG_ID 139
#define RTEERR_USERID_UNKNOWN                          SAPDBErr_MessageList::Error,140,"UNIX user id [%s] unknown",1
#define RTEERR_USERID_UNKNOWN_ID 140
#define RTEERR_GROUP_UNKNOWN                           SAPDBErr_MessageList::Error,141,"UNIX group '%s' unknown",1
#define RTEERR_GROUP_UNKNOWN_ID 141
#define RTEERR_GROUPNAME_TOO_LONG                      SAPDBErr_MessageList::Error,142,"UNIX group name [%s] -> '%s' too long",2
#define RTEERR_GROUPNAME_TOO_LONG_ID 142
#define RTEERR_GROUPID_UNKNOWN                         SAPDBErr_MessageList::Error,143,"UNIX group id [%s] unknown",1
#define RTEERR_GROUPID_UNKNOWN_ID 143
#define RTEERR_SETGID_FAILED                           SAPDBErr_MessageList::Error,144,"UNIX group id setting with setgid(%s) call failed: %s",2
#define RTEERR_SETGID_FAILED_ID 144
#define RTEERR_INITGROUPS_FAILED                       SAPDBErr_MessageList::Error,145,"UNIX inigroups(%s,%s) call failed: %s",3
#define RTEERR_INITGROUPS_FAILED_ID 145
#define RTEERR_SETUID_FAILED                           SAPDBErr_MessageList::Error,146,"UNIX user id setting with setuid(%s) call failed: %s",2
#define RTEERR_SETUID_FAILED_ID 146
#define RTEERR_REGISTRY_KEY_NOT_FOUND                  SAPDBErr_MessageList::Error,147,"UNIX installation registry key %s not found: %s",2
#define RTEERR_REGISTRY_KEY_NOT_FOUND_ID 147
#define RTEERR_OWNERNAME_MISMATCH                      SAPDBErr_MessageList::Error,148,"UNIX owner name mismatch: %s != %s",2
#define RTEERR_OWNERNAME_MISMATCH_ID 148
#define RTEERR_PATH_TOO_LONG                           SAPDBErr_MessageList::Error,149,"UNIX path too long: %s",1
#define RTEERR_PATH_TOO_LONG_ID 149
#define RTEERR_DATABASE_NOT_FOUND                      SAPDBErr_MessageList::Error,150,"UNIX database '%s' not found: %s",2
#define RTEERR_DATABASE_NOT_FOUND_ID 150
#define RTEERR_CHOWN_FAILED                            SAPDBErr_MessageList::Error,151,"UNIX change owner with chown(%s,%s,%s) failed: %s",4
#define RTEERR_CHOWN_FAILED_ID 151
#define RTEERR_STAT_FAILED                             SAPDBErr_MessageList::Error,152,"UNIX getting file status with stat(%s) failed: %s",2
#define RTEERR_STAT_FAILED_ID 152
#define RTEERR_FSTAT_FAILED                            SAPDBErr_MessageList::Error,153,"UNIX getting file status with fstat(%s) failed: %s",2
#define RTEERR_FSTAT_FAILED_ID 153
#define RTEERR_PASSWORD_MISMATCH                       SAPDBErr_MessageList::Error,154,"UNIX password mismatch",0
#define RTEERR_PASSWORD_MISMATCH_ID 154
#define RTEERR_USER_NOT_MEMBER_IN_GROUP                SAPDBErr_MessageList::Error,155,"UNIX user %s not member in group %s",2
#define RTEERR_USER_NOT_MEMBER_IN_GROUP_ID 155
#define RTEERR_CHMOD_FAILED                            SAPDBErr_MessageList::Error,156,"UNIX change mode with chmod(%s,%s) failed: %s",3
#define RTEERR_CHMOD_FAILED_ID 156
#define RTEERR_SECURITY_INIT_ATTRIBUTES                SAPDBErr_MessageList::Error,157,"Initialization of security attributes failed",0
#define RTEERR_SECURITY_INIT_ATTRIBUTES_ID 157
#define RTEERR_SECURITY_SET_SYNCHRONIZE_ACCESS         SAPDBErr_MessageList::Error,158,"Setting synchronized access failed, rc = %s",1
#define RTEERR_SECURITY_SET_SYNCHRONIZE_ACCESS_ID 158
#define RTEERR_SECURITY_INIT_DESCRIPTOR                SAPDBErr_MessageList::Error,159,"Initialization of security descriptor for %s failed, rc = %s",2
#define RTEERR_SECURITY_INIT_DESCRIPTOR_ID 159
#define RTEERR_SECURITY_LOCK_OBJ                       SAPDBErr_MessageList::Error,160,"Locking object failed, handle: %s, rc = %s",2
#define RTEERR_SECURITY_LOCK_OBJ_ID 160
#define RTEERR_TAG_GET_FILENAME                        SAPDBErr_MessageList::Error,161,"Get tag file name for %s resource %s failed, database: %s, id: %s",4
#define RTEERR_TAG_GET_FILENAME_ID 161
#define RTEERR_TAG_UNLINK_FILE                         SAPDBErr_MessageList::Error,162,"Unlink tag file %s failed, rc: %s",2
#define RTEERR_TAG_UNLINK_FILE_ID 162
#define RTEERR_TAG_UNKNOWN_USER_TYPE                   SAPDBErr_MessageList::Error,163,"Unknown user type: %s",1
#define RTEERR_TAG_UNKNOWN_USER_TYPE_ID 163
#define RTEERR_TAG_UNKNOWN_RESOURCE_TYPE               SAPDBErr_MessageList::Error,164,"Unknown resource type: %s",1
#define RTEERR_TAG_UNKNOWN_RESOURCE_TYPE_ID 164
#define RTEERR_TAG_CHECK_IPC_DIRECTORY                 SAPDBErr_MessageList::Error,165,"Check IPC directory failed",0
#define RTEERR_TAG_CHECK_IPC_DIRECTORY_ID 165
#define RTEERR_TAG_MISSING_DIRECTOY                    SAPDBErr_MessageList::Error,166,"Directory %s is missing, rc: %s",2
#define RTEERR_TAG_MISSING_DIRECTOY_ID 166
#define RTEERR_TAG_MAKE_DIRECTORY                      SAPDBErr_MessageList::Error,167,"Make directory %s failed, rc: %s",2
#define RTEERR_TAG_MAKE_DIRECTORY_ID 167
#define RTEERR_CANNOT_GET_PROCESS_GROUP_LIST           SAPDBErr_MessageList::Error,168,"UNIX get process group list with getgroups(%s) failed:%s",2
#define RTEERR_CANNOT_GET_PROCESS_GROUP_LIST_ID 168
#define RTEERR_CLUSTER_DB_ONLINE                       SAPDBErr_MessageList::Error,169,"MSCS failed to bring database resource online:[%s]%s",2
#define RTEERR_CLUSTER_DB_ONLINE_ID 169
#define RTEERR_CLUSTER_DB_OFFLINE                      SAPDBErr_MessageList::Error,170,"MSCS failed to take database resource offline:[%s]%s",2
#define RTEERR_CLUSTER_DB_OFFLINE_ID 170
#define RTEERR_RTEMEM_NO_MORE_SYSTEM_PAGES             SAPDBErr_MessageList::Error,171,"No more system pages for %s bytes available. Pagesize %s bytes, used syscall %s, error %s",4
#define RTEERR_RTEMEM_NO_MORE_SYSTEM_PAGES_ID 171
#define RTEERR_RTEMEM_OUT_OF_RESERVABLE_SYSTEM_PAGES   SAPDBErr_MessageList::Error,172,"Out of virtual address space for %s bytes at address %s",2
#define RTEERR_RTEMEM_OUT_OF_RESERVABLE_SYSTEM_PAGES_ID 172
#define RTEERR_RTEMEM_MEMORY_LIMIT_REACHED             SAPDBErr_MessageList::Error,173,"The set memory limit %s bytes for %s was reached (%s bytes requested)",3
#define RTEERR_RTEMEM_MEMORY_LIMIT_REACHED_ID 173
#define RTEWARN_UNEXPECTED_TIMER_LEAPS                 SAPDBErr_MessageList::Warning,174,"Unexpected %s timer leaps, timer type ignored",1
#define RTEWARN_UNEXPECTED_TIMER_LEAPS_ID 174
#define RTEWARN_IO_GET_DEV_ID                          SAPDBErr_MessageList::Warning,175,"Physical device for %s could not be determined: %s [%s]",3
#define RTEWARN_IO_GET_DEV_ID_ID 175
#define RTEWARN_SYS_COULD_NOT_DETERMINE_PHYSMEM        SAPDBErr_MessageList::Warning,176,"size of physical memory could not be determined",0
#define RTEWARN_SYS_COULD_NOT_DETERMINE_PHYSMEM_ID 176
#define RTEWARN_SYS_COULD_NOT_ALLOCATE_DESIRED_MEMORY  SAPDBErr_MessageList::Warning,177,"could not allocate desired amount of memory",0
#define RTEWARN_SYS_COULD_NOT_ALLOCATE_DESIRED_MEMORY_ID 177
#define RTEWARN_CONF_ENDMARKER_NOT_FOUND               SAPDBErr_MessageList::Warning,178,"End marker in xparam file not found. Contents may be corrupt!",0
#define RTEWARN_CONF_ENDMARKER_NOT_FOUND_ID 178
#define RTEWARN_CONF_UNKNOWN_VOLUME_ACCESS_MODE        SAPDBErr_MessageList::Warning,179,"Unknown volume access mode %s [data volume %s]",2
#define RTEWARN_CONF_UNKNOWN_VOLUME_ACCESS_MODE_ID 179
#define RTEWARN_GENERAL                                SAPDBErr_MessageList::Warning,180,"RTE warning %s",1
#define RTEWARN_GENERAL_ID 180
#define RTEWARN_PHYSICAL_MEMORY_EXCEEDED               SAPDBErr_MessageList::Warning,181,"Used memory exceeds physical memory installed (%s MByte)",1
#define RTEWARN_PHYSICAL_MEMORY_EXCEEDED_ID 181
#define RTEWARN_VERY_LITTLE_PHYSICAL_MEMORY_LEFT       SAPDBErr_MessageList::Warning,182,"Very little physical memory left (%s MByte)",1
#define RTEWARN_VERY_LITTLE_PHYSICAL_MEMORY_LEFT_ID 182
#define RTEINFO_TIMER_LEAP_DETECTED                    SAPDBErr_MessageList::Info,183,"%s timer leap detected (val: %s, expected: 'val' >= %s)",3
#define RTEINFO_TIMER_LEAP_DETECTED_ID 183
#define RTEINFO_START_FORMATTING                       SAPDBErr_MessageList::Info,184,"Formatting started",0
#define RTEINFO_START_FORMATTING_ID 184
#define RTEINFO_FORMATTING_DONE                        SAPDBErr_MessageList::Info,185,"Formatting done",0
#define RTEINFO_FORMATTING_DONE_ID 185
#define RTEINFO_SYS_CALL_DLL_FUNC                      SAPDBErr_MessageList::Info,186,"Error by calling DLL function: %s",1
#define RTEINFO_SYS_CALL_DLL_FUNC_ID 186
#define RTEINFO_SYS_PROTECT_ALLOC_SUCCESSFUL           SAPDBErr_MessageList::Info,187,"Protecting Allocator using %s MB of %s memory",2
#define RTEINFO_SYS_PROTECT_ALLOC_SUCCESSFUL_ID 187
#define RTEINFO_CONF_NOT_FOUND                         SAPDBErr_MessageList::Info,188,"Parameter %s not found",1
#define RTEINFO_CONF_NOT_FOUND_ID 188
#define RTEINFO_CONF_WRONG_TYPE                        SAPDBErr_MessageList::Info,189,"Parameter %s: wrong type (expected: %s, found: %s)",3
#define RTEINFO_CONF_WRONG_TYPE_ID 189
#define RTEINFO_CONF_NO_CHANGES                        SAPDBErr_MessageList::Info,190,"Parameter file not written because no changes have been made",0
#define RTEINFO_CONF_NO_CHANGES_ID 190
#define RTEINFO_INCONSISTENCIES_WHILE_WRITING          SAPDBErr_MessageList::Info,191,"The following inconsistencies occurred while writing the parameter file %s",1
#define RTEINFO_INCONSISTENCIES_WHILE_WRITING_ID 191
#define RTEINFO_TRACE_IN_NON_TASKING_CONTEXT           SAPDBErr_MessageList::Info,192,"trace output in non-tasking context: %s",1
#define RTEINFO_TRACE_IN_NON_TASKING_CONTEXT_ID 192
#define RTEINFO_CONF_NO_MORE_PARAMETERS                SAPDBErr_MessageList::Info,193,"No more parameters found",0
#define RTEINFO_CONF_NO_MORE_PARAMETERS_ID 193
#define RTEINFO_CONF_DATA_VOLUME_MODE                  SAPDBErr_MessageList::Info,194,"Using mode %s for data volume %s",2
#define RTEINFO_CONF_DATA_VOLUME_MODE_ID 194
#define RTEINFO_DBREG_SERVICE_ALREADY_INST             SAPDBErr_MessageList::Info,195,"Service '%s' is already installed",1
#define RTEINFO_DBREG_SERVICE_ALREADY_INST_ID 195
#define RTEINFO_DBREG_SERVICE_NOT_INSTALLED            SAPDBErr_MessageList::Info,196,"Service '%s' is not installed",1
#define RTEINFO_DBREG_SERVICE_NOT_INSTALLED_ID 196
#define RTEINFO_DBREG_SERVICE_DELETE_MARKED            SAPDBErr_MessageList::Info,197,"Service has been marked for delete",0
#define RTEINFO_DBREG_SERVICE_DELETE_MARKED_ID 197
#define RTEINFO_DBREG_UPDATING_SERVICE                 SAPDBErr_MessageList::Info,198,"One or more values are different, updating service: '%s'",1
#define RTEINFO_DBREG_UPDATING_SERVICE_ID 198
#define RTEINFO_DBREG_SERVICE_NOT_INST_CORR            SAPDBErr_MessageList::Info,199,"Service has not been installed correctly",0
#define RTEINFO_DBREG_SERVICE_NOT_INST_CORR_ID 199
#define RTEINFO_DBREG_KERNEL_STARTUP_MESSAGE           SAPDBErr_MessageList::Info,200,"startup message from kernel:%s",1
#define RTEINFO_DBREG_KERNEL_STARTUP_MESSAGE_ID 200
#define RTEINFO_KERNEL_THREAD_STARTED                  SAPDBErr_MessageList::Info,201,"%s thread started",1
#define RTEINFO_KERNEL_THREAD_STARTED_ID 201
#define RTEINFO_KERNEL_THREAD_STOPPED                  SAPDBErr_MessageList::Info,202,"%s thread stopped",1
#define RTEINFO_KERNEL_THREAD_STOPPED_ID 202
#define RTEINFO_GENERAL                                SAPDBErr_MessageList::Info,203,"RTE info %s",1
#define RTEINFO_GENERAL_ID 203
#define RTEINFO_KERNEL_STATE_CHANGED                   SAPDBErr_MessageList::Info,204,"Kernel state changed from %s to %s",2
#define RTEINFO_KERNEL_STATE_CHANGED_ID 204
#define RTEINFO_PHYSICAL_MEMORY_USED                   SAPDBErr_MessageList::Info,205,"Used physical memory %s MByte",1
#define RTEINFO_PHYSICAL_MEMORY_USED_ID 205
#define RTEINFO_CONF_MEMORY_ALLOCATION_LIMIT           SAPDBErr_MessageList::Info,206,"Memory allocation limited to %s KByte",1
#define RTEINFO_CONF_MEMORY_ALLOCATION_LIMIT_ID 206
#define RTEINFO_CONF_MEMORY_ALLOCATION_UNLIMITED       SAPDBErr_MessageList::Info,207,"Memory allocation not limited",0
#define RTEINFO_CONF_MEMORY_ALLOCATION_UNLIMITED_ID 207
#define RTEINFO_CONF_SYSTEM_PAGE_CACHE_ENABLED         SAPDBErr_MessageList::Info,208,"System page cache usage enabled",0
#define RTEINFO_CONF_SYSTEM_PAGE_CACHE_ENABLED_ID 208
#define RTEINFO_CONF_SYSTEM_PAGE_CACHE_DISABLED        SAPDBErr_MessageList::Info,209,"System page cache usage disabled",0
#define RTEINFO_CONF_SYSTEM_PAGE_CACHE_DISABLED_ID 209
#define RTEINFO_SYNC_RWREGION_TW_SLEEPING              SAPDBErr_MessageList::Info,210,"tas_coll - TW is sleeping for 1 sec ...",0
#define RTEINFO_SYNC_RWREGION_TW_SLEEPING_ID 210
#define RTEINFO_AUTOMATIC_RESTART_INITIATED            SAPDBErr_MessageList::Info,211,"Database tries automatic restart",0
#define RTEINFO_AUTOMATIC_RESTART_INITIATED_ID 211
#define RTEINFO_AUTOMATIC_RESTART_DONE                 SAPDBErr_MessageList::Info,212,"Database automatic restart reported ok",0
#define RTEINFO_AUTOMATIC_RESTART_DONE_ID 212
#define RTEINFO_NO_AUTOMATIC_RESTART                   SAPDBErr_MessageList::Info,213,"Database does not automatic restart",0
#define RTEINFO_NO_AUTOMATIC_RESTART_ID 213
#define RTEINFO_AUTOMATIC_SHUTDOWN_INITIATED           SAPDBErr_MessageList::Info,214,"Database tries automatic shutdown",0
#define RTEINFO_AUTOMATIC_SHUTDOWN_INITIATED_ID 214
#define RTEINFO_AUTOMATIC_SHUTDOWN_DONE                SAPDBErr_MessageList::Info,215,"Database automatic shutdown reported ok",0
#define RTEINFO_AUTOMATIC_SHUTDOWN_DONE_ID 215
#define RTEINFO_NO_AUTOMATIC_SHUTDOWN                  SAPDBErr_MessageList::Info,216,"Database does not automatic shutdown",0
#define RTEINFO_NO_AUTOMATIC_SHUTDOWN_ID 216
#define RTEINFO_ARGUMENT_UNEXPECTED                    SAPDBErr_MessageList::Info,217,"Argument '%s' unexpected",1
#define RTEINFO_ARGUMENT_UNEXPECTED_ID 217
#define RTEINFO_ARGUMENT_MISSING                       SAPDBErr_MessageList::Info,218,"Argument '%s' missing",1
#define RTEINFO_ARGUMENT_MISSING_ID 218
#define RTEINFO_ARGUMENT_UNKNOWN                       SAPDBErr_MessageList::Info,219,"Argument '%s' unknown",1
#define RTEINFO_ARGUMENT_UNKNOWN_ID 219
#define RTEINFO_ARGUMENT_COLLISION                     SAPDBErr_MessageList::Info,220,"Argument '%s' collides with '%s'",2
#define RTEINFO_ARGUMENT_COLLISION_ID 220
#define RTEINFO_ARGUMENT_COMBINATION                   SAPDBErr_MessageList::Info,221,"Argument '%s' must be combined with '%s'",2
#define RTEINFO_ARGUMENT_COMBINATION_ID 221
#define RTEINFO_STOP_SUCCESSFUL                        SAPDBErr_MessageList::Info,222,"'%s' stopped successfully",1
#define RTEINFO_STOP_SUCCESSFUL_ID 222
#define RTEINFO_PROCESSSTATE                           SAPDBErr_MessageList::Info,223,"process state: %s is %s",2
#define RTEINFO_PROCESSSTATE_ID 223
#define RTEINFO_BEGIN_OF_STARTUP_ARGUMENTS             SAPDBErr_MessageList::Info,224,"Dump of all kernel parameters start",0
#define RTEINFO_BEGIN_OF_STARTUP_ARGUMENTS_ID 224
#define RTEINFO_STARTUP_ARGUMENT                       SAPDBErr_MessageList::Info,225," %s=%s",2
#define RTEINFO_STARTUP_ARGUMENT_ID 225
#define RTEINFO_END_OF_STARTUP_ARGUMENTS               SAPDBErr_MessageList::Info,226,"Dump of all kernel parameters done",0
#define RTEINFO_END_OF_STARTUP_ARGUMENTS_ID 226
#define RTEINFO_RTEMEM_SYSTEM_HEAP_MEMORY_STATISTICS   SAPDBErr_MessageList::Info,227,"Used %s bytes from system heap with a limit of %s bytes",2
#define RTEINFO_RTEMEM_SYSTEM_HEAP_MEMORY_STATISTICS_ID 227
#define RTEINFO_RTEMEM_SYSTEM_HEAP_MEMORY_DETAILS      SAPDBErr_MessageList::Info,228,"Calls %s allocations, %s frees and %s failed allocations, maximum %s bytes used",4
#define RTEINFO_RTEMEM_SYSTEM_HEAP_MEMORY_DETAILS_ID 228
#define RTEINFO_RTEMEM_NEXT_RESERVED_ADDRESS           SAPDBErr_MessageList::Info,229,"%s is next address in reserved address space",1
#define RTEINFO_RTEMEM_NEXT_RESERVED_ADDRESS_ID 229

#endif /* RTE_MESSAGES_HPP */
