--TEST--
maxdb_example
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
$link = maxdb_connect("localhost", "MONA", "RED", "DEMODB");
   
/* check connection */
if (maxdb_connect_errno()) {
   printf("Connect failed: %s\n", maxdb_connect_error());
   exit();
}

/* Performing SQL query */
$query = "SELECT * FROM hotel.city";
$result = maxdb_query($link, $query) or die("Query failed : " . maxdb_error());

/* Printing results in HTML */
echo "<table>\n";
while ($line = maxdb_fetch_array($result, MAXDB_ASSOC)) {
    echo "  <tr>\n";
    foreach ($line as $col_value) {
        echo "    <td>$col_value</td>\n";
    }
    echo "  </tr>\n";
}
echo "</table>\n";

/* Free resultset */
maxdb_free_result($result);

/* Closing connection */
maxdb_close($link);
?>
--EXPECT--
<table>
  <tr>
    <td>10019</td>
    <td>New York</td>
    <td>NY</td>
  </tr>
  <tr>
    <td>10580</td>
    <td>New York</td>
    <td>NY</td>
  </tr>
  <tr>
    <td>11788</td>
    <td>Long Island</td>
    <td>NY</td>
  </tr>
  <tr>
    <td>12203</td>
    <td>Albany</td>
    <td>NY</td>
  </tr>
  <tr>
    <td>20005</td>
    <td>Washington</td>
    <td>DC</td>
  </tr>
  <tr>
    <td>20019</td>
    <td>Washington</td>
    <td>DC</td>
  </tr>
  <tr>
    <td>20037</td>
    <td>Washington</td>
    <td>DC</td>
  </tr>
  <tr>
    <td>20903</td>
    <td>Silver Spring</td>
    <td>MD</td>
  </tr>
  <tr>
    <td>32018</td>
    <td>Daytona Beach</td>
    <td>FL</td>
  </tr>
  <tr>
    <td>33441</td>
    <td>Deerfield Beach</td>
    <td>FL</td>
  </tr>
  <tr>
    <td>33575</td>
    <td>Clearwater</td>
    <td>FL</td>
  </tr>
  <tr>
    <td>45211</td>
    <td>Cincinnati</td>
    <td>OH</td>
  </tr>
  <tr>
    <td>48226</td>
    <td>Detroit</td>
    <td>MI</td>
  </tr>
  <tr>
    <td>60018</td>
    <td>Rosemont</td>
    <td>IL</td>
  </tr>
  <tr>
    <td>60601</td>
    <td>Chicago</td>
    <td>IL</td>
  </tr>
  <tr>
    <td>60615</td>
    <td>Chicago</td>
    <td>IL</td>
  </tr>
  <tr>
    <td>70112</td>
    <td>New Orleans</td>
    <td>LA</td>
  </tr>
  <tr>
    <td>75243</td>
    <td>Dallas</td>
    <td>TX</td>
  </tr>
  <tr>
    <td>90018</td>
    <td>Los Angeles</td>
    <td>CA</td>
  </tr>
  <tr>
    <td>90029</td>
    <td>Hollywood</td>
    <td>CA</td>
  </tr>
  <tr>
    <td>90804</td>
    <td>Long Beach</td>
    <td>CA</td>
  </tr>
  <tr>
    <td>92262</td>
    <td>Palm Springs</td>
    <td>CA</td>
  </tr>
  <tr>
    <td>92714</td>
    <td>Irvine</td>
    <td>CA</td>
  </tr>
  <tr>
    <td>95054</td>
    <td>Santa Clara</td>
    <td>CA</td>
  </tr>
  <tr>
    <td>97213</td>
    <td>Portland</td>
    <td>OR</td>
  </tr>
</table>


