--TEST--
maxdb connect
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
	include "connect.inc";

	$muser = $user;
	$mpasswd = $passwd;
	$dbname = $db;
	$test = "";
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $muser, $mpasswd);
	$test .= ($link) ? "1" : "0";
	maxdb_close($link);

	/*** test maxdb_connect localhost ***/
	$link = maxdb_connect("localhost", $muser, $mpasswd);
	$test .= ($link) ? "1" : "0";
	maxdb_close($link);

	/*** test maxdb_connect localhost:port ***/
	$link = maxdb_connect("localhost", $muser, $mpasswd, $dbname, 3306);
	$test .= ($link) ? "1" : "0";
	maxdb_close($link);

	/*** test maxdb_real_connect ***/
	$link = maxdb_init();	
	$test.= (maxdb_real_connect($link, "localhost", $muser, $mpasswd)) 
		? "1" : "0";
	maxdb_close($link);

	/*** test maxdb_real_connect with db ***/
	$link = maxdb_init();	
	$test .= (maxdb_real_connect($link, "localhost", $muser, $mpasswd, $dbname)) 
		? "1" : "0";
	maxdb_close($link);

	/*** test maxdb_real_connect with port ***/
	$link = maxdb_init();	
	$test .= (maxdb_real_connect($link, "localhost", $muser, $mpasswd, $dbname, 3306))
		? "1":"0";
	maxdb_close($link);

	/*** test maxdb_real_connect compressed ***/
	$link = maxdb_init();	
	$test .= (maxdb_real_connect($link, "localhost", $muser, $mpasswd, $dbname, 0, NULL)) 
		? "1" : "0";
	maxdb_close($link);

	/* todo ssl connections */

	var_dump($test);
?>
--EXPECT--
string(7) "1111111"
