/*
        ========== licence begin  GPL
        Copyright (C) 2004 SAP AG

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
        ========== licence end
 */
#ifndef IOMAN_MESSAGES_HPP
#define IOMAN_MESSAGES_HPP

// Generated Header file IOMan_Messages.hpp.
// Generated by genmsg V2.2 DO NOT EDIT

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"

#define IOMAN_INFO_UNSET_BAD_VOLUME         SAPDBErr_MessageList::Info,0,"Reset bad flag for %s volume %s",2
#define IOMAN_INFO_UNSET_BAD_VOLUME_ID 0
#define IOMAN_INFO_VOLUME_MARKED_AS_BAD     SAPDBErr_MessageList::Info,1,"%s volume %s is marked as bad",2
#define IOMAN_INFO_VOLUME_MARKED_AS_BAD_ID 1
#define IOMAN_INFO_ADD_VOLUME               SAPDBErr_MessageList::Info,2,"Add %s volume %s with %s pages successfully executed",3
#define IOMAN_INFO_ADD_VOLUME_ID 2
#define IOMAN_INFO_DO_MIGRATION             SAPDBErr_MessageList::Info,3,"Start data base inplace migration",0
#define IOMAN_INFO_DO_MIGRATION_ID 3
#define IOMAN_INFO_MIGRATION_FINISHED       SAPDBErr_MessageList::Info,4,"Data base migration successfully finished",0
#define IOMAN_INFO_MIGRATION_FINISHED_ID 4
#define IOMAN_INFO_CONV_PAGES_MIGRATED      SAPDBErr_MessageList::Info,5,"Migration: converter page count %s / data page count %s",2
#define IOMAN_INFO_CONV_PAGES_MIGRATED_ID 5
#define IOMAN_INFO_START_REINTEGRATION      SAPDBErr_MessageList::Info,6,"Start reintegration for log device %s from '%s' to '%s'.",3
#define IOMAN_INFO_START_REINTEGRATION_ID 6
#define IOMAN_INFO_STOP_REINTEGRATION       SAPDBErr_MessageList::Info,7,"Reintegration successfully finished.",0
#define IOMAN_INFO_STOP_REINTEGRATION_ID 7
#define IOMAN_INFO_BAD_VOLUME_NOT_FOUND     SAPDBErr_MessageList::Info,8,"Bad log volume '%s' not found.",1
#define IOMAN_INFO_BAD_VOLUME_NOT_FOUND_ID 8
#define IOMAN_INFO_VOLUME_NOT_BAD           SAPDBErr_MessageList::Info,9,"Given log volume '%s' is not marked as bad.",1
#define IOMAN_INFO_VOLUME_NOT_BAD_ID 9
#define IOMAN_WRN_VOLUME_OFFLINE            SAPDBErr_MessageList::Warning,10,"The %s volume %s is offline.",2
#define IOMAN_WRN_VOLUME_OFFLINE_ID 10
#define IOMAN_WRN_SAVE_PARAM_FAILED         SAPDBErr_MessageList::Warning,11,"The saving of the configuration file failed: %s",1
#define IOMAN_WRN_SAVE_PARAM_FAILED_ID 11
#define IOMAN_WRN_LOG_AREA_NOT_WRITEABLE    SAPDBErr_MessageList::Warning,12,"Operation not possible, because the log area is not writable.",0
#define IOMAN_WRN_LOG_AREA_NOT_WRITEABLE_ID 12
#define IOMAN_BAD_PAGE                      SAPDBErr_MessageList::Error,13,"Bad page on %s volume %s blockno %s",3
#define IOMAN_BAD_PAGE_ID 13
#define IOMAN_ATTACH_FAILED                 SAPDBErr_MessageList::Error,14,"Attach error on %s volume %s: %s",3
#define IOMAN_ATTACH_FAILED_ID 14
#define IOMAN_NOT_ACCESSIBLE                SAPDBErr_MessageList::Error,15,"Access error on %s volume %s blockno %s: %s",4
#define IOMAN_NOT_ACCESSIBLE_ID 15
#define IOMAN_UNKNOWN_VOLUME                SAPDBErr_MessageList::Error,16,"Unknown %s volume %s: %s",3
#define IOMAN_UNKNOWN_VOLUME_ID 16
#define IOMAN_EMERGENCY_MSG1                SAPDBErr_MessageList::Error,17,"EMERGENCY SHUTDOWN",0
#define IOMAN_EMERGENCY_MSG1_ID 17
#define IOMAN_WRONG_PAGENO                  SAPDBErr_MessageList::Error,18,"Wrong page %s on %s volume %s blockno %s",4
#define IOMAN_WRONG_PAGENO_ID 18
#define IOMAN_BAD_OUTPUT_PAGE               SAPDBErr_MessageList::Error,19,"Bad output page for %s volume %s blockno %s",3
#define IOMAN_BAD_OUTPUT_PAGE_ID 19
#define IOMAN_MIN_DATA_PAGES                SAPDBErr_MessageList::Error,20,"Minimum of data size is %s pages and not %s",2
#define IOMAN_MIN_DATA_PAGES_ID 20
#define IOMAN_WRONG_CONV_PAGE               SAPDBErr_MessageList::Error,21,"Wrong converter page on %s volume %s blockno %s",3
#define IOMAN_WRONG_CONV_PAGE_ID 21
#define IOMAN_FBM_FULL                      SAPDBErr_MessageList::Error,22,"No more free block address available from FBM",0
#define IOMAN_FBM_FULL_ID 22
#define IOMAN_BAD_RESTART_PAGE              SAPDBErr_MessageList::Error,23,"Bad restart page on %s volume %s blockno %s",3
#define IOMAN_BAD_RESTART_PAGE_ID 23
#define IOMAN_BAD_PAGENO                    SAPDBErr_MessageList::Error,24,"Bad data page %s",1
#define IOMAN_BAD_PAGENO_ID 24
#define IOMAN_READ_INFO_PAGE_FAILED         SAPDBErr_MessageList::Error,25,"Can not read info page from %s volume %s",2
#define IOMAN_READ_INFO_PAGE_FAILED_ID 25
#define IOMAN_WRITE_INFO_PAGE_FAILED        SAPDBErr_MessageList::Error,26,"Can not write info page into %s volume %s",2
#define IOMAN_WRITE_INFO_PAGE_FAILED_ID 26
#define IOMAN_DEVNO_MISSMATCH               SAPDBErr_MessageList::Error,27,"DevNo from %s volume in configuration and info page are different: %s vs %s",3
#define IOMAN_DEVNO_MISSMATCH_ID 27
#define IOMAN_CAPACITY_MISSMATCH            SAPDBErr_MessageList::Error,28,"Capacity of %s volume %s is different between configuration and info page: %s vs. %s",4
#define IOMAN_CAPACITY_MISSMATCH_ID 28
#define IOMAN_BLOCKSIZE_MISSMATCH           SAPDBErr_MessageList::Error,29,"Block size of %s volume %s is different between configuration and info page: %s vs. %s",4
#define IOMAN_BLOCKSIZE_MISSMATCH_ID 29
#define IOMAN_CORRUPTED_CONFIGURATION       SAPDBErr_MessageList::Error,30,"%s volume configuration corrupted: Linkage missmatch between volume %s and %s",3
#define IOMAN_CORRUPTED_CONFIGURATION_ID 30
#define IOMAN_DB_IDENTIFIER_MISSMATCH       SAPDBErr_MessageList::Error,31,"DB volume GUID '%s' of %s volume %s is not equal to the given volume GUID '%s'",4
#define IOMAN_DB_IDENTIFIER_MISSMATCH_ID 31
#define IOMAN_ERR_MISSING_PREDECESSOR       SAPDBErr_MessageList::Error,32,"%s volume configuration corrupted: Predecessor of volume %s should be %s",3
#define IOMAN_ERR_MISSING_PREDECESSOR_ID 32
#define IOMAN_ERR_MISSING_SUCCESSOR         SAPDBErr_MessageList::Error,33,"%s volume configuration corrupted: Successor of volume %s should be %s",3
#define IOMAN_ERR_MISSING_SUCCESSOR_ID 33
#define IOMAN_ERR_BAD_VOLUME                SAPDBErr_MessageList::Error,34,"%s volume %s is set to bad",2
#define IOMAN_ERR_BAD_VOLUME_ID 34
#define IOMAN_ERR_DATA_DEVNO_OUT_OF_RANGE   SAPDBErr_MessageList::Error,35,"Data volume number %s is out of range. Upper limit is %s",2
#define IOMAN_ERR_DATA_DEVNO_OUT_OF_RANGE_ID 35
#define IOMAN_ERR_LOG_DEVNO_OUT_OF_RANGE    SAPDBErr_MessageList::Error,36,"Log volume number %s is out of range. Upper limit is %s",2
#define IOMAN_ERR_LOG_DEVNO_OUT_OF_RANGE_ID 36
#define IOMAN_ERR_VOLUME_IS_ONLINE          SAPDBErr_MessageList::Error,37,"The added %s volume %s is already online",2
#define IOMAN_ERR_VOLUME_IS_ONLINE_ID 37
#define IOMAN_ERR_NEW_VOLUME_FAILED         SAPDBErr_MessageList::Error,38,"The adding of %s volume %s to the RTE failed",2
#define IOMAN_ERR_NEW_VOLUME_FAILED_ID 38
#define IOMAN_ERR_CREATE_LINKAGE            SAPDBErr_MessageList::Error,39,"Create linkage between %s volume %s and %s failed",3
#define IOMAN_ERR_CREATE_LINKAGE_ID 39
#define IOMAN_ERR_MIG_LOG_FAILED            SAPDBErr_MessageList::Error,40,"Create log volume during migration failed",0
#define IOMAN_ERR_MIG_LOG_FAILED_ID 40
#define IOMAN_ERR_MIG_LOG_FORMAT_FAILED     SAPDBErr_MessageList::Error,41,"Format log volume during migration failed, because of %s",1
#define IOMAN_ERR_MIG_LOG_FORMAT_FAILED_ID 41
#define IOMAN_ERR_MIG_DATA_FAILED           SAPDBErr_MessageList::Error,42,"Create data volume during migration failed",0
#define IOMAN_ERR_MIG_DATA_FAILED_ID 42
#define IOMAN_ERR_ILLEGAL_DATA_AREA_SIZE    SAPDBErr_MessageList::Error,43,"Illegal data area size. Restart record %s vs. data base %s",2
#define IOMAN_ERR_ILLEGAL_DATA_AREA_SIZE_ID 43
#define IOMAN_ERR_MIG_RESTARTREC_FAILED     SAPDBErr_MessageList::Error,44,"Migration of restart record failed",0
#define IOMAN_ERR_MIG_RESTARTREC_FAILED_ID 44
#define IOMAN_ERR_READ_PAGE_FAILED          SAPDBErr_MessageList::Error,45,"Read page from %s volume %s on blockno %s failed.",3
#define IOMAN_ERR_READ_PAGE_FAILED_ID 45
#define IOMAN_ERR_CONV_MIG_FAILED           SAPDBErr_MessageList::Error,46,"Migration of converter failed, because of base error: %s",1
#define IOMAN_ERR_CONV_MIG_FAILED_ID 46
#define IOMAN_ERR_MIG_ATTACH_FAILED         SAPDBErr_MessageList::Error,47,"Attach error on migration volume %s: %s",2
#define IOMAN_ERR_MIG_ATTACH_FAILED_ID 47
#define IOMAN_ERR_MIG_ALREADY_RUNNING       SAPDBErr_MessageList::Error,48,"Data base migration already running.",0
#define IOMAN_ERR_MIG_ALREADY_RUNNING_ID 48
#define IOMAN_ERR_MIG_PARAM_FAILED          SAPDBErr_MessageList::Error,49,"Could not update param file during migration, because: %s",1
#define IOMAN_ERR_MIG_PARAM_FAILED_ID 49
#define IOMAN_ERR_MIG_NOT_POSSIBLE          SAPDBErr_MessageList::Error,50,"The inplace migration of a liveCache is not possible.",0
#define IOMAN_ERR_MIG_NOT_POSSIBLE_ID 50
#define IOMAN_ERR_NOT_PREPARED_FOR_MIG      SAPDBErr_MessageList::Error,51,"The inplace migration is not possible, because the migrate command was not executed in 7.2/7.3",0
#define IOMAN_ERR_NOT_PREPARED_FOR_MIG_ID 51
#define IOMAN_ERR_CAPACITY_MISMATCH         SAPDBErr_MessageList::Error,52,"Capacity mismatch for dual log device %s. Volume capacity %s. Mirrored volume capacity %s.",3
#define IOMAN_ERR_CAPACITY_MISMATCH_ID 52
#define IOMAN_ERR_STOP_REINTEGRATION        SAPDBErr_MessageList::Error,53,"Reintegration unsuccessfully finished: %s",1
#define IOMAN_ERR_STOP_REINTEGRATION_ID 53
#define IOMAN_ERR_NOT_WRITEABLE             SAPDBErr_MessageList::Error,54,"The %s volume %s is not writeable. State is %s.",3
#define IOMAN_ERR_NOT_WRITEABLE_ID 54
#define IOMAN_ERR_LOG_OFFSET_OUT_OF_RANGE   SAPDBErr_MessageList::Error,55,"The given log offset %s is out of range. Total log area size %s.",2
#define IOMAN_ERR_LOG_OFFSET_OUT_OF_RANGE_ID 55
#define IOMAN_ERR_LOG_OFFSET_OUT_OF_RANGE_1 SAPDBErr_MessageList::Error,56,"The given log offset %s with blockcount %s is out of range. Total log area size %s.",3
#define IOMAN_ERR_LOG_OFFSET_OUT_OF_RANGE_1_ID 56
#define IOMAN_ERR_LOG_AREA_ALREADY_ONLINE   SAPDBErr_MessageList::Error,57,"Create log area not allowed, because log area is still in use.",0
#define IOMAN_ERR_LOG_AREA_ALREADY_ONLINE_ID 57
#define IOMAN_ERR_DATA_AREA_ALREADY_ONLINE  SAPDBErr_MessageList::Error,58,"Create data area not allowed, because data area is still in use.",0
#define IOMAN_ERR_DATA_AREA_ALREADY_ONLINE_ID 58

#endif /* IOMAN_MESSAGES_HPP */
