/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.powertoys;

import com.sap.dbtech.util.StructuredMem;
/**
 * Exception thrown when Loader command fails
 * @deprecated replaced by com.sap.dbtech.powertoys.LoaderException
 *
 */
public class RepmanException extends Exception
{
    private int errorCode;

    /**
     * creates a new RepmanException.
     */
    RepmanException (int eCode, String msg)
    {
        super (msg);
        this.errorCode = eCode;
    }
    /**
     * returns the error code as set by dbm server.
     */
    public int getErrorCode ()
    {
        return this.errorCode;
    }

    /**
     * returns printable String of exception
     */
    public String toString ()
    {
        return "<RepmanException " + this.errorCode + " "
             + this.getMessage () + ">";
    }
    /**
     *
     */
    static RepmanException create (StructuredMem packet)
    {
        int errorCode = 0;
        String message = null;
        String rawString;
        int chunkStart = 0;
        int chunkEnd;
        if(packet.size() < Repman.indicatorLengthC) {
            return new RepmanException(-807, "Invalid size of repman reply message (" + packet.size() + " bytes)");
        }
        rawString = packet.getString (Repman.indicatorLengthC, packet.size () - Repman.indicatorLengthC).trim();
        chunkEnd = rawString.indexOf ("\n");
        if(chunkEnd != -1) {
            errorCode = Integer.parseInt (rawString.substring (0, chunkEnd));
            message = rawString.substring(chunkEnd + 1).trim();
        }
        if(message == null) 
            message=rawString;
        return new RepmanException (errorCode, message);

    }
}

