/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
package  com.sap.dbtech.util;


/**
 *
 */
public class UnicodeUtil {
    public static final int CharWidthC = 2;

    /**
     * UnicodeUtil is all static
     */
    private UnicodeUtil () {
    }

    /**
     *
     */
    static public char []
    bigUnicode2Chars (
        byte [] b,
        int off,
        int len)
    {
        char [] result = new char [len/2];
        int lenInChars = len / 2;

        for (int i = 0; i < lenInChars; ++i) {
            int high = b [off + (2 * i)];
            if (high < 0) {
                high += 256;
            }
            int low = b [off + ((2 * i) + 1)];
            if (low < 0) {
                low += 256;
            }
            int current = (high << 8) + low;
            result [i] = (char) current;
        }
        return result;
    }
    /**
     *
     */
    static public char []
    bigUnicode2Chars (
        byte [] b)
    {
        return bigUnicode2Chars (b, 0, b.length);
    }
    /**
     *
     */
    static private boolean encodingAvailable = true;
    static public String bigUnicode2String (byte[] input) {
        String result;

        if (encodingAvailable) {
            try {
                /*works only for jdk`s >= 1.3*/
                result = new String(input, "UTF-16BE");
            }
            catch (java.io.UnsupportedEncodingException UEEexp) {
                result = new String (bigUnicode2Chars (input));
                encodingAvailable = false;
            }
        }
        else {
            result = new String (bigUnicode2Chars (input));
        }
        return result;
    }

    /**
     *
     */
    static public byte[] char2BigUnicode (char[] input) {
        byte[] result = new byte[input.length*2];
        charIntoBytes(input, result, 0);
        return  result;
    }

    /**
     *
     */
    static public byte[] bytes2BigUnicode (byte[] input) {
        int byteCount = input.length;
        byte[] result = new byte[byteCount*2];
        for (int i = 0; i < byteCount; ++i) {
            result[i*2 + 1] = input[i];
        }
        return  result;
    }    /**
     *
     */
    static public void charIntoBytes (char[] input, byte[] output, int byteOffset) {
        int charCount = input.length;
        for (int i = 0; i < charCount; ++i) {
            char current = input[i];
            output[i*2 + byteOffset] = (byte)(current/256);
            output[i*2 + byteOffset + 1] = (byte)(current%256);
        }
    }
}



