/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbcext;

import java.util.Map;
import java.sql.CallableStatement;
import java.sql.Date;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Clob;
import java.util.Calendar;
import java.net.URL;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.io.InputStream;
import java.sql.ParameterMetaData;
import java.sql.Timestamp;
import java.sql.ResultSetMetaData;
import java.sql.Ref;
import java.sql.Blob;

public class ClientCallableStatementSapDB
    implements CallableStatement
{
    private ClientConnectionSapDB clientConnection;
    private CallableStatement     originalCallableStatement;
    
    public ClientCallableStatementSapDB(CallableStatement originalCallableStatement,
                                        ClientConnectionSapDB clientConnection)
    {
        this.clientConnection=clientConnection;
        this.originalCallableStatement=originalCallableStatement;
    }
    
    public void exceptionOccurred(SQLException sqlEx)
    {
        clientConnection.exceptionOccurred(sqlEx);
    }

    // Code for delegation of java.sql.CallableStatement methods to originalCallableStatement

    public Object getObject(int param1, Map param2) throws SQLException
    {
        try {
            return originalCallableStatement.getObject(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Object getObject(String param1, Map param2) throws SQLException
    {
        try {
            return originalCallableStatement.getObject(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Object getObject(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getObject(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Object getObject(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getObject(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean getBoolean(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getBoolean(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean getBoolean(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getBoolean(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public byte getByte(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getByte(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public byte getByte(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getByte(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public short getShort(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getShort(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public short getShort(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getShort(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getInt(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getInt(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getInt(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getInt(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public long getLong(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getLong(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public long getLong(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getLong(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public float getFloat(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getFloat(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public float getFloat(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getFloat(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public double getDouble(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getDouble(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public double getDouble(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getDouble(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public byte[] getBytes(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getBytes(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public byte[] getBytes(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getBytes(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public URL getURL(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getURL(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public URL getURL(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getURL(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setBoolean(String param1, boolean param2) throws SQLException
    {
        try {
            originalCallableStatement.setBoolean(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setByte(String param1, byte param2) throws SQLException
    {
        try {
            originalCallableStatement.setByte(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setShort(String param1, short param2) throws SQLException
    {
        try {
            originalCallableStatement.setShort(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setInt(String param1, int param2) throws SQLException
    {
        try {
            originalCallableStatement.setInt(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setLong(String param1, long param2) throws SQLException
    {
        try {
            originalCallableStatement.setLong(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setFloat(String param1, float param2) throws SQLException
    {
        try {
            originalCallableStatement.setFloat(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setDouble(String param1, double param2) throws SQLException
    {
        try {
            originalCallableStatement.setDouble(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getString(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getString(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getString(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getString(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Ref getRef(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getRef(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Ref getRef(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getRef(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setURL(String param1, URL param2) throws SQLException
    {
        try {
            originalCallableStatement.setURL(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setTime(String param1, Time param2, Calendar param3) throws SQLException
    {
        try {
            originalCallableStatement.setTime(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setTime(String param1, Time param2) throws SQLException
    {
        try {
            originalCallableStatement.setTime(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Time getTime(String param1, Calendar param2) throws SQLException
    {
        try {
            return originalCallableStatement.getTime(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Time getTime(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getTime(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Time getTime(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getTime(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Time getTime(int param1, Calendar param2) throws SQLException
    {
        try {
            return originalCallableStatement.getTime(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Date getDate(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getDate(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Date getDate(String param1, Calendar param2) throws SQLException
    {
        try {
            return originalCallableStatement.getDate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Date getDate(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getDate(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Date getDate(int param1, Calendar param2) throws SQLException
    {
        try {
            return originalCallableStatement.getDate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setNull(String param1, int param2) throws SQLException
    {
        try {
            originalCallableStatement.setNull(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setNull(String param1, int param2, String param3) throws SQLException
    {
        try {
            originalCallableStatement.setNull(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setBigDecimal(String param1, BigDecimal param2) throws SQLException
    {
        try {
            originalCallableStatement.setBigDecimal(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setString(String param1, String param2) throws SQLException
    {
        try {
            originalCallableStatement.setString(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setBytes(String param1, byte[] param2) throws SQLException
    {
        try {
            originalCallableStatement.setBytes(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setDate(String param1, Date param2) throws SQLException
    {
        try {
            originalCallableStatement.setDate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setDate(String param1, Date param2, Calendar param3) throws SQLException
    {
        try {
            originalCallableStatement.setDate(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setTimestamp(String param1, Timestamp param2) throws SQLException
    {
        try {
            originalCallableStatement.setTimestamp(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setTimestamp(String param1, Timestamp param2, Calendar param3) throws SQLException
    {
        try {
            originalCallableStatement.setTimestamp(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setAsciiStream(String param1, InputStream param2, int param3) throws SQLException
    {
        try {
            originalCallableStatement.setAsciiStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setBinaryStream(String param1, InputStream param2, int param3) throws SQLException
    {
        try {
            originalCallableStatement.setBinaryStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setObject(String param1, Object param2, int param3) throws SQLException
    {
        try {
            originalCallableStatement.setObject(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setObject(String param1, Object param2) throws SQLException
    {
        try {
            originalCallableStatement.setObject(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setObject(String param1, Object param2, int param3, int param4) throws SQLException
    {
        try {
            originalCallableStatement.setObject(param1, param2, param3, param4);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setCharacterStream(String param1, Reader param2, int param3) throws SQLException
    {
        try {
            originalCallableStatement.setCharacterStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void registerOutParameter(String param1, int param2, String param3) throws SQLException
    {
        try {
            originalCallableStatement.registerOutParameter(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void registerOutParameter(int param1, int param2) throws SQLException
    {
        try {
            originalCallableStatement.registerOutParameter(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void registerOutParameter(int param1, int param2, String param3) throws SQLException
    {
        try {
            originalCallableStatement.registerOutParameter(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void registerOutParameter(String param1, int param2, int param3) throws SQLException
    {
        try {
            originalCallableStatement.registerOutParameter(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void registerOutParameter(String param1, int param2) throws SQLException
    {
        try {
            originalCallableStatement.registerOutParameter(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void registerOutParameter(int param1, int param2, int param3) throws SQLException
    {
        try {
            originalCallableStatement.registerOutParameter(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean wasNull() throws SQLException
    {
        try {
            return originalCallableStatement.wasNull();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public BigDecimal getBigDecimal(int param1, int param2) throws SQLException
    {
        try {
            return originalCallableStatement.getBigDecimal(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public BigDecimal getBigDecimal(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getBigDecimal(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public BigDecimal getBigDecimal(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getBigDecimal(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Timestamp getTimestamp(int param1, Calendar param2) throws SQLException
    {
        try {
            return originalCallableStatement.getTimestamp(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Timestamp getTimestamp(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getTimestamp(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Timestamp getTimestamp(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getTimestamp(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Timestamp getTimestamp(String param1, Calendar param2) throws SQLException
    {
        try {
            return originalCallableStatement.getTimestamp(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Blob getBlob(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getBlob(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Blob getBlob(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getBlob(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Clob getClob(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getClob(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Clob getClob(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getClob(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Array getArray(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.getArray(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Array getArray(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getArray(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }
    // Code for delegation of java.sql.Statement methods to originalCallableStatement

    public void close() throws SQLException
    {
        try {
            originalCallableStatement.close();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean execute(String param1, int param2) throws SQLException
    {
        try {
            return originalCallableStatement.execute(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean execute(String param1, String[] param2) throws SQLException
    {
        try {
            return originalCallableStatement.execute(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean execute(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.execute(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean execute(String param1, int[] param2) throws SQLException
    {
        try {
            return originalCallableStatement.execute(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public Connection getConnection() throws SQLException
    {
        return clientConnection;
    }

    public SQLWarning getWarnings() throws SQLException
    {
        try {
            return originalCallableStatement.getWarnings();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void clearWarnings() throws SQLException
    {
        try {
            originalCallableStatement.clearWarnings();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet executeQuery(String param1) throws SQLException
    {
        try {
            ResultSet rs = originalCallableStatement.executeQuery(param1);
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int executeUpdate(String param1, String[] param2) throws SQLException
    {
        try {
            return originalCallableStatement.executeUpdate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int executeUpdate(String param1) throws SQLException
    {
        try {
            return originalCallableStatement.executeUpdate(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int executeUpdate(String param1, int[] param2) throws SQLException
    {
        try {
            return originalCallableStatement.executeUpdate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int executeUpdate(String param1, int param2) throws SQLException
    {
        try {
            return originalCallableStatement.executeUpdate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxFieldSize() throws SQLException
    {
        try {
            return originalCallableStatement.getMaxFieldSize();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setMaxFieldSize(int param1) throws SQLException
    {
        try {
            originalCallableStatement.setMaxFieldSize(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getMaxRows() throws SQLException
    {
        try {
            return originalCallableStatement.getMaxRows();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setMaxRows(int param1) throws SQLException
    {
        try {
            originalCallableStatement.setMaxRows(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setEscapeProcessing(boolean param1) throws SQLException
    {
        try {
            originalCallableStatement.setEscapeProcessing(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getQueryTimeout() throws SQLException
    {
        try {
            return originalCallableStatement.getQueryTimeout();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setQueryTimeout(int param1) throws SQLException
    {
        try {
            originalCallableStatement.setQueryTimeout(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void cancel() throws SQLException
    {
        try {
            originalCallableStatement.cancel();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setCursorName(String param1) throws SQLException
    {
        try {
            originalCallableStatement.setCursorName(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getResultSet() throws SQLException
    {
        try {
            ResultSet rs = originalCallableStatement.getResultSet();
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getUpdateCount() throws SQLException
    {
        try {
            return originalCallableStatement.getUpdateCount();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean getMoreResults(int param1) throws SQLException
    {
        try {
            return originalCallableStatement.getMoreResults(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean getMoreResults() throws SQLException
    {
        try {
            return originalCallableStatement.getMoreResults();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setFetchDirection(int param1) throws SQLException
    {
        try {
            originalCallableStatement.setFetchDirection(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getFetchDirection() throws SQLException
    {
        try {
            return originalCallableStatement.getFetchDirection();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setFetchSize(int param1) throws SQLException
    {
        try {
            originalCallableStatement.setFetchSize(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getFetchSize() throws SQLException
    {
        try {
            return originalCallableStatement.getFetchSize();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getResultSetConcurrency() throws SQLException
    {
        try {
            return originalCallableStatement.getResultSetConcurrency();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getResultSetType() throws SQLException
    {
        try {
            return originalCallableStatement.getResultSetType();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void addBatch(String param1) throws SQLException
    {
        try {
            originalCallableStatement.addBatch(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void clearBatch() throws SQLException
    {
        try {
            originalCallableStatement.clearBatch();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int[] executeBatch() throws SQLException
    {
        try {
            return originalCallableStatement.executeBatch();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException
    {
        try {
            ResultSet rs=originalCallableStatement.getGeneratedKeys();
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getResultSetHoldability() throws SQLException
    {
        try {
            return originalCallableStatement.getResultSetHoldability();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }
    // Code for delegation of java.sql.PreparedStatement methods to originalCallableStatement

    public void setBoolean(int param1, boolean param2) throws SQLException
    {
        try {
            originalCallableStatement.setBoolean(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setByte(int param1, byte param2) throws SQLException
    {
        try {
            originalCallableStatement.setByte(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setShort(int param1, short param2) throws SQLException
    {
        try {
            originalCallableStatement.setShort(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setInt(int param1, int param2) throws SQLException
    {
        try {
            originalCallableStatement.setInt(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setLong(int param1, long param2) throws SQLException
    {
        try {
            originalCallableStatement.setLong(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setFloat(int param1, float param2) throws SQLException
    {
        try {
            originalCallableStatement.setFloat(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setDouble(int param1, double param2) throws SQLException
    {
        try {
            originalCallableStatement.setDouble(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setURL(int param1, URL param2) throws SQLException
    {
        try {
            originalCallableStatement.setURL(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setTime(int param1, Time param2) throws SQLException
    {
        try {
            originalCallableStatement.setTime(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setTime(int param1, Time param2, Calendar param3) throws SQLException
    {
        try {
            originalCallableStatement.setTime(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean execute() throws SQLException
    {
        try {
            return originalCallableStatement.execute();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException
    {
        try {
            return originalCallableStatement.getMetaData();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ResultSet executeQuery() throws SQLException
    {
        try {
            ResultSet rs = originalCallableStatement.executeQuery();
            return rs==null ? null : new ClientResultSetSapDB(rs, clientConnection, this);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int executeUpdate() throws SQLException
    {
        try {
            return originalCallableStatement.executeUpdate();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void addBatch() throws SQLException
    {
        try {
            originalCallableStatement.addBatch();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setNull(int param1, int param2, String param3) throws SQLException
    {
        try {
            originalCallableStatement.setNull(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setNull(int param1, int param2) throws SQLException
    {
        try {
            originalCallableStatement.setNull(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setBigDecimal(int param1, BigDecimal param2) throws SQLException
    {
        try {
            originalCallableStatement.setBigDecimal(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setString(int param1, String param2) throws SQLException
    {
        try {
            originalCallableStatement.setString(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setBytes(int param1, byte[] param2) throws SQLException
    {
        try {
            originalCallableStatement.setBytes(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setDate(int param1, Date param2) throws SQLException
    {
        try {
            originalCallableStatement.setDate(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setDate(int param1, Date param2, Calendar param3) throws SQLException
    {
        try {
            originalCallableStatement.setDate(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setTimestamp(int param1, Timestamp param2) throws SQLException
    {
        try {
            originalCallableStatement.setTimestamp(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setTimestamp(int param1, Timestamp param2, Calendar param3) throws SQLException
    {
        try {
            originalCallableStatement.setTimestamp(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setAsciiStream(int param1, InputStream param2, int param3) throws SQLException
    {
        try {
            originalCallableStatement.setAsciiStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setUnicodeStream(int param1, InputStream param2, int param3) throws SQLException
    {
        try {
            originalCallableStatement.setUnicodeStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setBinaryStream(int param1, InputStream param2, int param3) throws SQLException
    {
        try {
            originalCallableStatement.setBinaryStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void clearParameters() throws SQLException
    {
        try {
            originalCallableStatement.clearParameters();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setObject(int param1, Object param2) throws SQLException
    {
        try {
            originalCallableStatement.setObject(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setObject(int param1, Object param2, int param3) throws SQLException
    {
        try {
            originalCallableStatement.setObject(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setObject(int param1, Object param2, int param3, int param4) throws SQLException
    {
        try {
            originalCallableStatement.setObject(param1, param2, param3, param4);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setCharacterStream(int param1, Reader param2, int param3) throws SQLException
    {
        try {
            originalCallableStatement.setCharacterStream(param1, param2, param3);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setRef(int param1, Ref param2) throws SQLException
    {
        try {
            originalCallableStatement.setRef(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setBlob(int param1, Blob param2) throws SQLException
    {
        try {
            originalCallableStatement.setBlob(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setClob(int param1, Clob param2) throws SQLException
    {
        try {
            originalCallableStatement.setClob(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public void setArray(int param1, Array param2) throws SQLException
    {
        try {
            originalCallableStatement.setArray(param1, param2);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException
    {
        try {
            ParameterMetaData pm = originalCallableStatement.getParameterMetaData();
            return pm==null ? null : ClientParameterMetaDataSapDB.createNew(pm, clientConnection);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    
}
