/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.translators;

import java.sql.*;

import com.sap.dbtech.jdbc.packet.*;
import com.sap.dbtech.util.*;
/**
 *
 */
abstract class CharDataTranslator
    extends DBTechTranslator
{
    final protected static byte[] HighTime_C = { '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3'};
    final protected static byte[] LowTime_C  = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1'};

    /**
     * CharDataTranslator constructor comment.
     * @param mode int
     * @param ioType int
     * @param dataType int
     * @param len int
     * @param ioLen int
     * @param bufpos int
     */
    protected CharDataTranslator(
        int mode,
        int ioType,
        int dataType,
        int len,
        int ioLen,
        int bufpos)
    {
        super(mode, ioType, dataType, len, ioLen, bufpos);
    }
    /**
     *
     * @return boolean
     */
    public boolean isCaseSensitive () {
        return true;
    }
    /**
     *
     * @param dataPart com.sap.dbtech.jdbc.packet.DataPart
     * @param data java.lang.Object
     */
    protected void putSpecific (
        DataPart dataPart,
        Object data)
    throws SQLException
    {
        byte [] bytes = StringUtil.bytes_iso8859_1(data.toString()); // ((String) data).getBytes ();
        if (bytes.length > this.physicalLength - 1) {
            throw new com.sap.dbtech.jdbc.exceptions.ValueOverflow (
                com.sap.dbtech.vsp00.DataType.stringValuesC [this.dataType],
                -1);
        }
        dataPart.putInt1 ((byte) ' ', this.bufpos - 1);
        dataPart.putStringBytes (bytes, this.bufpos, this.physicalLength - 1);
    }
    /**
     *
     */
    public Date getDate (
        SQLParamController controller,
        StructuredMem mem,
        java.util.Calendar cal)
    throws SQLException
    {
        String strValue = this.getString (controller, mem);
        if (strValue == null) {
            return null;
        }
        try {
            Date dateValue = Date.valueOf (strValue);

            if (cal == null)
              return dateValue;
            else {
              cal.setTime(dateValue);
              return DBTechTranslator.CalendarUtil.getDateFromCalendar(cal);
            }
        }
        catch (IllegalArgumentException dateExc) {
            // ignore and try as time stamp
        }
        try {
            Timestamp tsValue = Timestamp.valueOf (strValue);

            if (cal == null)
              return new Date (tsValue.getTime ());
            else {
              cal.setTime(tsValue);
              return DBTechTranslator.CalendarUtil.getDateFromCalendar(cal);
            }
        }
        catch (IllegalArgumentException tsExc) {
            throw newParseException (strValue, "Date");
        }
    }
    /**
     *
     */
    public Time getTime (
        SQLParamController controller,
        StructuredMem mem,
        java.util.Calendar cal)
    throws SQLException
    {
        String strValue = this.getString (controller, mem);
        if (strValue == null) {
            return null;
        }
        try {
            Time dateValue = Time.valueOf (strValue);
            if (cal == null)
              return dateValue;
            else {
              cal.setTime(dateValue);
              return DBTechTranslator.CalendarUtil.getTimeFromCalendar(cal);
            }
        }
        catch (IllegalArgumentException dateExc) {
            //ignore
        }
        try {
            Timestamp dateValue = Timestamp.valueOf (strValue);
            if (cal == null)
              return new Time(dateValue.getTime());
            else {
              cal.setTime(dateValue);
              return DBTechTranslator.CalendarUtil.getTimeFromCalendar(cal);
            }
        }
        catch (IllegalArgumentException dateExc) {
            throw newParseException (strValue, "Time");
        }
    }
    /**
     *
     */
    public Timestamp getTimestamp (
        SQLParamController controller,
        StructuredMem mem,
        java.util.Calendar cal)
    throws SQLException
    {
        String strValue = this.getString (controller, mem);
        if (strValue == null) {
            return null;
        }
        try {
            Timestamp ts = Timestamp.valueOf (strValue);
            if (cal == null)
              return ts;
            else {
              cal.setTime(ts);
              return DBTechTranslator.CalendarUtil.getTimestampFromCalendar(cal, ts.getNanos());
            }
        }
        catch (IllegalArgumentException tsExc) {
          // ignore and try as date
          try {
              Date dateValue = Date.valueOf (strValue);
            if (cal == null)
              return new Timestamp (dateValue.getTime ());
            else {
              cal.setTime(dateValue);
              return DBTechTranslator.CalendarUtil.getTimestampFromCalendar(cal,0);
            }
          }
          catch (IllegalArgumentException dateExc) {
              throw newParseException (strValue, "Timestamp");
          }
       }
    }

}
