/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
package com.sap.dbtech.jdbc.translators;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;

public class BinaryProcedurePutval extends AbstractProcedurePutval
{
    private InputStream stream;
    private int         length;
	private boolean     atBegin;
	private boolean     marksupported;
	
	public BinaryProcedurePutval(DBTechTranslator translator, byte[] bytes)
    {
        this(translator, new ByteArrayInputStream(bytes), -1);
    }
	
	
    public BinaryProcedurePutval(DBTechTranslator translator, InputStream stream, int length)
    {
        super(translator);
        this.atBegin = true;
        if(length == -1) {
            this.stream = stream;
            this.marksupported = this.stream.markSupported();
            this.length = Integer.MAX_VALUE; 
        } else {
            this.stream = new InputStreamFilter(stream, length);
            this.marksupported = this.stream.markSupported();
            this.length = length;
        }
        if(marksupported) {
            this.stream.mark(this.length);
        }

    }

    public void transferStream(DataPart dataPart, short rowCount) throws SQLException
    {
        if(rowCount == STREAM_RESET) {
            if(!atBegin) {
                if(marksupported) {
                    try {
                        stream.reset();
                        stream.mark(length);
                    } catch(IOException ioEx) {
                        throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_IOEXCEPTION,
        						ioEx.getMessage()));
                    }
                } else {
                    throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_RESET_STREAM));
                }
            }
            rowCount = Short.MAX_VALUE;
        } else if(atBegin) {
            if(marksupported) {
                stream.mark(length);
            }
        }
        
        if(dataPart.fillWithProcedureStream(stream, rowCount)) {
            try {
                stream.close();
            } catch(IOException ioex) {
                throw new SQLExceptionSapDB(MessageTranslator.translate(MessageKey.ERROR_STREAM_IOEXCEPTION,
    						ioex.getMessage()));                   
            }
    	}          	
    }

}
