/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.Xid;

class XATransaction {
    public static final int STATUS_STARTED = 0;
    public static final int STATUS_PREPARED = 3;
    public static final int STATUS_COMMITTED = 1;
    public static final int STATUS_ROLLED_BACK = 2;
    Xid xid;
    Connection physicalConnection;
    int status;
    long timeOutTime;

    public XATransaction(Xid xid, Connection connection, long l) {
        this.xid = xid;
        this.physicalConnection = connection;
        this.timeOutTime = l;
        this.status = 0;
    }

    public String toString() {
        return "xid =" + this.xid.toString() + " status=" + this.status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitRelease() throws SQLException {
        XATransaction xATransaction = this;
        synchronized (xATransaction) {
            if (this.physicalConnection != null) {
                this.physicalConnection.commit();
                this.physicalConnection.close();
                this.physicalConnection = null;
                this.status = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackRelease() throws SQLException {
        XATransaction xATransaction = this;
        synchronized (xATransaction) {
            if (this.physicalConnection != null) {
                this.physicalConnection.rollback();
                this.physicalConnection.close();
                this.physicalConnection = null;
                this.status = 2;
            }
        }
    }
}

